/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usageView.impl;

import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.ui.UIBundle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class UsageViewContentManagerImpl
extends UsageViewContentManager {
    private final Key<Boolean> REUSABLE_CONTENT_KEY;
    private final Key<Boolean> NOT_REUSABLE_CONTENT_KEY;
    private final Key<UsageView> NEW_USAGE_VIEW_KEY;
    private final ContentManager myFindContentManager;

    public UsageViewContentManagerImpl(@NotNull Project project) {
        if (project == null) {
            UsageViewContentManagerImpl.$$$reportNull$$$0(0);
        }
        this(project, ToolWindowManager.getInstance((Project)project));
    }

    @NonInjectable
    public UsageViewContentManagerImpl(final @NotNull Project project, @NotNull ToolWindowManager toolWindowManager) {
        if (project == null) {
            UsageViewContentManagerImpl.$$$reportNull$$$0(1);
        }
        if (toolWindowManager == null) {
            UsageViewContentManagerImpl.$$$reportNull$$$0(2);
        }
        this.REUSABLE_CONTENT_KEY = Key.create((String)"UsageTreeManager.REUSABLE_CONTENT_KEY");
        this.NOT_REUSABLE_CONTENT_KEY = Key.create((String)"UsageTreeManager.NOT_REUSABLE_CONTENT_KEY");
        this.NEW_USAGE_VIEW_KEY = Key.create((String)"NEW_USAGE_VIEW_KEY");
        ToolWindow toolWindow2 = toolWindowManager.registerToolWindow(RegisterToolWindowTask.closable((String)"Find", (Supplier)UIBundle.messagePointer((String)"tool.window.name.find", (Object[])new Object[0]), (Icon)AllIcons.Toolwindows.ToolWindowFind));
        toolWindow2.setHelpId("ideaInterface.find");
        toolWindow2.setToHideOnEmptyContent(true);
        DumbAwareToggleAction toggleNewTabAction = new DumbAwareToggleAction(FindBundle.message("find.open.in.new.tab.action", new Object[0])){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                return FindSettings.getInstance().isShowResultsInSeparateView();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                FindSettings.getInstance().setShowResultsInSeparateView(state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/usageView/impl/UsageViewContentManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DumbAwareToggleAction toggleSortAction = new DumbAwareToggleAction(UsageViewBundle.message((String)"sort.alphabetically.action.text", (Object[])new Object[0]), null, AllIcons.ObjectBrowser.Sorted){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                return UsageViewSettings.getInstance().isSortAlphabetically();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                UsageViewSettings.getInstance().setSortAlphabetically(state);
                ((Runnable)project.getMessageBus().syncPublisher(UsageFilteringRuleProvider.RULES_CHANGED)).run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/usageView/impl/UsageViewContentManagerImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DumbAwareToggleAction toggleAutoscrollAction = new DumbAwareToggleAction(UIBundle.message((String)"autoscroll.to.source.action.name", (Object[])new Object[0]), UIBundle.message((String)"autoscroll.to.source.action.description", (Object[])new Object[0]), AllIcons.General.AutoscrollToSource){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                return UsageViewSettings.getInstance().isAutoScrollToSource();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                UsageViewSettings.getInstance().setAutoScrollToSource(state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/usageView/impl/UsageViewContentManagerImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DefaultActionGroup gearActions = DefaultActionGroup.createPopupGroup((Supplier)IdeBundle.messagePointer((String)"group.view.options", (Object[])new Object[0]));
        gearActions.addAll(new AnAction[]{toggleAutoscrollAction, toggleSortAction, toggleNewTabAction});
        ((ToolWindowEx)toolWindow2).setAdditionalGearActions((ActionGroup)gearActions);
        this.myFindContentManager = toolWindow2.getContentManager();
        this.myFindContentManager.addContentManagerListener(new ContentManagerListener(){

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                event.getContent().release();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/usageView/impl/UsageViewContentManagerImpl$4", "contentRemoved"));
            }
        });
        ContentManagerWatcher.watchContentManager(toolWindow2, this.myFindContentManager);
    }

    @NotNull
    public Content addContent(@NotNull String contentName, boolean reusable, @NotNull JComponent component2, boolean toOpenInNewTab, boolean isLockable) {
        if (contentName == null) {
            UsageViewContentManagerImpl.$$$reportNull$$$0(3);
        }
        if (component2 == null) {
            UsageViewContentManagerImpl.$$$reportNull$$$0(4);
        }
        Content content2 = this.addContent(contentName, null, null, reusable, component2, toOpenInNewTab, isLockable);
        if (content2 == null) {
            UsageViewContentManagerImpl.$$$reportNull$$$0(5);
        }
        return content2;
    }

    @NotNull
    public Content addContent(@NotNull String contentName, String tabName, String toolwindowTitle, boolean reusable, @NotNull JComponent component2, boolean toOpenInNewTab, boolean isLockable) {
        if (contentName == null) {
            UsageViewContentManagerImpl.$$$reportNull$$$0(6);
        }
        if (component2 == null) {
            UsageViewContentManagerImpl.$$$reportNull$$$0(7);
        }
        Key<Boolean> contentKey = reusable ? this.REUSABLE_CONTENT_KEY : this.NOT_REUSABLE_CONTENT_KEY;
        Content selectedContent = this.getSelectedContent();
        boolean bl = selectedContent != null && selectedContent.isPinned();
        Content contentToDelete = null;
        int indexToAdd = -1;
        if (!(toOpenInNewTab |= bl) && reusable) {
            ArrayList contents = ContainerUtil.newArrayList((Object[])this.myFindContentManager.getContents());
            if (selectedContent != null) {
                contents.remove(selectedContent);
                contents.add(selectedContent);
            }
            for (Content content2 : contents) {
                UsageView usageView;
                if (content2.isPinned() || content2.getUserData(contentKey) == null || (usageView = (UsageView)content2.getUserData(this.NEW_USAGE_VIEW_KEY)) != null && usageView.isSearchInProgress()) continue;
                contentToDelete = content2;
                indexToAdd = this.myFindContentManager.getIndexOfContent(contentToDelete);
            }
        }
        Content content3 = ContentFactory.SERVICE.getInstance().createContent(component2, contentName, isLockable);
        content3.setTabName(tabName);
        content3.setToolwindowTitle(toolwindowTitle);
        content3.putUserData(contentKey, (Object)Boolean.TRUE);
        content3.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        this.myFindContentManager.addContent(content3, indexToAdd);
        if (contentToDelete != null) {
            this.myFindContentManager.removeContent(contentToDelete, true);
        }
        this.myFindContentManager.setSelectedContent(content3);
        Content content4 = content3;
        if (content4 == null) {
            UsageViewContentManagerImpl.$$$reportNull$$$0(8);
        }
        return content4;
    }

    public int getReusableContentsCount() {
        return this.getContentCount(true);
    }

    private int getContentCount(boolean reusable) {
        Key<Boolean> contentKey = reusable ? this.REUSABLE_CONTENT_KEY : this.NOT_REUSABLE_CONTENT_KEY;
        Content[] contents = this.myFindContentManager.getContents();
        return (int)Arrays.stream(contents).filter(content2 -> content2.getUserData(contentKey) != null).count();
    }

    public Content getSelectedContent(boolean reusable) {
        Key<Boolean> contentKey = reusable ? this.REUSABLE_CONTENT_KEY : this.NOT_REUSABLE_CONTENT_KEY;
        Content selectedContent = this.myFindContentManager.getSelectedContent();
        return selectedContent == null || selectedContent.getUserData(contentKey) == null ? null : selectedContent;
    }

    public Content getSelectedContent() {
        return this.myFindContentManager == null ? null : this.myFindContentManager.getSelectedContent();
    }

    public void closeContent(@NotNull Content content2) {
        if (content2 == null) {
            UsageViewContentManagerImpl.$$$reportNull$$$0(9);
        }
        this.myFindContentManager.removeContent(content2, true);
        content2.release();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowManager";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentName";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usageView/impl/UsageViewContentManagerImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usageView/impl/UsageViewContentManagerImpl";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addContent";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "closeContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

