/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.containers.IntObjectLRUMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntSLRUCache<T> {
    private static final boolean ourPrintDebugStatistics = false;
    private final IntObjectLRUMap<T> myProtectedQueue;
    private final IntObjectLRUMap<T> myProbationalQueue;
    private int probationalHits;
    private int protectedHits;
    private int misses;

    public IntSLRUCache(int protectedQueueSize, int probationalQueueSize) {
        this.myProtectedQueue = new IntObjectLRUMap(protectedQueueSize);
        this.myProbationalQueue = new IntObjectLRUMap(probationalQueueSize);
    }

    @NotNull
    public IntObjectLRUMap.MapEntry<T> cacheEntry(int key, T value2) {
        IntObjectLRUMap.MapEntry<T> cached = this.myProtectedQueue.getEntry(key);
        if (cached == null) {
            cached = this.myProbationalQueue.getEntry(key);
        }
        if (cached != null) {
            IntObjectLRUMap.MapEntry<T> mapEntry = cached;
            if (mapEntry == null) {
                IntSLRUCache.$$$reportNull$$$0(0);
            }
            return mapEntry;
        }
        IntObjectLRUMap.MapEntry<T> entry2 = new IntObjectLRUMap.MapEntry<T>(key, value2);
        this.myProbationalQueue.putEntry(entry2);
        IntObjectLRUMap.MapEntry<T> mapEntry = entry2;
        if (mapEntry == null) {
            IntSLRUCache.$$$reportNull$$$0(1);
        }
        return mapEntry;
    }

    @Nullable
    public IntObjectLRUMap.MapEntry<T> getCachedEntry(int id2) {
        return this.getCachedEntry(id2, true);
    }

    @Nullable
    public IntObjectLRUMap.MapEntry<T> getCachedEntry(int id2, boolean allowMutation) {
        IntObjectLRUMap.MapEntry<T> entry2 = this.myProtectedQueue.getEntry(id2);
        if (entry2 != null) {
            ++this.protectedHits;
            return entry2;
        }
        entry2 = this.myProbationalQueue.getEntry(id2);
        if (entry2 != null) {
            this.printStatistics(++this.probationalHits);
            if (allowMutation) {
                this.myProbationalQueue.removeEntry(entry2.key);
                IntObjectLRUMap.MapEntry<T> demoted = this.myProtectedQueue.putEntry(entry2);
                if (demoted != null) {
                    this.myProbationalQueue.putEntry(demoted);
                }
            }
            return entry2;
        }
        this.printStatistics(++this.misses);
        return null;
    }

    private void printStatistics(int hits) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IntSLRUCache", "cacheEntry"));
    }
}

