/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.animation;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.animation.Animation;
import com.intellij.util.animation.Easing;
import com.intellij.util.animation.JBAnimator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.DoubleConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\u0014\u001a\u00020\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0016\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/util/animation/ShowHideAnimator;", "", "consumer", "Ljava/util/function/DoubleConsumer;", "(Ljava/util/function/DoubleConsumer;)V", "easing", "Lcom/intellij/util/animation/Easing;", "(Lcom/intellij/util/animation/Easing;Ljava/util/function/DoubleConsumer;)V", "animator", "Lcom/intellij/util/animation/JBAnimator;", "atomicVisible", "Ljava/util/concurrent/atomic/AtomicBoolean;", "hidingDelay", "", "getHidingDelay", "()I", "hidingDuration", "getHidingDuration", "showingDelay", "getShowingDelay", "showingDuration", "getShowingDuration", "statefulEasing", "Lcom/intellij/util/animation/Easing$Stateful;", "kotlin.jvm.PlatformType", "createHidingAnimation", "Lcom/intellij/util/animation/Animation;", "value", "", "createShowingAnimation", "setVisible", "", "visible", "", "setVisibleImmediately", "intellij.platform.ide.impl"})
public class ShowHideAnimator {
    private final JBAnimator animator;
    private final AtomicBoolean atomicVisible;
    private final Easing.Stateful statefulEasing;
    private final DoubleConsumer consumer;

    public final void setVisible(boolean visible) {
        if (visible != this.atomicVisible.getAndSet(visible)) {
            double value2 = this.statefulEasing.value;
            if (!visible && value2 > 0.0) {
                this.animator.animate(new Animation[]{this.createHidingAnimation(value2)});
            } else if (visible && value2 < 1.0) {
                this.animator.animate(new Animation[]{this.createShowingAnimation(value2)});
            } else {
                this.animator.stop();
            }
        }
    }

    public final void setVisibleImmediately(boolean visible) {
        if (visible != this.atomicVisible.getAndSet(visible)) {
            this.consumer.accept(this.statefulEasing.calc(visible ? 1.0 : 0.0));
        }
    }

    protected final int getShowingDelay() {
        return Registry.intValue((String)"ide.animation.showing.delay", (int)0);
    }

    protected final int getShowingDuration() {
        return Registry.intValue((String)"ide.animation.showing.duration", (int)130);
    }

    protected final int getHidingDelay() {
        return Registry.intValue((String)"ide.animation.hiding.delay", (int)70);
    }

    protected final int getHidingDuration() {
        return Registry.intValue((String)"ide.animation.hiding.duration", (int)150);
    }

    private final Animation createShowingAnimation(double value2) {
        Animation animation = new Animation(this.consumer);
        boolean bl = false;
        boolean bl2 = false;
        Animation $this$apply = animation;
        boolean bl3 = false;
        if (value2 > 0.0) {
            $this$apply.setDuration(MathKt.roundToInt((double)((double)this.getShowingDuration() * (1.0 - value2))));
            $this$apply.setEasing(this.statefulEasing.coerceIn(value2, 1.0));
        } else {
            $this$apply.setDelay(this.getShowingDelay());
            $this$apply.setDuration(this.getShowingDuration());
            $this$apply.setEasing((Easing)this.statefulEasing);
        }
        return animation;
    }

    private final Animation createHidingAnimation(double value2) {
        Animation animation = new Animation(this.consumer);
        boolean bl = false;
        boolean bl2 = false;
        Animation $this$apply = animation;
        boolean bl3 = false;
        if (value2 < 1.0) {
            $this$apply.setDuration(MathKt.roundToInt((double)((double)this.getHidingDuration() * value2)));
            $this$apply.setEasing(this.statefulEasing.coerceIn(0.0, value2).reverse());
        } else {
            $this$apply.setDelay(this.getHidingDelay());
            $this$apply.setDuration(this.getHidingDuration());
            $this$apply.setEasing(this.statefulEasing.reverse());
        }
        return animation;
    }

    public ShowHideAnimator(@NotNull Easing easing2, @NotNull DoubleConsumer consumer2) {
        Intrinsics.checkNotNullParameter((Object)easing2, (String)"easing");
        Intrinsics.checkNotNullParameter((Object)consumer2, (String)"consumer");
        this.consumer = consumer2;
        this.animator = new JBAnimator();
        this.atomicVisible = new AtomicBoolean();
        this.statefulEasing = easing2.stateful();
    }

    public ShowHideAnimator(@NotNull DoubleConsumer consumer2) {
        Intrinsics.checkNotNullParameter((Object)consumer2, (String)"consumer");
        Easing easing2 = Easing.LINEAR;
        Intrinsics.checkNotNullExpressionValue((Object)easing2, (String)"Easing.LINEAR");
        this(easing2, consumer2);
    }
}

