/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph.impl;

import com.intellij.util.graph.ElementOrder;
import com.intellij.util.graph.EndpointPair;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.MutableNetwork;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GraphAdapter {
    private GraphAdapter() {
    }

    public static <N> EndpointPair<N> wrapEndpointsPair(com.google.common.graph.EndpointPair<N> endpoints) {
        if (endpoints.isOrdered()) {
            return EndpointPair.ordered((Object)endpoints.source(), (Object)endpoints.target());
        }
        return EndpointPair.unordered((Object)endpoints.nodeU(), (Object)endpoints.nodeV());
    }

    public static <N> com.google.common.graph.EndpointPair<N> unwrapEndpointsPair(EndpointPair<N> endpoints) {
        if (endpoints.isOrdered()) {
            return com.google.common.graph.EndpointPair.ordered((Object)endpoints.source(), (Object)endpoints.target());
        }
        return com.google.common.graph.EndpointPair.unordered((Object)endpoints.nodeU(), (Object)endpoints.nodeV());
    }

    public static <T> ElementOrder<T> wrapOrder(com.google.common.graph.ElementOrder<T> order) {
        switch (order.type()) {
            case STABLE: {
                return ElementOrder.stable();
            }
            case INSERTION: {
                return ElementOrder.insertion();
            }
            case SORTED: {
                return ElementOrder.sorted((Comparator)order.comparator());
            }
        }
        return ElementOrder.unordered();
    }

    public static <T> com.google.common.graph.ElementOrder<T> unwrapOrder(ElementOrder<T> order) {
        switch (order.type()) {
            case STABLE: {
                return com.google.common.graph.ElementOrder.stable();
            }
            case INSERTION: {
                return com.google.common.graph.ElementOrder.insertion();
            }
            case SORTED: {
                return com.google.common.graph.ElementOrder.sorted((Comparator)order.comparator());
            }
        }
        return com.google.common.graph.ElementOrder.unordered();
    }

    public static <N, E> MutableNetwork<N, E> wrapNetwork(final com.google.common.graph.MutableNetwork<N, E> delegate2) {
        return new MutableNetwork<N, E>(){

            public boolean addNode(N n) {
                return delegate2.addNode(n);
            }

            public boolean addEdge(N n, N n1, E e) {
                return delegate2.addEdge(n, n1, e);
            }

            public boolean addEdge(EndpointPair<N> endpoints, E edge) {
                return delegate2.addEdge(GraphAdapter.unwrapEndpointsPair(endpoints), edge);
            }

            public boolean removeNode(N n) {
                return delegate2.removeNode(n);
            }

            public boolean removeEdge(E e) {
                return delegate2.removeEdge(e);
            }

            public Set<N> nodes() {
                return delegate2.nodes();
            }

            public Set<E> edges() {
                return delegate2.edges();
            }

            public Graph<N> asGraph() {
                return new Graph<N>(){

                    @NotNull
                    public Collection<N> getNodes() {
                        Set set2 = this.nodes();
                        if (set2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return set2;
                    }

                    @NotNull
                    public Iterator<N> getIn(N n) {
                        Iterator iterator2 = this.predecessors(n).iterator();
                        if (iterator2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return iterator2;
                    }

                    @NotNull
                    public Iterator<N> getOut(N n) {
                        Iterator iterator2 = this.successors(n).iterator();
                        if (iterator2 == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return iterator2;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = "com/intellij/util/graph/impl/GraphAdapter$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getNodes";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getIn";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getOut";
                                break;
                            }
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                    }
                };
            }

            public boolean isDirected() {
                return delegate2.isDirected();
            }

            public boolean allowsParallelEdges() {
                return delegate2.allowsParallelEdges();
            }

            public boolean allowsSelfLoops() {
                return delegate2.allowsSelfLoops();
            }

            public ElementOrder<N> nodeOrder() {
                return GraphAdapter.wrapOrder(delegate2.nodeOrder());
            }

            public ElementOrder<E> edgeOrder() {
                return GraphAdapter.wrapOrder(delegate2.edgeOrder());
            }

            public Set<N> adjacentNodes(N n) {
                return delegate2.adjacentNodes(n);
            }

            public Set<N> predecessors(N n) {
                return delegate2.predecessors(n);
            }

            public Set<N> successors(N n) {
                return delegate2.successors(n);
            }

            public Set<E> incidentEdges(N n) {
                return delegate2.incidentEdges(n);
            }

            public Set<E> inEdges(N n) {
                return delegate2.inEdges(n);
            }

            public Set<E> outEdges(N n) {
                return delegate2.outEdges(n);
            }

            public int degree(N n) {
                return delegate2.degree(n);
            }

            public int inDegree(N n) {
                return delegate2.inDegree(n);
            }

            public int outDegree(N n) {
                return delegate2.outDegree(n);
            }

            public EndpointPair<N> incidentNodes(E e) {
                return GraphAdapter.wrapEndpointsPair(delegate2.incidentNodes(e));
            }

            public Set<E> adjacentEdges(E e) {
                return delegate2.adjacentEdges(e);
            }

            public Set<E> edgesConnecting(N n, N n1) {
                return delegate2.edgesConnecting(n, n1);
            }

            public Optional<E> edgeConnecting(N n, N n1) {
                return delegate2.edgeConnecting(n, n1);
            }

            public E edgeConnectingOrNull(N n, N n1) {
                return delegate2.edgeConnectingOrNull(n, n1);
            }

            public Set<E> edgesConnecting(EndpointPair<N> endpoints) {
                return delegate2.edgesConnecting(GraphAdapter.unwrapEndpointsPair(endpoints));
            }

            public Optional<E> edgeConnecting(EndpointPair<N> endpoints) {
                return delegate2.edgeConnecting(GraphAdapter.unwrapEndpointsPair(endpoints));
            }

            @Nullable
            public E edgeConnectingOrNull(EndpointPair<N> endpoints) {
                return delegate2.edgeConnectingOrNull(GraphAdapter.unwrapEndpointsPair(endpoints));
            }

            public boolean hasEdgeConnecting(N n, N n1) {
                return delegate2.hasEdgeConnecting(n, n1);
            }

            public boolean hasEdgeConnecting(EndpointPair<N> endpoints) {
                return delegate2.hasEdgeConnecting(GraphAdapter.unwrapEndpointsPair(endpoints));
            }

            public boolean equals(@Nullable Object o) {
                return delegate2.equals(o);
            }

            public int hashCode() {
                return delegate2.hashCode();
            }
        };
    }
}

