/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.actions.cache.AsyncRecoveryResult;
import com.intellij.ide.actions.cache.CacheInconsistencyProblem;
import com.intellij.ide.actions.cache.ExceptionalCompletionProblem;
import com.intellij.ide.actions.cache.RecoveryAction;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.BooleanFunction;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexingFlag;
import com.intellij.util.indexing.RescanIndexesAction;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistoryImpl;
import com.intellij.util.indexing.diagnostic.dto.JsonScanningStatistics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u0017H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR%\u0010\u000b\u001a\u00130\u0004\u00a2\u0006\u000e\b\f\u0012\n\b\r\u0012\u0006\b\n0\u000e8\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lcom/intellij/util/indexing/RescanIndexesAction;", "Lcom/intellij/ide/actions/cache/RecoveryAction;", "()V", "actionKey", "", "getActionKey", "()Ljava/lang/String;", "performanceRate", "", "getPerformanceRate", "()I", "presentableName", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "getPresentableName", "performSync", "", "Lcom/intellij/ide/actions/cache/CacheInconsistencyProblem;", "project", "Lcom/intellij/openapi/project/Project;", "extractConsistencyProblems", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl;", "UnindexedFilesInconsistencyProblem", "intellij.platform.lang.impl"})
public final class RescanIndexesAction
implements RecoveryAction {
    @Override
    public int getPerformanceRate() {
        return 9990;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = LangBundle.message((String)"rescan.indexes.recovery.action.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"LangBundle.message(\"resc\u2026es.recovery.action.name\")");
        return string;
    }

    @Override
    @NotNull
    public String getActionKey() {
        return "rescan";
    }

    @Override
    @NotNull
    public List<CacheInconsistencyProblem> performSync(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CompletableFuture historyFuture = new CompletableFuture();
        boolean bl = false;
        List stubAndIndexingStampInconsistencies = Collections.synchronizedList(new ArrayList());
        new UnindexedFilesUpdater(stubAndIndexingStampInconsistencies, historyFuture, project, project, "Rescanning indexes recovery action"){
            private final UpdatableIndex<Integer, SerializedStubTree, FileContent> stubIndex;
            final /* synthetic */ List $stubAndIndexingStampInconsistencies;
            final /* synthetic */ CompletableFuture $historyFuture;
            final /* synthetic */ Project $project;

            @Nullable
            protected BooleanFunction<IndexedFile> getForceReindexingTrigger() {
                if (this.stubIndex != null) {
                    return new BooleanFunction(this){
                        final /* synthetic */ performSync.1 this$0;

                        public final boolean fun(IndexedFile it) {
                            IndexedFile indexedFile = it;
                            Intrinsics.checkNotNullExpressionValue((Object)indexedFile, (String)"it");
                            VirtualFile virtualFile2 = indexedFile.getFile();
                            if (virtualFile2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.vfs.VirtualFileWithId");
                            }
                            int fileId = ((VirtualFileWithId)virtualFile2).getId();
                            if (performSync.1.access$getStubIndex$p(this.this$0).getIndexingStateForFile(fileId, it) == FileIndexingState.UP_TO_DATE && performSync.1.access$getStubIndex$p(this.this$0).getIndexedFileData(fileId).isEmpty()) {
                                VirtualFile virtualFile3 = it.getFile();
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"it.file");
                                if (performSync.1.access$isAbleToBuildStub(this.this$0, virtualFile3)) {
                                    List list2 = this.this$0.$stubAndIndexingStampInconsistencies;
                                    VirtualFile virtualFile4 = it.getFile();
                                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"it.file");
                                    String string = virtualFile4.getPath();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.file.path");
                                    list2.add(new performSync.StubAndIndexStampInconsistency(this.this$0, string));
                                    return true;
                                }
                            }
                            return false;
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    };
                }
                return null;
            }

            private final boolean isAbleToBuildStub(VirtualFile file2) {
                Object object;
                performSync.1 var2_2 = this;
                boolean bl = false;
                try {
                    object = Result.Companion;
                    performSync.1 $this$runCatching = var2_2;
                    boolean bl2 = false;
                    Stub stub = StubTreeBuilder.buildStubTree(FileContentImpl.createByFile(file2));
                    boolean bl3 = false;
                    object = Result.constructor-impl((Object)stub);
                }
                catch (Throwable throwable) {
                    Result.Companion companion = Result.Companion;
                    boolean bl4 = false;
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                var2_2 = object;
                bl = false;
                return (Result.isFailure-impl((Object)((Object)var2_2)) ? null : var2_2) != null;
            }

            @NotNull
            protected ProjectIndexingHistoryImpl performScanningAndIndexing(@NotNull ProgressIndicator indicator2) {
                Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
                try {
                    IndexingFlag.cleanupProcessedFlag();
                    ProjectIndexingHistoryImpl projectIndexingHistoryImpl = super.performScanningAndIndexing(indicator2);
                    Intrinsics.checkNotNullExpressionValue((Object)projectIndexingHistoryImpl, (String)"super.performScanningAndIndexing(indicator)");
                    ProjectIndexingHistoryImpl history2 = projectIndexingHistoryImpl;
                    this.$historyFuture.complete(history2);
                    return history2;
                }
                catch (Exception e) {
                    this.$historyFuture.completeExceptionally(e);
                    throw (Throwable)e;
                }
            }
            {
                Object object;
                this.$stubAndIndexingStampInconsistencies = $captured_local_variable$0;
                this.$historyFuture = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
                performSync.1 var6_6 = this;
                performSync.1 var16_7 = this;
                boolean bl = false;
                try {
                    object = Result.Companion;
                    performSync.1 $this$runCatching = var6_6;
                    boolean bl2 = false;
                    FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
                    if (fileBasedIndex == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
                    }
                    UpdatableIndex<Integer, SerializedStubTree, FileContent> updatableIndex = ((FileBasedIndexImpl)fileBasedIndex).getIndex(StubUpdatingIndex.INDEX_ID);
                    boolean bl3 = false;
                    object = Result.constructor-impl(updatableIndex);
                }
                catch (Throwable throwable) {
                    Result.Companion companion = Result.Companion;
                    boolean bl4 = false;
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                Object object2 = object;
                performSync.1 v1 = var16_7;
                var6_6 = object2;
                bl = false;
                boolean bl5 = false;
                Throwable throwable = Result.exceptionOrNull-impl((Object)((Object)var6_6));
                if (throwable != null) {
                    void it;
                    Throwable throwable2 = throwable;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    Throwable throwable3 = throwable2;
                    boolean bl8 = false;
                    Throwable throwable4 = throwable3;
                    var16_7 = v1;
                    boolean bl9 = false;
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(RescanIndexesAction.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.error((Throwable)it);
                    object2 = Unit.INSTANCE;
                    v1 = var16_7;
                }
                bl = false;
                v1.stubIndex = (UpdatableIndex)((Object)(Result.isFailure-impl((Object)((Object)var6_6)) ? null : var6_6));
            }

            public static final /* synthetic */ boolean access$isAbleToBuildStub(performSync.1 $this, VirtualFile file2) {
                return $this.isAbleToBuildStub(file2);
            }

            public static final /* synthetic */ UpdatableIndex access$getStubIndex$p(performSync.1 $this) {
                return $this.stubIndex;
            }
        }.queue(project);
        try {
            Object t = ProgressIndicatorUtils.awaitWithCheckCanceled(historyFuture);
            Intrinsics.checkNotNullExpressionValue(t, (String)"ProgressIndicatorUtils.a\u2026ckCanceled(historyFuture)");
            Collection collection = this.extractConsistencyProblems((ProjectIndexingHistoryImpl)t);
            List list2 = stubAndIndexingStampInconsistencies;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"stubAndIndexingStampInconsistencies");
            return CollectionsKt.plus((Collection)collection, (Iterable)list2);
        }
        catch (Exception e) {
            return CollectionsKt.listOf((Object)new ExceptionalCompletionProblem(e));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<CacheInconsistencyProblem> extractConsistencyProblems(ProjectIndexingHistoryImpl $this$extractConsistencyProblems) {
        void $this$mapTo$iv$iv;
        JsonScanningStatistics it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$extractConsistencyProblems.getScanningStatistics();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (JsonScanningStatistics)element$iv$iv;
            boolean bl = false;
            if (!(it.getNumberOfFilesForIndexing() != 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (JsonScanningStatistics)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UnindexedFilesInconsistencyProblem unindexedFilesInconsistencyProblem = new UnindexedFilesInconsistencyProblem(it.getNumberOfFilesForIndexing(), it.getProviderName());
            collection.add(unindexedFilesInconsistencyProblem);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean canBeApplied(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return RecoveryAction.DefaultImpls.canBeApplied(this, project);
    }

    @Override
    @NotNull
    public CompletableFuture<AsyncRecoveryResult> perform(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return RecoveryAction.DefaultImpls.perform(this, project);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/util/indexing/RescanIndexesAction$UnindexedFilesInconsistencyProblem;", "Lcom/intellij/ide/actions/cache/CacheInconsistencyProblem;", "numberOfFilesForIndexing", "", "providerName", "", "(ILjava/lang/String;)V", "message", "getMessage", "()Ljava/lang/String;", "intellij.platform.lang.impl"})
    private static final class UnindexedFilesInconsistencyProblem
    implements CacheInconsistencyProblem {
        private final int numberOfFilesForIndexing;
        private final String providerName;

        @Override
        @NotNull
        public String getMessage() {
            return "Provider `" + this.providerName + "` had " + this.numberOfFilesForIndexing + " unindexed files";
        }

        public UnindexedFilesInconsistencyProblem(int numberOfFilesForIndexing, @NotNull String providerName) {
            Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
            this.numberOfFilesForIndexing = numberOfFilesForIndexing;
            this.providerName = providerName;
        }
    }
}

