/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.indexing.diagnostic.ChangedFilesPushedDiagnostic;
import com.intellij.util.indexing.diagnostic.ChangedFilesPushedEvent;
import com.intellij.util.indexing.diagnostic.ChangedFilesPushingStatistics;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.dto.JsonDuration;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u0006\u0010\u000e\u001a\u00020\u000fR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/intellij/util/indexing/diagnostic/ChangedFilesPushedDiagnostic;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "jacksonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getJacksonMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "jacksonMapper$delegate", "Lkotlin/Lazy;", "addEvent", "", "project", "Lcom/intellij/openapi/project/Project;", "event", "Lcom/intellij/util/indexing/diagnostic/ChangedFilesPushingStatistics;", "appendEvent", "Lcom/intellij/util/indexing/diagnostic/ChangedFilesPushedEvent;", "getEventsFile", "Ljava/nio/file/Path;", "readEvents", "", "intellij.platform.lang.impl"})
public final class ChangedFilesPushedDiagnostic {
    private static final Logger LOG;
    private static final Lazy jacksonMapper$delegate;
    @NotNull
    public static final ChangedFilesPushedDiagnostic INSTANCE;

    public final void addEvent(@NotNull Project project, @NotNull ChangedFilesPushingStatistics event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.appendEvent(project, new ChangedFilesPushedEvent(event.getReason(), event.getStartTime(), new JsonDuration(event.getDuration()), event.isCancelled()));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ChangedFilesPushedEvent> readEvents(@NotNull Project project) {
        Path eventsFile;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Path path2 = eventsFile = this.getEventsFile(project);
        Object object = new LinkOption[]{};
        boolean bl = false;
        if (!Files.exists(path2, Arrays.copyOf(object, ((LinkOption[])object).length))) {
            return CollectionsKt.emptyList();
        }
        try {
            void $this$mapTo$iv$iv;
            path2 = eventsFile;
            object = Charsets.UTF_8;
            bl = false;
            List<String> list2 = Files.readAllLines(path2, (Charset)object);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"Files.readAllLines(this, charset)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                ObjectMapper $this$readValue$iv = INSTANCE.getJacksonMapper();
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef = false;
                ChangedFilesPushedEvent changedFilesPushedEvent = (ChangedFilesPushedEvent)$this$readValue$iv.readValue((String)it, (TypeReference)new TypeReference<ChangedFilesPushedEvent>(){});
                collection.add(changedFilesPushedEvent);
            }
            return (List)destination$iv$iv;
        }
        catch (Exception e) {
            LOG.warn("Failed to read " + eventsFile, (Throwable)e);
            return CollectionsKt.emptyList();
        }
    }

    private final void appendEvent(Project project, ChangedFilesPushedEvent event) {
        try {
            Path file2 = this.getEventsFile(project);
            String string = this.getJacksonMapper().writeValueAsString((Object)event);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jacksonMapper.writeValueAsString(event)");
            String jsonLine = StringsKt.replace$default((String)string, (String)"\n", (String)" ", (boolean)false, (int)4, null);
            Path path2 = file2;
            Iterable iterable = CollectionsKt.listOf((Object)jsonLine);
            Charset charset = Charsets.UTF_8;
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)Files.write(path2, (Iterable<? extends CharSequence>)iterable, charset, Arrays.copyOf(openOptionArray, openOptionArray.length)), (String)"Files.write(this, lines, charset, *options)");
        }
        catch (Exception e) {
            LOG.warn("Failed to append changed files pushing event: " + event, (Throwable)e);
        }
    }

    private final Path getEventsFile(Project project) {
        Path path2 = IndexDiagnosticDumper.Companion.getProjectDiagnosticDirectory(project).resolve("changed-files-pushing-events.json");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"IndexDiagnosticDumper.ge\u2026les-pushing-events.json\")");
        return path2;
    }

    private final ObjectMapper getJacksonMapper() {
        Lazy lazy = jacksonMapper$delegate;
        ChangedFilesPushedDiagnostic changedFilesPushedDiagnostic = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ObjectMapper)lazy.getValue();
    }

    private ChangedFilesPushedDiagnostic() {
    }

    static {
        ChangedFilesPushedDiagnostic changedFilesPushedDiagnostic;
        INSTANCE = changedFilesPushedDiagnostic = new ChangedFilesPushedDiagnostic();
        ChangedFilesPushedDiagnostic $this$thisLogger$iv = changedFilesPushedDiagnostic;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(ChangedFilesPushedDiagnostic.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        jacksonMapper$delegate = LazyKt.lazy((Function0)jacksonMapper.2.INSTANCE);
    }
}

