/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.diagnostic.FileIndexingStatistics;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.LimitedPriorityQueue;
import com.intellij.util.indexing.diagnostic.SlowIndexedFile;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePaths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 E2\u00020\u0001:\u0004EFGHB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J:\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\n\u0010>\u001a\u00060\bj\u0002`\t2\n\u0010?\u001a\u00060\bj\u0002`\t2\n\u0010@\u001a\u00060\bj\u0002`AJ\u000e\u0010B\u001a\u0002092\u0006\u0010:\u001a\u00020;J\u0010\u0010C\u001a\u00020D2\u0006\u0010:\u001a\u00020;H\u0002R\u001e\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0015\u0010\u000e\u001a\u00060\bj\u0002`\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00060\bj\u0002`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000b\"\u0004\b\u001a\u0010\rR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\u001a\u0010$\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001e\"\u0004\b&\u0010 R\u001e\u0010'\u001a\u00060\bj\u0002`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u000b\"\u0004\b)\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R-\u0010/\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020100j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u000201`2\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R-\u00105\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020600j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u000206`2\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00104\u00a8\u0006I"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexingJobStatistics;", "", "project", "Lcom/intellij/openapi/project/Project;", "fileSetName", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "contentLoadingTimeInAllThreads", "", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "getContentLoadingTimeInAllThreads", "()J", "setContentLoadingTimeInAllThreads", "(J)V", "contentLoadingVisibleTime", "getContentLoadingVisibleTime", "getFileSetName", "()Ljava/lang/String;", "indexedFiles", "Ljava/util/ArrayList;", "Lcom/intellij/util/indexing/diagnostic/IndexingJobStatistics$IndexedFile;", "Lkotlin/collections/ArrayList;", "getIndexedFiles", "()Ljava/util/ArrayList;", "indexingVisibleTime", "getIndexingVisibleTime", "setIndexingVisibleTime", "numberOfFilesFullyIndexedByExtensions", "", "getNumberOfFilesFullyIndexedByExtensions", "()I", "setNumberOfFilesFullyIndexedByExtensions", "(I)V", "numberOfIndexedFiles", "getNumberOfIndexedFiles", "setNumberOfIndexedFiles", "numberOfTooLargeForIndexingFiles", "getNumberOfTooLargeForIndexingFiles", "setNumberOfTooLargeForIndexingFiles", "processingTimeInAllThreads", "getProcessingTimeInAllThreads", "setProcessingTimeInAllThreads", "slowIndexedFiles", "Lcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;", "Lcom/intellij/util/indexing/diagnostic/SlowIndexedFile;", "getSlowIndexedFiles", "()Lcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;", "statsPerFileType", "Ljava/util/HashMap;", "Lcom/intellij/util/indexing/diagnostic/IndexingJobStatistics$StatsPerFileType;", "Lkotlin/collections/HashMap;", "getStatsPerFileType", "()Ljava/util/HashMap;", "statsPerIndexer", "Lcom/intellij/util/indexing/diagnostic/IndexingJobStatistics$StatsPerIndexer;", "getStatsPerIndexer", "addFileStatistics", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileStatistics", "Lcom/intellij/util/indexing/diagnostic/FileIndexingStatistics;", "processingTime", "contentLoadingTime", "fileSize", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "addTooLargeForIndexingFile", "getIndexedFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "Companion", "IndexedFile", "StatsPerFileType", "StatsPerIndexer", "intellij.platform.lang.impl"})
public final class IndexingJobStatistics {
    private long indexingVisibleTime;
    private long processingTimeInAllThreads;
    private long contentLoadingTimeInAllThreads;
    private int numberOfIndexedFiles;
    private int numberOfFilesFullyIndexedByExtensions;
    private int numberOfTooLargeForIndexingFiles;
    @NotNull
    private final HashMap<String, StatsPerIndexer> statsPerIndexer;
    @NotNull
    private final HashMap<String, StatsPerFileType> statsPerFileType;
    @NotNull
    private final ArrayList<IndexedFile> indexedFiles;
    @NotNull
    private final LimitedPriorityQueue<SlowIndexedFile> slowIndexedFiles;
    private final Project project;
    @NotNull
    private final String fileSetName;
    public static final int SLOW_FILES_LIMIT = 10;
    public static final int SLOW_FILE_PROCESSING_THRESHOLD_MS = 500;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final long getIndexingVisibleTime() {
        return this.indexingVisibleTime;
    }

    public final void setIndexingVisibleTime(long l) {
        this.indexingVisibleTime = l;
    }

    public final long getProcessingTimeInAllThreads() {
        return this.processingTimeInAllThreads;
    }

    public final void setProcessingTimeInAllThreads(long l) {
        this.processingTimeInAllThreads = l;
    }

    public final long getContentLoadingTimeInAllThreads() {
        return this.contentLoadingTimeInAllThreads;
    }

    public final void setContentLoadingTimeInAllThreads(long l) {
        this.contentLoadingTimeInAllThreads = l;
    }

    public final long getContentLoadingVisibleTime() {
        return this.processingTimeInAllThreads == 0L ? 0L : (long)((double)this.indexingVisibleTime * (double)this.contentLoadingTimeInAllThreads / (double)this.processingTimeInAllThreads);
    }

    public final int getNumberOfIndexedFiles() {
        return this.numberOfIndexedFiles;
    }

    public final void setNumberOfIndexedFiles(int n) {
        this.numberOfIndexedFiles = n;
    }

    public final int getNumberOfFilesFullyIndexedByExtensions() {
        return this.numberOfFilesFullyIndexedByExtensions;
    }

    public final void setNumberOfFilesFullyIndexedByExtensions(int n) {
        this.numberOfFilesFullyIndexedByExtensions = n;
    }

    public final int getNumberOfTooLargeForIndexingFiles() {
        return this.numberOfTooLargeForIndexingFiles;
    }

    public final void setNumberOfTooLargeForIndexingFiles(int n) {
        this.numberOfTooLargeForIndexingFiles = n;
    }

    @NotNull
    public final HashMap<String, StatsPerIndexer> getStatsPerIndexer() {
        return this.statsPerIndexer;
    }

    @NotNull
    public final HashMap<String, StatsPerFileType> getStatsPerFileType() {
        return this.statsPerFileType;
    }

    @NotNull
    public final ArrayList<IndexedFile> getIndexedFiles() {
        return this.indexedFiles;
    }

    @NotNull
    public final LimitedPriorityQueue<SlowIndexedFile> getSlowIndexedFiles() {
        return this.slowIndexedFiles;
    }

    /*
     * WARNING - void declaration
     */
    public final void addFileStatistics(@NotNull VirtualFile file2, @NotNull FileIndexingStatistics fileStatistics, long processingTime, long contentLoadingTime, long fileSize) {
        StatsPerFileType stats;
        Object object;
        Map perIndexerTimes;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileStatistics, (String)"fileStatistics");
        int n = this.numberOfIndexedFiles;
        this.numberOfIndexedFiles = n + 1;
        if (fileStatistics.getWasFullyIndexedByExtensions()) {
            n = this.numberOfFilesFullyIndexedByExtensions;
            this.numberOfFilesFullyIndexedByExtensions = n + 1;
        }
        this.processingTimeInAllThreads += processingTime;
        this.contentLoadingTimeInAllThreads += contentLoadingTime;
        Map $this$forEach$iv = perIndexerTimes = MapsKt.plus(fileStatistics.getPerIndexerUpdateTimes(), fileStatistics.getPerIndexerDeleteTimes());
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            StatsPerIndexer stats2;
            Object object2;
            String key$iv;
            void $this$getOrPut$iv;
            void indexId;
            Map.Entry element$iv;
            Map.Entry $dstr$indexId$time = element$iv = iterator2.next();
            boolean bl2 = false;
            Map.Entry entry2 = $dstr$indexId$time;
            int n2 = 0;
            ID iD = (ID)entry2.getKey();
            entry2 = $dstr$indexId$time;
            n2 = 0;
            long time = ((Number)entry2.getValue()).longValue();
            Map map3 = this.statsPerIndexer;
            Intrinsics.checkNotNullExpressionValue((Object)indexId.getName(), (String)"indexId.name");
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl3 = false;
                StatsPerIndexer answer$iv = new StatsPerIndexer(0L, 0, 0, 0L);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            StatsPerIndexer statsPerIndexer = stats2 = (StatsPerIndexer)object2;
            statsPerIndexer.setIndexingTime(statsPerIndexer.getIndexingTime() + time);
            StatsPerIndexer statsPerIndexer2 = stats2;
            n2 = statsPerIndexer2.getNumberOfFiles();
            statsPerIndexer2.setNumberOfFiles(n2 + 1);
            if (fileStatistics.getIndexesProvidedByExtensions().contains(indexId)) {
                StatsPerIndexer statsPerIndexer3 = stats2;
                n2 = statsPerIndexer3.getNumberOfFilesIndexedByExtensions();
                statsPerIndexer3.setNumberOfFilesIndexedByExtensions(n2 + 1);
            }
            StatsPerIndexer statsPerIndexer4 = stats2;
            statsPerIndexer4.setTotalBytes(statsPerIndexer4.getTotalBytes() + fileSize);
        }
        String string = fileStatistics.getFileType().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileStatistics.fileType.name");
        String fileTypeName = string;
        Map $this$getOrPut$iv = this.statsPerFileType;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(fileTypeName);
        if (value$iv == null) {
            boolean bl4 = false;
            StatsPerFileType answer$iv = new StatsPerFileType(0L, 0L, 0, 0L);
            $this$getOrPut$iv.put(fileTypeName, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        StatsPerFileType statsPerFileType = stats = (StatsPerFileType)object;
        statsPerFileType.setContentLoadingTimeInAllThreads(statsPerFileType.getContentLoadingTimeInAllThreads() + contentLoadingTime);
        long indexingTime = CollectionsKt.sumOfLong((Iterable)perIndexerTimes.values());
        StatsPerFileType statsPerFileType2 = stats;
        statsPerFileType2.setProcessingTimeInAllThreads(statsPerFileType2.getProcessingTimeInAllThreads() + processingTime);
        StatsPerFileType statsPerFileType3 = stats;
        statsPerFileType3.setTotalBytes(statsPerFileType3.getTotalBytes() + fileSize);
        StatsPerFileType statsPerFileType4 = stats;
        int n3 = statsPerFileType4.getNumberOfFiles();
        statsPerFileType4.setNumberOfFiles(n3 + 1);
        if (IndexDiagnosticDumper.Companion.getShouldDumpPathsOfIndexedFiles()) {
            Collection collection = this.indexedFiles;
            IndexedFile indexedFile = new IndexedFile(this.getIndexedFilePath(file2), fileStatistics.getWasFullyIndexedByExtensions());
            boolean bl5 = false;
            collection.add(indexedFile);
        }
        if (processingTime > (long)500000000) {
            String string2 = file2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.name");
            this.slowIndexedFiles.addElement(new SlowIndexedFile(string2, processingTime, indexingTime, contentLoadingTime));
        }
    }

    public final void addTooLargeForIndexingFile(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        int n = this.numberOfIndexedFiles;
        this.numberOfIndexedFiles = n + 1;
        n = this.numberOfTooLargeForIndexingFiles;
        this.numberOfTooLargeForIndexingFiles = n + 1;
        if (IndexDiagnosticDumper.Companion.getShouldDumpPathsOfIndexedFiles()) {
            Collection collection = this.indexedFiles;
            IndexedFile indexedFile = new IndexedFile(this.getIndexedFilePath(file2), false);
            boolean bl = false;
            collection.add(indexedFile);
        }
    }

    private final PortableFilePath getIndexedFilePath(VirtualFile file2) {
        PortableFilePath portableFilePath;
        try {
            portableFilePath = PortableFilePaths.INSTANCE.getPortableFilePath(file2, this.project);
        }
        catch (Exception e) {
            String string = file2.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.url");
            portableFilePath = new PortableFilePath.AbsolutePath(string);
        }
        return portableFilePath;
    }

    @NotNull
    public final String getFileSetName() {
        return this.fileSetName;
    }

    public IndexingJobStatistics(@NotNull Project project, @NotNull String fileSetName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileSetName, (String)"fileSetName");
        this.project = project;
        this.fileSetName = fileSetName;
        boolean bl = false;
        this.statsPerIndexer = new HashMap();
        bl = false;
        this.statsPerFileType = new HashMap();
        bl = false;
        this.indexedFiles = new ArrayList();
        bl = false;
        this.slowIndexedFiles = new LimitedPriorityQueue(10, new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                SlowIndexedFile it = (SlowIndexedFile)a;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getProcessingTime());
                it = (SlowIndexedFile)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = Long.valueOf(it.getProcessingTime());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        });
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexingJobStatistics$IndexedFile;", "", "portableFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "wasFullyIndexedByExtensions", "", "(Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;Z)V", "getPortableFilePath", "()Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "getWasFullyIndexedByExtensions", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.lang.impl"})
    public static final class IndexedFile {
        @NotNull
        private final PortableFilePath portableFilePath;
        private final boolean wasFullyIndexedByExtensions;

        @NotNull
        public final PortableFilePath getPortableFilePath() {
            return this.portableFilePath;
        }

        public final boolean getWasFullyIndexedByExtensions() {
            return this.wasFullyIndexedByExtensions;
        }

        public IndexedFile(@NotNull PortableFilePath portableFilePath, boolean wasFullyIndexedByExtensions) {
            Intrinsics.checkNotNullParameter((Object)portableFilePath, (String)"portableFilePath");
            this.portableFilePath = portableFilePath;
            this.wasFullyIndexedByExtensions = wasFullyIndexedByExtensions;
        }

        @NotNull
        public final PortableFilePath component1() {
            return this.portableFilePath;
        }

        public final boolean component2() {
            return this.wasFullyIndexedByExtensions;
        }

        @NotNull
        public final IndexedFile copy(@NotNull PortableFilePath portableFilePath, boolean wasFullyIndexedByExtensions) {
            Intrinsics.checkNotNullParameter((Object)portableFilePath, (String)"portableFilePath");
            return new IndexedFile(portableFilePath, wasFullyIndexedByExtensions);
        }

        public static /* synthetic */ IndexedFile copy$default(IndexedFile indexedFile, PortableFilePath portableFilePath, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                portableFilePath = indexedFile.portableFilePath;
            }
            if ((n & 2) != 0) {
                bl = indexedFile.wasFullyIndexedByExtensions;
            }
            return indexedFile.copy(portableFilePath, bl);
        }

        @NotNull
        public String toString() {
            return "IndexedFile(portableFilePath=" + this.portableFilePath + ", wasFullyIndexedByExtensions=" + this.wasFullyIndexedByExtensions + ")";
        }

        public int hashCode() {
            PortableFilePath portableFilePath = this.portableFilePath;
            int n = (portableFilePath != null ? portableFilePath.hashCode() : 0) * 31;
            int n2 = this.wasFullyIndexedByExtensions ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof IndexedFile)) break block3;
                    IndexedFile indexedFile = (IndexedFile)object;
                    if (!Intrinsics.areEqual((Object)this.portableFilePath, (Object)indexedFile.portableFilePath) || this.wasFullyIndexedByExtensions != indexedFile.wasFullyIndexedByExtensions) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\n\u0010\b\u001a\u00060\u0003j\u0002`\t\u00a2\u0006\u0002\u0010\nJ\r\u0010\u0017\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J\r\u0010\u001a\u001a\u00060\u0003j\u0002`\tH\u00c6\u0003J9\u0010\u001b\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\f\b\u0002\u0010\b\u001a\u00060\u0003j\u0002`\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0006H\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u001e\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012R\u001e\u0010\b\u001a\u00060\u0003j\u0002`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\f\"\u0004\b\u0016\u0010\u000e\u00a8\u0006\""}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexingJobStatistics$StatsPerIndexer;", "", "indexingTime", "", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "numberOfFiles", "", "numberOfFilesIndexedByExtensions", "totalBytes", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "(JIIJ)V", "getIndexingTime", "()J", "setIndexingTime", "(J)V", "getNumberOfFiles", "()I", "setNumberOfFiles", "(I)V", "getNumberOfFilesIndexedByExtensions", "setNumberOfFilesIndexedByExtensions", "getTotalBytes", "setTotalBytes", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.lang.impl"})
    public static final class StatsPerIndexer {
        private long indexingTime;
        private int numberOfFiles;
        private int numberOfFilesIndexedByExtensions;
        private long totalBytes;

        public final long getIndexingTime() {
            return this.indexingTime;
        }

        public final void setIndexingTime(long l) {
            this.indexingTime = l;
        }

        public final int getNumberOfFiles() {
            return this.numberOfFiles;
        }

        public final void setNumberOfFiles(int n) {
            this.numberOfFiles = n;
        }

        public final int getNumberOfFilesIndexedByExtensions() {
            return this.numberOfFilesIndexedByExtensions;
        }

        public final void setNumberOfFilesIndexedByExtensions(int n) {
            this.numberOfFilesIndexedByExtensions = n;
        }

        public final long getTotalBytes() {
            return this.totalBytes;
        }

        public final void setTotalBytes(long l) {
            this.totalBytes = l;
        }

        public StatsPerIndexer(long indexingTime, int numberOfFiles, int numberOfFilesIndexedByExtensions, long totalBytes) {
            this.indexingTime = indexingTime;
            this.numberOfFiles = numberOfFiles;
            this.numberOfFilesIndexedByExtensions = numberOfFilesIndexedByExtensions;
            this.totalBytes = totalBytes;
        }

        public final long component1() {
            return this.indexingTime;
        }

        public final int component2() {
            return this.numberOfFiles;
        }

        public final int component3() {
            return this.numberOfFilesIndexedByExtensions;
        }

        public final long component4() {
            return this.totalBytes;
        }

        @NotNull
        public final StatsPerIndexer copy(long indexingTime, int numberOfFiles, int numberOfFilesIndexedByExtensions, long totalBytes) {
            return new StatsPerIndexer(indexingTime, numberOfFiles, numberOfFilesIndexedByExtensions, totalBytes);
        }

        public static /* synthetic */ StatsPerIndexer copy$default(StatsPerIndexer statsPerIndexer, long l, int n, int n2, long l2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                l = statsPerIndexer.indexingTime;
            }
            if ((n3 & 2) != 0) {
                n = statsPerIndexer.numberOfFiles;
            }
            if ((n3 & 4) != 0) {
                n2 = statsPerIndexer.numberOfFilesIndexedByExtensions;
            }
            if ((n3 & 8) != 0) {
                l2 = statsPerIndexer.totalBytes;
            }
            return statsPerIndexer.copy(l, n, n2, l2);
        }

        @NotNull
        public String toString() {
            return "StatsPerIndexer(indexingTime=" + this.indexingTime + ", numberOfFiles=" + this.numberOfFiles + ", numberOfFilesIndexedByExtensions=" + this.numberOfFilesIndexedByExtensions + ", totalBytes=" + this.totalBytes + ")";
        }

        public int hashCode() {
            return ((Long.hashCode(this.indexingTime) * 31 + Integer.hashCode(this.numberOfFiles)) * 31 + Integer.hashCode(this.numberOfFilesIndexedByExtensions)) * 31 + Long.hashCode(this.totalBytes);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StatsPerIndexer)) break block3;
                    StatsPerIndexer statsPerIndexer = (StatsPerIndexer)object;
                    if (this.indexingTime != statsPerIndexer.indexingTime || this.numberOfFiles != statsPerIndexer.numberOfFiles || this.numberOfFilesIndexedByExtensions != statsPerIndexer.numberOfFilesIndexedByExtensions || this.totalBytes != statsPerIndexer.totalBytes) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u00060\u0003j\u0002`\t\u00a2\u0006\u0002\u0010\nJ\r\u0010\u0017\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\r\u0010\u0018\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\r\u0010\u001a\u001a\u00060\u0003j\u0002`\tH\u00c6\u0003J=\u0010\u001b\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\f\b\u0002\u0010\u0005\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00072\f\b\u0002\u0010\b\u001a\u00060\u0003j\u0002`\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u001e\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001e\u0010\b\u001a\u00060\u0003j\u0002`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\f\"\u0004\b\u0016\u0010\u000e\u00a8\u0006\""}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexingJobStatistics$StatsPerFileType;", "", "processingTimeInAllThreads", "", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "contentLoadingTimeInAllThreads", "numberOfFiles", "", "totalBytes", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "(JJIJ)V", "getContentLoadingTimeInAllThreads", "()J", "setContentLoadingTimeInAllThreads", "(J)V", "getNumberOfFiles", "()I", "setNumberOfFiles", "(I)V", "getProcessingTimeInAllThreads", "setProcessingTimeInAllThreads", "getTotalBytes", "setTotalBytes", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.lang.impl"})
    public static final class StatsPerFileType {
        private long processingTimeInAllThreads;
        private long contentLoadingTimeInAllThreads;
        private int numberOfFiles;
        private long totalBytes;

        public final long getProcessingTimeInAllThreads() {
            return this.processingTimeInAllThreads;
        }

        public final void setProcessingTimeInAllThreads(long l) {
            this.processingTimeInAllThreads = l;
        }

        public final long getContentLoadingTimeInAllThreads() {
            return this.contentLoadingTimeInAllThreads;
        }

        public final void setContentLoadingTimeInAllThreads(long l) {
            this.contentLoadingTimeInAllThreads = l;
        }

        public final int getNumberOfFiles() {
            return this.numberOfFiles;
        }

        public final void setNumberOfFiles(int n) {
            this.numberOfFiles = n;
        }

        public final long getTotalBytes() {
            return this.totalBytes;
        }

        public final void setTotalBytes(long l) {
            this.totalBytes = l;
        }

        public StatsPerFileType(long processingTimeInAllThreads, long contentLoadingTimeInAllThreads, int numberOfFiles, long totalBytes) {
            this.processingTimeInAllThreads = processingTimeInAllThreads;
            this.contentLoadingTimeInAllThreads = contentLoadingTimeInAllThreads;
            this.numberOfFiles = numberOfFiles;
            this.totalBytes = totalBytes;
        }

        public final long component1() {
            return this.processingTimeInAllThreads;
        }

        public final long component2() {
            return this.contentLoadingTimeInAllThreads;
        }

        public final int component3() {
            return this.numberOfFiles;
        }

        public final long component4() {
            return this.totalBytes;
        }

        @NotNull
        public final StatsPerFileType copy(long processingTimeInAllThreads, long contentLoadingTimeInAllThreads, int numberOfFiles, long totalBytes) {
            return new StatsPerFileType(processingTimeInAllThreads, contentLoadingTimeInAllThreads, numberOfFiles, totalBytes);
        }

        public static /* synthetic */ StatsPerFileType copy$default(StatsPerFileType statsPerFileType, long l, long l2, int n, long l3, int n2, Object object) {
            if ((n2 & 1) != 0) {
                l = statsPerFileType.processingTimeInAllThreads;
            }
            if ((n2 & 2) != 0) {
                l2 = statsPerFileType.contentLoadingTimeInAllThreads;
            }
            if ((n2 & 4) != 0) {
                n = statsPerFileType.numberOfFiles;
            }
            if ((n2 & 8) != 0) {
                l3 = statsPerFileType.totalBytes;
            }
            return statsPerFileType.copy(l, l2, n, l3);
        }

        @NotNull
        public String toString() {
            return "StatsPerFileType(processingTimeInAllThreads=" + this.processingTimeInAllThreads + ", contentLoadingTimeInAllThreads=" + this.contentLoadingTimeInAllThreads + ", numberOfFiles=" + this.numberOfFiles + ", totalBytes=" + this.totalBytes + ")";
        }

        public int hashCode() {
            return ((Long.hashCode(this.processingTimeInAllThreads) * 31 + Long.hashCode(this.contentLoadingTimeInAllThreads)) * 31 + Integer.hashCode(this.numberOfFiles)) * 31 + Long.hashCode(this.totalBytes);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StatsPerFileType)) break block3;
                    StatsPerFileType statsPerFileType = (StatsPerFileType)object;
                    if (this.processingTimeInAllThreads != statsPerFileType.processingTimeInAllThreads || this.contentLoadingTimeInAllThreads != statsPerFileType.contentLoadingTimeInAllThreads || this.numberOfFiles != statsPerFileType.numberOfFiles || this.totalBytes != statsPerFileType.totalBytes) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexingJobStatistics$Companion;", "", "()V", "SLOW_FILES_LIMIT", "", "SLOW_FILE_PROCESSING_THRESHOLD_MS", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

