/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0006\u0010\u0017\u001a\u00020\u0018J\t\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/util/indexing/diagnostic/dto/JsonPercentages;", "", "part", "", "total", "(JJ)V", "doublePercentages", "", "getDoublePercentages", "()D", "getPart", "()J", "partition", "getPartition", "getTotal", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "presentablePercentages", "", "toString", "intellij.platform.lang.impl"})
public final class JsonPercentages {
    private final long part;
    private final long total;

    @JsonIgnore
    public final double getPartition() {
        return this.total == 0L ? 1.0 : (double)this.part / (double)this.total;
    }

    @JsonIgnore
    public final double getDoublePercentages() {
        return this.getPartition() * (double)100;
    }

    @NotNull
    public final String presentablePercentages() {
        String string;
        if (this.total == 0L) {
            string = "100%";
        } else if (this.part == 0L) {
            string = "0%";
        } else if (this.part * (long)100 < this.total) {
            string = "< 1%";
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "%.1f";
            Object[] objectArray = new Object[]{this.getDoublePercentages()};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            string = stringBuilder.append(string3).append("%").toString();
        }
        return string;
    }

    public final long getPart() {
        return this.part;
    }

    public final long getTotal() {
        return this.total;
    }

    public JsonPercentages(long part, long total) {
        this.part = part;
        this.total = total;
    }

    public /* synthetic */ JsonPercentages(long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            l2 = 0L;
        }
        this(l, l2);
    }

    public JsonPercentages() {
        this(0L, 0L, 3, null);
    }

    public final long component1() {
        return this.part;
    }

    public final long component2() {
        return this.total;
    }

    @NotNull
    public final JsonPercentages copy(long part, long total) {
        return new JsonPercentages(part, total);
    }

    public static /* synthetic */ JsonPercentages copy$default(JsonPercentages jsonPercentages, long l, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            l = jsonPercentages.part;
        }
        if ((n & 2) != 0) {
            l2 = jsonPercentages.total;
        }
        return jsonPercentages.copy(l, l2);
    }

    @NotNull
    public String toString() {
        return "JsonPercentages(part=" + this.part + ", total=" + this.total + ")";
    }

    public int hashCode() {
        return Long.hashCode(this.part) * 31 + Long.hashCode(this.total);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof JsonPercentages)) break block3;
                JsonPercentages jsonPercentages = (JsonPercentages)object;
                if (this.part != jsonPercentages.part || this.total != jsonPercentages.total) break block3;
            }
            return true;
        }
        return false;
    }
}

