/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dump;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdaterImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnostic;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnosticBuilder;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnosticDumper$getIndexContentDiagnosticForProject$;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/IndexContentDiagnosticDumper;", "", "()V", "jacksonObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getIndexContentDiagnosticForProject", "Lcom/intellij/util/indexing/diagnostic/dump/IndexContentDiagnostic;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "readFrom", "file", "Ljava/nio/file/Path;", "writeTo", "", "destination", "contentDiagnostic", "intellij.platform.lang.impl"})
public final class IndexContentDiagnosticDumper {
    private static final ObjectMapper jacksonObjectMapper;
    @NotNull
    public static final IndexContentDiagnosticDumper INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IndexContentDiagnostic getIndexContentDiagnosticForProject(@NotNull Project project, @NotNull ProgressIndicator indicator2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        if (fileBasedIndex == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
        }
        List<IndexableFilesIterator> list2 = ((FileBasedIndexImpl)fileBasedIndex).getIndexableFilesProviders(project);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"(FileBasedIndex.getInsta\u2026leFilesProviders(project)");
        List<IndexableFilesIterator> providers = list2;
        indicator2.setText(IndexingBundle.message((String)"index.content.diagnostic.dumping", (Object[])new Object[0]));
        indicator2.setIndeterminate(false);
        indicator2.setFraction(0.0);
        IndexContentDiagnosticBuilder builder2 = new IndexContentDiagnosticBuilder(project);
        AtomicInteger processed2 = new AtomicInteger();
        Iterable $this$map$iv = providers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void provider2;
            IndexableFilesIterator indexableFilesIterator = (IndexableFilesIterator)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Runnable runnable2 = new Runnable((IndexableFilesIterator)provider2, indicator2, project, builder2, processed2, providers){
                final /* synthetic */ IndexableFilesIterator $provider;
                final /* synthetic */ ProgressIndicator $indicator$inlined;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ IndexContentDiagnosticBuilder $builder$inlined;
                final /* synthetic */ AtomicInteger $processed$inlined;
                final /* synthetic */ List $providers$inlined;
                {
                    this.$provider = indexableFilesIterator;
                    this.$indicator$inlined = progressIndicator;
                    this.$project$inlined = project;
                    this.$builder$inlined = indexContentDiagnosticBuilder;
                    this.$processed$inlined = atomicInteger;
                    this.$providers$inlined = list2;
                }

                public final void run() {
                    IndexableFilesIterator indexableFilesIterator = this.$provider;
                    Intrinsics.checkNotNullExpressionValue((Object)indexableFilesIterator, (String)"provider");
                    this.$indicator$inlined.setText2(indexableFilesIterator.getDebugName());
                    this.$provider.iterateFiles(this.$project$inlined, new ContentIterator(this){
                        final /* synthetic */ getIndexContentDiagnosticForProject$$inlined$map$lambda$1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final boolean processFile(@NotNull VirtualFile fileOrDir) {
                            Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
                            IndexContentDiagnosticBuilder indexContentDiagnosticBuilder = this.this$0.$builder$inlined;
                            IndexableFilesIterator indexableFilesIterator = this.this$0.$provider;
                            Intrinsics.checkNotNullExpressionValue((Object)indexableFilesIterator, (String)"provider");
                            String string = indexableFilesIterator.getDebugName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"provider.debugName");
                            indexContentDiagnosticBuilder.addFile(fileOrDir, string);
                            return true;
                        }
                    }, VirtualFileFilter.ALL);
                    this.$indicator$inlined.setFraction((double)this.$processed$inlined.incrementAndGet() / (double)this.$providers$inlined.size());
                }
            };
            collection.add(runnable2);
        }
        PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible((List)destination$iv$iv);
        return builder2.build();
    }

    public final void writeTo(@NotNull Path destination, @NotNull IndexContentDiagnostic contentDiagnostic) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)contentDiagnostic, (String)"contentDiagnostic");
        jacksonObjectMapper.writerWithDefaultPrettyPrinter().writeValue(destination.toFile(), (Object)contentDiagnostic);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IndexContentDiagnostic readFrom(@NotNull Path file2) {
        void $this$readValue$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ObjectMapper objectMapper2 = jacksonObjectMapper;
        File file3 = file2.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"file.toFile()");
        File src$iv = file3;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        return (IndexContentDiagnostic)$this$readValue$iv.readValue(src$iv, (TypeReference)new TypeReference<IndexContentDiagnostic>(){});
    }

    private IndexContentDiagnosticDumper() {
    }

    static {
        IndexContentDiagnosticDumper indexContentDiagnosticDumper;
        INSTANCE = indexContentDiagnosticDumper = new IndexContentDiagnosticDumper();
        jacksonObjectMapper = ExtensionsKt.jacksonObjectMapper();
    }
}

