/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dump.paths;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.intellij.util.indexing.diagnostic.dump.paths.providers.IdePortableFilePathProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0007\b\t\n\u000b\f\r\u000eB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0007\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "", "()V", "presentablePath", "", "getPresentablePath", "()Ljava/lang/String;", "toString", "AbsolutePath", "ArchiveRoot", "IdeRoot", "JdkRoot", "LibraryRoot", "ProjectRoot", "RelativePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$ProjectRoot;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$LibraryRoot;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$JdkRoot;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$IdeRoot;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$ArchiveRoot;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$AbsolutePath;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$RelativePath;", "intellij.platform.lang.impl"})
public abstract class PortableFilePath {
    @JsonIgnore
    @NotNull
    public abstract String getPresentablePath();

    @NotNull
    public String toString() {
        return this.getPresentablePath();
    }

    private PortableFilePath() {
    }

    public /* synthetic */ PortableFilePath(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @JsonTypeName(value="project")
    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$ProjectRoot;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "()V", "presentablePath", "", "getPresentablePath", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "intellij.platform.lang.impl"})
    public static final class ProjectRoot
    extends PortableFilePath {
        @NotNull
        public static final ProjectRoot INSTANCE;

        @Override
        @NotNull
        public String getPresentablePath() {
            return "<project home>";
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof ProjectRoot;
        }

        public int hashCode() {
            return 42;
        }

        private ProjectRoot() {
            super(null);
        }

        static {
            ProjectRoot projectRoot;
            INSTANCE = projectRoot = new ProjectRoot();
        }
    }

    @JsonTypeName(value="library")
    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001:\u0001\"B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00c6\u0003J=\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020\bH\u00d6\u0001J\t\u0010!\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0014\u0010\u0015\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000f\u00a8\u0006#"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$LibraryRoot;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "libraryType", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$LibraryRoot$LibraryType;", "libraryName", "", "moduleName", "libraryRootIndex", "", "inClassFiles", "", "(Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$LibraryRoot$LibraryType;Ljava/lang/String;Ljava/lang/String;IZ)V", "getInClassFiles", "()Z", "getLibraryName", "()Ljava/lang/String;", "getLibraryRootIndex", "()I", "getLibraryType", "()Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$LibraryRoot$LibraryType;", "getModuleName", "presentablePath", "getPresentablePath", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "toString", "LibraryType", "intellij.platform.lang.impl"})
    public static final class LibraryRoot
    extends PortableFilePath {
        @NotNull
        private final LibraryType libraryType;
        @NotNull
        private final String libraryName;
        @Nullable
        private final String moduleName;
        private final int libraryRootIndex;
        private final boolean inClassFiles;

        @Override
        @NotNull
        public String getPresentablePath() {
            return "" + '<' + (Object)((Object)this.libraryType) + ' ' + (this.libraryType == LibraryType.MODULE ? '\'' + this.moduleName + "' " : "") + "library '" + this.libraryName + "'>/" + "<library " + (this.inClassFiles ? "class" : "source") + " root #" + this.libraryRootIndex + '>';
        }

        @NotNull
        public final LibraryType getLibraryType() {
            return this.libraryType;
        }

        @NotNull
        public final String getLibraryName() {
            return this.libraryName;
        }

        @Nullable
        public final String getModuleName() {
            return this.moduleName;
        }

        public final int getLibraryRootIndex() {
            return this.libraryRootIndex;
        }

        public final boolean getInClassFiles() {
            return this.inClassFiles;
        }

        public LibraryRoot(@NotNull LibraryType libraryType, @NotNull String libraryName, @Nullable String moduleName, int libraryRootIndex, boolean inClassFiles) {
            Intrinsics.checkNotNullParameter((Object)((Object)libraryType), (String)"libraryType");
            Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
            super(null);
            this.libraryType = libraryType;
            this.libraryName = libraryName;
            this.moduleName = moduleName;
            this.libraryRootIndex = libraryRootIndex;
            this.inClassFiles = inClassFiles;
        }

        @NotNull
        public final LibraryType component1() {
            return this.libraryType;
        }

        @NotNull
        public final String component2() {
            return this.libraryName;
        }

        @Nullable
        public final String component3() {
            return this.moduleName;
        }

        public final int component4() {
            return this.libraryRootIndex;
        }

        public final boolean component5() {
            return this.inClassFiles;
        }

        @NotNull
        public final LibraryRoot copy(@NotNull LibraryType libraryType, @NotNull String libraryName, @Nullable String moduleName, int libraryRootIndex, boolean inClassFiles) {
            Intrinsics.checkNotNullParameter((Object)((Object)libraryType), (String)"libraryType");
            Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
            return new LibraryRoot(libraryType, libraryName, moduleName, libraryRootIndex, inClassFiles);
        }

        public static /* synthetic */ LibraryRoot copy$default(LibraryRoot libraryRoot, LibraryType libraryType, String string, String string2, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                libraryType = libraryRoot.libraryType;
            }
            if ((n2 & 2) != 0) {
                string = libraryRoot.libraryName;
            }
            if ((n2 & 4) != 0) {
                string2 = libraryRoot.moduleName;
            }
            if ((n2 & 8) != 0) {
                n = libraryRoot.libraryRootIndex;
            }
            if ((n2 & 0x10) != 0) {
                bl = libraryRoot.inClassFiles;
            }
            return libraryRoot.copy(libraryType, string, string2, n, bl);
        }

        @Override
        @NotNull
        public String toString() {
            return "LibraryRoot(libraryType=" + (Object)((Object)this.libraryType) + ", libraryName=" + this.libraryName + ", moduleName=" + this.moduleName + ", libraryRootIndex=" + this.libraryRootIndex + ", inClassFiles=" + this.inClassFiles + ")";
        }

        public int hashCode() {
            LibraryType libraryType = this.libraryType;
            String string = this.libraryName;
            String string2 = this.moduleName;
            int n = ((((libraryType != null ? ((Object)((Object)libraryType)).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + Integer.hashCode(this.libraryRootIndex)) * 31;
            int n2 = this.inClassFiles ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LibraryRoot)) break block3;
                    LibraryRoot libraryRoot = (LibraryRoot)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.libraryType), (Object)((Object)libraryRoot.libraryType)) || !Intrinsics.areEqual((Object)this.libraryName, (Object)libraryRoot.libraryName) || !Intrinsics.areEqual((Object)this.moduleName, (Object)libraryRoot.moduleName) || this.libraryRootIndex != libraryRoot.libraryRootIndex || this.inClassFiles != libraryRoot.inClassFiles) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$LibraryRoot$LibraryType;", "", "(Ljava/lang/String;I)V", "toString", "", "APPLICATION", "PROJECT", "MODULE", "intellij.platform.lang.impl"})
        public static final class LibraryType
        extends Enum<LibraryType> {
            public static final /* enum */ LibraryType APPLICATION;
            public static final /* enum */ LibraryType PROJECT;
            public static final /* enum */ LibraryType MODULE;
            private static final /* synthetic */ LibraryType[] $VALUES;

            static {
                LibraryType[] libraryTypeArray = new LibraryType[3];
                LibraryType[] libraryTypeArray2 = libraryTypeArray;
                libraryTypeArray[0] = APPLICATION = new LibraryType();
                libraryTypeArray[1] = PROJECT = new LibraryType();
                libraryTypeArray[2] = MODULE = new LibraryType();
                $VALUES = libraryTypeArray;
            }

            @NotNull
            public String toString() {
                String string = this.name();
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                return string3;
            }

            public static LibraryType[] values() {
                return (LibraryType[])$VALUES.clone();
            }

            public static LibraryType valueOf(String string) {
                return Enum.valueOf(LibraryType.class, string);
            }
        }
    }

    @JsonTypeName(value="jdk")
    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$JdkRoot;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "jdkName", "", "jdkRootIndex", "", "inClassFiles", "", "(Ljava/lang/String;IZ)V", "getInClassFiles", "()Z", "getJdkName", "()Ljava/lang/String;", "getJdkRootIndex", "()I", "presentablePath", "getPresentablePath", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "toString", "intellij.platform.lang.impl"})
    public static final class JdkRoot
    extends PortableFilePath {
        @NotNull
        private final String jdkName;
        private final int jdkRootIndex;
        private final boolean inClassFiles;

        @Override
        @NotNull
        public String getPresentablePath() {
            return "<jdk " + this.jdkName + ">/" + "<jdk " + (this.inClassFiles ? "class" : "source") + " root #" + this.jdkRootIndex + '>';
        }

        @NotNull
        public final String getJdkName() {
            return this.jdkName;
        }

        public final int getJdkRootIndex() {
            return this.jdkRootIndex;
        }

        public final boolean getInClassFiles() {
            return this.inClassFiles;
        }

        public JdkRoot(@NotNull String jdkName, int jdkRootIndex, boolean inClassFiles) {
            Intrinsics.checkNotNullParameter((Object)jdkName, (String)"jdkName");
            super(null);
            this.jdkName = jdkName;
            this.jdkRootIndex = jdkRootIndex;
            this.inClassFiles = inClassFiles;
        }

        @NotNull
        public final String component1() {
            return this.jdkName;
        }

        public final int component2() {
            return this.jdkRootIndex;
        }

        public final boolean component3() {
            return this.inClassFiles;
        }

        @NotNull
        public final JdkRoot copy(@NotNull String jdkName, int jdkRootIndex, boolean inClassFiles) {
            Intrinsics.checkNotNullParameter((Object)jdkName, (String)"jdkName");
            return new JdkRoot(jdkName, jdkRootIndex, inClassFiles);
        }

        public static /* synthetic */ JdkRoot copy$default(JdkRoot jdkRoot, String string, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = jdkRoot.jdkName;
            }
            if ((n2 & 2) != 0) {
                n = jdkRoot.jdkRootIndex;
            }
            if ((n2 & 4) != 0) {
                bl = jdkRoot.inClassFiles;
            }
            return jdkRoot.copy(string, n, bl);
        }

        @Override
        @NotNull
        public String toString() {
            return "JdkRoot(jdkName=" + this.jdkName + ", jdkRootIndex=" + this.jdkRootIndex + ", inClassFiles=" + this.inClassFiles + ")";
        }

        public int hashCode() {
            String string = this.jdkName;
            int n = ((string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.jdkRootIndex)) * 31;
            int n2 = this.inClassFiles ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof JdkRoot)) break block3;
                    JdkRoot jdkRoot = (JdkRoot)object;
                    if (!Intrinsics.areEqual((Object)this.jdkName, (Object)jdkRoot.jdkName) || this.jdkRootIndex != jdkRoot.jdkRootIndex || this.inClassFiles != jdkRoot.inClassFiles) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @JsonTypeName(value="ide")
    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$IdeRoot;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "ideDirectoryType", "", "(Ljava/lang/String;)V", "getIdeDirectoryType", "()Ljava/lang/String;", "presentablePath", "getPresentablePath", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.lang.impl"})
    public static final class IdeRoot
    extends PortableFilePath {
        @NotNull
        private final String ideDirectoryType;

        @Override
        @NotNull
        public String getPresentablePath() {
            return "<ide " + this.ideDirectoryType + " dir>";
        }

        @NotNull
        public final String getIdeDirectoryType() {
            return this.ideDirectoryType;
        }

        public IdeRoot(@NotNull String ideDirectoryType) {
            Intrinsics.checkNotNullParameter((Object)ideDirectoryType, (String)"ideDirectoryType");
            super(null);
            this.ideDirectoryType = ideDirectoryType;
            boolean bl = IdePortableFilePathProvider.INSTANCE.getIDE_PATHS().keySet().contains(this.ideDirectoryType);
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = this.ideDirectoryType;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final String component1() {
            return this.ideDirectoryType;
        }

        @NotNull
        public final IdeRoot copy(@NotNull String ideDirectoryType) {
            Intrinsics.checkNotNullParameter((Object)ideDirectoryType, (String)"ideDirectoryType");
            return new IdeRoot(ideDirectoryType);
        }

        public static /* synthetic */ IdeRoot copy$default(IdeRoot ideRoot, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = ideRoot.ideDirectoryType;
            }
            return ideRoot.copy(string);
        }

        @Override
        @NotNull
        public String toString() {
            return "IdeRoot(ideDirectoryType=" + this.ideDirectoryType + ")";
        }

        public int hashCode() {
            String string = this.ideDirectoryType;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof IdeRoot)) break block3;
                    IdeRoot ideRoot = (IdeRoot)object;
                    if (!Intrinsics.areEqual((Object)this.ideDirectoryType, (Object)ideRoot.ideDirectoryType)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @JsonTypeName(value="archive")
    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\t\u0010\n\u001a\u00020\u0001H\u00c6\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$ArchiveRoot;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "archiveLocalPath", "(Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;)V", "getArchiveLocalPath", "()Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "presentablePath", "", "getPresentablePath", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.lang.impl"})
    public static final class ArchiveRoot
    extends PortableFilePath {
        @NotNull
        private final PortableFilePath archiveLocalPath;

        @Override
        @NotNull
        public String getPresentablePath() {
            return this.archiveLocalPath.getPresentablePath() + "!/";
        }

        @NotNull
        public final PortableFilePath getArchiveLocalPath() {
            return this.archiveLocalPath;
        }

        public ArchiveRoot(@NotNull PortableFilePath archiveLocalPath) {
            Intrinsics.checkNotNullParameter((Object)archiveLocalPath, (String)"archiveLocalPath");
            super(null);
            this.archiveLocalPath = archiveLocalPath;
        }

        @NotNull
        public final PortableFilePath component1() {
            return this.archiveLocalPath;
        }

        @NotNull
        public final ArchiveRoot copy(@NotNull PortableFilePath archiveLocalPath) {
            Intrinsics.checkNotNullParameter((Object)archiveLocalPath, (String)"archiveLocalPath");
            return new ArchiveRoot(archiveLocalPath);
        }

        public static /* synthetic */ ArchiveRoot copy$default(ArchiveRoot archiveRoot, PortableFilePath portableFilePath, int n, Object object) {
            if ((n & 1) != 0) {
                portableFilePath = archiveRoot.archiveLocalPath;
            }
            return archiveRoot.copy(portableFilePath);
        }

        @Override
        @NotNull
        public String toString() {
            return "ArchiveRoot(archiveLocalPath=" + this.archiveLocalPath + ")";
        }

        public int hashCode() {
            PortableFilePath portableFilePath = this.archiveLocalPath;
            return portableFilePath != null ? portableFilePath.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ArchiveRoot)) break block3;
                    ArchiveRoot archiveRoot = (ArchiveRoot)object;
                    if (!Intrinsics.areEqual((Object)this.archiveLocalPath, (Object)archiveRoot.archiveLocalPath)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @JsonTypeName(value="absolute")
    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$AbsolutePath;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "absoluteUrl", "", "(Ljava/lang/String;)V", "getAbsoluteUrl", "()Ljava/lang/String;", "presentablePath", "getPresentablePath", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.lang.impl"})
    public static final class AbsolutePath
    extends PortableFilePath {
        @NotNull
        private final String absoluteUrl;

        @Override
        @NotNull
        public String getPresentablePath() {
            return "<absolute>/" + this.absoluteUrl;
        }

        @NotNull
        public final String getAbsoluteUrl() {
            return this.absoluteUrl;
        }

        public AbsolutePath(@NotNull String absoluteUrl) {
            Intrinsics.checkNotNullParameter((Object)absoluteUrl, (String)"absoluteUrl");
            super(null);
            this.absoluteUrl = absoluteUrl;
        }

        @NotNull
        public final String component1() {
            return this.absoluteUrl;
        }

        @NotNull
        public final AbsolutePath copy(@NotNull String absoluteUrl) {
            Intrinsics.checkNotNullParameter((Object)absoluteUrl, (String)"absoluteUrl");
            return new AbsolutePath(absoluteUrl);
        }

        public static /* synthetic */ AbsolutePath copy$default(AbsolutePath absolutePath, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = absolutePath.absoluteUrl;
            }
            return absolutePath.copy(string);
        }

        @Override
        @NotNull
        public String toString() {
            return "AbsolutePath(absoluteUrl=" + this.absoluteUrl + ")";
        }

        public int hashCode() {
            String string = this.absoluteUrl;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof AbsolutePath)) break block3;
                    AbsolutePath absolutePath = (AbsolutePath)object;
                    if (!Intrinsics.areEqual((Object)this.absoluteUrl, (Object)absolutePath.absoluteUrl)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @JsonTypeName(value="relative")
    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0004H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001R\u0014\u0010\u0006\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$RelativePath;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "root", "relativePath", "", "(Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;Ljava/lang/String;)V", "presentablePath", "getPresentablePath", "()Ljava/lang/String;", "getRelativePath", "getRoot", "()Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.lang.impl"})
    public static final class RelativePath
    extends PortableFilePath {
        @NotNull
        private final PortableFilePath root;
        @NotNull
        private final String relativePath;

        @Override
        @NotNull
        public String getPresentablePath() {
            return StringsKt.trimEnd((String)this.root.getPresentablePath(), (char[])new char[]{'/'}) + '/' + this.relativePath;
        }

        @NotNull
        public final PortableFilePath getRoot() {
            return this.root;
        }

        @NotNull
        public final String getRelativePath() {
            return this.relativePath;
        }

        public RelativePath(@NotNull PortableFilePath root2, @NotNull String relativePath) {
            Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            super(null);
            this.root = root2;
            this.relativePath = relativePath;
            boolean bl = !StringsKt.startsWith$default((CharSequence)this.relativePath, (char)'/', (boolean)false, (int)2, null);
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = this.relativePath;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final PortableFilePath component1() {
            return this.root;
        }

        @NotNull
        public final String component2() {
            return this.relativePath;
        }

        @NotNull
        public final RelativePath copy(@NotNull PortableFilePath root2, @NotNull String relativePath) {
            Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            return new RelativePath(root2, relativePath);
        }

        public static /* synthetic */ RelativePath copy$default(RelativePath relativePath, PortableFilePath portableFilePath, String string, int n, Object object) {
            if ((n & 1) != 0) {
                portableFilePath = relativePath.root;
            }
            if ((n & 2) != 0) {
                string = relativePath.relativePath;
            }
            return relativePath.copy(portableFilePath, string);
        }

        @Override
        @NotNull
        public String toString() {
            return "RelativePath(root=" + this.root + ", relativePath=" + this.relativePath + ")";
        }

        public int hashCode() {
            PortableFilePath portableFilePath = this.root;
            String string = this.relativePath;
            return (portableFilePath != null ? portableFilePath.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RelativePath)) break block3;
                    RelativePath relativePath = (RelativePath)object;
                    if (!Intrinsics.areEqual((Object)this.root, (Object)relativePath.root) || !Intrinsics.areEqual((Object)this.relativePath, (Object)relativePath.relativePath)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

