/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dump.paths.resolvers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.resolvers.PortableFilePathResolver;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/paths/resolvers/ProjectRootPortableFilePathResolver;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/resolvers/PortableFilePathResolver;", "()V", "findFileByPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "portableFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "intellij.platform.lang.impl"})
public final class ProjectRootPortableFilePathResolver
implements PortableFilePathResolver {
    @NotNull
    public static final ProjectRootPortableFilePathResolver INSTANCE;

    @Override
    @Nullable
    public VirtualFile findFileByPath(@NotNull Project project, @NotNull PortableFilePath portableFilePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)portableFilePath, (String)"portableFilePath");
        if (portableFilePath instanceof PortableFilePath.ProjectRoot) {
            String string = project.getBasePath();
            if (string == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.basePath ?: return null");
            String projectBasePath = string;
            return VfsUtil.findFile((Path)Paths.get(projectBasePath, new String[0]), (boolean)true);
        }
        return null;
    }

    private ProjectRootPortableFilePathResolver() {
    }

    static {
        ProjectRootPortableFilePathResolver projectRootPortableFilePathResolver;
        INSTANCE = projectRootPortableFilePathResolver = new ProjectRootPortableFilePathResolver();
    }
}

