/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.roots.ProjectIndexableFilesIterator;
import com.intellij.util.indexing.roots.kind.ProjectFileOrDirOrigin;
import com.intellij.util.indexing.roots.origin.ProjectFileOrDirOriginImpl;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/util/indexing/roots/ProjectIndexableFilesIteratorImpl;", "Lcom/intellij/util/indexing/roots/ProjectIndexableFilesIterator;", "fileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getDebugName", "", "getIndexingProgressText", "getOrigin", "Lcom/intellij/util/indexing/roots/kind/ProjectFileOrDirOrigin;", "getRootUrls", "", "getRootsScanningProgressText", "iterateFiles", "", "project", "Lcom/intellij/openapi/project/Project;", "fileIterator", "Lcom/intellij/openapi/roots/ContentIterator;", "fileFilter", "Lcom/intellij/openapi/vfs/VirtualFileFilter;", "intellij.platform.lang.impl"})
public final class ProjectIndexableFilesIteratorImpl
implements ProjectIndexableFilesIterator {
    private final VirtualFile fileOrDir;

    @NotNull
    public String getDebugName() {
        return "Files under `" + this.fileOrDir.getPath() + '`';
    }

    @NotNull
    public String getIndexingProgressText() {
        String string = IndexingBundle.message((String)"indexable.files.provider.indexing.fileOrDir.name", (Object[])new Object[]{this.fileOrDir.getName()});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IndexingBundle.message(\"\u2026ir.name\", fileOrDir.name)");
        return string;
    }

    @NotNull
    public String getRootsScanningProgressText() {
        String string = IndexingBundle.message((String)"indexable.files.provider.scanning.fileOrDir.name", (Object[])new Object[]{this.fileOrDir.getName()});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IndexingBundle.message(\"\u2026ir.name\", fileOrDir.name)");
        return string;
    }

    @NotNull
    public ProjectFileOrDirOrigin getOrigin() {
        return new ProjectFileOrDirOriginImpl(this.fileOrDir);
    }

    public boolean iterateFiles(@NotNull Project project, @NotNull ContentIterator fileIterator, @NotNull VirtualFileFilter fileFilter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileIterator, (String)"fileIterator");
        Intrinsics.checkNotNullParameter((Object)fileFilter, (String)"fileFilter");
        return ProjectFileIndex.getInstance((Project)project).iterateContentUnderDirectory(this.fileOrDir, fileIterator, fileFilter);
    }

    @NotNull
    public Set<String> getRootUrls() {
        throw (Throwable)new UnsupportedOperationException();
    }

    public ProjectIndexableFilesIteratorImpl(@NotNull VirtualFile fileOrDir) {
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        this.fileOrDir = fileOrDir;
    }
}

