/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots.builders;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.indexing.roots.IndexableEntityProvider;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.builders.FullModuleContentIteratorBuilder;
import com.intellij.util.indexing.roots.builders.IndexableIteratorBuilderHandler;
import com.intellij.util.indexing.roots.builders.InheritedSdkIteratorBuilder;
import com.intellij.util.indexing.roots.builders.LibraryIdIteratorBuilder;
import com.intellij.util.indexing.roots.builders.ModuleRootsIteratorBuilder;
import com.intellij.util.indexing.roots.builders.SdkIteratorBuilder;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryId;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleId;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0011\u001a\u00020\u0012J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\"\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\tJ0\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cJ*\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00182\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006%"}, d2={"Lcom/intellij/util/indexing/roots/builders/IndexableIteratorBuilders;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "forInheritedSdk", "", "Lcom/intellij/util/indexing/roots/IndexableEntityProvider$IndexableIteratorBuilder;", "forLibraryEntity", "libraryId", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryId;", "dependencyChecked", "", "forModuleContent", "moduleId", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleId;", "forModuleRoots", "url", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "urls", "newRoots", "", "oldRoots", "forSdk", "sdkName", "", "sdkType", "instantiateBuilders", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "builders", "project", "Lcom/intellij/openapi/project/Project;", "entityStorage", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "intellij.platform.lang.impl"})
public final class IndexableIteratorBuilders {
    @NotNull
    private static final Logger logger;
    @NotNull
    public static final IndexableIteratorBuilders INSTANCE;

    @NotNull
    public final Logger getLogger() {
        return logger;
    }

    @NotNull
    public final Collection<IndexableEntityProvider.IndexableIteratorBuilder> forModuleRoots(@NotNull ModuleId moduleId, @NotNull Collection<? extends VirtualFileUrl> urls) {
        Intrinsics.checkNotNullParameter((Object)moduleId, (String)"moduleId");
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        return urls.isEmpty() ? (Collection)CollectionsKt.emptyList() : (Collection)CollectionsKt.listOf((Object)new ModuleRootsIteratorBuilder(moduleId, urls));
    }

    @NotNull
    public final Collection<IndexableEntityProvider.IndexableIteratorBuilder> forModuleRoots(@NotNull ModuleId moduleId, @NotNull VirtualFileUrl url) {
        Intrinsics.checkNotNullParameter((Object)moduleId, (String)"moduleId");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return CollectionsKt.listOf((Object)new ModuleRootsIteratorBuilder(moduleId, url));
    }

    @NotNull
    public final Collection<IndexableEntityProvider.IndexableIteratorBuilder> forModuleRoots(@NotNull ModuleId moduleId, @NotNull List<? extends VirtualFileUrl> newRoots, @NotNull List<? extends VirtualFileUrl> oldRoots) {
        Intrinsics.checkNotNullParameter((Object)moduleId, (String)"moduleId");
        Intrinsics.checkNotNullParameter(newRoots, (String)"newRoots");
        Intrinsics.checkNotNullParameter(oldRoots, (String)"oldRoots");
        List roots2 = CollectionsKt.toMutableList((Collection)newRoots);
        roots2.removeAll((Collection)oldRoots);
        return this.forModuleRoots(moduleId, roots2);
    }

    @NotNull
    public final Collection<IndexableEntityProvider.IndexableIteratorBuilder> forLibraryEntity(@NotNull LibraryId libraryId, boolean dependencyChecked) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        return CollectionsKt.listOf((Object)new LibraryIdIteratorBuilder(libraryId, dependencyChecked));
    }

    @NotNull
    public final Collection<IndexableEntityProvider.IndexableIteratorBuilder> forSdk(@NotNull String sdkName, @NotNull String sdkType) {
        Intrinsics.checkNotNullParameter((Object)sdkName, (String)"sdkName");
        Intrinsics.checkNotNullParameter((Object)sdkType, (String)"sdkType");
        return CollectionsKt.listOf((Object)new SdkIteratorBuilder(sdkName, sdkType));
    }

    @NotNull
    public final Collection<IndexableEntityProvider.IndexableIteratorBuilder> forInheritedSdk() {
        return CollectionsKt.listOf((Object)InheritedSdkIteratorBuilder.INSTANCE);
    }

    @NotNull
    public final Collection<IndexableEntityProvider.IndexableIteratorBuilder> forModuleContent(@NotNull ModuleId moduleId) {
        Intrinsics.checkNotNullParameter((Object)moduleId, (String)"moduleId");
        return CollectionsKt.listOf((Object)new FullModuleContentIteratorBuilder(moduleId));
    }

    @NotNull
    public final List<IndexableFilesIterator> instantiateBuilders(@NotNull List<? extends IndexableEntityProvider.IndexableIteratorBuilder> builders, @NotNull Project project, @NotNull WorkspaceEntityStorage entityStorage) {
        Intrinsics.checkNotNullParameter(builders, (String)"builders");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)entityStorage, (String)"entityStorage");
        if (builders.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ArrayList result2 = new ArrayList(builders.size());
        List buildersToProceed = builders;
        ExtensionPointName<IndexableIteratorBuilderHandler> extensionPointName = IndexableIteratorBuilderHandler.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"IndexableIteratorBuilderHandler.EP_NAME");
        List list2 = extensionPointName.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"IndexableIteratorBuilder\u2026ler.EP_NAME.extensionList");
        List handlers = list2;
        for (IndexableIteratorBuilderHandler handler2 : handlers) {
            ProgressManager.checkCanceled();
            Iterable $this$partition$iv = buildersToProceed;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                IndexableEntityProvider.IndexableIteratorBuilder it = (IndexableEntityProvider.IndexableIteratorBuilder)element$iv;
                boolean bl = false;
                if (handler2.accepts(it)) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair partition = new Pair(first$iv, second$iv);
            buildersToProceed = (List)partition.getSecond();
            Collection collection = (Collection)partition.getFirst();
            boolean bl = false;
            if (!(!collection.isEmpty())) continue;
            result2.addAll(handler2.instantiate((Collection)partition.getFirst(), project, entityStorage));
        }
        Collection collection = buildersToProceed;
        boolean bl = false;
        if (!collection.isEmpty()) {
            logger.error("Failed to find handlers for IndexableIteratorBuilders: " + buildersToProceed + ";\n" + "available handlers: " + handlers);
        }
        return result2;
    }

    private IndexableIteratorBuilders() {
    }

    static {
        IndexableIteratorBuilders indexableIteratorBuilders;
        INSTANCE = indexableIteratorBuilders = new IndexableIteratorBuilders();
        IndexableIteratorBuilders $this$thisLogger$iv = indexableIteratorBuilders;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(IndexableIteratorBuilders.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        IndexableIteratorBuilders.logger = logger;
    }
}

