/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.snapshot;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.CompressionUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexedHashesSupport;
import com.intellij.util.indexing.InputMapExternalizer;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.forward.AbstractForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.AbstractMapForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.indexing.impl.perFileVersion.PersistentSubIndexerRetriever;
import com.intellij.util.indexing.impl.storage.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.snapshot.CompositeHashIdEnumerator;
import com.intellij.util.indexing.snapshot.HashIdForwardIndexAccessor;
import com.intellij.util.indexing.snapshot.HashedInputData;
import com.intellij.util.indexing.snapshot.SnapshotHashEnumeratorService;
import com.intellij.util.indexing.snapshot.SnapshotInputMappingsStatistics;
import com.intellij.util.indexing.storage.UpdatableSnapshotInputMappingIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.NullableDataExternalizer;
import com.intellij.util.io.PersistentHashMap;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class SnapshotInputMappings<Key, Value>
implements UpdatableSnapshotInputMappingIndex<Key, Value, FileContent> {
    private static final Logger LOG = Logger.getInstance(SnapshotInputMappings.class);
    private final ID<Key, Value> myIndexId;
    private final DataExternalizer<Map<Key, Value>> myMapExternalizer;
    private final DataExternalizer<Value> myValueExternalizer;
    private final DataIndexer<Key, Value, FileContent> myIndexer;
    @NotNull
    private final PersistentMapBasedForwardIndex myContents;
    @NotNull
    private final SnapshotHashEnumeratorService.HashEnumeratorHandle myEnumeratorHandle;
    private volatile PersistentHashMap<Integer, String> myIndexingTrace;
    @Nullable
    private final SnapshotInputMappingsStatistics myStatistics;
    private final HashIdForwardIndexAccessor<Key, Value, FileContent> myHashIdForwardIndexAccessor;
    private final CompositeHashIdEnumerator myCompositeHashIdEnumerator;
    private PersistentSubIndexerRetriever<?, ?> mySubIndexerRetriever;
    private static final Key<Integer> ourContentHashIdKey = Key.create((String)"saved.content.hash.id");

    public static int getVersion() {
        assert (FileBasedIndex.ourSnapshotMappingsEnabled);
        return 4096;
    }

    public SnapshotInputMappings(@NotNull IndexExtension<Key, Value, FileContent> indexExtension2, @NotNull AbstractMapForwardIndexAccessor<Key, Value, ?> accessor2) throws IOException {
        if (indexExtension2 == null) {
            SnapshotInputMappings.$$$reportNull$$$0(0);
        }
        if (accessor2 == null) {
            SnapshotInputMappings.$$$reportNull$$$0(1);
        }
        this.myIndexId = (ID)indexExtension2.getName();
        this.myStatistics = IndexDebugProperties.DEBUG ? new SnapshotInputMappingsStatistics(this.myIndexId) : null;
        boolean storeOnlySingleValue = indexExtension2 instanceof SingleEntryFileBasedIndexExtension;
        this.myMapExternalizer = storeOnlySingleValue ? null : new InputMapExternalizer<Key, Value>(indexExtension2);
        this.myValueExternalizer = storeOnlySingleValue ? new NullableDataExternalizer(indexExtension2.getValueExternalizer()) : null;
        this.myIndexer = indexExtension2.getIndexer();
        this.myContents = this.createContentsIndex();
        this.myHashIdForwardIndexAccessor = new HashIdForwardIndexAccessor(this, accessor2);
        this.myIndexingTrace = IndexDebugProperties.EXTRA_SANITY_CHECKS ? this.createIndexingTrace() : null;
        this.myEnumeratorHandle = SnapshotHashEnumeratorService.getInstance().createHashEnumeratorHandle(this.myIndexId);
        this.myCompositeHashIdEnumerator = VfsAwareMapReduceIndex.isCompositeIndexer(this.myIndexer) ? new CompositeHashIdEnumerator(this.myIndexId) : null;
    }

    public HashIdForwardIndexAccessor<Key, Value, FileContent> getForwardIndexAccessor() {
        return this.myHashIdForwardIndexAccessor;
    }

    public Path getInputIndexStorageFile() throws IOException {
        return IndexInfrastructure.getIndexRootDir(this.myIndexId).resolve("fileIdToHashId");
    }

    @Override
    @NotNull
    public Map<Key, Value> readData(int hashId) throws IOException {
        Map map2 = (Map)ObjectUtils.notNull(this.doReadData(hashId), Collections.emptyMap());
        if (map2 == null) {
            SnapshotInputMappings.$$$reportNull$$$0(2);
        }
        return map2;
    }

    @Override
    @Nullable
    public InputData<Key, Value> readData(@NotNull FileContent content2) throws IOException {
        if (content2 == null) {
            SnapshotInputMappings.$$$reportNull$$$0(3);
        }
        if (!((FileContentImpl)content2).isPhysicalContent()) {
            throw new IllegalArgumentException("Non-physical data are not allowed.");
        }
        int hashId = this.getHashId(content2);
        Map<Key, Value> data2 = this.doReadData(hashId);
        if (this.myStatistics != null) {
            this.myStatistics.update(data2 == null);
        }
        if (data2 != null && IndexDebugProperties.EXTRA_SANITY_CHECKS) {
            boolean sameValueForSavedIndexedResultAndCurrentOne;
            Map contentData = this.myIndexer.map((Object)content2);
            if (this.myIndexer instanceof SingleEntryIndexer) {
                Object contentValue = ContainerUtil.getFirstItem(contentData.values());
                Object value2 = ContainerUtil.getFirstItem(data2.values());
                sameValueForSavedIndexedResultAndCurrentOne = Comparing.equal((Object)contentValue, (Object)value2);
            } else {
                sameValueForSavedIndexedResultAndCurrentOne = contentData.equals(data2);
            }
            if (!sameValueForSavedIndexedResultAndCurrentOne) {
                LOG.error("Unexpected difference in indexing of\n" + this.getContentDebugData(content2) + "\n by index " + this.myIndexId + "\nprevious indexed info " + (String)this.myIndexingTrace.get((Object)hashId) + "\ndiff " + this.buildDiff(data2, contentData));
            }
        }
        return data2 == null ? null : new HashedInputData<Key, Value>(data2, hashId);
    }

    @Nullable
    private Map<Key, Value> doReadData(int hashId) throws IOException {
        ByteArraySequence byteSequence = this.readContents(hashId);
        return byteSequence != null ? this.deserialize(byteSequence) : null;
    }

    @NotNull
    private Map<Key, Value> deserialize(@NotNull ByteArraySequence byteSequence) throws IOException {
        if (byteSequence == null) {
            SnapshotInputMappings.$$$reportNull$$$0(4);
        }
        if (this.myMapExternalizer != null) {
            Map map2 = (Map)AbstractForwardIndexAccessor.deserializeFromByteSeq((ByteArraySequence)byteSequence, this.myMapExternalizer);
            if (map2 == null) {
                SnapshotInputMappings.$$$reportNull$$$0(5);
            }
            return map2;
        }
        assert (this.myValueExternalizer != null);
        Object value2 = AbstractForwardIndexAccessor.deserializeFromByteSeq((ByteArraySequence)byteSequence, this.myValueExternalizer);
        if (value2 == null && !((SingleEntryIndexer)this.myIndexer).isAcceptNullValues()) {
            Map map3 = Collections.emptyMap();
            if (map3 == null) {
                SnapshotInputMappings.$$$reportNull$$$0(6);
            }
            return map3;
        }
        Map<Integer, Object> map4 = Collections.singletonMap(0, value2);
        if (map4 == null) {
            SnapshotInputMappings.$$$reportNull$$$0(7);
        }
        return map4;
    }

    @NotNull
    private ByteArraySequence serializeData(@NotNull Map<Key, Value> data2) throws IOException {
        if (data2 == null) {
            SnapshotInputMappings.$$$reportNull$$$0(8);
        }
        if (this.myMapExternalizer != null) {
            ByteArraySequence byteArraySequence = AbstractForwardIndexAccessor.serializeValueToByteSeq(data2, this.myMapExternalizer, (int)(data2.size() * 4));
            if (byteArraySequence == null) {
                SnapshotInputMappings.$$$reportNull$$$0(9);
            }
            return byteArraySequence;
        }
        assert (this.myValueExternalizer != null);
        ByteArraySequence byteArraySequence = AbstractForwardIndexAccessor.serializeValueToByteSeq((Object)ContainerUtil.getFirstItem(data2.values()), this.myValueExternalizer, (int)4);
        if (byteArraySequence == null) {
            SnapshotInputMappings.$$$reportNull$$$0(10);
        }
        return byteArraySequence;
    }

    @Override
    public InputData<Key, Value> putData(@NotNull FileContent content2, @NotNull InputData<Key, Value> data2) throws IOException {
        InputData result2;
        int hashId;
        if (content2 == null) {
            SnapshotInputMappings.$$$reportNull$$$0(11);
        }
        if (data2 == null) {
            SnapshotInputMappings.$$$reportNull$$$0(12);
        }
        if (data2 instanceof HashedInputData) {
            hashId = ((HashedInputData)data2).getHashId();
            result2 = data2;
        } else {
            hashId = this.getHashId(content2);
            result2 = hashId == 0 ? InputData.empty() : new HashedInputData(data2.getKeyValues(), hashId);
        }
        boolean saved = this.savePersistentData(data2.getKeyValues(), hashId);
        if (IndexDebugProperties.EXTRA_SANITY_CHECKS && saved) {
            try {
                this.myIndexingTrace.put((Object)hashId, (Object)(this.getContentDebugData(content2) + "," + ExceptionUtil.getThrowableText((Throwable)new Throwable())));
            }
            catch (IOException ex) {
                LOG.error((Throwable)ex);
            }
        }
        return result2;
    }

    @NotNull
    private String getContentDebugData(@NotNull FileContent input) {
        if (input == null) {
            SnapshotInputMappings.$$$reportNull$$$0(13);
        }
        FileContentImpl content2 = (FileContentImpl)input;
        ArrayList<Object> data2 = new ArrayList<Object>();
        data2.add(content2.getFile().getPath());
        data2.add(content2.getFileType().getName());
        data2.add(content2.getCharset().name());
        if (VfsAwareMapReduceIndex.isCompositeIndexer(this.myIndexer)) {
            data2.add("composite indexer: " + this.mySubIndexerRetriever.getVersion(content2));
        }
        String string = "[" + StringUtil.join(data2, (String)";") + "]";
        if (string == null) {
            SnapshotInputMappings.$$$reportNull$$$0(14);
        }
        return string;
    }

    private int getHashId(@Nullable FileContent content2) throws IOException {
        if (content2 == null) {
            return 0;
        }
        int hash = this.doGetContentHash((FileContentImpl)content2);
        if (this.myCompositeHashIdEnumerator != null) {
            int subIndexerTypeId = this.mySubIndexerRetriever.getFileIndexerId((IndexedFile)content2);
            hash = this.myCompositeHashIdEnumerator.enumerate(hash, subIndexerTypeId);
        }
        return hash;
    }

    @Override
    public void flush() {
        this.myContents.force();
        if (this.myIndexingTrace != null) {
            this.myIndexingTrace.force();
        }
        if (this.myCompositeHashIdEnumerator != null) {
            this.myCompositeHashIdEnumerator.force();
        }
    }

    @Override
    public void clear() throws IOException {
        try {
            if (this.myCompositeHashIdEnumerator != null) {
                try {
                    this.myCompositeHashIdEnumerator.clear();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            if (this.myIndexingTrace != null) {
                this.myIndexingTrace.closeAndClean();
                this.myIndexingTrace = this.createIndexingTrace();
            }
        }
        finally {
            try {
                this.myContents.clear();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        IOUtil.closeSafe((Logger)LOG, (Closeable[])new Closeable[]{this.myContents, this.myIndexingTrace, this.myCompositeHashIdEnumerator});
        this.myEnumeratorHandle.release();
    }

    @NotNull
    private PersistentMapBasedForwardIndex createContentsIndex() throws IOException {
        Path saved = IndexInfrastructure.getPersistentIndexRootDir(this.myIndexId).resolve("values");
        try {
            return new PersistentMapBasedForwardIndex(saved, false);
        }
        catch (IOException ex) {
            IOUtil.deleteAllFilesStartingWith((Path)saved);
            throw ex;
        }
    }

    private PersistentHashMap<Integer, String> createIndexingTrace() throws IOException {
        Path mapFile = IndexInfrastructure.getIndexRootDir(this.myIndexId).resolve("indextrace");
        try {
            return new PersistentHashMap(mapFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new DataExternalizer<String>(){

                public void save(@NotNull DataOutput out, String value2) throws IOException {
                    if (out == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    out.write((byte[])CompressionUtil.compressStringRawBytes((CharSequence)value2));
                }

                public String read(@NotNull DataInput in) throws IOException {
                    if (in == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    byte[] b = new byte[((InputStream)((Object)in)).available()];
                    in.readFully(b);
                    return (String)CompressionUtil.uncompressStringRawBytes((Object)b);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "out";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "in";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/util/indexing/snapshot/SnapshotInputMappings$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "save";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "read";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, 4096);
        }
        catch (IOException ex) {
            IOUtil.deleteAllFilesStartingWith((Path)mapFile);
            throw ex;
        }
    }

    private ByteArraySequence readContents(int hashId) throws IOException {
        return this.myContents.get(Integer.valueOf(hashId));
    }

    public void setSubIndexerRetriever(@NotNull PersistentSubIndexerRetriever<?, ?> retriever) {
        if (retriever == null) {
            SnapshotInputMappings.$$$reportNull$$$0(15);
        }
        assert (this.myCompositeHashIdEnumerator != null);
        this.mySubIndexerRetriever = retriever;
    }

    @NotNull
    private Integer doGetContentHash(FileContentImpl content2) throws IOException {
        Integer previouslyCalculatedContentHashId = (Integer)content2.getUserData(ourContentHashIdKey);
        if (previouslyCalculatedContentHashId == null) {
            byte[] hash = IndexedHashesSupport.getOrInitIndexedHash(content2);
            previouslyCalculatedContentHashId = this.myEnumeratorHandle.enumerateHash(hash);
            content2.putUserData(ourContentHashIdKey, previouslyCalculatedContentHashId);
        }
        Integer n = previouslyCalculatedContentHashId;
        if (n == null) {
            SnapshotInputMappings.$$$reportNull$$$0(16);
        }
        return n;
    }

    private StringBuilder buildDiff(Map<Key, Value> data2, Map<Key, Value> contentData) {
        Value value2;
        StringBuilder moreInfo = new StringBuilder();
        if (contentData.size() != data2.size()) {
            moreInfo.append("Indexer has different number of elements, previously ").append(data2.size()).append(" after ").append(contentData.size()).append("\n");
        } else {
            moreInfo.append("total ").append(contentData.size()).append(" entries\n");
        }
        for (Map.Entry<Key, Value> keyValueEntry : contentData.entrySet()) {
            if (!data2.containsKey(keyValueEntry.getKey())) {
                moreInfo.append("Previous data doesn't contain:").append(keyValueEntry.getKey()).append(" with value ").append(keyValueEntry.getValue()).append("\n");
                continue;
            }
            value2 = data2.get(keyValueEntry.getKey());
            if (Comparing.equal(keyValueEntry.getValue(), value2)) continue;
            moreInfo.append("Previous data has different value for key:").append(keyValueEntry.getKey()).append(", new value ").append(keyValueEntry.getValue()).append(", oldValue:").append(value2).append("\n");
        }
        for (Map.Entry<Key, Value> keyValueEntry : data2.entrySet()) {
            if (!contentData.containsKey(keyValueEntry.getKey())) {
                moreInfo.append("New data doesn't contain:").append(keyValueEntry.getKey()).append(" with value ").append(keyValueEntry.getValue()).append("\n");
                continue;
            }
            value2 = contentData.get(keyValueEntry.getKey());
            if (Comparing.equal(keyValueEntry.getValue(), value2)) continue;
            moreInfo.append("New data has different value for key:").append(keyValueEntry.getKey()).append(" new value ").append(value2).append(", oldValue:").append(keyValueEntry.getValue()).append("\n");
        }
        return moreInfo;
    }

    private boolean savePersistentData(@NotNull Map<Key, Value> data2, int id2) {
        if (data2 == null) {
            SnapshotInputMappings.$$$reportNull$$$0(17);
        }
        try {
            if (this.myContents.containsMapping(id2)) {
                return false;
            }
            ByteArraySequence bytes = this.serializeData(data2);
            this.myContents.put(Integer.valueOf(id2), bytes);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return true;
    }

    @ApiStatus.Internal
    public void resetStatistics() {
        if (this.myStatistics != null) {
            this.myStatistics.reset();
        }
    }

    @ApiStatus.Internal
    @Nullable
    public SnapshotInputMappingsStatistics dumpStatistics() {
        return this.myStatistics;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexExtension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/snapshot/SnapshotInputMappings";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byteSequence";
                break;
            }
            case 8: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "retriever";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/snapshot/SnapshotInputMappings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readData";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeData";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentDebugData";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetContentHash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "serializeData";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "putData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getContentDebugData";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setSubIndexerRetriever";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "savePersistentData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

