/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.processHandshake;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.util.io.processHandshake.ProcessHandshakeLauncherKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/util/io/processHandshake/LoggingProcessListener;", "Lcom/intellij/execution/process/ProcessAdapter;", "()V", "onTextAvailable", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "processTerminated", "intellij.platform.ide.impl"})
final class LoggingProcessListener
extends ProcessAdapter {
    @NotNull
    public static final LoggingProcessListener INSTANCE;

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        Logger logger = ProcessHandshakeLauncherKt.access$getLOG$p();
        StringBuilder stringBuilder = new StringBuilder().append("Process [").append(outputType).append("]: ");
        String string = event.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.text");
        logger.info(stringBuilder.append(StringsKt.removeSuffix((String)string, (CharSequence)"\n")).toString());
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = ProcessTerminatedListener.stringifyExitCode((int)event.getExitCode());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ProcessTerminatedListene\u2026yExitCode(event.exitCode)");
        String exitCodeString = string;
        ProcessHandshakeLauncherKt.access$getLOG$p().info("Process terminated with exit code " + exitCodeString);
    }

    private LoggingProcessListener() {
    }

    static {
        LoggingProcessListener loggingProcessListener;
        INSTANCE = loggingProcessListener = new LoggingProcessListener();
    }
}

