/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.progress;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.util.progress.ConcurrentTasksProgressManager;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class SubTaskProgressIndicator
extends SensitiveProgressWrapper {
    private final ConcurrentTasksProgressManager myProgressManager;
    private final AtomicLong myFraction;
    private final int myTaskWeight;

    SubTaskProgressIndicator(ConcurrentTasksProgressManager progressManager, int taskWeight) {
        super(progressManager.getParent());
        this.myProgressManager = progressManager;
        this.myTaskWeight = taskWeight;
        this.myFraction = new AtomicLong();
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
    }

    @Override
    public void setText(String text2) {
        this.myProgressManager.setText2(this, text2);
    }

    @Override
    public void setFraction(double newValue2) {
        double oldValue = Double.longBitsToDouble(this.myFraction.getAndSet(Double.doubleToRawLongBits(newValue2)));
        this.myProgressManager.updateTaskFraction(newValue2 - oldValue, this.myTaskWeight);
    }

    @Override
    public void setText2(String text2) {
    }

    @Override
    public double getFraction() {
        return Double.longBitsToDouble(this.myFraction.get());
    }

    public void finished() {
        this.setFraction(1.0);
        this.myProgressManager.setText2(this, null);
    }
}

