/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.browser.LoadingChangesPanel;
import com.intellij.openapi.vcs.history.actions.GetVersionAction;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vcs.impl.ChangesBrowserToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareWithLocalDialog {
    public static void showChanges(@NotNull Project project, @NotNull @NlsContexts.DialogTitle String dialogTitle, @NotNull LocalContent localContent, @NotNull ThrowableComputable<? extends Collection<Change>, ? extends VcsException> changesLoader) {
        if (project == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(0);
        }
        if (dialogTitle == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(1);
        }
        if (localContent == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(2);
        }
        if (changesLoader == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(3);
        }
        if (AbstractVcsHelperImpl.showCommittedChangesAsTab()) {
            CompareWithLocalDialog.showAsTab(project, dialogTitle, localContent, changesLoader);
        } else {
            CompareWithLocalDialog.showDialog(project, dialogTitle, localContent, changesLoader);
        }
    }

    private static void showDialog(@NotNull Project project, @NotNull @NlsContexts.DialogTitle String dialogTitle, @NotNull LocalContent localContent, @NotNull ThrowableComputable<? extends Collection<Change>, ? extends VcsException> changesLoader) {
        if (project == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(4);
        }
        if (dialogTitle == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(5);
        }
        if (localContent == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(6);
        }
        if (changesLoader == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(7);
        }
        MyLoadingChangesPanel changesPanel = CompareWithLocalDialog.createPanel(project, localContent, changesLoader);
        DialogBuilder dialogBuilder = new DialogBuilder(project);
        dialogBuilder.setTitle(dialogTitle);
        dialogBuilder.setActionDescriptors(new DialogBuilder.ActionDescriptor[]{new DialogBuilder.CloseDialogAction()});
        dialogBuilder.setCenterPanel((JComponent)changesPanel);
        dialogBuilder.setPreferredFocusComponent(changesPanel.getChangesBrowser().getPreferredFocusedComponent());
        dialogBuilder.addDisposable((Disposable)changesPanel);
        dialogBuilder.setDimensionServiceKey("Git.DiffForPathsDialog");
        dialogBuilder.showNotModal();
    }

    private static void showAsTab(@NotNull Project project, @NotNull @NlsContexts.DialogTitle String dialogTitle, @NotNull LocalContent localContent, @NotNull ThrowableComputable<? extends Collection<Change>, ? extends VcsException> changesLoader) {
        if (project == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(8);
        }
        if (dialogTitle == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(9);
        }
        if (localContent == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(10);
        }
        if (changesLoader == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(11);
        }
        MyLoadingChangesPanel changesPanel = CompareWithLocalDialog.createPanel(project, localContent, changesLoader);
        SimpleChangesBrowser changesBrowser = changesPanel.getChangesBrowser();
        DiffPreview diffPreview = ChangesBrowserToolWindow.createDiffPreview(project, changesBrowser, changesPanel);
        changesBrowser.setShowDiffActionPreview(diffPreview);
        Content content2 = ContentFactory.SERVICE.getInstance().createContent((JComponent)changesPanel, dialogTitle, false);
        content2.setPreferredFocusableComponent(changesBrowser.getPreferredFocusedComponent());
        content2.setDisposer((Disposable)changesPanel);
        ChangesBrowserToolWindow.showTab(project, content2);
    }

    @NotNull
    private static MyLoadingChangesPanel createPanel(@NotNull Project project, @NotNull LocalContent localContent, final @NotNull ThrowableComputable<? extends Collection<Change>, ? extends VcsException> changesLoader) {
        if (project == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(12);
        }
        if (localContent == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(13);
        }
        if (changesLoader == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(14);
        }
        MyChangesBrowser changesBrowser = new MyChangesBrowser(project, localContent);
        MyLoadingChangesPanel changesPanel = new MyLoadingChangesPanel(changesBrowser){

            @Override
            @NotNull
            protected Collection<Change> loadChanges() throws VcsException {
                Collection collection = (Collection)changesLoader.compute();
                if (collection == null) {
                    1.$$$reportNull$$$0(0);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/CompareWithLocalDialog$1", "loadChanges"));
            }
        };
        Disposer.register((Disposable)changesPanel, (Disposable)changesBrowser);
        changesPanel.reloadChanges();
        MyLoadingChangesPanel myLoadingChangesPanel = changesPanel;
        if (myLoadingChangesPanel == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(15);
        }
        return myLoadingChangesPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogTitle";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localContent";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changesLoader";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/CompareWithLocalDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/CompareWithLocalDialog";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showChanges";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showAsTab";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createPanel";
                break;
            }
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum LocalContent {
        BEFORE,
        AFTER,
        NONE;

    }

    private static class MyGetVersionAction
    extends DumbAwareAction {
        private MyGetVersionAction() {
            super(VcsBundle.messagePointer((String)"action.name.get.file.content.from.repository", (Object[])new Object[0]), VcsBundle.messagePointer((String)"action.description.get.file.content.from.repository", (Object[])new Object[0]), AllIcons.Actions.Download);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyGetVersionAction.$$$reportNull$$$0(0);
            }
            Project project = e.getProject();
            MyLoadingChangesPanel changesPanel = (MyLoadingChangesPanel)e.getData(MyLoadingChangesPanel.DATA_KEY);
            if (project == null || changesPanel == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            MyChangesBrowser browser2 = (MyChangesBrowser)ObjectUtils.tryCast((Object)changesPanel.getChangesBrowser(), MyChangesBrowser.class);
            boolean isVisible2 = browser2 != null && browser2.myLocalContent != LocalContent.NONE;
            boolean isEnabled = isVisible2 && !browser2.getSelectedChanges().isEmpty();
            e.getPresentation().setVisible(isVisible2);
            e.getPresentation().setEnabled(isEnabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyGetVersionAction.$$$reportNull$$$0(1);
            }
            Project project = Objects.requireNonNull(e.getProject());
            MyLoadingChangesPanel changesPanel = (MyLoadingChangesPanel)e.getRequiredData(MyLoadingChangesPanel.DATA_KEY);
            MyChangesBrowser browser2 = (MyChangesBrowser)changesPanel.getChangesBrowser();
            List fileContentProviders = ContainerUtil.map(changesPanel.getChangesBrowser().getSelectedChanges(), change -> new MyFileContentProvider((Change)change, browser2.myLocalContent));
            GetVersionAction.doGet(project, VcsBundle.message((String)"compare.with.dialog.get.from.vcs.action.title", (Object[])new Object[0]), fileContentProviders, () -> changesPanel.reloadChanges());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/vcs/CompareWithLocalDialog$MyGetVersionAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class MyFileContentProvider
        implements GetVersionAction.FileRevisionProvider {
            @NotNull
            private final Change myChange;
            @NotNull
            private final LocalContent myLocalContent;

            private MyFileContentProvider(@NotNull Change change, @NotNull LocalContent localContent) {
                if (change == null) {
                    MyFileContentProvider.$$$reportNull$$$0(0);
                }
                if (localContent == null) {
                    MyFileContentProvider.$$$reportNull$$$0(1);
                }
                this.myChange = change;
                this.myLocalContent = localContent;
            }

            @Override
            @NotNull
            public FilePath getFilePath() {
                FilePath filePath = ChangesUtil.getFilePath((Change)this.myChange);
                if (filePath == null) {
                    MyFileContentProvider.$$$reportNull$$$0(2);
                }
                return filePath;
            }

            @Override
            public byte @Nullable [] getContent() throws VcsException {
                ContentRevision revision;
                ContentRevision contentRevision = revision = this.myLocalContent == LocalContent.AFTER ? this.myChange.getBeforeRevision() : this.myChange.getAfterRevision();
                if (revision == null) {
                    return null;
                }
                return ChangesUtil.loadContentRevision((ContentRevision)revision);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "change";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "localContent";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/vcs/CompareWithLocalDialog$MyGetVersionAction$MyFileContentProvider";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/vcs/CompareWithLocalDialog$MyGetVersionAction$MyFileContentProvider";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFilePath";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    private static class MyChangesBrowser
    extends SimpleChangesBrowser
    implements Disposable {
        @NotNull
        private final LocalContent myLocalContent;

        private MyChangesBrowser(@NotNull Project project, @NotNull LocalContent localContent) {
            if (project == null) {
                MyChangesBrowser.$$$reportNull$$$0(0);
            }
            if (localContent == null) {
                MyChangesBrowser.$$$reportNull$$$0(1);
            }
            super(project, false, true);
            this.myLocalContent = localContent;
            this.hideViewerBorder();
        }

        public void dispose() {
        }

        @Override
        @NotNull
        protected List<AnAction> createToolbarActions() {
            List list2 = ContainerUtil.append(super.createToolbarActions(), (Object[])new AnAction[]{new MyGetVersionAction()});
            if (list2 == null) {
                MyChangesBrowser.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @Override
        @NotNull
        protected List<AnAction> createPopupMenuActions() {
            List list2 = ContainerUtil.append(super.createPopupMenuActions(), (Object[])new AnAction[]{new MyGetVersionAction()});
            if (list2 == null) {
                MyChangesBrowser.$$$reportNull$$$0(3);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localContent";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/CompareWithLocalDialog$MyChangesBrowser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/CompareWithLocalDialog$MyChangesBrowser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createToolbarActions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupMenuActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class MyLoadingChangesPanel
    extends JPanel
    implements DataProvider,
    Disposable {
        public static final DataKey<MyLoadingChangesPanel> DATA_KEY = DataKey.create("git4idea.log.MyLoadingChangesPanel");
        private final SimpleChangesBrowser myChangesBrowser;
        private final LoadingChangesPanel myLoadingPanel;

        private MyLoadingChangesPanel(@NotNull SimpleChangesBrowser changesBrowser) {
            if (changesBrowser == null) {
                MyLoadingChangesPanel.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.myChangesBrowser = changesBrowser;
            StatusText emptyText = this.myChangesBrowser.getViewer().getEmptyText();
            this.myLoadingPanel = new LoadingChangesPanel(this.myChangesBrowser, emptyText, this);
            this.add((Component)this.myLoadingPanel, "Center");
        }

        public void dispose() {
        }

        @NotNull
        public SimpleChangesBrowser getChangesBrowser() {
            SimpleChangesBrowser simpleChangesBrowser = this.myChangesBrowser;
            if (simpleChangesBrowser == null) {
                MyLoadingChangesPanel.$$$reportNull$$$0(1);
            }
            return simpleChangesBrowser;
        }

        public void reloadChanges() {
            this.myLoadingPanel.loadChangesInBackground(this::loadChanges, this::applyResult);
        }

        @NotNull
        protected abstract Collection<Change> loadChanges() throws VcsException;

        private void applyResult(@Nullable Collection<Change> changes) {
            this.myChangesBrowser.setChangesToDisplay(changes != null ? changes : Collections.emptyList());
        }

        @Override
        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                MyLoadingChangesPanel.$$$reportNull$$$0(2);
            }
            if (DATA_KEY.is(dataId)) {
                return this;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changesBrowser";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/CompareWithLocalDialog$MyLoadingChangesPanel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/CompareWithLocalDialog$MyLoadingChangesPanel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangesBrowser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

