/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.application.Topics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.advanced.AdvancedSettingsChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.impl.VcsEP;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.commit.CommitMode;
import com.intellij.vcs.commit.CommitModeManager;
import com.intellij.vcs.commit.CommitModeManagerKt;
import com.intellij.vcs.commit.NonModalCommitUsagesCollector;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00102\u00020\u0001:\u0004\u000f\u0010\u0011\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u0006\u0010\n\u001a\u00020\u0006J\b\u0010\u000b\u001a\u00020\u0006H\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/vcs/commit/CommitModeManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "commitMode", "Lcom/intellij/vcs/commit/CommitMode;", "canSetNonModal", "", "canSetNonModal$intellij_platform_vcs_impl", "getCurrentCommitMode", "getNewCommitMode", "subscribeToChanges", "", "updateCommitMode", "CommitModeListener", "Companion", "MyStartupActivity", "SettingsListener", "intellij.platform.vcs.impl"})
public final class CommitModeManager {
    private CommitMode commitMode;
    private final Project project;
    @JvmField
    @NotNull
    public static final Topic<SettingsListener> SETTINGS;
    @JvmField
    @NotNull
    public static final Topic<CommitModeListener> COMMIT_MODE_TOPIC;
    @NotNull
    public static final Companion Companion;

    @RequiresEdt
    public final void updateCommitMode() {
        if (this.project.isDisposed()) {
            return;
        }
        CommitMode newCommitMode = this.getNewCommitMode();
        if (Intrinsics.areEqual((Object)this.commitMode, (Object)newCommitMode)) {
            return;
        }
        this.commitMode = newCommitMode;
        ((CommitModeListener)this.project.getMessageBus().syncPublisher(COMMIT_MODE_TOPIC)).commitModeChanged();
    }

    private final CommitMode getNewCommitMode() {
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectLevelVcsManager, (String)"ProjectLevelVcsManager.getInstance(project)");
        Object[] activeVcses = projectLevelVcsManager.getAllActiveVcss();
        Intrinsics.checkNotNullExpressionValue((Object)activeVcses, (String)"activeVcses");
        AbstractVcs singleVcs = (AbstractVcs)ArraysKt.singleOrNull((Object[])activeVcses);
        Object[] objectArray = activeVcses;
        boolean bl = false;
        if (objectArray.length == 0) {
            return CommitMode.PendingCommitMode.INSTANCE;
        }
        if (singleVcs != null && singleVcs.isWithCustomLocalChanges()) {
            return new CommitMode.ExternalCommitMode(singleVcs);
        }
        if (Companion.isNonModalInSettings() && this.canSetNonModal$intellij_platform_vcs_impl()) {
            return new CommitMode.NonModalCommitMode(CommitModeManagerKt.access$isToggleCommitUi$p());
        }
        return CommitMode.ModalCommitMode.INSTANCE;
    }

    @NotNull
    public final CommitMode getCurrentCommitMode() {
        return this.commitMode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canSetNonModal$intellij_platform_vcs_impl() {
        if (CommitModeManagerKt.access$isForceNonModalCommit$p().asBoolean()) {
            return true;
        }
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectLevelVcsManager, (String)"ProjectLevelVcsManager.getInstance(project)");
        AbstractVcs[] activeVcses = projectLevelVcsManager.getAllActiveVcss();
        Intrinsics.checkNotNullExpressionValue((Object)activeVcses, (String)"activeVcses");
        AbstractVcs[] abstractVcsArray = activeVcses;
        boolean bl = false;
        AbstractVcs[] abstractVcsArray2 = abstractVcsArray;
        int n = 0;
        if (abstractVcsArray2.length == 0) {
            return false;
        }
        boolean bl2 = false;
        if (bl2) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        AbstractVcs[] $this$all$iv = activeVcses;
        boolean $i$f$all = false;
        abstractVcsArray2 = $this$all$iv;
        n = abstractVcsArray2.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractVcs element$iv;
            AbstractVcs it = element$iv = abstractVcsArray2[n2];
            boolean bl4 = false;
            AbstractVcs abstractVcs = it;
            Intrinsics.checkNotNullExpressionValue((Object)abstractVcs, (String)"it");
            if (abstractVcs.getType() != VcsType.distributed) return false;
            boolean bl5 = true;
            if (!bl5) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private final void subscribeToChanges() {
        if (this.project.isDisposed()) {
            return;
        }
        CommitModeManagerKt.access$isForceNonModalCommit$p().addListener(new RegistryValueListener(this){
            final /* synthetic */ CommitModeManager this$0;

            public void afterValueChanged(@NotNull RegistryValue value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                this.this$0.updateCommitMode();
            }
            {
                this.this$0 = this$0;
            }
        }, (Disposable)this.project);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication()");
        application.getMessageBus().connect((Disposable)this.project).subscribe(AdvancedSettingsChangeListener.TOPIC, (Object)new AdvancedSettingsChangeListener(this){
            final /* synthetic */ CommitModeManager this$0;

            public void advancedSettingChanged(@NotNull String id2, @NotNull Object oldValue, @NotNull Object newValue2) {
                Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
                Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
                Intrinsics.checkNotNullParameter((Object)newValue2, (String)"newValue");
                if (Intrinsics.areEqual((Object)id2, (Object)CommitModeManagerKt.access$getTOGGLE_COMMIT_UI$p())) {
                    this.this$0.updateCommitMode();
                }
            }
            {
                this.this$0 = this$0;
            }
        });
        Topics.subscribe(SETTINGS, (Disposable)((Disposable)this.project), (Object)new SettingsListener(this){
            final /* synthetic */ CommitModeManager this$0;

            public void settingsChanged() {
                this.this$0.updateCommitMode();
            }
            {
                this.this$0 = this$0;
            }
        });
        VcsEP.EP_NAME.addChangeListener(new Runnable(this){
            final /* synthetic */ CommitModeManager this$0;

            public final void run() {
                this.this$0.updateCommitMode();
            }
            {
                this.this$0 = commitModeManager;
            }
        }, (Disposable)this.project);
        this.project.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)new VcsListener(this){
            final /* synthetic */ CommitModeManager this$0;

            public final void directoryMappingChanged() {
                Application app$iv;
                ModalityState modalityState$iv = null;
                boolean $i$f$runInEdt = false;
                Application application = app$iv = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
                if (application.isDispatchThread()) {
                    boolean bl = false;
                    this.this$0.updateCommitMode();
                } else {
                    boolean $i$f$invokeLater = false;
                    Application application2 = ApplicationManager.getApplication();
                    Runnable runnable2 = new Runnable(this){
                        final /* synthetic */ subscribeToChanges.5 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void run() {
                            boolean bl = false;
                            this.this$0.this$0.updateCommitMode();
                        }
                    };
                    ModalityState modalityState = ModalityState.defaultModalityState();
                    Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                    application2.invokeLater(runnable2, modalityState);
                }
            }
            {
                this.this$0 = commitModeManager;
            }
        });
    }

    public CommitModeManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.commitMode = CommitMode.PendingCommitMode.INSTANCE;
    }

    static {
        Companion = new Companion(null);
        SETTINGS = new Topic(SettingsListener.class, Topic.BroadcastDirection.TO_DIRECT_CHILDREN, true);
        COMMIT_MODE_TOPIC = new Topic(CommitModeListener.class, Topic.BroadcastDirection.NONE, true);
    }

    @JvmStatic
    @NotNull
    public static final CommitModeManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    public static final void setCommitFromLocalChanges(@Nullable Project project, boolean value2) {
        Companion.setCommitFromLocalChanges(project, value2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/vcs/commit/CommitModeManager$MyStartupActivity;", "Lcom/intellij/openapi/vcs/impl/VcsStartupActivity;", "()V", "getOrder", "", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    public static final class MyStartupActivity
    implements VcsStartupActivity {
        @Override
        public void runActivity(@NotNull Project project) {
            Application app$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ModalityState modalityState$iv = null;
            boolean $i$f$runInEdt = false;
            Application application = app$iv = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
            if (application.isDispatchThread()) {
                boolean bl = false;
                if (!project.isDisposed()) {
                    CommitModeManager commitModeManager = Companion.getInstance(project);
                    commitModeManager.subscribeToChanges();
                    commitModeManager.updateCommitMode();
                }
            } else {
                boolean $i$f$invokeLater = false;
                Application application2 = ApplicationManager.getApplication();
                Runnable runnable2 = new Runnable(project){
                    final /* synthetic */ Project $project$inlined;
                    {
                        this.$project$inlined = project;
                    }

                    public final void run() {
                        boolean bl = false;
                        if (!this.$project$inlined.isDisposed()) {
                            CommitModeManager commitModeManager = CommitModeManager.Companion.getInstance(this.$project$inlined);
                            CommitModeManager.access$subscribeToChanges(commitModeManager);
                            commitModeManager.updateCommitMode();
                        }
                    }
                };
                ModalityState modalityState = ModalityState.defaultModalityState();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                application2.invokeLater(runnable2, modalityState);
            }
        }

        @Override
        public int getOrder() {
            return VcsInitObject.MAPPINGS.getOrder() + 50;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/intellij/vcs/commit/CommitModeManager$SettingsListener;", "Ljava/util/EventListener;", "settingsChanged", "", "intellij.platform.vcs.impl"})
    public static interface SettingsListener
    extends EventListener {
        public void settingsChanged();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H'\u00a8\u0006\u0004"}, d2={"Lcom/intellij/vcs/commit/CommitModeManager$CommitModeListener;", "Ljava/util/EventListener;", "commitModeChanged", "", "intellij.platform.vcs.impl"})
    public static interface CommitModeListener
    extends EventListener {
        @RequiresEdt
        public void commitModeChanged();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u00020\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\rH\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/vcs/commit/CommitModeManager$Companion;", "", "()V", "COMMIT_MODE_TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/vcs/commit/CommitModeManager$CommitModeListener;", "SETTINGS", "Lcom/intellij/vcs/commit/CommitModeManager$SettingsListener;", "getInstance", "Lcom/intellij/vcs/commit/CommitModeManager;", "project", "Lcom/intellij/openapi/project/Project;", "isNonModalInSettings", "", "setCommitFromLocalChanges", "", "value", "intellij.platform.vcs.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final CommitModeManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(CommitModeManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (CommitModeManager)object;
        }

        @JvmStatic
        public final void setCommitFromLocalChanges(@Nullable Project project, boolean value2) {
            boolean oldValue = CommitModeManagerKt.access$getAppSettings$p().COMMIT_FROM_LOCAL_CHANGES;
            if (oldValue == value2) {
                return;
            }
            CommitModeManagerKt.access$getAppSettings$p().COMMIT_FROM_LOCAL_CHANGES = value2;
            NonModalCommitUsagesCollector.INSTANCE.logStateChanged(project);
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication()");
            ((SettingsListener)application.getMessageBus().syncPublisher(SETTINGS)).settingsChanged();
        }

        public final boolean isNonModalInSettings() {
            return CommitModeManagerKt.access$isForceNonModalCommit$p().asBoolean() || CommitModeManagerKt.access$getAppSettings$p().COMMIT_FROM_LOCAL_CHANGES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

