/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.editor;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b&\u0018\u0000 \u001c*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004:\u0003\u001c\u001d\u001eB\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u000b\u001a\u00020\tH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\tH\u0016J\u001f\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0013J\u0017\u0010\u0014\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0015\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\tH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem;", "P", "Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPath;", "Lcom/intellij/openapi/vfs/DeprecatedVirtualFileSystem;", "Lcom/intellij/openapi/vfs/NonPhysicalFileSystem;", "pathSerializer", "Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPathSerializer;", "(Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPathSerializer;)V", "extractPresentableUrl", "", "Lorg/jetbrains/annotations/NotNull;", "path", "findFileByPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "findOrCreateFile", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPath;)Lcom/intellij/openapi/vfs/VirtualFile;", "getComplexPath", "(Ljava/lang/String;)Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPath;", "getComplexPathSafe", "getPath", "(Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPath;)Ljava/lang/String;", "refresh", "", "asynchronous", "", "refreshAndFindFileByPath", "Companion", "ComplexPath", "ComplexPathSerializer", "intellij.platform.vcs.impl"})
public abstract class ComplexPathVirtualFileSystem<P extends ComplexPath>
extends DeprecatedVirtualFileSystem
implements NonPhysicalFileSystem {
    private final ComplexPathSerializer<P> pathSerializer;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Nullable
    protected abstract VirtualFile findOrCreateFile(@NotNull Project var1, @NotNull P var2);

    @NotNull
    public final String getPath(@NotNull P path2) {
        Intrinsics.checkNotNullParameter(path2, (String)"path");
        return this.pathSerializer.serialize(path2);
    }

    @NotNull
    public final P getComplexPath(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return this.pathSerializer.deserialize(path2);
    }

    private final P getComplexPathSafe(String path2) {
        P p;
        try {
            p = this.getComplexPath(path2);
        }
        catch (Exception e) {
            LOG.warn("Cannot deserialize " + path2, (Throwable)e);
            return null;
        }
        return p;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        P p = this.getComplexPathSafe(path2);
        if (p == null) {
            return null;
        }
        P parsedPath = p;
        Project project = ProjectManagerEx.getInstanceEx().findOpenProjectByHash(parsedPath.getProjectHash());
        if (project == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"ProjectManagerEx.getInst\u2026ojectHash) ?: return null");
        Project project2 = project;
        return this.findOrCreateFile(project2, parsedPath);
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return this.findFileByPath(path2);
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        VirtualFile virtualFile2 = this.refreshAndFindFileByPath(path2);
        if (!(virtualFile2 instanceof VirtualFilePathWrapper)) {
            virtualFile2 = null;
        }
        if ((object = (VirtualFilePathWrapper)virtualFile2) == null || (object = object.getPresentablePath()) == null) {
            object = path2;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"(refreshAndFindFileByPat\u2026?.presentablePath ?: path");
        return object;
    }

    public void refresh(boolean asynchronous) {
    }

    public ComplexPathVirtualFileSystem(@NotNull ComplexPathSerializer<P> pathSerializer) {
        Intrinsics.checkNotNullParameter(pathSerializer, (String)"pathSerializer");
        this.pathSerializer = pathSerializer;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ComplexPathVirtualFileSystem.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\b"}, d2={"Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPath;", "", "projectHash", "", "getProjectHash", "()Ljava/lang/String;", "sessionId", "getSessionId", "intellij.platform.vcs.impl"})
    public static interface ComplexPath {
        @NotNull
        public String getSessionId();

        @NotNull
        public String getProjectHash();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003J\u0015\u0010\u0004\u001a\u00028\u00012\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPathSerializer;", "P", "Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPath;", "", "deserialize", "rawPath", "", "(Ljava/lang/String;)Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPath;", "serialize", "path", "(Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPath;)Ljava/lang/String;", "intellij.platform.vcs.impl"})
    public static interface ComplexPathSerializer<P extends ComplexPath> {
        @NotNull
        public String serialize(@NotNull P var1);

        @NotNull
        public P deserialize(@NotNull String var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

