/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UnorderedPair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogBranchLikeFilter;
import com.intellij.vcs.log.VcsLogFileHistoryHandler;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRevisionFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CommitDetailsGetter;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.history.AdditionDeletion;
import com.intellij.vcs.log.history.FileHistory;
import com.intellij.vcs.log.history.FileHistoryBuilder;
import com.intellij.vcs.log.history.FileHistoryData;
import com.intellij.vcs.log.history.FileHistoryFiltererKt;
import com.intellij.vcs.log.history.FileHistoryPaths;
import com.intellij.vcs.log.history.FileHistoryTask;
import com.intellij.vcs.log.history.MaybeDeletedFilePath;
import com.intellij.vcs.log.history.Rename;
import com.intellij.vcs.log.history.VcsLogFileHistoryFilter;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.util.DataPackUtilKt;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.CommitCountStage;
import com.intellij.vcs.log.visible.EmptyVisibleGraph;
import com.intellij.vcs.log.visible.VcsLogFilterer;
import com.intellij.vcs.log.visible.VcsLogFiltererImpl;
import com.intellij.vcs.log.visible.VcsLogFiltererImplKt;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 92\u00020\u00012\u00020\u0002:\u00029:B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dH\u0002J*\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\u001dH\u0002J\b\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020!H\u0016J<\u0010.\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u0002010/2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002002\u0006\u00105\u001a\u0002062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00107\u001a\u000201H\u0016J\u0012\u00108\u001a\u0004\u0018\u00010)2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000RV\u0010\u0010\u001aJ\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00140\u0014 \u0013*#\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00140\u00140\u0015\u00a2\u0006\u0002\b\f0\u0011\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryFilterer;", "Lcom/intellij/vcs/log/visible/VcsLogFilterer;", "Lcom/intellij/openapi/Disposable;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "logId", "", "(Lcom/intellij/vcs/log/data/VcsLogData;Ljava/lang/String;)V", "fileHistoryTask", "Lcom/intellij/vcs/log/history/FileHistoryTask;", "index", "Lcom/intellij/vcs/log/data/index/VcsLogIndex;", "Lorg/jetbrains/annotations/NotNull;", "indexDataGetter", "Lcom/intellij/vcs/log/data/index/IndexDataGetter;", "Lorg/jetbrains/annotations/Nullable;", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "Lcom/intellij/vcs/log/VcsLogProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "vcsLogFilterer", "Lcom/intellij/vcs/log/visible/VcsLogFiltererImpl;", "canFilterEmptyPack", "", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "cancelLastTask", "", "wait", "createFileHistoryTask", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "hash", "Lcom/intellij/vcs/log/Hash;", "isInitial", "createProgressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "dispose", "filter", "Lkotlin/Pair;", "Lcom/intellij/vcs/log/visible/VisiblePack;", "Lcom/intellij/vcs/log/visible/CommitCountStage;", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "oldVisiblePack", "sortType", "Lcom/intellij/vcs/log/graph/PermanentGraph$SortType;", "commitCount", "getHash", "Companion", "MyWorker", "intellij.platform.vcs.log.impl"})
public final class FileHistoryFilterer
implements VcsLogFilterer,
Disposable {
    private final Project project;
    private final Map<VirtualFile, VcsLogProvider> logProviders;
    private final VcsLogStorage storage;
    private final VcsLogIndex index;
    private final IndexDataGetter indexDataGetter;
    private final VcsLogFiltererImpl vcsLogFilterer;
    private FileHistoryTask fileHistoryTask;
    private final VcsLogData logData;
    private final String logId;
    private static final Logger LOG;
    @JvmField
    @NotNull
    public static final Key<Boolean> NO_PARENTS_INFO;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public Pair<VisiblePack, CommitCountStage> filter(@NotNull DataPack dataPack, @NotNull VisiblePack oldVisiblePack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount) {
        Pair<VisiblePack, CommitCountStage> result2;
        VirtualFile virtualFile2;
        FilePath filePath;
        Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
        Intrinsics.checkNotNullParameter((Object)oldVisiblePack, (String)"oldVisiblePack");
        Intrinsics.checkNotNullParameter((Object)sortType, (String)"sortType");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)((Object)commitCount), (String)"commitCount");
        FilePath filePath2 = filePath = Companion.getFilePath(filters);
        if (filePath2 != null) {
            FilePath filePath3 = filePath2;
            boolean bl = false;
            boolean bl2 = false;
            FilePath it = filePath3;
            boolean bl3 = false;
            virtualFile2 = VcsLogUtil.getActualRoot(this.project, filePath);
        } else {
            virtualFile2 = null;
        }
        VirtualFile root2 = virtualFile2;
        Hash hash = this.getHash(filters);
        if (root2 != null && !filePath.isDirectory() && (result2 = new MyWorker(root2, filePath, hash).filter(dataPack, oldVisiblePack, sortType, filters, commitCount)) != null) {
            return result2;
        }
        return this.vcsLogFilterer.filter(dataPack, oldVisiblePack, sortType, filters, commitCount);
    }

    @Override
    public boolean canFilterEmptyPack(@NotNull VcsLogFilterCollection filters) {
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        return true;
    }

    private final void cancelLastTask(boolean wait) {
        FileHistoryTask fileHistoryTask = this.fileHistoryTask;
        if (fileHistoryTask != null) {
            fileHistoryTask.cancel(wait);
        }
        this.fileHistoryTask = null;
    }

    private final FileHistoryTask createFileHistoryTask(AbstractVcs vcs, FilePath filePath, Hash hash, boolean isInitial) {
        FileHistoryTask newHistoryTask;
        FileHistoryTask oldHistoryTask = this.fileHistoryTask;
        if (oldHistoryTask != null && !oldHistoryTask.isCancelled() && !isInitial && Intrinsics.areEqual((Object)oldHistoryTask.getFilePath(), (Object)filePath) && Intrinsics.areEqual((Object)oldHistoryTask.getHash(), (Object)hash)) {
            return oldHistoryTask;
        }
        this.cancelLastTask(false);
        this.fileHistoryTask = newHistoryTask = new FileHistoryTask(vcs, filePath, hash, this.createProgressIndicator());
        return newHistoryTask;
    }

    private final ProgressIndicator createProgressIndicator() {
        ProgressIndicator progressIndicator = this.logData.getProgress().createProgressIndicator(new VcsLogProgress.ProgressKey("file history task for " + this.logId));
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"logData.progress.createP\u2026istory task for $logId\"))");
        return progressIndicator;
    }

    public void dispose() {
        this.cancelLastTask(true);
    }

    private final Hash getHash(VcsLogFilterCollection filters) {
        VcsLogFileHistoryFilter fileHistoryFilter;
        VcsLogStructureFilter vcsLogStructureFilter = FileHistoryFilterer.Companion.getStructureFilter(filters);
        if (!(vcsLogStructureFilter instanceof VcsLogFileHistoryFilter)) {
            vcsLogStructureFilter = null;
        }
        if ((fileHistoryFilter = (VcsLogFileHistoryFilter)vcsLogStructureFilter) != null) {
            return fileHistoryFilter.getHash();
        }
        VcsLogRevisionFilter revisionFilter = (VcsLogRevisionFilter)filters.get(VcsLogFilterCollection.REVISION_FILTER);
        Object object = revisionFilter;
        return object != null && (object = object.getHeads()) != null && (object = (CommitId)CollectionsKt.singleOrNull((Iterable)((Iterable)object))) != null ? object.getHash() : null;
    }

    public FileHistoryFilterer(@NotNull VcsLogData logData, @NotNull String logId) {
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
        this.logData = logData;
        this.logId = logId;
        Project project = this.logData.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"logData.project");
        this.project = project;
        Map<VirtualFile, VcsLogProvider> map2 = this.logData.getLogProviders();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"logData.logProviders");
        this.logProviders = map2;
        VcsLogStorage vcsLogStorage = this.logData.getStorage();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogStorage, (String)"logData.storage");
        this.storage = vcsLogStorage;
        VcsLogIndex vcsLogIndex = this.logData.getIndex();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogIndex, (String)"logData.index");
        this.index = vcsLogIndex;
        IndexDataGetter indexDataGetter = this.index.getDataGetter();
        Intrinsics.checkNotNull((Object)indexDataGetter);
        Intrinsics.checkNotNullExpressionValue((Object)indexDataGetter, (String)"index.dataGetter!!");
        this.indexDataGetter = indexDataGetter;
        TopCommitsCache topCommitsCache = this.logData.getTopCommitsCache();
        Intrinsics.checkNotNullExpressionValue((Object)topCommitsCache, (String)"logData.topCommitsCache");
        CommitDetailsGetter commitDetailsGetter = this.logData.getCommitDetailsGetter();
        Intrinsics.checkNotNullExpressionValue((Object)commitDetailsGetter, (String)"logData.commitDetailsGetter");
        this.vcsLogFilterer = new VcsLogFiltererImpl(this.logProviders, this.storage, topCommitsCache, commitDetailsGetter, this.index);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FileHistoryFilterer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        Key key = Key.create((String)"NO_PARENTS_INFO");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<Boolean>(\"NO_PARENTS_INFO\")");
        NO_PARENTS_INFO = key;
    }

    @JvmStatic
    @NotNull
    public static final VcsLogFilterCollection createFilters(@NotNull FilePath path2, @Nullable Hash revision, @NotNull VirtualFile root2, boolean showAllBranches) {
        return Companion.createFilters(path2, revision, root2, showAllBranches);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\"\u0010\u0010\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0004\u0012\u00020\u00140\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J<\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0019JB\u0010 \u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0018\u0010!\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0004\u0012\u00020\u00140\u00112\u0006\u0010\"\u001a\u00020\u0016H\u0002J0\u0010 \u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\nH\u0002J0\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\nH\u0002J\u001c\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020)0(2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010\u00072\u0006\u0010+\u001a\u00020\fH\u0002J\u0010\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020.H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryFilterer$MyWorker;", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "hash", "Lcom/intellij/vcs/log/Hash;", "(Lcom/intellij/vcs/log/history/FileHistoryFilterer;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/vcs/log/Hash;)V", "checkNotEmpty", "", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "visiblePack", "Lcom/intellij/vcs/log/visible/VisiblePack;", "withIndex", "collectRenamesFromProvider", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/util/UnorderedPair;", "", "Lcom/intellij/vcs/log/history/Rename;", "fileHistory", "Lcom/intellij/vcs/log/history/FileHistory;", "filter", "Lkotlin/Pair;", "Lcom/intellij/vcs/log/visible/CommitCountStage;", "oldVisiblePack", "sortType", "Lcom/intellij/vcs/log/graph/PermanentGraph$SortType;", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "commitCount", "filterWithIndex", "oldRenames", "oldFileHistory", "isInitial", "filterWithProvider", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "getFilteredRefs", "", "Lcom/intellij/vcs/log/data/CompressedRefs;", "getHead", "pack", "getIndex", "revision", "Lcom/intellij/openapi/vcs/history/VcsFileRevision;", "intellij.platform.vcs.log.impl"})
    private final class MyWorker {
        private final VirtualFile root;
        private final FilePath filePath;
        private final Hash hash;

        @Nullable
        public final Pair<VisiblePack, CommitCountStage> filter(@NotNull DataPack dataPack, @NotNull VisiblePack oldVisiblePack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount) {
            boolean isInitial;
            Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
            Intrinsics.checkNotNullParameter((Object)oldVisiblePack, (String)"oldVisiblePack");
            Intrinsics.checkNotNullParameter((Object)sortType, (String)"sortType");
            Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
            Intrinsics.checkNotNullParameter((Object)((Object)commitCount), (String)"commitCount");
            long start2 = System.currentTimeMillis();
            boolean bl = isInitial = commitCount == CommitCountStage.INITIAL;
            if (FileHistoryFilterer.this.index.isIndexed(this.root) && dataPack.isFull()) {
                FileHistoryFilterer.this.cancelLastTask(false);
                VisiblePack visiblePack = this.filterWithIndex(dataPack, oldVisiblePack, sortType, filters, isInitial);
                LOG.debug(StopWatch.formatTime(System.currentTimeMillis() - start2) + " for computing history for " + this.filePath + " with index");
                if (this.checkNotEmpty(dataPack, visiblePack, true)) {
                    return new Pair((Object)visiblePack, (Object)commitCount);
                }
            }
            AbstractVcs abstractVcs = ProjectLevelVcsManager.getInstance((Project)FileHistoryFilterer.this.project).getVcsFor(this.root);
            if (abstractVcs != null) {
                AbstractVcs abstractVcs2 = abstractVcs;
                boolean bl2 = false;
                boolean bl3 = false;
                AbstractVcs vcs = abstractVcs2;
                boolean bl4 = false;
                AbstractVcs abstractVcs3 = vcs;
                Intrinsics.checkNotNullExpressionValue((Object)abstractVcs3, (String)"vcs");
                if (abstractVcs3.getVcsHistoryProvider() != null) {
                    try {
                        VisiblePack visiblePack = this.filterWithProvider(vcs, dataPack, sortType, filters, isInitial);
                        LOG.debug(StopWatch.formatTime(System.currentTimeMillis() - start2) + " for computing history for " + this.filePath + " with history provider");
                        this.checkNotEmpty(dataPack, visiblePack, false);
                        return new Pair((Object)visiblePack, (Object)commitCount);
                    }
                    catch (VcsException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
            LOG.warn("Could not find vcs or history provider for file " + this.filePath);
            return null;
        }

        private final boolean checkNotEmpty(DataPack dataPack, VisiblePack visiblePack, boolean withIndex) {
            if (!dataPack.isFull()) {
                Logger logger = LOG;
                StringBuilder stringBuilder = new StringBuilder().append("Data pack is not full while computing file history for ").append(this.filePath).append('\n').append("Found ");
                VisibleGraph<Integer> visibleGraph = visiblePack.getVisibleGraph();
                Intrinsics.checkNotNullExpressionValue(visibleGraph, (String)"visiblePack.visibleGraph");
                logger.debug(stringBuilder.append(visibleGraph.getVisibleCommitCount()).append(" commits").toString());
                return true;
            }
            VisibleGraph<Integer> visibleGraph = visiblePack.getVisibleGraph();
            Intrinsics.checkNotNullExpressionValue(visibleGraph, (String)"visiblePack.visibleGraph");
            if (visibleGraph.getVisibleCommitCount() == 0) {
                LOG.warn("Empty file history from " + (withIndex ? "index" : "provider") + " for " + this.filePath);
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private final VisiblePack filterWithProvider(AbstractVcs vcs, DataPack dataPack, PermanentGraph.SortType sortType, VcsLogFilterCollection filters, boolean isInitial) throws VcsException {
            void revisions;
            Pair<List<VcsFileRevision>, Boolean> pair = FileHistoryFilterer.this.createFileHistoryTask(vcs, this.filePath, this.hash, isInitial).waitForRevisions();
            List list2 = (List)pair.component1();
            boolean isDone = (Boolean)pair.component2();
            if (revisions.isEmpty()) {
                VisiblePack visiblePack = VisiblePack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)visiblePack, (String)"VisiblePack.EMPTY");
                return visiblePack;
            }
            if (dataPack.isFull()) {
                HashMap pathsMap = new HashMap();
                Iterator iterator2 = revisions.iterator();
                while (iterator2.hasNext()) {
                    VcsFileRevision revision;
                    VcsFileRevision vcsFileRevision = revision = (VcsFileRevision)iterator2.next();
                    if (vcsFileRevision == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.vcs.history.VcsFileRevisionEx");
                    }
                    VcsFileRevisionEx revisionEx = (VcsFileRevisionEx)vcsFileRevision;
                    Map map2 = pathsMap;
                    Integer n = this.getIndex(revision);
                    FilePath filePath = revisionEx.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"revisionEx.path");
                    map2.put(n, new MaybeDeletedFilePath(filePath, revisionEx.isDeleted()));
                }
                VisibleGraph visibleGraph = Companion.createVisibleGraph(dataPack, sortType, null, pathsMap.keySet());
                return FileHistoryPaths.INSTANCE.withFileHistory(new VisiblePack(dataPack, (VisibleGraph<Integer>)visibleGraph, !isDone, filters), new FileHistory(pathsMap, null, null, null, 14, null));
            }
            ArrayList<GraphCommit<Integer>> commits = new ArrayList<GraphCommit<Integer>>(revisions.size());
            HashMap pathsMap = new HashMap();
            for (VcsFileRevision revision : revisions) {
                int index2 = this.getIndex(revision);
                VcsFileRevision vcsFileRevision = revision;
                if (vcsFileRevision == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.vcs.history.VcsFileRevisionEx");
                }
                VcsFileRevisionEx revisionEx = (VcsFileRevisionEx)vcsFileRevision;
                Map map3 = pathsMap;
                Integer n = index2;
                FilePath filePath = revisionEx.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"revisionEx.path");
                map3.put(n, new MaybeDeletedFilePath(filePath, revisionEx.isDeleted()));
                Integer n2 = index2;
                List list3 = CollectionsKt.emptyList();
                Date date = revision.getRevisionDate();
                Intrinsics.checkNotNullExpressionValue((Object)date, (String)"revision.getRevisionDate()");
                commits.add(GraphCommitImpl.createCommit(n2, list3, date.getTime()));
            }
            Map<VirtualFile, CompressedRefs> refs = this.getFilteredRefs(dataPack);
            DataPack dataPack2 = DataPack.build((List<? extends GraphCommit<Integer>>)commits, refs, MapsKt.mapOf((Pair)TuplesKt.to((Object)this.root, FileHistoryFilterer.this.logProviders.get(this.root))), FileHistoryFilterer.this.storage, false);
            Intrinsics.checkNotNullExpressionValue((Object)dataPack2, (String)"DataPack.build(commits, \u2026s[root]), storage, false)");
            DataPack fakeDataPack = dataPack2;
            VisibleGraph visibleGraph = Companion.createVisibleGraph(fakeDataPack, sortType, null, null);
            VisiblePack visiblePack = FileHistoryPaths.INSTANCE.withFileHistory(new VisiblePack(fakeDataPack, (VisibleGraph<Integer>)visibleGraph, !isDone, filters), new FileHistory(pathsMap, null, null, null, 14, null));
            boolean bl = false;
            boolean bl2 = false;
            VisiblePack $this$apply = visiblePack;
            boolean bl3 = false;
            $this$apply.putUserData(NO_PARENTS_INFO, true);
            return visiblePack;
        }

        private final Map<VirtualFile, CompressedRefs> getFilteredRefs(DataPack dataPack) {
            RefsModel refsModel = dataPack.getRefsModel();
            Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"dataPack.refsModel");
            CompressedRefs compressedRefs = refsModel.getAllRefsByRoot().get(this.root);
            if (compressedRefs == null) {
                compressedRefs = new CompressedRefs(SetsKt.emptySet(), FileHistoryFilterer.this.storage);
            }
            CompressedRefs compressedRefs2 = compressedRefs;
            return MapsKt.mapOf((Pair)new Pair((Object)this.root, (Object)compressedRefs2));
        }

        private final int getIndex(VcsFileRevision revision) {
            return FileHistoryFilterer.this.storage.getCommitIndex(HashImpl.build(revision.getRevisionNumber().asString()), this.root);
        }

        private final VisiblePack filterWithIndex(DataPack dataPack, VisiblePack oldVisiblePack, PermanentGraph.SortType sortType, VcsLogFilterCollection filters, boolean isInitial) {
            FileHistory oldFileHistory = FileHistoryPaths.INSTANCE.getFileHistory(oldVisiblePack);
            if (isInitial) {
                return this.filterWithIndex(dataPack, filters, sortType, oldFileHistory.getCommitToRename$intellij_platform_vcs_log_impl(), new FileHistory(MapsKt.emptyMap(), oldFileHistory.getProcessedAdditionsDeletions$intellij_platform_vcs_log_impl(), null, null, 12, null));
            }
            MultiMap<UnorderedPair<Integer>, Rename> renames = this.collectRenamesFromProvider(oldFileHistory);
            return this.filterWithIndex(dataPack, filters, sortType, (MultiMap<UnorderedPair<Integer>, Rename>)FileHistoryFiltererKt.access$union(renames, oldFileHistory.getCommitToRename$intellij_platform_vcs_log_impl()), oldFileHistory);
        }

        private final VisiblePack filterWithIndex(DataPack dataPack, VcsLogFilterCollection filters, PermanentGraph.SortType sortType, MultiMap<UnorderedPair<Integer>, Rename> oldRenames, FileHistory oldFileHistory) {
            Integer n;
            VcsLogFiltererImpl vcsLogFiltererImpl = FileHistoryFilterer.this.vcsLogFilterer;
            RefsModel refsModel = dataPack.getRefsModel();
            Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"dataPack.refsModel");
            Set<Integer> matchingHeads = vcsLogFiltererImpl.getMatchingHeads(refsModel, (Collection<? extends VirtualFile>)SetsKt.setOf((Object)this.root), filters);
            FileHistoryData data2 = FileHistoryFilterer.this.indexDataGetter.createFileHistoryData(this.filePath).build$intellij_platform_vcs_log_impl(oldRenames);
            PermanentGraph<Integer> permanentGraph = dataPack.getPermanentGraph();
            Intrinsics.checkNotNullExpressionValue(permanentGraph, (String)"dataPack.permanentGraph");
            PermanentGraph<Integer> permanentGraph2 = permanentGraph;
            if (!(permanentGraph2 instanceof PermanentGraphImpl)) {
                VisibleGraph visibleGraph = Companion.createVisibleGraph(dataPack, sortType, matchingHeads, (Set)data2.getCommits());
                FileHistory fileHistory = new FileHistory(data2.buildPathsMap(), null, null, null, 14, null);
                return FileHistoryPaths.INSTANCE.withFileHistory(new VisiblePack(dataPack, (VisibleGraph<Integer>)visibleGraph, false, filters), fileHistory);
            }
            if (VcsLogFiltererImplKt.matchesNothing((Collection)matchingHeads) || data2.isEmpty()) {
                VisiblePack visiblePack = VisiblePack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)visiblePack, (String)"VisiblePack.EMPTY");
                return visiblePack;
            }
            Hash hash = this.hash;
            if (hash == null) {
                hash = this.getHead(dataPack);
            }
            if (hash != null) {
                Hash fileHistory = hash;
                boolean bl = false;
                boolean bl2 = false;
                Hash it = fileHistory;
                boolean bl3 = false;
                n = FileHistoryFilterer.this.storage.getCommitIndex(it, this.root);
            } else {
                n = null;
            }
            Integer commit2 = n;
            FileHistoryBuilder historyBuilder = new FileHistoryBuilder(commit2, this.filePath, data2, oldFileHistory, null, FileHistoryBuilder.Companion.isRemoveTrivialMerges$intellij_platform_vcs_log_impl(), FileHistoryBuilder.Companion.isRefine$intellij_platform_vcs_log_impl(), 16, null);
            VisibleGraph<Integer> visibleGraph = ((PermanentGraphImpl)permanentGraph2).createVisibleGraph(sortType, matchingHeads, (Set)data2.getCommits(), historyBuilder);
            Intrinsics.checkNotNullExpressionValue(visibleGraph, (String)"permanentGraph.createVis\u2026ommits(), historyBuilder)");
            VisibleGraph<Integer> visibleGraph2 = visibleGraph;
            FileHistory fileHistory = historyBuilder.getFileHistory();
            Collection collection = fileHistory.getUnmatchedAdditionsDeletions$intellij_platform_vcs_log_impl();
            boolean bl = false;
            return FileHistoryPaths.INSTANCE.withFileHistory(new VisiblePack(dataPack, visibleGraph2, !collection.isEmpty(), filters), fileHistory);
        }

        /*
         * WARNING - void declaration
         */
        private final MultiMap<UnorderedPair<Integer>, Rename> collectRenamesFromProvider(FileHistory fileHistory) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$mapNotNullTo$iv$iv;
            if (fileHistory.getUnmatchedAdditionsDeletions$intellij_platform_vcs_log_impl().isEmpty()) {
                MultiMap multiMap = MultiMap.empty();
                Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"MultiMap.empty()");
                return multiMap;
            }
            long start2 = System.currentTimeMillis();
            VcsLogProvider vcsLogProvider = (VcsLogProvider)FileHistoryFilterer.this.logProviders.get(this.root);
            if (vcsLogProvider == null || (vcsLogProvider = vcsLogProvider.getFileHistoryHandler()) == null) {
                MultiMap multiMap = MultiMap.empty();
                Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"MultiMap.empty()");
                return multiMap;
            }
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogProvider, (String)"logProviders[root]?.file\u2026: return MultiMap.empty()");
            VcsLogProvider handler2 = vcsLogProvider;
            Iterable $this$mapNotNull$iv = fileHistory.getUnmatchedAdditionsDeletions$intellij_platform_vcs_log_impl();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            VcsLogFileHistoryHandler.Rename rename2 = $this$forEach$iv$iv$iv.iterator();
            while (rename2.hasNext()) {
                VcsLogFileHistoryHandler.Rename rename3;
                Hash childHash;
                Hash parentHash;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = rename2.next();
                boolean bl = false;
                AdditionDeletion it = (AdditionDeletion)element$iv$iv;
                boolean bl2 = false;
                CommitId commitId2 = FileHistoryFilterer.this.storage.getCommitId(it.getParent());
                Intrinsics.checkNotNull((Object)commitId2);
                Intrinsics.checkNotNullExpressionValue((Object)commitId2, (String)"storage.getCommitId(it.parent)!!");
                Intrinsics.checkNotNullExpressionValue((Object)commitId2.getHash(), (String)"storage.getCommitId(it.parent)!!.hash");
                CommitId commitId3 = FileHistoryFilterer.this.storage.getCommitId(it.getChild());
                Intrinsics.checkNotNull((Object)commitId3);
                Intrinsics.checkNotNullExpressionValue((Object)commitId3, (String)"storage.getCommitId(it.child)!!");
                Intrinsics.checkNotNullExpressionValue((Object)commitId3.getHash(), (String)"storage.getCommitId(it.child)!!.hash");
                if ((it.isAddition() ? handler2.getRename(this.root, it.getFilePath(), parentHash, childHash) : handler2.getRename(this.root, it.getFilePath(), childHash, parentHash)) == null) continue;
                rename3 = rename3;
                boolean bl3 = false;
                boolean bl4 = false;
                VcsLogFileHistoryHandler.Rename it$iv$iv = rename3;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void r;
                rename2 = (VcsLogFileHistoryHandler.Rename)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Rename rename4 = new Rename(r.getFilePath1(), r.getFilePath2(), FileHistoryFilterer.this.storage.getCommitIndex(r.getHash1(), this.root), FileHistoryFilterer.this.storage.getCommitIndex(r.getHash2(), this.root));
                collection.add(rename4);
            }
            List renames = (List)destination$iv$iv;
            LOG.debug("Found " + renames.size() + " renames for " + fileHistory.getUnmatchedAdditionsDeletions$intellij_platform_vcs_log_impl().size() + " addition-deletions in " + StopWatch.formatTime(System.currentTimeMillis() - start2));
            MultiMap result2 = new MultiMap();
            Iterable $this$forEach$iv = renames;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Rename it = (Rename)element$iv;
                boolean bl = false;
                result2.putValue(it.getCommits(), (Object)it);
            }
            return result2;
        }

        private final Hash getHead(DataPack pack) {
            RefsModel refsModel = pack.getRefsModel();
            Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"pack.refsModel");
            VcsRef vcsRef = DataPackUtilKt.findBranch(refsModel, "HEAD", this.root);
            return vcsRef != null ? vcsRef.getCommitHash() : null;
        }

        public MyWorker(@NotNull VirtualFile root2, @Nullable FilePath filePath, Hash hash) {
            Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            this.root = root2;
            this.filePath = filePath;
            this.hash = hash;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0007J>\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001bH\u0002J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001e\u001a\u00020\u000bJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryFilterer$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NO_PARENTS_INFO", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "createFilters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "revision", "Lcom/intellij/vcs/log/Hash;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "showAllBranches", "createVisibleGraph", "Lcom/intellij/vcs/log/graph/VisibleGraph;", "", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "sortType", "Lcom/intellij/vcs/log/graph/PermanentGraph$SortType;", "matchingHeads", "", "matchingCommits", "getFilePath", "filters", "getStructureFilter", "Lcom/intellij/vcs/log/VcsLogStructureFilter;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private final VcsLogStructureFilter getStructureFilter(VcsLogFilterCollection filters) {
            List list2 = filters.getDetailsFilters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"filters.detailsFilters");
            Object object = CollectionsKt.singleOrNull((List)list2);
            if (!(object instanceof VcsLogStructureFilter)) {
                object = null;
            }
            return (VcsLogStructureFilter)object;
        }

        @Nullable
        public final FilePath getFilePath(@NotNull VcsLogFilterCollection filters) {
            Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
            VcsLogStructureFilter vcsLogStructureFilter = this.getStructureFilter(filters);
            if (vcsLogStructureFilter == null) {
                return null;
            }
            VcsLogStructureFilter filter = vcsLogStructureFilter;
            Collection collection = filter.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"filter.files");
            return (FilePath)CollectionsKt.singleOrNull((Iterable)collection);
        }

        @JvmStatic
        @NotNull
        public final VcsLogFilterCollection createFilters(@NotNull FilePath path2, @Nullable Hash revision, @NotNull VirtualFile root2, boolean showAllBranches) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
            VcsLogFileHistoryFilter fileFilter = new VcsLogFileHistoryFilter(path2, revision);
            VcsLogBranchLikeFilter revisionFilter = showAllBranches ? null : (revision != null ? (VcsLogBranchLikeFilter)VcsLogFilterObject.fromCommit(new CommitId(revision, root2)) : (VcsLogBranchLikeFilter)VcsLogFilterObject.fromBranch("HEAD"));
            return VcsLogFilterObject.collection((VcsLogFilter)fileFilter, (VcsLogFilter)revisionFilter);
        }

        private final VisibleGraph<Integer> createVisibleGraph(DataPack dataPack, PermanentGraph.SortType sortType, Set<Integer> matchingHeads, Set<Integer> matchingCommits) {
            if (VcsLogFiltererImplKt.matchesNothing((Collection)matchingHeads) || VcsLogFiltererImplKt.matchesNothing((Collection)matchingCommits)) {
                VisibleGraph<Integer> visibleGraph = EmptyVisibleGraph.getInstance();
                Intrinsics.checkNotNullExpressionValue(visibleGraph, (String)"EmptyVisibleGraph.getInstance()");
                return visibleGraph;
            }
            VisibleGraph visibleGraph = dataPack.getPermanentGraph().createVisibleGraph(sortType, matchingHeads, matchingCommits);
            Intrinsics.checkNotNullExpressionValue((Object)visibleGraph, (String)"dataPack.permanentGraph.\u2026ngHeads, matchingCommits)");
            return visibleGraph;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

