/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.history.VcsCachingHistory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001aJ\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0'H\u0002J\b\u0010(\u001a\u00020$H\u0002J\u0018\u0010)\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0'\u0012\u0004\u0012\u00020\u001a0*R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u001e\u001a\t\u0018\u00010\u001f\u00a2\u0006\u0002\b X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryTask;", "", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "hash", "Lcom/intellij/vcs/log/Hash;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/openapi/vcs/AbstractVcs;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/vcs/log/Hash;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "_revisions", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/intellij/openapi/vcs/history/VcsFileRevision;", "exception", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/vcs/VcsException;", "getFilePath", "()Lcom/intellij/openapi/vcs/FilePath;", "future", "Ljava/util/concurrent/Future;", "getHash", "()Lcom/intellij/vcs/log/Hash;", "getIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "isCancelled", "", "()Z", "lastSize", "", "revisionNumber", "Lcom/intellij/openapi/vcs/changes/TextRevisionNumber;", "Lorg/jetbrains/annotations/NotNull;", "getVcs", "()Lcom/intellij/openapi/vcs/AbstractVcs;", "cancel", "", "wait", "getRevisionsSnapshot", "", "throwOnError", "waitForRevisions", "Lkotlin/Pair;", "intellij.platform.vcs.log.impl"})
final class FileHistoryTask {
    private final TextRevisionNumber revisionNumber;
    private final Future<?> future;
    private final ConcurrentLinkedQueue<VcsFileRevision> _revisions;
    private final AtomicReference<VcsException> exception;
    private volatile int lastSize;
    @NotNull
    private final AbstractVcs vcs;
    @NotNull
    private final FilePath filePath;
    @Nullable
    private final Hash hash;
    @NotNull
    private final ProgressIndicator indicator;

    public final boolean isCancelled() {
        return this.indicator.isCanceled();
    }

    @NotNull
    public final Pair<List<VcsFileRevision>, Boolean> waitForRevisions() throws VcsException {
        this.throwOnError();
        while (this._revisions.size() == this.lastSize) {
            try {
                this.future.get(100L, TimeUnit.MILLISECONDS);
                ProgressManager.checkCanceled();
                this.throwOnError();
                return new Pair(this.getRevisionsSnapshot(), (Object)true);
            }
            catch (TimeoutException timeoutException) {
            }
        }
        return new Pair(this.getRevisionsSnapshot(), (Object)false);
    }

    private final List<VcsFileRevision> getRevisionsSnapshot() {
        List list2 = CollectionsKt.toList((Iterable)this._revisions);
        this.lastSize = list2.size();
        return list2;
    }

    private final void throwOnError() throws VcsException {
        if (this.exception.get() != null) {
            throw (Throwable)new VcsException((Throwable)this.exception.get());
        }
    }

    public final void cancel(boolean wait) {
        this.indicator.cancel();
        if (wait) {
            try {
                this.future.get(20L, TimeUnit.MILLISECONDS);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @NotNull
    public final AbstractVcs getVcs() {
        return this.vcs;
    }

    @NotNull
    public final FilePath getFilePath() {
        return this.filePath;
    }

    @Nullable
    public final Hash getHash() {
        return this.hash;
    }

    @NotNull
    public final ProgressIndicator getIndicator() {
        return this.indicator;
    }

    public FileHistoryTask(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, @Nullable Hash hash, @NotNull ProgressIndicator indicator2) {
        Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
        this.vcs = vcs;
        this.filePath = filePath;
        this.hash = hash;
        this.indicator = indicator2;
        this.revisionNumber = this.hash != null ? VcsLogUtil.convertToRevisionNumber(this.hash) : null;
        this._revisions = new ConcurrentLinkedQueue();
        this.exception = new AtomicReference();
        Future<?> future2 = AppExecutorUtil.getAppExecutorService().submit(new Runnable(){

            @Override
            public final void run() {
                ProgressManager.getInstance().runProcess(new Runnable(){

                    @Override
                    public final void run() {
                        try {
                            VcsCachingHistory.collect(this.getVcs(), this.getFilePath(), (VcsRevisionNumber)revisionNumber, (Consumer<VcsFileRevision>)new Consumer(){

                                public final void consume(VcsFileRevision revision) {
                                    _revisions.add(revision);
                                }
                            });
                        }
                        catch (VcsException e) {
                            exception.set(e);
                        }
                    }
                }, this.getIndicator());
            }
        });
        Intrinsics.checkNotNullExpressionValue(future2, (String)"AppExecutorUtil.getAppEx\u2026      }, indicator)\n    }");
        this.future = future2;
    }
}

