/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogFileHistoryProvider;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.VcsLogFileHistoryProviderImplKt;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.filter.VcsLogFilterUiEx;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J \u0010\f\u001a\u00020\r2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/history/VcsLogDirectoryHistoryProvider;", "Lcom/intellij/vcs/log/VcsLogFileHistoryProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "canShowFileHistory", "", "paths", "", "Lcom/intellij/openapi/vcs/FilePath;", "revisionNumber", "", "showFileHistory", "", "Companion", "intellij.platform.vcs.log.impl"})
final class VcsLogDirectoryHistoryProvider
implements VcsLogFileHistoryProvider {
    private final Project project;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean canShowFileHistory(@NotNull Collection<? extends FilePath> paths2, @Nullable String revisionNumber) {
        Intrinsics.checkNotNullParameter(paths2, (String)"paths");
        if (!Registry.is((String)"vcs.history.show.directory.history.in.log")) {
            return false;
        }
        VcsProjectLog vcsProjectLog = VcsProjectLog.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)vcsProjectLog, (String)"VcsProjectLog.getInstance(project)");
        VcsLogData vcsLogData = vcsProjectLog.getDataManager();
        if (vcsLogData == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"VcsProjectLog.getInstanc\u2026taManager ?: return false");
        VcsLogData dataManager = vcsLogData;
        return VcsLogDirectoryHistoryProvider.Companion.createPathsFilter(this.project, dataManager, paths2) != null;
    }

    public void showFileHistory(@NotNull Collection<? extends FilePath> paths2, @Nullable String revisionNumber) {
        boolean firstTime;
        Hash hash;
        Intrinsics.checkNotNullParameter(paths2, (String)"paths");
        String string = revisionNumber;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            hash = HashImpl.build(it);
        } else {
            hash = null;
        }
        Hash hash2 = hash;
        VirtualFile virtualFile2 = VcsLogUtil.getActualRoot(this.project, (FilePath)CollectionsKt.first((Iterable)paths2));
        Intrinsics.checkNotNull((Object)virtualFile2);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"VcsLogUtil.getActualRoot(project, paths.first())!!");
        VirtualFile root2 = virtualFile2;
        VcsLogFileHistoryProviderImplKt.access$triggerFileHistoryUsage(this.project, paths2, hash2);
        VcsProjectLog vcsProjectLog = VcsProjectLog.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)vcsProjectLog, (String)"VcsProjectLog.getInstance(project)");
        VcsLogManager vcsLogManager = vcsProjectLog.getLogManager();
        Intrinsics.checkNotNull((Object)vcsLogManager);
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogManager, (String)"VcsProjectLog.getInstance(project).logManager!!");
        VcsLogManager logManager = vcsLogManager;
        VcsLogData vcsLogData = logManager.getDataManager();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"logManager.dataManager");
        VcsLogFilter vcsLogFilter = VcsLogDirectoryHistoryProvider.Companion.createPathsFilter(this.project, vcsLogData, paths2);
        Intrinsics.checkNotNull((Object)vcsLogFilter);
        VcsLogFilter pathsFilter = vcsLogFilter;
        VcsLogFilter hashFilter = VcsLogDirectoryHistoryProvider.Companion.createHashFilter(hash2, root2);
        MainVcsLogUi ui2 = VcsLogContentUtil.findAndSelect(this.project, MainVcsLogUi.class, (Condition)new Condition(pathsFilter, hashFilter){
            final /* synthetic */ VcsLogFilter $pathsFilter;
            final /* synthetic */ VcsLogFilter $hashFilter;

            public final boolean value(MainVcsLogUi logUi) {
                MainVcsLogUi mainVcsLogUi = logUi;
                Intrinsics.checkNotNullExpressionValue((Object)mainVcsLogUi, (String)"logUi");
                VcsLogFilterUiEx vcsLogFilterUiEx = mainVcsLogUi.getFilterUi();
                Intrinsics.checkNotNullExpressionValue((Object)vcsLogFilterUiEx, (String)"logUi.filterUi");
                VcsLogFilterCollection vcsLogFilterCollection = vcsLogFilterUiEx.getFilters();
                Intrinsics.checkNotNullExpressionValue((Object)vcsLogFilterCollection, (String)"logUi.filterUi.filters");
                return com.intellij.vcs.log.history.VcsLogDirectoryHistoryProvider$Companion.access$matches(VcsLogDirectoryHistoryProvider.Companion, vcsLogFilterCollection, this.$pathsFilter, this.$hashFilter);
            }
            {
                this.$pathsFilter = vcsLogFilter;
                this.$hashFilter = vcsLogFilter2;
            }
        });
        boolean bl = firstTime = ui2 == null;
        if (firstTime) {
            VcsLogFilterCollection filters = VcsLogFilterObject.collection(pathsFilter, hashFilter);
            MainVcsLogUi mainVcsLogUi = VcsProjectLog.getInstance(this.project).openLogTab(filters);
            if (mainVcsLogUi == null) {
                return;
            }
            ui2 = mainVcsLogUi;
            ui2.getProperties().set(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES, true);
        }
        MainVcsLogUi mainVcsLogUi = ui2;
        Intrinsics.checkNotNull((Object)mainVcsLogUi);
        VcsLogFileHistoryProviderImplKt.access$selectRowWhenOpen(logManager, hash2, root2, mainVcsLogUi, firstTime);
    }

    public VcsLogDirectoryHistoryProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/vcs/log/history/VcsLogDirectoryHistoryProvider$Companion;", "", "()V", "createHashFilter", "Lcom/intellij/vcs/log/VcsLogFilter;", "hash", "Lcom/intellij/vcs/log/Hash;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "createPathsFilter", "project", "Lcom/intellij/openapi/project/Project;", "dataManager", "Lcom/intellij/vcs/log/data/VcsLogData;", "paths", "", "Lcom/intellij/openapi/vcs/FilePath;", "matches", "", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "pathsFilter", "hashFilter", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private final VcsLogFilter createPathsFilter(Project project, VcsLogData dataManager, Collection<? extends FilePath> paths2) {
            boolean bl = false;
            Set forRootFilter = new LinkedHashSet();
            boolean bl2 = false;
            List forPathsFilter = new ArrayList();
            for (FilePath filePath : paths2) {
                VirtualFile root2 = VcsLogUtil.getActualRoot(project, filePath);
                if (root2 == null) {
                    return null;
                }
                if (!dataManager.getRoots().contains(root2) || !((Boolean)VcsLogProperties.SUPPORTS_LOG_DIRECTORY_HISTORY.getOrDefault(dataManager.getLogProvider(root2))).booleanValue()) {
                    return null;
                }
                FilePath correctedPath = VcsLogFileHistoryProviderImplKt.access$getCorrectedPath(project, filePath, root2, false);
                if (!correctedPath.isDirectory()) {
                    return null;
                }
                if (Intrinsics.areEqual((Object)filePath.getVirtualFile(), (Object)root2)) {
                    forRootFilter.add(root2);
                } else {
                    forPathsFilter.add(correctedPath);
                }
                Collection collection = forPathsFilter;
                boolean bl3 = false;
                if (!(!collection.isEmpty())) continue;
                collection = forRootFilter;
                bl3 = false;
                if (!(!collection.isEmpty())) continue;
                return null;
            }
            Collection collection = forPathsFilter;
            boolean bl4 = false;
            if (!collection.isEmpty()) {
                return (VcsLogFilter)VcsLogFilterObject.fromPaths(forPathsFilter);
            }
            return (VcsLogFilter)VcsLogFilterObject.fromRoots(forRootFilter);
        }

        private final VcsLogFilter createHashFilter(Hash hash, VirtualFile root2) {
            if (hash == null) {
                return (VcsLogFilter)VcsLogFilterObject.fromBranch("HEAD");
            }
            return (VcsLogFilter)VcsLogFilterObject.fromCommit(new CommitId(hash, root2));
        }

        private final boolean matches(VcsLogFilterCollection filters, VcsLogFilter pathsFilter, VcsLogFilter hashFilter) {
            VcsLogFilterCollection.FilterKey[] filterKeyArray = new VcsLogFilterCollection.FilterKey[2];
            VcsLogFilterCollection.FilterKey filterKey = hashFilter.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)filterKey, (String)"hashFilter.key");
            filterKeyArray[0] = filterKey;
            VcsLogFilterCollection.FilterKey filterKey2 = pathsFilter.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)filterKey2, (String)"pathsFilter.key");
            filterKeyArray[1] = filterKey2;
            if (!VcsLogFiltersKt.matches(filters, filterKeyArray)) {
                return false;
            }
            return Intrinsics.areEqual((Object)filters.get(pathsFilter.getKey()), (Object)pathsFilter) && Intrinsics.areEqual((Object)filters.get(hashFilter.getKey()), (Object)hashFilter);
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$matches(Companion $this, VcsLogFilterCollection filters, VcsLogFilter pathsFilter, VcsLogFilter hashFilter) {
            return $this.matches(filters, pathsFilter, hashFilter);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

