/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.TabGroupId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogFileHistoryProvider;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.history.FileHistoryUiFactory;
import com.intellij.vcs.log.history.VcsLogFileHistoryProviderImplKt;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/vcs/log/history/VcsLogSingleFileHistoryProvider;", "Lcom/intellij/vcs/log/VcsLogFileHistoryProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "tabGroupId", "Lcom/intellij/ui/content/TabGroupId;", "canShowFileHistory", "", "paths", "", "Lcom/intellij/openapi/vcs/FilePath;", "revisionNumber", "", "showFileHistory", "", "intellij.platform.vcs.log.impl"})
final class VcsLogSingleFileHistoryProvider
implements VcsLogFileHistoryProvider {
    private final TabGroupId tabGroupId;
    private final Project project;

    public boolean canShowFileHistory(@NotNull Collection<? extends FilePath> paths2, @Nullable String revisionNumber) {
        Intrinsics.checkNotNullParameter(paths2, (String)"paths");
        if (!VcsLogFileHistoryProviderImplKt.isNewHistoryEnabled() || paths2.size() != 1) {
            return false;
        }
        VirtualFile virtualFile2 = VcsLogUtil.getActualRoot(this.project, (FilePath)CollectionsKt.single((Iterable)paths2));
        if (virtualFile2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"VcsLogUtil.getActualRoot\u2026single()) ?: return false");
        VirtualFile root2 = virtualFile2;
        FilePath correctedPath = VcsLogFileHistoryProviderImplKt.access$getCorrectedPath(this.project, (FilePath)CollectionsKt.single((Iterable)paths2), root2, revisionNumber != null);
        if (correctedPath.isDirectory()) {
            return false;
        }
        VcsProjectLog vcsProjectLog = VcsProjectLog.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)vcsProjectLog, (String)"VcsProjectLog.getInstance(project)");
        VcsLogData vcsLogData = vcsProjectLog.getDataManager();
        if (vcsLogData == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"VcsProjectLog.getInstanc\u2026taManager ?: return false");
        VcsLogData dataManager = vcsLogData;
        VcsLogProvider vcsLogProvider = dataManager.getLogProviders().get(root2);
        if ((vcsLogProvider != null ? vcsLogProvider.getDiffHandler() : null) == null) {
            return false;
        }
        return dataManager.getIndex().isIndexingEnabled(root2) || Registry.is((String)"vcs.force.new.history");
    }

    public void showFileHistory(@NotNull Collection<? extends FilePath> paths2, @Nullable String revisionNumber) {
        boolean firstTime;
        Hash hash;
        Intrinsics.checkNotNullParameter(paths2, (String)"paths");
        if (paths2.size() != 1) {
            return;
        }
        VirtualFile virtualFile2 = VcsLogUtil.getActualRoot(this.project, (FilePath)CollectionsKt.first((Iterable)paths2));
        Intrinsics.checkNotNull((Object)virtualFile2);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"VcsLogUtil.getActualRoot(project, paths.first())!!");
        VirtualFile root2 = virtualFile2;
        FilePath path2 = VcsLogFileHistoryProviderImplKt.access$getCorrectedPath(this.project, (FilePath)CollectionsKt.single((Iterable)paths2), root2, revisionNumber != null);
        if (path2.isDirectory()) {
            return;
        }
        String string = revisionNumber;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            hash = HashImpl.build(it);
        } else {
            hash = null;
        }
        Hash hash2 = hash;
        VcsLogFileHistoryProviderImplKt.access$triggerFileHistoryUsage(this.project, paths2, hash2);
        VcsProjectLog vcsProjectLog = VcsProjectLog.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)vcsProjectLog, (String)"VcsProjectLog.getInstance(project)");
        VcsLogManager vcsLogManager = vcsProjectLog.getLogManager();
        Intrinsics.checkNotNull((Object)vcsLogManager);
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogManager, (String)"VcsProjectLog.getInstance(project).logManager!!");
        VcsLogManager logManager = vcsLogManager;
        FileHistoryUi fileHistoryUi2 = VcsLogContentUtil.findAndSelect(this.project, FileHistoryUi.class, (Condition)new Condition(path2, hash2){
            final /* synthetic */ FilePath $path;
            final /* synthetic */ Hash $hash;

            public final boolean value(FileHistoryUi ui2) {
                return ui2.matches(this.$path, this.$hash);
            }
            {
                this.$path = filePath;
                this.$hash = hash;
            }
        });
        boolean bl = firstTime = fileHistoryUi2 == null;
        if (firstTime) {
            String suffix = hash2 != null ? " (" + hash2.toShortString() + ")" : "";
            fileHistoryUi2 = (FileHistoryUi)VcsLogContentUtil.openLogTab(this.project, logManager, this.tabGroupId, new Function(path2, suffix){
                final /* synthetic */ FilePath $path;
                final /* synthetic */ String $suffix;

                public final String apply(FileHistoryUi it) {
                    return this.$path.getName() + this.$suffix;
                }
                {
                    this.$path = filePath;
                    this.$suffix = string;
                }
            }, new FileHistoryUiFactory(path2, root2, hash2), true);
        }
        FileHistoryUi fileHistoryUi3 = fileHistoryUi2;
        Intrinsics.checkNotNull((Object)fileHistoryUi3);
        VcsLogFileHistoryProviderImplKt.access$selectRowWhenOpen(logManager, hash2, root2, fileHistoryUi3, firstTime);
    }

    public VcsLogSingleFileHistoryProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Supplier supplier2 = VcsBundle.messagePointer((String)"file.history.tab.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier2, (String)"VcsBundle.messagePointer(\"file.history.tab.name\")");
        this.tabGroupId = new TabGroupId("History", supplier2, false);
    }
}

