/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogEditorTabsWatcher;
import com.intellij.vcs.log.impl.VcsLogEditorUtilKt;
import com.intellij.vcs.log.impl.VcsLogTabsWatcherExtension;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0000\u0018\u0000 \u001a2\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0003\u001a\u001b\u001cB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J$\u0010\u0010\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000fH\u0016J\u001c\u0010\u0018\u001a\u00020\u000b2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogEditorTabsWatcher;", "Lcom/intellij/vcs/log/impl/VcsLogTabsWatcherExtension;", "Lcom/intellij/vcs/log/impl/VcsLogEditorTabsWatcher$VcsLogEditorTab;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "tabSelectedCallback", "Lkotlin/Function1;", "", "", "closeTabs", "tabs", "", "Lcom/intellij/vcs/log/impl/PostponableLogRefresher$VcsLogWindow;", "createLogTab", "logId", "refresher", "Lcom/intellij/vcs/log/visible/VisiblePackRefresher;", "isClosedOnDispose", "", "isOwnerOf", "tab", "setTabSelectedCallback", "callback", "Companion", "MyFileManagerListener", "VcsLogEditorTab", "intellij.platform.vcs.log.impl"})
public final class VcsLogEditorTabsWatcher
implements VcsLogTabsWatcherExtension<VcsLogEditorTab> {
    private Function1<? super String, Unit> tabSelectedCallback;
    private final Project project;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    public void setTabSelectedCallback(@NotNull Function1<? super String, Unit> callback2) {
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        this.tabSelectedCallback = callback2;
    }

    @Override
    @NotNull
    public VcsLogEditorTab createLogTab(@NotNull String logId, @NotNull VisiblePackRefresher refresher, boolean isClosedOnDispose) {
        Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
        Intrinsics.checkNotNullParameter((Object)refresher, (String)"refresher");
        return new VcsLogEditorTab(logId, refresher, isClosedOnDispose);
    }

    @Override
    public boolean isOwnerOf(@NotNull PostponableLogRefresher.VcsLogWindow tab) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        return tab instanceof VcsLogEditorTab;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeTabs(@NotNull List<? extends PostponableLogRefresher.VcsLogWindow> tabs) {
        void $this$mapTo$iv$iv;
        VcsLogEditorTab it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(tabs, (String)"tabs");
        Iterable $this$filter$iv = CollectionsKt.filterIsInstance((Iterable)tabs, VcsLogEditorTab.class);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (VcsLogEditorTab)element$iv$iv;
            boolean bl = false;
            if (!it.isClosedOnDispose()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (VcsLogEditorTab)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getId();
            collection.add(string);
        }
        List editorTabs = (List)destination$iv$iv;
        boolean closed = VcsLogEditorUtilKt.closeLogTabs(this.project, editorTabs);
        LOG.assertTrue(closed, (Object)("Could not close tabs: " + editorTabs));
    }

    public VcsLogEditorTabsWatcher(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.tabSelectedCallback = tabSelectedCallback.1.INSTANCE;
        MessageBusConnection messageBusConnection2 = this.project.getMessageBus().connect(parentDisposable);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection2, (String)"project.messageBus.connect(parentDisposable)");
        MessageBusConnection connection = messageBusConnection2;
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new MyFileManagerListener());
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(VcsLogEditorTabsWatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(VcsLo\u2026rTabsWatcher::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$setTabSelectedCallback$p(VcsLogEditorTabsWatcher $this, Function1 function1) {
        $this.tabSelectedCallback = function1;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\n\u001a\u00020\u0007H\u0016J\r\u0010\u000b\u001a\u00070\u0003\u00a2\u0006\u0002\b\fH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogEditorTabsWatcher$VcsLogEditorTab;", "Lcom/intellij/vcs/log/impl/PostponableLogRefresher$VcsLogWindow;", "id", "", "refresher", "Lcom/intellij/vcs/log/visible/VisiblePackRefresher;", "isClosedOnDispose", "", "(Lcom/intellij/vcs/log/impl/VcsLogEditorTabsWatcher;Ljava/lang/String;Lcom/intellij/vcs/log/visible/VisiblePackRefresher;Z)V", "()Z", "isVisible", "toString", "Lorg/jetbrains/annotations/NonNls;", "intellij.platform.vcs.log.impl"})
    public final class VcsLogEditorTab
    extends PostponableLogRefresher.VcsLogWindow {
        private final boolean isClosedOnDispose;

        @Override
        public boolean isVisible() {
            return Companion.getSelectedEditorTabIds(VcsLogEditorTabsWatcher.this.project).contains(this.getId());
        }

        @Override
        @NotNull
        public String toString() {
            return "VcsLogEditorTab '" + this.getId() + '\'';
        }

        public final boolean isClosedOnDispose() {
            return this.isClosedOnDispose;
        }

        public VcsLogEditorTab(@NotNull String id2, VisiblePackRefresher refresher, boolean isClosedOnDispose) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)refresher, (String)"refresher");
            super(id2, refresher);
            this.isClosedOnDispose = isClosedOnDispose;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogEditorTabsWatcher$MyFileManagerListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "(Lcom/intellij/vcs/log/impl/VcsLogEditorTabsWatcher;)V", "selectionChanged", "", "e", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "intellij.platform.vcs.log.impl"})
    private final class MyFileManagerListener
    implements FileEditorManagerListener {
        public void selectionChanged(@NotNull FileEditorManagerEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            FileEditor fileEditor = e.getNewEditor();
            if (fileEditor != null) {
                FileEditor fileEditor2 = fileEditor;
                boolean bl = false;
                boolean bl2 = false;
                FileEditor editor2 = fileEditor2;
                boolean bl3 = false;
                for (String tabId : VcsLogEditorUtilKt.getLogIds(editor2)) {
                    VcsLogEditorTabsWatcher.this.tabSelectedCallback.invoke((Object)tabId);
                }
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogEditorTabsWatcher$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getSelectedEditorTabIds", "", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private final Set<String> getSelectedEditorTabIds(Project project) {
            return VcsLogEditorUtilKt.findSelectedLogIds(project);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

