/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogEditorTabsWatcher;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabsWatcherExtension;
import com.intellij.vcs.log.impl.VcsLogToolWindowTabsWatcher;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u000eH\u0002R\"\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogTabsWatcher;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "postponableLogRefresher", "Lcom/intellij/vcs/log/impl/PostponableLogRefresher;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/impl/PostponableLogRefresher;)V", "extensions", "", "Lcom/intellij/vcs/log/impl/VcsLogManager$LogWindowKind;", "Lcom/intellij/vcs/log/impl/VcsLogTabsWatcherExtension;", "Lcom/intellij/vcs/log/impl/PostponableLogRefresher$VcsLogWindow;", "addTabToWatch", "logId", "", "refresher", "Lcom/intellij/vcs/log/visible/VisiblePackRefresher;", "kind", "isClosedOnDispose", "", "closeLogTabs", "", "dispose", "selectionChanged", "tabId", "Companion", "intellij.platform.vcs.log.impl"})
public final class VcsLogTabsWatcher
implements Disposable {
    private final Map<VcsLogManager.LogWindowKind, VcsLogTabsWatcherExtension<? extends PostponableLogRefresher.VcsLogWindow>> extensions;
    private final Project project;
    private final PostponableLogRefresher postponableLogRefresher;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Disposable addTabToWatch(@NotNull String logId, @NotNull VisiblePackRefresher refresher, @NotNull VcsLogManager.LogWindowKind kind, boolean isClosedOnDispose) {
        Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
        Intrinsics.checkNotNullParameter((Object)refresher, (String)"refresher");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        VcsLogTabsWatcherExtension<? extends PostponableLogRefresher.VcsLogWindow> extension2 = this.extensions.get((Object)kind);
        VcsLogTabsWatcherExtension<? extends PostponableLogRefresher.VcsLogWindow> vcsLogTabsWatcherExtension = extension2;
        if (vcsLogTabsWatcherExtension == null || (vcsLogTabsWatcherExtension = vcsLogTabsWatcherExtension.createLogTab(logId, refresher, isClosedOnDispose)) == null) {
            vcsLogTabsWatcherExtension = new PostponableLogRefresher.VcsLogWindow(logId, refresher);
        }
        VcsLogTabsWatcherExtension<? extends PostponableLogRefresher.VcsLogWindow> window = vcsLogTabsWatcherExtension;
        Disposable disposable2 = this.postponableLogRefresher.addLogWindow((PostponableLogRefresher.VcsLogWindow)((Object)window));
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"postponableLogRefresher.addLogWindow(window)");
        return disposable2;
    }

    private final void selectionChanged(String tabId) {
        Object v2;
        block2: {
            Set<PostponableLogRefresher.VcsLogWindow> set2 = this.postponableLogRefresher.getLogWindows();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"postponableLogRefresher.logWindows");
            Iterable iterable = set2;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                PostponableLogRefresher.VcsLogWindow window = (PostponableLogRefresher.VcsLogWindow)t;
                boolean bl3 = false;
                PostponableLogRefresher.VcsLogWindow vcsLogWindow = window;
                Intrinsics.checkNotNullExpressionValue((Object)vcsLogWindow, (String)"window");
                if (!Intrinsics.areEqual((Object)vcsLogWindow.getId(), (Object)tabId)) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        PostponableLogRefresher.VcsLogWindow logWindow = v2;
        if (logWindow != null) {
            LOG.debug("Selected log window '" + logWindow + '\'');
            VcsLogUsageTriggerCollector.triggerTabNavigated(this.project);
            this.postponableLogRefresher.refresherActivated(logWindow.getRefresher(), false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void closeLogTabs() {
        for (VcsLogTabsWatcherExtension<? extends PostponableLogRefresher.VcsLogWindow> extension2 : this.extensions.values()) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Set<PostponableLogRefresher.VcsLogWindow> set2 = this.postponableLogRefresher.getLogWindows();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"postponableLogRefresher.logWindows");
            Iterable iterable = set2;
            VcsLogTabsWatcherExtension<? extends PostponableLogRefresher.VcsLogWindow> vcsLogTabsWatcherExtension = extension2;
            boolean $i$f$filter = false;
            void var5_5 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PostponableLogRefresher.VcsLogWindow p1 = (PostponableLogRefresher.VcsLogWindow)element$iv$iv;
                boolean bl = false;
                if (!extension2.isOwnerOf(p1)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            vcsLogTabsWatcherExtension.closeTabs(list2);
        }
    }

    public void dispose() {
        this.closeLogTabs();
    }

    public VcsLogTabsWatcher(@NotNull Project project, @NotNull PostponableLogRefresher postponableLogRefresher) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)postponableLogRefresher, (String)"postponableLogRefresher");
        this.project = project;
        this.postponableLogRefresher = postponableLogRefresher;
        this.extensions = MapsKt.mapOf((Pair[])new Pair[]{new Pair((Object)VcsLogManager.LogWindowKind.TOOL_WINDOW, (Object)new VcsLogToolWindowTabsWatcher(this.project, this)), new Pair((Object)VcsLogManager.LogWindowKind.EDITOR, (Object)new VcsLogEditorTabsWatcher(this.project, this))});
        this.extensions.values().forEach(new Consumer(){

            public final void accept(VcsLogTabsWatcherExtension<? extends PostponableLogRefresher.VcsLogWindow> extension2) {
                extension2.setTabSelectedCallback((Function1<String, Unit>)((Function1)new Function1<String, Unit>(){

                    public final void invoke(@NotNull String tabId) {
                        Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
                        this.selectionChanged(tabId);
                    }
                }));
            }
        });
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(VcsLogTabsWatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(VcsLogTabsWatcher::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogTabsWatcher$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

