/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogTabsWatcherExtension;
import com.intellij.vcs.log.impl.VcsLogToolWindowTabsWatcher;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0000\u0018\u0000 #2\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0004#$%&B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0013\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J$\u0010\u0017\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\rH\u0002J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0016H\u0016J\b\u0010 \u001a\u00020\rH\u0002J\u001c\u0010!\u001a\u00020\r2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0016R\u0013\u0010\b\u001a\u00070\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u00070\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogToolWindowTabsWatcher;", "Lcom/intellij/vcs/log/impl/VcsLogTabsWatcherExtension;", "Lcom/intellij/vcs/log/impl/VcsLogToolWindowTabsWatcher$VcsLogToolWindowTab;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "mainDisposable", "Lorg/jetbrains/annotations/NotNull;", "tabSelectedCallback", "Lkotlin/Function1;", "", "", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "getToolWindow", "()Lcom/intellij/openapi/wm/ToolWindow;", "toolwindowListenerDisposable", "closeTabs", "tabs", "", "Lcom/intellij/vcs/log/impl/PostponableLogRefresher$VcsLogWindow;", "createLogTab", "logId", "refresher", "Lcom/intellij/vcs/log/visible/VisiblePackRefresher;", "isClosedOnDispose", "", "installContentListeners", "isOwnerOf", "tab", "removeContentListeners", "setTabSelectedCallback", "callback", "Companion", "MyToolWindowManagerListener", "VcsLogTabsListener", "VcsLogToolWindowTab", "intellij.platform.vcs.log.impl"})
public final class VcsLogToolWindowTabsWatcher
implements VcsLogTabsWatcherExtension<VcsLogToolWindowTab> {
    private final Disposable mainDisposable;
    private final Disposable toolwindowListenerDisposable;
    private Function1<? super String, Unit> tabSelectedCallback;
    private final Project project;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    private final ToolWindow getToolWindow() {
        return ToolWindowManager.Companion.getInstance(this.project).getToolWindow("Version Control");
    }

    @Override
    public void setTabSelectedCallback(@NotNull Function1<? super String, Unit> callback2) {
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        this.tabSelectedCallback = callback2;
    }

    @Override
    @NotNull
    public VcsLogToolWindowTab createLogTab(@NotNull String logId, @NotNull VisiblePackRefresher refresher, boolean isClosedOnDispose) {
        Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
        Intrinsics.checkNotNullParameter((Object)refresher, (String)"refresher");
        return new VcsLogToolWindowTab(logId, refresher, isClosedOnDispose);
    }

    @Override
    public boolean isOwnerOf(@NotNull PostponableLogRefresher.VcsLogWindow tab) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        return tab instanceof VcsLogToolWindowTab;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeTabs(@NotNull List<? extends PostponableLogRefresher.VcsLogWindow> tabs) {
        Intrinsics.checkNotNullParameter(tabs, (String)"tabs");
        ToolWindow toolWindow2 = this.getToolWindow();
        if (toolWindow2 != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            VcsLogToolWindowTab it;
            void $this$filterTo$iv$iv;
            ToolWindow toolWindow3 = toolWindow2;
            boolean bl = false;
            boolean bl2 = false;
            ToolWindow window = toolWindow3;
            boolean bl3 = false;
            Iterable $this$filter$iv = CollectionsKt.filterIsInstance((Iterable)tabs, VcsLogToolWindowTab.class);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (VcsLogToolWindowTab)element$iv$iv;
                boolean bl4 = false;
                if (!it.isClosedOnDispose()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (VcsLogToolWindowTab)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                String string = it.getId();
                collection.add(string);
            }
            List tabIds = (List)destination$iv$iv;
            for (String tabId : tabIds) {
                boolean closed = VcsLogContentUtil.closeLogTab(window.getContentManager(), tabId);
                StringBuilder stringBuilder = new StringBuilder().append("\n           Could not find content component for tab ").append(tabId).append("\n           Existing content: ");
                ContentManager contentManager2 = window.getContentManager();
                Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"window.contentManager");
                LOG.assertTrue(closed, (Object)StringsKt.trimIndent((String)stringBuilder.append(Arrays.toString(contentManager2.getContents())).append("\n           Tabs to close: ").append(tabIds).append("\n           ").toString()));
            }
        }
    }

    private final void installContentListeners() {
        block0: {
            ApplicationManager.getApplication().assertIsDispatchThread();
            ToolWindow toolWindow2 = this.getToolWindow();
            if (toolWindow2 == null) break block0;
            ToolWindow toolWindow3 = toolWindow2;
            boolean bl = false;
            boolean bl2 = false;
            ToolWindow window = toolWindow3;
            boolean bl3 = false;
            VcsLogToolWindowTabsWatcher.Companion.addContentManagerListener(window, new VcsLogTabsListener(window, this.project, window, this.mainDisposable, this){
                final /* synthetic */ ToolWindow $window;
                final /* synthetic */ VcsLogToolWindowTabsWatcher this$0;
                {
                    this.$window = $captured_local_variable$1;
                    this.this$0 = vcsLogToolWindowTabsWatcher;
                    super($super_call_param$2, $super_call_param$3, $super_call_param$4);
                }

                protected void selectionChanged(@NotNull String tabId) {
                    Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
                    VcsLogToolWindowTabsWatcher.access$getTabSelectedCallback$p(this.this$0).invoke((Object)tabId);
                }
            }, this.toolwindowListenerDisposable);
        }
    }

    private final void removeContentListeners() {
        Disposer.dispose((Disposable)this.toolwindowListenerDisposable);
    }

    public VcsLogToolWindowTabsWatcher(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        Disposable disposable2 = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"Disposer.newDisposable()");
        this.mainDisposable = disposable2;
        Disposable disposable3 = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable3, (String)"Disposer.newDisposable()");
        this.toolwindowListenerDisposable = disposable3;
        this.tabSelectedCallback = tabSelectedCallback.1.INSTANCE;
        MessageBusConnection messageBusConnection2 = this.project.getMessageBus().connect(this.mainDisposable);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection2, (String)"project.messageBus.connect(mainDisposable)");
        MessageBusConnection connection = messageBusConnection2;
        connection.subscribe(ToolWindowManagerListener.TOPIC, (Object)new MyToolWindowManagerListener());
        this.installContentListeners();
        Disposer.register((Disposable)parentDisposable, (Disposable)this.mainDisposable);
        Disposer.register((Disposable)parentDisposable, (Disposable)this.toolwindowListenerDisposable);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(VcsLogToolWindowTabsWatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(VcsLo\u2026wTabsWatcher::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Function1 access$getTabSelectedCallback$p(VcsLogToolWindowTabsWatcher $this) {
        return $this.tabSelectedCallback;
    }

    public static final /* synthetic */ void access$setTabSelectedCallback$p(VcsLogToolWindowTabsWatcher $this, Function1 function1) {
        $this.tabSelectedCallback = function1;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\n\u001a\u00020\u0007H\u0016J\r\u0010\u000b\u001a\u00070\u0003\u00a2\u0006\u0002\b\fH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogToolWindowTabsWatcher$VcsLogToolWindowTab;", "Lcom/intellij/vcs/log/impl/PostponableLogRefresher$VcsLogWindow;", "id", "", "refresher", "Lcom/intellij/vcs/log/visible/VisiblePackRefresher;", "isClosedOnDispose", "", "(Lcom/intellij/vcs/log/impl/VcsLogToolWindowTabsWatcher;Ljava/lang/String;Lcom/intellij/vcs/log/visible/VisiblePackRefresher;Z)V", "()Z", "isVisible", "toString", "Lorg/jetbrains/annotations/NonNls;", "intellij.platform.vcs.log.impl"})
    public final class VcsLogToolWindowTab
    extends PostponableLogRefresher.VcsLogWindow {
        private final boolean isClosedOnDispose;

        @Override
        public boolean isVisible() {
            String selectedTab = Companion.getSelectedToolWindowTabId(VcsLogToolWindowTabsWatcher.this.getToolWindow());
            return Intrinsics.areEqual((Object)this.getId(), (Object)selectedTab);
        }

        @Override
        @NotNull
        public String toString() {
            return "VcsLogToolWindowTab '" + this.getId() + '\'';
        }

        public final boolean isClosedOnDispose() {
            return this.isClosedOnDispose;
        }

        public VcsLogToolWindowTab(@NotNull String id2, VisiblePackRefresher refresher, boolean isClosedOnDispose) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)refresher, (String)"refresher");
            super(id2, refresher);
            this.isClosedOnDispose = isClosedOnDispose;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogToolWindowTabsWatcher$MyToolWindowManagerListener;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "(Lcom/intellij/vcs/log/impl/VcsLogToolWindowTabsWatcher;)V", "toolWindowUnregistered", "", "id", "", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "toolWindowsRegistered", "ids", "", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "intellij.platform.vcs.log.impl"})
    private final class MyToolWindowManagerListener
    implements ToolWindowManagerListener {
        @Override
        public void toolWindowsRegistered(@NotNull List<String> ids, @NotNull ToolWindowManager toolWindowManager) {
            Intrinsics.checkNotNullParameter(ids, (String)"ids");
            Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
            if (ids.contains("Version Control")) {
                VcsLogToolWindowTabsWatcher.this.installContentListeners();
            }
        }

        @Override
        public void toolWindowUnregistered(@NotNull String id2, @NotNull ToolWindow toolWindow2) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
            if (Intrinsics.areEqual((Object)id2, (Object)"Version Control")) {
                VcsLogToolWindowTabsWatcher.this.removeContentListeners();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\"\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\fH\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H$J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogToolWindowTabsWatcher$VcsLogTabsListener;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "Ljava/beans/PropertyChangeListener;", "Lcom/intellij/ui/content/ContentManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "window", "Lcom/intellij/openapi/wm/ToolWindow;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/ToolWindow;Lcom/intellij/openapi/Disposable;)V", "contentAdded", "", "event", "Lcom/intellij/ui/content/ContentManagerEvent;", "contentRemoved", "propertyChange", "evt", "Ljava/beans/PropertyChangeEvent;", "selectionChanged", "tabId", "", "toolWindowShown", "toolWindow", "intellij.platform.vcs.log.impl"})
    private static abstract class VcsLogTabsListener
    implements ToolWindowManagerListener,
    PropertyChangeListener,
    ContentManagerListener {
        private final ToolWindow window;

        protected abstract void selectionChanged(@NotNull String var1);

        private final void selectionChanged() {
            block0: {
                String string = Companion.getSelectedToolWindowTabId(this.window);
                if (string == null) break block0;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                this.selectionChanged(it);
            }
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            block1: {
                String tabId;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (ContentManagerEvent.ContentOperation.add != event.getOperation()) break block1;
                String string = tabId = VcsLogContentUtil.getId(event.getContent());
                if (string != null) {
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    this.selectionChanged(it);
                }
            }
        }

        public void contentAdded(@NotNull ContentManagerEvent event) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Content content2 = event.getContent();
                Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"event.content");
                Content content3 = content2;
                Content content4 = content3;
                if (!(content4 instanceof TabbedContent)) {
                    content4 = null;
                }
                TabbedContent tabbedContent = (TabbedContent)content4;
                if (tabbedContent == null) break block1;
                tabbedContent.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Content content2 = event.getContent();
                Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"event.content");
                Content content3 = content2;
                Content content4 = content3;
                if (!(content4 instanceof TabbedContent)) {
                    content4 = null;
                }
                TabbedContent tabbedContent = (TabbedContent)content4;
                if (tabbedContent == null) break block1;
                tabbedContent.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        @Override
        public void toolWindowShown(@NotNull ToolWindow toolWindow2) {
            Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
            if (this.window == toolWindow2) {
                this.selectionChanged();
            }
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent evt) {
            Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
            if (Intrinsics.areEqual((Object)evt.getPropertyName(), (Object)"component")) {
                this.selectionChanged();
            }
        }

        public VcsLogTabsListener(@NotNull Project project, @NotNull ToolWindow window, @NotNull Disposable disposable2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)window, (String)"window");
            Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
            this.window = window;
            project.getMessageBus().connect(disposable2).subscribe(ToolWindowManagerListener.TOPIC, (Object)this);
            Disposer.register((Disposable)disposable2, (Disposable)new Disposable(){

                public final void dispose() {
                    ContentManager contentManager2 = window.getContentManagerIfCreated();
                    if (contentManager2 == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"window.contentManagerIfCreated ?: return@register");
                    ContentManager contentManager3 = contentManager2;
                    for (Content content2 : contentManager3.getContents()) {
                        Content content3 = content2;
                        if (!(content3 instanceof TabbedContent)) {
                            content3 = null;
                        }
                        TabbedContent tabbedContent = (TabbedContent)content3;
                        if (tabbedContent == null) continue;
                        tabbedContent.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                }
            });
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogToolWindowTabsWatcher$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "addContentManagerListener", "", "window", "Lcom/intellij/openapi/wm/ToolWindow;", "listener", "Lcom/intellij/ui/content/ContentManagerListener;", "disposable", "Lcom/intellij/openapi/Disposable;", "getSelectedToolWindowTabId", "", "toolWindow", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private final String getSelectedToolWindowTabId(ToolWindow toolWindow2) {
            if (toolWindow2 == null || !toolWindow2.isVisible()) {
                return null;
            }
            ContentManager contentManager2 = toolWindow2.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"toolWindow.contentManager");
            Content content2 = contentManager2.getSelectedContent();
            if (content2 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"toolWindow.contentManage\u2026tedContent ?: return null");
            Content content3 = content2;
            return VcsLogContentUtil.getId(content3);
        }

        private final void addContentManagerListener(ToolWindow window, ContentManagerListener listener2, Disposable disposable2) {
            window.addContentManagerListener(listener2);
            Disposer.register((Disposable)disposable2, (Disposable)new Disposable(window, listener2){
                final /* synthetic */ ToolWindow $window;
                final /* synthetic */ ContentManagerListener $listener;

                public final void dispose() {
                    block1: {
                        if (this.$window.isDisposed()) break block1;
                        ContentManager contentManager2 = this.$window.getContentManagerIfCreated();
                        if (contentManager2 != null) {
                            contentManager2.removeContentManagerListener(this.$listener);
                        }
                    }
                }
                {
                    this.$window = toolWindow2;
                    this.$listener = contentManagerListener;
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

