/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.CustomVcsLogUiFactoryProvider;
import com.intellij.vcs.log.impl.HeavyAwareExecutor;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogCachesInvalidator;
import com.intellij.vcs.log.impl.VcsLogContentProvider;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogProjectTabsProperties;
import com.intellij.vcs.log.impl.VcsLogTabsManager;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.util.PersistentUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class VcsProjectLog
implements Disposable {
    private static final Logger LOG = Logger.getInstance(VcsProjectLog.class);
    public static final Topic<ProjectLogListener> VCS_PROJECT_LOG_CHANGED = Topic.create((String)"Project Vcs Log Created or Disposed", ProjectLogListener.class);
    private static final int RECREATE_LOG_TRIES = 5;
    @NotNull
    private final Project myProject;
    @NotNull
    private final MessageBus myMessageBus;
    @NotNull
    private final VcsLogTabsProperties myUiProperties;
    @NotNull
    private final VcsLogTabsManager myTabsManager;
    @NotNull
    private final LazyVcsLogManager myLogManager;
    @NotNull
    private final Disposable myDisposable;
    @NotNull
    private final ExecutorService myExecutor;
    @NotNull
    private final AtomicBoolean myDisposeStarted;
    private int myRecreatedLogCount;

    public VcsProjectLog(@NotNull Project project) {
        if (project == null) {
            VcsProjectLog.$$$reportNull$$$0(0);
        }
        this.myLogManager = new LazyVcsLogManager();
        this.myDisposable = Disposer.newDisposable();
        this.myDisposeStarted = new AtomicBoolean(false);
        this.myRecreatedLogCount = 0;
        this.myProject = project;
        this.myMessageBus = this.myProject.getMessageBus();
        VcsLogProjectTabsProperties uiProperties = (VcsLogProjectTabsProperties)this.myProject.getService(VcsLogProjectTabsProperties.class);
        this.myUiProperties = uiProperties;
        this.myTabsManager = new VcsLogTabsManager(project, this.myMessageBus, uiProperties, this);
        this.myExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Vcs Log Initialization/Dispose", (int)1);
        this.myMessageBus.connect(this.myDisposable).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosing(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (VcsProjectLog.this.myProject == project) {
                    VcsProjectLog.this.shutDown();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsProjectLog$1", "projectClosing"));
            }
        });
        ShutDownTracker.getInstance().registerShutdownTask(this::shutDown, this.myDisposable);
    }

    private void shutDown() {
        if (this.myDisposeStarted.compareAndSet(false, true)) {
            Disposer.dispose((Disposable)this.myDisposable);
            this.disposeLog(false);
            this.myExecutor.shutdown();
            Runnable awaitDisposal = () -> {
                try {
                    this.myExecutor.awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            };
            if (ApplicationManager.getApplication().isDispatchThread()) {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(awaitDisposal, VcsLogBundle.message((String)"vcs.log.closing.process", (Object[])new Object[0]), false, this.myProject);
            } else {
                awaitDisposal.run();
            }
        }
    }

    private void subscribeToMappingsAndPluginsChanges() {
        MessageBusConnection connection = this.myMessageBus.connect(this.myDisposable);
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> this.disposeLog(true));
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new MyDynamicPluginUnloader());
    }

    @Nullable
    public VcsLogData getDataManager() {
        VcsLogManager cached = this.myLogManager.getCached();
        if (cached == null) {
            return null;
        }
        return cached.getDataManager();
    }

    @Nullable
    public VcsLogUiImpl getMainLogUi() {
        VcsLogContentProvider logContentProvider = VcsLogContentProvider.getInstance(this.myProject);
        if (logContentProvider == null) {
            return null;
        }
        return (VcsLogUiImpl)logContentProvider.getUi();
    }

    @Nullable
    public VcsLogManager getLogManager() {
        return this.myLogManager.getCached();
    }

    @NotNull
    public VcsLogTabsManager getTabsManager() {
        VcsLogTabsManager vcsLogTabsManager = this.myTabsManager;
        if (vcsLogTabsManager == null) {
            VcsProjectLog.$$$reportNull$$$0(1);
        }
        return vcsLogTabsManager;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @Nullable
    public MainVcsLogUi openLogTab(@NotNull VcsLogFilterCollection vcsLogFilterCollection) {
        void filters;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (filters == null) {
            VcsProjectLog.$$$reportNull$$$0(2);
        }
        return this.openLogTab((VcsLogFilterCollection)filters, VcsLogManager.LogWindowKind.TOOL_WINDOW);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @Nullable
    public MainVcsLogUi openLogTab(@NotNull VcsLogFilterCollection vcsLogFilterCollection, @NotNull VcsLogManager.LogWindowKind logWindowKind) {
        VcsLogManager logManager;
        void kind;
        void filters;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (filters == null) {
            VcsProjectLog.$$$reportNull$$$0(3);
        }
        if (kind == null) {
            VcsProjectLog.$$$reportNull$$$0(4);
        }
        if ((logManager = this.getLogManager()) == null) {
            return null;
        }
        return this.myTabsManager.openAnotherLogTab(logManager, (VcsLogFilterCollection)filters, (VcsLogManager.LogWindowKind)kind);
    }

    private void disposeLog(boolean recreate) {
        this.myExecutor.execute(() -> {
            VcsLogManager logManager = (VcsLogManager)VcsProjectLog.invokeAndWait(() -> {
                VcsLogManager manager2 = this.myLogManager.dropValue();
                if (manager2 != null) {
                    manager2.disposeUi();
                }
                return manager2;
            });
            if (logManager != null) {
                Disposer.dispose((Disposable)logManager);
            }
            if (recreate) {
                this.createLog(false);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private void recreateOnError(@NotNull Throwable throwable) {
        void t;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (t == null) {
            VcsProjectLog.$$$reportNull$$$0(5);
        }
        if (this.myDisposeStarted.get()) {
            return;
        }
        ++this.myRecreatedLogCount;
        String logMessage = "Recreating Vcs Log after storage corruption. Recreated count " + this.myRecreatedLogCount;
        if (this.myRecreatedLogCount % 5 == 0) {
            LOG.error(logMessage, (Throwable)t);
            VcsLogManager manager2 = this.getLogManager();
            if (manager2 != null && manager2.isLogVisible()) {
                String balloonMessage = VcsLogBundle.message((String)"vcs.log.recreated.due.to.corruption", (Object[])new Object[]{VcsLogUtil.getVcsDisplayName(this.myProject, manager2), this.myRecreatedLogCount, PersistentUtil.LOG_CACHE, ApplicationNamesInfo.getInstance().getFullProductName()});
                VcsBalloonProblemNotifier.showOverChangesView(this.myProject, balloonMessage, MessageType.ERROR, new NamedRunnable[0]);
            }
        } else {
            LOG.debug(logMessage, (Throwable)t);
        }
        this.disposeLog(true);
    }

    @NotNull
    Future<VcsLogManager> createLogInBackground(boolean forceInit) {
        Future<VcsLogManager> future2 = this.myExecutor.submit(() -> this.createLog(forceInit));
        if (future2 == null) {
            VcsProjectLog.$$$reportNull$$$0(6);
        }
        return future2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @RequiresBackgroundThread
    private VcsLogManager createLog(boolean bl) {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (this.myDisposeStarted.get()) {
            return null;
        }
        Map<VirtualFile, VcsLogProvider> logProviders = VcsProjectLog.getLogProviders(this.myProject);
        if (!logProviders.isEmpty()) {
            void forceInit;
            VcsLogManager logManager = this.myLogManager.getValue(logProviders);
            VcsProjectLog.initialize(logManager, (boolean)forceInit);
            return logManager;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    private static void initialize(@NotNull VcsLogManager vcsLogManager, boolean bl) {
        VcsLogCachesInvalidator invalidator;
        void force;
        VcsLogManager logManager;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (logManager == null) {
            VcsProjectLog.$$$reportNull$$$0(7);
        }
        if (force != false) {
            logManager.scheduleInitialization();
            return;
        }
        if (PostponableLogRefresher.keepUpToDate() && (invalidator = (VcsLogCachesInvalidator)((Object)CachesInvalidator.EP_NAME.findExtension(VcsLogCachesInvalidator.class))).isValid()) {
            HeavyAwareExecutor.executeOutOfHeavyProcessLater(logManager::scheduleInitialization, 5000);
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (logManager.isLogVisible()) {
                logManager.scheduleInitialization();
            }
        }, VcsProjectLog.getModality());
    }

    @NotNull
    public static Map<VirtualFile, VcsLogProvider> getLogProviders(@NotNull Project project) {
        if (project == null) {
            VcsProjectLog.$$$reportNull$$$0(8);
        }
        Map<VirtualFile, VcsLogProvider> map2 = VcsLogManager.findLogProviders(Arrays.asList(ProjectLevelVcsManager.getInstance((Project)project).getAllVcsRoots()), project);
        if (map2 == null) {
            VcsProjectLog.$$$reportNull$$$0(9);
        }
        return map2;
    }

    public static VcsProjectLog getInstance(@NotNull Project project) {
        if (project == null) {
            VcsProjectLog.$$$reportNull$$$0(10);
        }
        return (VcsProjectLog)project.getService(VcsProjectLog.class);
    }

    public void dispose() {
    }

    private static <T> T invokeAndWait(@NotNull Computable<T> computable) {
        if (computable == null) {
            VcsProjectLog.$$$reportNull$$$0(11);
        }
        Ref result2 = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> result2.set(computable.compute()), VcsProjectLog.getModality());
        return (T)result2.get();
    }

    @NotNull
    private static ModalityState getModality() {
        ModalityState modalityState = ModalityState.any();
        if (modalityState == null) {
            VcsProjectLog.$$$reportNull$$$0(12);
        }
        return modalityState;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public static void runWhenLogIsReady(@NotNull Project project, @NotNull Consumer<? super VcsLogManager> consumer2) {
        VcsProjectLog log;
        VcsLogManager manager2;
        void action2;
        Project project2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (project2 == null) {
            VcsProjectLog.$$$reportNull$$$0(13);
        }
        if (action2 == null) {
            VcsProjectLog.$$$reportNull$$$0(14);
        }
        if ((manager2 = (log = VcsProjectLog.getInstance(project2)).getLogManager()) != null) {
            action2.consume((Object)manager2);
        } else {
            final Future<VcsLogManager> futureLogManager = log.createLogInBackground(true);
            new Task.Backgroundable(project2, VcsLogBundle.message((String)"vcs.log.creating.process", (Object[])new Object[0]), (Consumer)action2){
                final /* synthetic */ Consumer val$action;
                {
                    this.val$action = consumer2;
                    super(arg0, arg1);
                }

                public void run(@NotNull ProgressIndicator indicator2) {
                    if (indicator2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    try {
                        futureLogManager.get(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException e) {
                        LOG.error((Throwable)e);
                    }
                    catch (TimeoutException e) {
                        LOG.warn((Throwable)e);
                    }
                }

                public void onSuccess() {
                    VcsLogManager manager2 = log.getLogManager();
                    if (manager2 != null) {
                        this.val$action.consume((Object)manager2);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/impl/VcsProjectLog$2", "run"));
                }
            }.queue();
        }
    }

    @ApiStatus.Internal
    @RequiresBackgroundThread
    public static boolean ensureLogCreated(@NotNull Project project) {
        Project project2;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (project2 == null) {
            VcsProjectLog.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (VcsProjectLog.getInstance(project2).getLogManager() != null) {
            return true;
        }
        try {
            return VcsProjectLog.getInstance(project2).createLogInBackground(true).get() != null;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsProjectLog";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logManager";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsProjectLog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabsManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createLogInBackground";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogProviders";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModality";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 12: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "openLogTab";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "recreateOnError";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLogProviders";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWait";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runWhenLogIsReady";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "ensureLogCreated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ProjectLogListener {
        @RequiresEdt
        public void logCreated(@NotNull VcsLogManager var1);

        @RequiresEdt
        public void logDisposed(@NotNull VcsLogManager var1);
    }

    private class MyDynamicPluginUnloader
    implements DynamicPluginListener {
        private final Set<PluginId> affectedPlugins = new HashSet<PluginId>();

        private MyDynamicPluginUnloader() {
        }

        @Override
        public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
            if (pluginDescriptor == null) {
                MyDynamicPluginUnloader.$$$reportNull$$$0(0);
            }
            if (this.hasLogExtensions(pluginDescriptor)) {
                VcsProjectLog.this.disposeLog(true);
            }
        }

        @Override
        public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
            if (pluginDescriptor == null) {
                MyDynamicPluginUnloader.$$$reportNull$$$0(1);
            }
            if (this.hasLogExtensions(pluginDescriptor)) {
                this.affectedPlugins.add(pluginDescriptor.getPluginId());
                LOG.debug("Disposing Vcs Log before unloading " + pluginDescriptor.getPluginId());
                VcsProjectLog.this.disposeLog(false);
            }
        }

        @Override
        public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
            if (pluginDescriptor == null) {
                MyDynamicPluginUnloader.$$$reportNull$$$0(2);
            }
            if (this.affectedPlugins.remove(pluginDescriptor.getPluginId())) {
                LOG.debug("Recreating Vcs Log after unloading " + pluginDescriptor.getPluginId());
                VcsProjectLog.this.disposeLog(true);
            }
        }

        private boolean hasLogExtensions(@NotNull IdeaPluginDescriptor descriptor2) {
            if (descriptor2 == null) {
                MyDynamicPluginUnloader.$$$reportNull$$$0(3);
            }
            for (VcsLogProvider logProvider : (VcsLogProvider[])VcsLogProvider.LOG_PROVIDER_EP.getExtensions((AreaInstance)VcsProjectLog.this.myProject)) {
                if (logProvider.getClass().getClassLoader() != descriptor2.getPluginClassLoader()) continue;
                return true;
            }
            for (CustomVcsLogUiFactoryProvider factory2 : CustomVcsLogUiFactoryProvider.LOG_CUSTOM_UI_FACTORY_PROVIDER_EP.getExtensions((AreaInstance)VcsProjectLog.this.myProject)) {
                if (factory2.getClass().getClassLoader() != descriptor2.getPluginClassLoader()) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/impl/VcsProjectLog$MyDynamicPluginUnloader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "pluginLoaded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforePluginUnload";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "pluginUnloaded";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasLogExtensions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class InitLogStartupActivity
    implements StartupActivity,
    DumbAware {
        InitLogStartupActivity() {
            Application app2 = ApplicationManager.getApplication();
            if (app2.isUnitTestMode() || app2.isHeadlessEnvironment()) {
                throw ExtensionNotApplicableException.INSTANCE;
            }
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                InitLogStartupActivity.$$$reportNull$$$0(0);
            }
            VcsProjectLog projectLog = VcsProjectLog.getInstance(project);
            projectLog.subscribeToMappingsAndPluginsChanges();
            projectLog.createLogInBackground(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsProjectLog$InitLogStartupActivity", "runActivity"));
        }
    }

    private class LazyVcsLogManager {
        @Nullable
        private volatile VcsLogManager myValue;

        private LazyVcsLogManager() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        @RequiresBackgroundThread
        public VcsLogManager getValue(@NotNull Map<VirtualFile, VcsLogProvider> map2) {
            void logProviders;
            ApplicationManager.getApplication().assertIsNonDispatchThread();
            if (logProviders == null) {
                LazyVcsLogManager.$$$reportNull$$$0(0);
            }
            if (this.myValue == null) {
                VcsLogManager value2;
                LOG.debug("Creating Vcs Log for " + VcsLogUtil.getProvidersMapText((Map<VirtualFile, VcsLogProvider>)logProviders));
                this.myValue = value2 = new VcsLogManager(VcsProjectLog.this.myProject, VcsProjectLog.this.myUiProperties, (Map<VirtualFile, VcsLogProvider>)logProviders, false, (Consumer<? super Throwable>)((Consumer)x$0 -> VcsProjectLog.this.recreateOnError((Throwable)x$0)));
                ApplicationManager.getApplication().invokeAndWait(() -> ((ProjectLogListener)VcsProjectLog.this.myMessageBus.syncPublisher(VCS_PROJECT_LOG_CHANGED)).logCreated(value2), VcsProjectLog.getModality());
            }
            VcsLogManager vcsLogManager = this.myValue;
            if (vcsLogManager == null) {
                LazyVcsLogManager.$$$reportNull$$$0(1);
            }
            return vcsLogManager;
        }

        @Nullable
        @RequiresEdt
        public VcsLogManager dropValue() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
            if (this.myValue != null) {
                VcsLogManager oldValue = this.myValue;
                this.myValue = null;
                LOG.debug("Disposing Vcs Log for " + VcsLogUtil.getProvidersMapText(oldValue.getDataManager().getLogProviders()));
                ((ProjectLogListener)VcsProjectLog.this.myMessageBus.syncPublisher(VCS_PROJECT_LOG_CHANGED)).logDisposed(oldValue);
                return oldValue;
            }
            return null;
        }

        @Nullable
        public VcsLogManager getCached() {
            return this.myValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logProviders";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/impl/VcsProjectLog$LazyVcsLogManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/impl/VcsProjectLog$LazyVcsLogManager";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

