/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.table.VcsLogCellController;
import com.intellij.vcs.log.ui.table.VcsLogCellRenderer;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RootCellRenderer
extends SimpleColoredRenderer
implements TableCellRenderer,
VcsLogCellRenderer {
    @NotNull
    private final VcsLogUiProperties myProperties;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private Color myColor;
    @NotNull
    private Color myBorderColor;
    private boolean isNarrow;
    @NotNull
    @Nls
    private String myTooltip;

    public RootCellRenderer(@NotNull VcsLogUiProperties properties2, @NotNull VcsLogColorManager colorManager) {
        if (properties2 == null) {
            RootCellRenderer.$$$reportNull$$$0(0);
        }
        if (colorManager == null) {
            RootCellRenderer.$$$reportNull$$$0(1);
        }
        this.myColor = UIUtil.getTableBackground();
        this.myBorderColor = UIUtil.getTableBackground();
        this.isNarrow = true;
        this.myTooltip = "";
        this.myProperties = properties2;
        this.myColorManager = colorManager;
        this.setTextAlign(0);
    }

    protected void paintBackground(Graphics2D g, int x, int width, int height) {
        g.setColor(this.myColor);
        if (this.isNarrow) {
            g.fillRect(x, 0, width - JBUIScale.scale((int)5), height);
            g.setColor(this.myBorderColor);
            g.fillRect(x + width - JBUIScale.scale((int)5), 0, JBUIScale.scale((int)5), height);
        } else {
            g.fillRect(x, 0, width, height);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row2, int column2) {
        this.clear();
        FilePath path2 = (FilePath)value2;
        this.myColor = path2 == null ? UIUtil.getTableBackground((boolean)isSelected, (boolean)hasFocus) : VcsLogGraphTable.getPathBackgroundColor(path2, this.myColorManager);
        this.myBorderColor = Objects.requireNonNull(((VcsLogGraphTable)((Object)table)).getStyle(row2, column2, hasFocus, isSelected, row2 == TableHoverListener.getHoveredRow((JTable)table)).getBackground());
        this.setForeground(UIUtil.getTableForeground((boolean)false, (boolean)hasFocus));
        if (this.myProperties.exists(CommonUiProperties.SHOW_ROOT_NAMES) && this.myProperties.get(CommonUiProperties.SHOW_ROOT_NAMES).booleanValue()) {
            if (RootCellRenderer.isTextShown(table, value2, row2, column2)) {
                if (path2 == null) {
                    this.append("");
                } else {
                    String text2 = path2.getName();
                    int availableWidth = ((VcsLogGraphTable)((Object)table)).getRootColumn().getWidth() - VcsLogUiUtil.getHorizontalTextPadding((SimpleColoredComponent)this);
                    text2 = VcsLogUiUtil.shortenTextToFit(text2, this.getFontMetrics(VcsLogGraphTable.getTableFont()), availableWidth, 0, "\u2026");
                    this.append(text2);
                }
            }
            this.isNarrow = false;
        } else {
            this.append("");
            this.isNarrow = true;
        }
        this.myTooltip = this.getTooltipText(path2, this.isNarrow);
        return this;
    }

    @Override
    @NotNull
    public VcsLogCellController getCellController() {
        return new VcsLogCellController(){

            @Override
            @Nullable
            public Cursor performMouseClick(int row2, @NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (RootCellRenderer.this.myColorManager.hasMultiplePaths() && RootCellRenderer.this.myProperties.exists(CommonUiProperties.SHOW_ROOT_NAMES)) {
                    VcsLogUsageTriggerCollector.triggerClick("root.column");
                    RootCellRenderer.this.myProperties.set(CommonUiProperties.SHOW_ROOT_NAMES, RootCellRenderer.this.myProperties.get(CommonUiProperties.SHOW_ROOT_NAMES) == false);
                }
                return null;
            }

            @Override
            @NotNull
            public Cursor performMouseMove(int row2, @NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                Cursor cursor = Cursor.getPredefinedCursor(12);
                if (cursor == null) {
                    1.$$$reportNull$$$0(2);
                }
                return cursor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/vcs/log/ui/table/RootCellRenderer$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/vcs/log/ui/table/RootCellRenderer$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "performMouseMove";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "performMouseClick";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "performMouseMove";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static boolean isTextShown(JTable table, Object value2, int row2, int column2) {
        int readableRow = ScrollingUtil.getReadableRow((JTable)table, (int)Math.round((float)table.getRowHeight() * 0.5f));
        if (row2 < readableRow) {
            return false;
        }
        return row2 == 0 || readableRow == row2 || !Objects.equals(value2, table.getModel().getValueAt(row2 - 1, column2));
    }

    public void setBackground(Color bg) {
        this.myBorderColor = bg;
    }

    public String getToolTipText(MouseEvent event) {
        return this.myTooltip;
    }

    @NotNull
    @Nls
    private String getTooltipText(@Nullable FilePath path2, boolean isNarrow) {
        String clickMessage;
        String string = clickMessage = !isNarrow ? VcsLogBundle.message((String)"vcs.log.click.to.collapse.paths.column.tooltip", (Object[])new Object[0]) : VcsLogBundle.message((String)"vcs.log.click.to.expand.paths.column.tooltip", (Object[])new Object[0]);
        if (path2 == null) {
            String string2 = clickMessage;
            if (string2 == null) {
                RootCellRenderer.$$$reportNull$$$0(2);
            }
            return string2;
        }
        String string3 = new HtmlBuilder().append((HtmlChunk)HtmlChunk.text((String)this.myColorManager.getLongName(path2)).bold()).br().append(clickMessage).wrapWith(HtmlChunk.html()).toString();
        if (string3 == null) {
            RootCellRenderer.$$$reportNull$$$0(3);
        }
        return string3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/table/RootCellRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/table/RootCellRenderer";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

