/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.CommittedChangeListForRevision;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogListener;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsChangesLazilyParsedDetails;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsLogUtil {
    public static final int MAX_SELECTED_COMMITS = 1000;
    public static final int FULL_HASH_LENGTH = 40;
    public static final int SHORT_HASH_LENGTH = 8;
    public static final Pattern HASH_REGEX = Pattern.compile("[a-fA-F0-9]{7,40}");
    @NlsSafe
    public static final String HEAD = "HEAD";

    @NotNull
    public static Map<VirtualFile, Set<VcsRef>> groupRefsByRoot(@NotNull Collection<? extends VcsRef> refs) {
        if (refs == null) {
            VcsLogUtil.$$$reportNull$$$0(0);
        }
        return VcsLogUtil.groupByRoot(refs, VcsRef::getRoot);
    }

    @NotNull
    private static <T> Map<VirtualFile, Set<T>> groupByRoot(@NotNull Collection<? extends T> items, @NotNull Function<? super T, ? extends VirtualFile> rootGetter) {
        if (items == null) {
            VcsLogUtil.$$$reportNull$$$0(1);
        }
        if (rootGetter == null) {
            VcsLogUtil.$$$reportNull$$$0(2);
        }
        TreeMap<VirtualFile, Set<T>> map2 = new TreeMap<VirtualFile, Set<T>>(Comparator.comparing(VirtualFile::getPresentableUrl));
        for (T item : items) {
            VirtualFile root2 = (VirtualFile)rootGetter.fun(item);
            map2.computeIfAbsent(root2, k -> new HashSet()).add(item);
        }
        TreeMap<VirtualFile, Set<T>> treeMap = map2;
        if (treeMap == null) {
            VcsLogUtil.$$$reportNull$$$0(3);
        }
        return treeMap;
    }

    public static int compareRoots(@NotNull VirtualFile root1, @NotNull VirtualFile root2) {
        if (root1 == null) {
            VcsLogUtil.$$$reportNull$$$0(4);
        }
        if (root2 == null) {
            VcsLogUtil.$$$reportNull$$$0(5);
        }
        return root1.getPresentableUrl().compareTo(root2.getPresentableUrl());
    }

    @NotNull
    private static Set<VirtualFile> collectRoots(@NotNull Collection<? extends FilePath> files2, @NotNull Set<? extends VirtualFile> roots2) {
        if (files2 == null) {
            VcsLogUtil.$$$reportNull$$$0(6);
        }
        if (roots2 == null) {
            VcsLogUtil.$$$reportNull$$$0(7);
        }
        HashSet<VirtualFile> selectedRoots = new HashSet<VirtualFile>();
        List sortedRoots = ContainerUtil.sorted(roots2, Comparator.comparing(VirtualFile::getPath));
        for (FilePath filePath : files2) {
            VirtualFile virtualFile2 = filePath.getVirtualFile();
            if (virtualFile2 != null && roots2.contains(virtualFile2)) {
                selectedRoots.add(virtualFile2);
            } else {
                VirtualFile candidateAncestorRoot = null;
                for (VirtualFile root2 : sortedRoots) {
                    if (!FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)root2), (File)filePath.getIOFile(), (boolean)false)) continue;
                    candidateAncestorRoot = root2;
                }
                if (candidateAncestorRoot != null) {
                    selectedRoots.add(candidateAncestorRoot);
                }
            }
            if (virtualFile2 == null) continue;
            for (VirtualFile virtualFile3 : roots2) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile2, (VirtualFile)virtualFile3, (boolean)false)) continue;
                selectedRoots.add(virtualFile3);
            }
        }
        HashSet<VirtualFile> hashSet = selectedRoots;
        if (hashSet == null) {
            VcsLogUtil.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @NotNull
    public static Set<VirtualFile> getVisibleRoots(@NotNull VcsLogUi logUi) {
        if (logUi == null) {
            VcsLogUtil.$$$reportNull$$$0(9);
        }
        VcsLogFilterCollection filters = logUi.getFilterUi().getFilters();
        Set<VirtualFile> roots2 = logUi.getDataPack().getLogProviders().keySet();
        return VcsLogUtil.getAllVisibleRoots(roots2, filters);
    }

    @NotNull
    public static Set<VirtualFile> getAllVisibleRoots(@NotNull Collection<VirtualFile> roots2, @NotNull VcsLogFilterCollection filters) {
        if (roots2 == null) {
            VcsLogUtil.$$$reportNull$$$0(10);
        }
        if (filters == null) {
            VcsLogUtil.$$$reportNull$$$0(11);
        }
        return VcsLogUtil.getAllVisibleRoots(roots2, (VcsLogRootFilter)filters.get(VcsLogFilterCollection.ROOT_FILTER), (VcsLogStructureFilter)filters.get(VcsLogFilterCollection.STRUCTURE_FILTER));
    }

    @NotNull
    public static Set<VirtualFile> getAllVisibleRoots(@NotNull Collection<VirtualFile> roots2, @Nullable VcsLogRootFilter rootFilter, @Nullable VcsLogStructureFilter structureFilter) {
        if (roots2 == null) {
            VcsLogUtil.$$$reportNull$$$0(12);
        }
        if (rootFilter == null && structureFilter == null) {
            return new HashSet<VirtualFile>(roots2);
        }
        Set<VirtualFile> fromRootFilter = rootFilter != null ? rootFilter.getRoots() : roots2;
        Set<VirtualFile> fromStructureFilter = structureFilter != null ? VcsLogUtil.collectRoots(structureFilter.getFiles(), new HashSet(roots2)) : roots2;
        return new HashSet<VirtualFile>(ContainerUtil.intersection((Collection)fromRootFilter, (Collection)fromStructureFilter));
    }

    @NotNull
    public static Set<FilePath> getFilteredFilesForRoot(@NotNull VirtualFile root2, @NotNull VcsLogFilterCollection filterCollection) {
        VcsLogStructureFilter structureFilter;
        if (root2 == null) {
            VcsLogUtil.$$$reportNull$$$0(13);
        }
        if (filterCollection == null) {
            VcsLogUtil.$$$reportNull$$$0(14);
        }
        if ((structureFilter = (VcsLogStructureFilter)filterCollection.get(VcsLogFilterCollection.STRUCTURE_FILTER)) == null) {
            Set<FilePath> set2 = Collections.emptySet();
            if (set2 == null) {
                VcsLogUtil.$$$reportNull$$$0(15);
            }
            return set2;
        }
        Collection files2 = structureFilter.getFiles();
        return new HashSet<FilePath>(ContainerUtil.filter((Collection)files2, filePath -> {
            VirtualFile virtualFile2 = filePath.getVirtualFile();
            return root2.equals(virtualFile2) || FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)root2), (File)filePath.getIOFile(), (boolean)false);
        }));
    }

    @Nullable
    @NlsSafe
    public static String getSingleFilteredBranch(@NotNull VcsLogFilterCollection filters, @NotNull VcsLogRefs refs) {
        VcsLogBranchFilter filter;
        if (filters == null) {
            VcsLogUtil.$$$reportNull$$$0(16);
        }
        if (refs == null) {
            VcsLogUtil.$$$reportNull$$$0(17);
        }
        if ((filter = (VcsLogBranchFilter)filters.get(VcsLogFilterCollection.BRANCH_FILTER)) == null) {
            return null;
        }
        String branchName = null;
        HashSet<VirtualFile> checkedRoots = new HashSet<VirtualFile>();
        for (VcsRef branch : refs.getBranches()) {
            if (!filter.matches(branch.getName())) continue;
            if (branchName == null) {
                branchName = branch.getName();
            } else if (!branch.getName().equals(branchName)) {
                return null;
            }
            if (checkedRoots.contains(branch.getRoot())) {
                return null;
            }
            checkedRoots.add(branch.getRoot());
        }
        return branchName;
    }

    public static boolean isRegexp(@NotNull String text2) {
        if (text2 == null) {
            VcsLogUtil.$$$reportNull$$$0(18);
        }
        return StringUtil.containsAnyChar((String)text2, (String)"()[]{}.*?+^$\\|");
    }

    @NotNull
    public static TextRevisionNumber convertToRevisionNumber(@NotNull Hash hash) {
        if (hash == null) {
            VcsLogUtil.$$$reportNull$$$0(19);
        }
        return new TextRevisionNumber(hash.asString(), hash.toShortString());
    }

    @NotNull
    public static VcsFullCommitDetails getDetails(@NotNull VcsLogData data2, @NotNull VirtualFile root2, @NotNull Hash hash) throws VcsException {
        if (data2 == null) {
            VcsLogUtil.$$$reportNull$$$0(20);
        }
        if (root2 == null) {
            VcsLogUtil.$$$reportNull$$$0(21);
        }
        if (hash == null) {
            VcsLogUtil.$$$reportNull$$$0(22);
        }
        VcsFullCommitDetails vcsFullCommitDetails = Objects.requireNonNull((VcsFullCommitDetails)ContainerUtil.getFirstItem(VcsLogUtil.getDetails(data2.getLogProvider(root2), root2, Collections.singletonList(hash.asString()))));
        if (vcsFullCommitDetails == null) {
            VcsLogUtil.$$$reportNull$$$0(23);
        }
        return vcsFullCommitDetails;
    }

    @NotNull
    public static List<? extends VcsFullCommitDetails> getDetails(@NotNull VcsLogProvider logProvider, @NotNull VirtualFile root2, @NotNull List<String> hashes) throws VcsException {
        if (logProvider == null) {
            VcsLogUtil.$$$reportNull$$$0(24);
        }
        if (root2 == null) {
            VcsLogUtil.$$$reportNull$$$0(25);
        }
        if (hashes == null) {
            VcsLogUtil.$$$reportNull$$$0(26);
        }
        ArrayList result2 = new ArrayList();
        logProvider.readFullDetails(root2, hashes, result2::add);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            VcsLogUtil.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @NotNull
    public static CommittedChangeListForRevision createCommittedChangeList(@NotNull VcsFullCommitDetails detail, boolean withChanges) {
        if (detail == null) {
            VcsLogUtil.$$$reportNull$$$0(28);
        }
        return new CommittedChangeListForRevision(detail.getSubject(), detail.getFullMessage(), VcsUserUtil.getShortPresentation(detail.getCommitter()), new Date(detail.getCommitTime()), withChanges ? detail.getChanges() : ContainerUtil.emptyList(), (VcsRevisionNumber)VcsLogUtil.convertToRevisionNumber((Hash)detail.getId()));
    }

    @NotNull
    public static CommittedChangeListForRevision createCommittedChangeList(@NotNull VcsFullCommitDetails detail) {
        if (detail == null) {
            VcsLogUtil.$$$reportNull$$$0(29);
        }
        return VcsLogUtil.createCommittedChangeList(detail, true);
    }

    @NotNull
    @NlsSafe
    public static String getShortHash(@NotNull String hashString) {
        if (hashString == null) {
            VcsLogUtil.$$$reportNull$$$0(30);
        }
        return VcsLogUtil.getShortHash(hashString, 8);
    }

    @NotNull
    @NlsSafe
    public static String getShortHash(@NotNull String hashString, int shortHashLength) {
        if (hashString == null) {
            VcsLogUtil.$$$reportNull$$$0(31);
        }
        String string = hashString.substring(0, Math.min(shortHashLength, hashString.length()));
        if (string == null) {
            VcsLogUtil.$$$reportNull$$$0(32);
        }
        return string;
    }

    public static boolean isFullHash(@NotNull String s) {
        if (s == null) {
            VcsLogUtil.$$$reportNull$$$0(33);
        }
        return s.length() == 40 && HASH_REGEX.matcher(s).matches();
    }

    @Nullable
    public static VcsRef findBranch(@NotNull RefsModel refs, @NotNull VirtualFile root2, @NotNull String branchName) {
        CompressedRefs compressedRefs;
        if (refs == null) {
            VcsLogUtil.$$$reportNull$$$0(34);
        }
        if (root2 == null) {
            VcsLogUtil.$$$reportNull$$$0(35);
        }
        if (branchName == null) {
            VcsLogUtil.$$$reportNull$$$0(36);
        }
        if ((compressedRefs = refs.getAllRefsByRoot().get(root2)) == null) {
            return null;
        }
        Stream<VcsRef> branches = compressedRefs.streamBranches();
        return branches.filter(vcsRef -> vcsRef.getName().equals(branchName)).findFirst().orElse(null);
    }

    @NotNull
    public static List<Change> collectChanges(@NotNull List<? extends VcsFullCommitDetails> detailsList, @NotNull Function<? super VcsFullCommitDetails, ? extends Collection<Change>> getChanges2) {
        if (detailsList == null) {
            VcsLogUtil.$$$reportNull$$$0(37);
        }
        if (getChanges2 == null) {
            VcsLogUtil.$$$reportNull$$$0(38);
        }
        ArrayList changes = new ArrayList();
        List detailsListReversed = ContainerUtil.reverse(detailsList);
        for (VcsFullCommitDetails details2 : detailsListReversed) {
            changes.addAll((Collection)getChanges2.fun((Object)details2));
        }
        List<Change> list2 = CommittedChangesTreeBrowser.zipChanges(changes);
        if (list2 == null) {
            VcsLogUtil.$$$reportNull$$$0(39);
        }
        return list2;
    }

    @Nullable
    public static VirtualFile getActualRoot(@NotNull Project project, @NotNull FilePath path2) {
        VcsRoot rootObject;
        if (project == null) {
            VcsLogUtil.$$$reportNull$$$0(40);
        }
        if (path2 == null) {
            VcsLogUtil.$$$reportNull$$$0(41);
        }
        if ((rootObject = ProjectLevelVcsManager.getInstance((Project)project).getVcsRootObjectFor(path2)) == null) {
            return null;
        }
        Map<VirtualFile, VcsLogProvider> providers = VcsLogManager.findLogProviders(Collections.singletonList(rootObject), project);
        if (providers.isEmpty()) {
            return null;
        }
        VcsLogProvider provider2 = Objects.requireNonNull((VcsLogProvider)ContainerUtil.getFirstItem(providers.values()));
        return provider2.getVcsRoot(project, rootObject.getPath(), path2);
    }

    @Nullable
    public static Collection<FilePath> getAffectedPaths(@NotNull VcsLogUi logUi) {
        if (logUi == null) {
            VcsLogUtil.$$$reportNull$$$0(42);
        }
        return VcsLogUtil.getAffectedPaths(logUi.getDataPack());
    }

    @Nullable
    public static Collection<FilePath> getAffectedPaths(@NotNull VcsLogDataPack dataPack) {
        VcsLogStructureFilter structureFilter;
        if (dataPack == null) {
            VcsLogUtil.$$$reportNull$$$0(43);
        }
        if ((structureFilter = (VcsLogStructureFilter)dataPack.getFilters().get(VcsLogFilterCollection.STRUCTURE_FILTER)) != null) {
            return structureFilter.getFiles();
        }
        return null;
    }

    @Nullable
    public static Collection<FilePath> getAffectedPaths(@NotNull VirtualFile root2, @NotNull AnActionEvent e) {
        VcsLogUiProperties properties2;
        if (root2 == null) {
            VcsLogUtil.$$$reportNull$$$0(44);
        }
        if (e == null) {
            VcsLogUtil.$$$reportNull$$$0(45);
        }
        if ((properties2 = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES)) != null && properties2.exists(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES) && properties2.get(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES).booleanValue()) {
            Collection<FilePath> affectedFilePaths;
            VcsLogUi logUi = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
            Project project = e.getProject();
            if (logUi != null && project != null && (affectedFilePaths = VcsLogUtil.getAffectedPaths(logUi)) != null) {
                return ContainerUtil.filter(affectedFilePaths, path2 -> Objects.equals(VcsUtil.getVcsRootFor((Project)project, (FilePath)path2), root2));
            }
        }
        return null;
    }

    public static int getMaxSize(@NotNull List<? extends VcsFullCommitDetails> detailsList) {
        if (detailsList == null) {
            VcsLogUtil.$$$reportNull$$$0(46);
        }
        int maxSize2 = 0;
        for (VcsFullCommitDetails vcsFullCommitDetails : detailsList) {
            maxSize2 = Math.max(VcsLogUtil.getSize(vcsFullCommitDetails), maxSize2);
        }
        return maxSize2;
    }

    public static int getSize(@NotNull VcsFullCommitDetails details2) {
        if (details2 == null) {
            VcsLogUtil.$$$reportNull$$$0(47);
        }
        if (details2 instanceof VcsChangesLazilyParsedDetails) {
            return ((VcsChangesLazilyParsedDetails)details2).size();
        }
        int size = 0;
        for (int i2 = 0; i2 < details2.getParents().size(); ++i2) {
            size += details2.getChanges(i2).size();
        }
        return size;
    }

    public static int getShownChangesLimit() {
        return Registry.intValue((String)"vcs.log.max.changes.shown");
    }

    @NotNull
    @NonNls
    public static String getSizeText(int maxSize2) {
        if (maxSize2 < 1000) {
            String string = String.valueOf(maxSize2);
            if (string == null) {
                VcsLogUtil.$$$reportNull$$$0(48);
            }
            return string;
        }
        DecimalFormat format2 = new DecimalFormat("#.#");
        format2.setRoundingMode(RoundingMode.FLOOR);
        if (maxSize2 < 10000) {
            String string = format2.format((double)maxSize2 / 1000.0) + "K";
            if (string == null) {
                VcsLogUtil.$$$reportNull$$$0(49);
            }
            return string;
        }
        if (maxSize2 < 1000000) {
            String string = maxSize2 / 1000 + "K";
            if (string == null) {
                VcsLogUtil.$$$reportNull$$$0(50);
            }
            return string;
        }
        if (maxSize2 < 10000000) {
            String string = format2.format((double)maxSize2 / 1000000.0) + "M";
            if (string == null) {
                VcsLogUtil.$$$reportNull$$$0(51);
            }
            return string;
        }
        String string = maxSize2 / 1000000 + "M";
        if (string == null) {
            VcsLogUtil.$$$reportNull$$$0(52);
        }
        return string;
    }

    @NotNull
    @NonNls
    public static String getProvidersMapText(@NotNull Map<VirtualFile, VcsLogProvider> providers) {
        if (providers == null) {
            VcsLogUtil.$$$reportNull$$$0(53);
        }
        String string = "[" + StringUtil.join(providers.keySet(), file2 -> file2.getPresentableUrl(), (String)", ") + "]";
        if (string == null) {
            VcsLogUtil.$$$reportNull$$$0(54);
        }
        return string;
    }

    @NotNull
    @Nls
    public static String getVcsDisplayName(@NotNull Project project, @NotNull Collection<VcsLogProvider> logProviders) {
        Set vcs;
        if (project == null) {
            VcsLogUtil.$$$reportNull$$$0(55);
        }
        if (logProviders == null) {
            VcsLogUtil.$$$reportNull$$$0(56);
        }
        if ((vcs = ContainerUtil.map2SetNotNull(logProviders, provider2 -> VcsUtil.findVcsByKey((Project)project, (VcsKey)provider2.getSupportedVcs()))).size() != 1) {
            String string = VcsLogBundle.message((String)"vcs", (Object[])new Object[0]);
            if (string == null) {
                VcsLogUtil.$$$reportNull$$$0(57);
            }
            return string;
        }
        String string = Objects.requireNonNull((AbstractVcs)ContainerUtil.getFirstItem((Collection)vcs)).getDisplayName();
        if (string == null) {
            VcsLogUtil.$$$reportNull$$$0(58);
        }
        return string;
    }

    @NotNull
    @Nls
    public static String getVcsDisplayName(@NotNull Project project, @NotNull VcsLogManager logManager) {
        if (project == null) {
            VcsLogUtil.$$$reportNull$$$0(59);
        }
        if (logManager == null) {
            VcsLogUtil.$$$reportNull$$$0(60);
        }
        return VcsLogUtil.getVcsDisplayName(project, logManager.getDataManager().getLogProviders().values());
    }

    public static void invokeOnChange(final @NotNull VcsLogUi ui2, final @NotNull Runnable runnable2, final @NotNull Condition<? super VcsLogDataPack> condition) {
        if (ui2 == null) {
            VcsLogUtil.$$$reportNull$$$0(61);
        }
        if (runnable2 == null) {
            VcsLogUtil.$$$reportNull$$$0(62);
        }
        if (condition == null) {
            VcsLogUtil.$$$reportNull$$$0(63);
        }
        ui2.addLogListener(new VcsLogListener(){

            public void onChange(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
                if (dataPack == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (condition.value((Object)dataPack)) {
                    runnable2.run();
                    ui2.removeLogListener((VcsLogListener)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/util/VcsLogUtil$1", "onChange"));
            }
        });
    }

    public static void jumpToRow(@NotNull VcsLogUiEx vcsLogUi, int row2, boolean silently) {
        if (vcsLogUi == null) {
            VcsLogUtil.$$$reportNull$$$0(64);
        }
        vcsLogUi.jumpTo(row2, (visiblePack, r) -> {
            if (visiblePack.getVisibleGraph().getVisibleCommitCount() <= r) {
                return -1;
            }
            return r;
        }, (SettableFuture<? super Boolean>)SettableFuture.create(), silently, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 15: 
            case 23: 
            case 27: 
            case 32: 
            case 39: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 57: 
            case 58: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 15: 
            case 23: 
            case 27: 
            case 32: 
            case 39: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 57: 
            case 58: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootGetter";
                break;
            }
            case 3: 
            case 8: 
            case 15: 
            case 23: 
            case 27: 
            case 32: 
            case 39: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/util/VcsLogUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 9: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logUi";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 13: 
            case 21: 
            case 25: 
            case 35: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterCollection";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProvider";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detail";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashString";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 37: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsList";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getChanges";
                break;
            }
            case 40: 
            case 55: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProviders";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logManager";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsLogUi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/util/VcsLogUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByRoot";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRoots";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredFilesForRoot";
                break;
            }
            case 23: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetails";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortHash";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "collectChanges";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getSizeText";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvidersMapText";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "groupRefsByRoot";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "groupByRoot";
                break;
            }
            case 3: 
            case 8: 
            case 15: 
            case 23: 
            case 27: 
            case 32: 
            case 39: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 57: 
            case 58: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "compareRoots";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectRoots";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleRoots";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAllVisibleRoots";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredFilesForRoot";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSingleFilteredBranch";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isRegexp";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "convertToRevisionNumber";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDetails";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createCommittedChangeList";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getShortHash";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isFullHash";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findBranch";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "collectChanges";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getActualRoot";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedPaths";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getMaxSize";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getSize";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getProvidersMapText";
                break;
            }
            case 55: 
            case 56: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getVcsDisplayName";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "invokeOnChange";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "jumpToRow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 15: 
            case 23: 
            case 27: 
            case 32: 
            case 39: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 57: 
            case 58: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

