/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsLogStorageImpl;
import com.intellij.vcs.log.graph.GraphColorManagerImpl;
import com.intellij.vcs.log.graph.collapsing.CollapsedController;
import com.intellij.vcs.log.graph.impl.facade.BaseController;
import com.intellij.vcs.log.graph.impl.facade.SimpleGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.EmptyVisibleGraph;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SnapshotVisiblePackBuilder {
    private static final int VISIBLE_RANGE = 1000;
    @NotNull
    private final VcsLogStorage myStorage;

    public SnapshotVisiblePackBuilder(@NotNull VcsLogStorage storage2) {
        if (storage2 == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(0);
        }
        this.myStorage = storage2;
    }

    @NotNull
    public VisiblePack build(@NotNull VisiblePack visiblePack) {
        if (visiblePack == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(1);
        }
        if (visiblePack.getVisibleGraph() instanceof VisibleGraphImpl && visiblePack.getVisibleGraph().getVisibleCommitCount() > 0) {
            return this.build(visiblePack.getDataPack(), (VisibleGraphImpl)visiblePack.getVisibleGraph(), visiblePack.getFilters(), visiblePack.getAdditionalData());
        }
        DataPackBase newPack = new DataPackBase(visiblePack.getDataPack().getLogProviders(), RefsModel.createEmptyInstance(this.myStorage), false);
        return new VisiblePack(newPack, EmptyVisibleGraph.getInstance(), true, visiblePack.getFilters());
    }

    @NotNull
    private VisiblePack build(@NotNull DataPackBase oldPack, @NotNull VisibleGraphImpl<Integer> oldGraph, @NotNull VcsLogFilterCollection filters, @Nullable Map<Key, Object> data2) {
        if (oldPack == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(2);
        }
        if (oldGraph == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(3);
        }
        if (filters == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(4);
        }
        int visibleRow = 1000;
        int visibleRange = 1000;
        SimpleGraphInfo<Integer> info2 = oldGraph.buildSimpleGraphInfo(visibleRow, visibleRange);
        Set heads = ContainerUtil.map2Set(info2.getPermanentGraphLayout().getHeadNodeIndex(), integer -> (Integer)info2.getPermanentCommitsInfo().getCommitId((int)integer));
        RefsModel newRefsModel = this.createRefsModel(oldPack.getRefsModel(), heads, oldGraph, oldPack.getLogProviders(), visibleRow, visibleRange);
        DataPackBase newPack = new DataPackBase(oldPack.getLogProviders(), newRefsModel, false);
        GraphColorManagerImpl colorManager = new GraphColorManagerImpl(newRefsModel, VcsLogStorageImpl.createHashGetter(this.myStorage), DataPack.getRefManagerMap(oldPack.getLogProviders()));
        VisibleGraphImpl<Integer> newGraph = new VisibleGraphImpl<Integer>(new CollapsedController(new BaseController(info2), info2, null), info2, colorManager);
        return new VisiblePack(newPack, newGraph, true, filters, data2);
    }

    private RefsModel createRefsModel(@NotNull RefsModel refsModel, @NotNull Set<Integer> heads, @NotNull VisibleGraphImpl<Integer> visibleGraph, @NotNull Map<VirtualFile, VcsLogProvider> providers, int visibleRow, int visibleRange) {
        if (refsModel == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(5);
        }
        if (heads == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(6);
        }
        if (visibleGraph == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(7);
        }
        if (providers == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(8);
        }
        HashSet branchesAndHeads = new HashSet();
        for (int row2 = Math.max(0, visibleRow - visibleRange); row2 < Math.min(visibleGraph.getLinearGraph().nodesCount(), visibleRow + visibleRange); ++row2) {
            Integer commit2 = (Integer)visibleGraph.getRowInfo(row2).getCommit();
            refsModel.refsToCommit(commit2).forEach(ref -> {
                if (ref.getType().isBranch() || heads.contains(commit2)) {
                    branchesAndHeads.add(ref);
                }
            });
        }
        Map<VirtualFile, Set<VcsRef>> map2 = VcsLogUtil.groupRefsByRoot(branchesAndHeads);
        HashMap<VirtualFile, CompressedRefs> refs = new HashMap<VirtualFile, CompressedRefs>();
        Iterator<VirtualFile> iterator2 = providers.keySet().iterator();
        while (iterator2.hasNext()) {
            VirtualFile root2;
            HashSet<VcsRef> refsForRoot = map2.get(root2 = iterator2.next());
            refs.put(root2, new CompressedRefs(refsForRoot == null ? new HashSet<VcsRef>() : refsForRoot, this.myStorage));
        }
        return new RefsModel(refs, heads, this.myStorage, providers);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePack";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPack";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldGraph";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refsModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heads";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleGraph";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/visible/SnapshotVisiblePackBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "build";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createRefsModel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

