/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible.filters;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogUserResolver;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcs.log.visible.filters.SimpleVcsLogUserResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B7\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0002\u0010\u000bB\u001b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J\b\u0010 \u001a\u00020\u0004H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/vcs/log/visible/filters/VcsLogUserFilterImpl;", "Lcom/intellij/vcs/log/VcsLogUserFilter;", "users", "", "", "currentUsers", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsUser;", "allUsers", "", "(Ljava/util/Collection;Ljava/util/Map;Ljava/util/Set;)V", "userNames", "resolver", "Lcom/intellij/vcs/log/data/VcsLogUserResolver;", "(Ljava/util/Collection;Lcom/intellij/vcs/log/data/VcsLogUserResolver;)V", "equals", "", "other", "", "getDisplayText", "getUsers", "", "root", "getValuesAsText", "hashCode", "", "matches", "commit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "resolveUserName", "name", "toString", "Companion", "intellij.platform.vcs.log.impl"})
public final class VcsLogUserFilterImpl
implements VcsLogUserFilter {
    private final Collection<String> userNames;
    private final VcsLogUserResolver resolver;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<VcsUser> getUsers(@NotNull VirtualFile root2) {
        void var3_4;
        void $this$flatMapTo$iv;
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        Iterable iterable = this.userNames;
        boolean bl = false;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            Iterable list$iv = this.resolveUserName(root2, it);
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)var3_4;
    }

    @NotNull
    public Collection<String> getValuesAsText() {
        return this.userNames;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getDisplayText() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.userNames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void user;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var12_11 = Intrinsics.areEqual((Object)user, (Object)"*") ? VcsLogBundle.message((String)"vcs.log.user.filter.me", (Object[])new Object[0]) : user;
            collection.add(var12_11);
        }
        List users = (List)destination$iv$iv;
        String string = StringUtil.join((Collection)users, (String)", ");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.join(users, \", \")");
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public boolean matches(@NotNull VcsCommitMetadata commit) {
        block4: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
                $this$any$iv = this.userNames;
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block5;
                v0 = false;
                break block4;
            }
            for (T element$iv : $this$any$iv) {
                block7: {
                    block8: {
                        block6: {
                            name = (String)element$iv;
                            $i$a$-any-VcsLogUserFilterImpl$matches$1 = false;
                            v1 = commit.getRoot();
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"commit.root");
                            users = this.resolveUserName(v1, name);
                            var9_9 = users;
                            var10_10 = false;
                            if (!(var9_9.isEmpty() == false)) break block6;
                            v2 = users.contains(commit.getAuthor());
                            break block7;
                        }
                        if (!(Intrinsics.areEqual((Object)name, (Object)"*") ^ true)) break block8;
                        Intrinsics.checkNotNullExpressionValue((Object)VcsUserUtil.nameToLowerCase(name), (String)"VcsUserUtil.nameToLowerCase(name)");
                        v3 = commit.getAuthor();
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"commit.author");
                        if (Intrinsics.areEqual((Object)VcsUserUtil.nameToLowerCase(v3.getName()), (Object)lowerUser)) ** GOTO lbl-1000
                        v4 = commit.getAuthor();
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"commit.author");
                        v5 = VcsUserUtil.emailToLowerCase(v4.getEmail());
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"VcsUserUtil.emailToLowerCase(commit.author.email)");
                        if (StringsKt.startsWith$default((String)v5, (String)(lowerUser + '@'), (boolean)false, (int)2, null)) lbl-1000:
                        // 2 sources

                        {
                            v6 = true;
                        } else {
                            v6 = result = false;
                        }
                        if (result) {
                            VcsLogUserFilterImpl.LOG.warn("Unregistered author " + commit.getAuthor() + " for commit " + ((Hash)commit.getId()).asString() + "; search pattern " + name);
                        }
                        v2 = result;
                        break block7;
                    }
                    v2 = false;
                }
                if (!v2) continue;
                v0 = true;
                break block4;
            }
            v0 = false;
        }
        return v0;
    }

    private final Set<VcsUser> resolveUserName(VirtualFile root2, String name2) {
        if (Intrinsics.areEqual((Object)"*", (Object)name2) ^ true) {
            return this.resolver.resolveUserName(name2);
        }
        return this.resolver.resolveCurrentUser(root2);
    }

    @NotNull
    public String toString() {
        return "author: " + StringUtil.join(this.userNames, (String)", ");
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
            return false;
        }
        VcsLogUserFilterImpl filter = (VcsLogUserFilterImpl)other;
        return Comparing.haveEqualElements(this.userNames, filter.userNames);
    }

    public int hashCode() {
        return Comparing.unorderedHashcode(this.userNames);
    }

    public VcsLogUserFilterImpl(@NotNull Collection<String> userNames, @NotNull VcsLogUserResolver resolver) {
        Intrinsics.checkNotNullParameter(userNames, (String)"userNames");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        this.userNames = userNames;
        this.resolver = resolver;
    }

    public VcsLogUserFilterImpl(@NotNull Collection<String> users, @NotNull Map<VirtualFile, ? extends VcsUser> currentUsers, @NotNull Set<? extends VcsUser> allUsers) {
        Intrinsics.checkNotNullParameter(users, (String)"users");
        Intrinsics.checkNotNullParameter(currentUsers, (String)"currentUsers");
        Intrinsics.checkNotNullParameter(allUsers, (String)"allUsers");
        this(users, new SimpleVcsLogUserResolver(currentUsers, allUsers));
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VcsLogUserFilterImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/vcs/log/visible/filters/VcsLogUserFilterImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

