/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.HashingStrategy;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.SystemIndependent;

public final class VcsFileUtil {
    public static final int FILE_PATH_LIMIT = 7600;
    public static final HashingStrategy<FilePath> CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY = new FilePathCaseSensitiveStrategy();

    @NotNull
    public static <T> List<T> foreachChunk(@NotNull List<String> arguments, int groupSize, @NotNull ThrowableNotNullFunction<? super List<String>, ? extends List<? extends T>, ? extends VcsException> processor2) throws VcsException {
        if (arguments == null) {
            VcsFileUtil.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            VcsFileUtil.$$$reportNull$$$0(1);
        }
        ArrayList result2 = new ArrayList();
        VcsFileUtil.foreachChunk(arguments, groupSize, (ThrowableConsumer<? super List<String>, ? extends VcsException>)((ThrowableConsumer)chunk -> result2.addAll((Collection)processor2.fun(chunk))));
        ArrayList arrayList = result2;
        if (arrayList == null) {
            VcsFileUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public static void foreachChunk(@NotNull List<String> arguments, int groupSize, @NotNull ThrowableConsumer<? super List<String>, ? extends VcsException> consumer2) throws VcsException {
        if (arguments == null) {
            VcsFileUtil.$$$reportNull$$$0(3);
        }
        if (consumer2 == null) {
            VcsFileUtil.$$$reportNull$$$0(4);
        }
        List<List<String>> chunks = VcsFileUtil.chunkArguments(arguments, groupSize);
        for (List<String> chunk : chunks) {
            ProgressIndicator indicator2 = ProgressManager.getInstance().getProgressIndicator();
            if (indicator2 != null) {
                indicator2.checkCanceled();
            }
            consumer2.consume(chunk);
        }
    }

    @NotNull
    public static List<List<String>> chunkArguments(@NotNull List<String> arguments) {
        if (arguments == null) {
            VcsFileUtil.$$$reportNull$$$0(5);
        }
        return VcsFileUtil.chunkArguments(arguments, 1);
    }

    @NotNull
    public static List<List<String>> chunkArguments(@NotNull List<String> arguments, int groupSize) {
        int i2;
        if (arguments == null) {
            VcsFileUtil.$$$reportNull$$$0(6);
        }
        assert (arguments.size() % groupSize == 0) : "Arguments size should be divisible by group size";
        ArrayList<List<String>> rc = new ArrayList<List<String>>();
        int start2 = 0;
        int size = 0;
        for (i2 = 0; i2 < arguments.size(); i2 += groupSize) {
            int length = 0;
            for (int j = 0; j < groupSize; ++j) {
                length += arguments.get(i2 + j).length();
            }
            if (size + length > 7600) {
                if (start2 == i2) {
                    rc.add(arguments.subList(i2, i2 + groupSize));
                    start2 = i2 + groupSize;
                    size = 0;
                    continue;
                }
                rc.add(arguments.subList(start2, i2));
                start2 = i2;
                size = length;
                continue;
            }
            size += length;
        }
        if (start2 != arguments.size()) {
            rc.add(arguments.subList(start2, i2));
        }
        ArrayList<List<String>> arrayList = rc;
        if (arrayList == null) {
            VcsFileUtil.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public static List<List<String>> chunkPaths(VirtualFile root2, Collection<? extends FilePath> files2) {
        return VcsFileUtil.chunkArguments(VcsFileUtil.toRelativePaths(root2, files2));
    }

    public static List<List<String>> chunkFiles(@NotNull VirtualFile root2, @NotNull Collection<? extends VirtualFile> files2) {
        if (root2 == null) {
            VcsFileUtil.$$$reportNull$$$0(8);
        }
        if (files2 == null) {
            VcsFileUtil.$$$reportNull$$$0(9);
        }
        return VcsFileUtil.chunkArguments(VcsFileUtil.toRelativeFiles(root2, files2));
    }

    public static String getRelativeFilePath(VirtualFile file2, @NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            VcsFileUtil.$$$reportNull$$$0(10);
        }
        return VcsFileUtil.getRelativeFilePath(file2.getPath(), baseDir);
    }

    public static String getRelativeFilePath(String file2, @NotNull VirtualFile baseDir) {
        String basePath;
        if (baseDir == null) {
            VcsFileUtil.$$$reportNull$$$0(11);
        }
        if (SystemInfo.isWindows) {
            file2 = file2.replace('\\', '/');
        }
        if (!file2.startsWith(basePath = baseDir.getPath())) {
            return file2;
        }
        if (file2.equals(basePath)) {
            return ".";
        }
        return file2.substring(baseDir.getPath().length() + 1);
    }

    public static boolean isOctal(char ch) {
        return '0' <= ch && ch <= '7';
    }

    public static String relativePath(VirtualFile root2, FilePath path2) {
        return VcsFileUtil.relativePath(VfsUtilCore.virtualToIoFile((VirtualFile)root2), path2.getIOFile());
    }

    public static String relativePath(File root2, FilePath path2) {
        return VcsFileUtil.relativePath(root2, path2.getIOFile());
    }

    public static String relativePath(File root2, VirtualFile file2) {
        return VcsFileUtil.relativePath(root2, VfsUtilCore.virtualToIoFile((VirtualFile)file2));
    }

    public static String relativePath(VirtualFile root2, VirtualFile file2) {
        return VcsFileUtil.relativePath(VfsUtilCore.virtualToIoFile((VirtualFile)root2), VfsUtilCore.virtualToIoFile((VirtualFile)file2));
    }

    public static String relativeOrFullPath(VirtualFile root2, VirtualFile file2) {
        if (root2 == null) {
            file2.getPath();
        }
        return VcsFileUtil.relativePath(VfsUtilCore.virtualToIoFile((VirtualFile)root2), VfsUtilCore.virtualToIoFile((VirtualFile)file2));
    }

    @NotNull
    public static String relativePath(@NotNull FilePath root2, @NotNull FilePath file2) {
        if (root2 == null) {
            VcsFileUtil.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            VcsFileUtil.$$$reportNull$$$0(13);
        }
        String string = VcsFileUtil.relativePath(root2.getIOFile(), file2.getIOFile());
        if (string == null) {
            VcsFileUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    public static String relativePath(File root2, File path2) {
        String rc = FileUtil.getRelativePath((File)root2, (File)path2);
        if (rc == null) {
            throw new IllegalArgumentException("The file " + path2 + " cannot be made relative to " + root2);
        }
        return rc.replace(File.separatorChar, '/');
    }

    public static List<String> toRelativePaths(@NotNull VirtualFile root2, @NotNull Collection<? extends FilePath> filePaths) {
        if (root2 == null) {
            VcsFileUtil.$$$reportNull$$$0(15);
        }
        if (filePaths == null) {
            VcsFileUtil.$$$reportNull$$$0(16);
        }
        ArrayList<String> rc = new ArrayList<String>(filePaths.size());
        for (FilePath filePath : filePaths) {
            rc.add(VcsFileUtil.relativePath(root2, filePath));
        }
        return rc;
    }

    public static List<String> toRelativeFiles(@NotNull VirtualFile root2, @NotNull Collection<? extends VirtualFile> files2) {
        if (root2 == null) {
            VcsFileUtil.$$$reportNull$$$0(17);
        }
        if (files2 == null) {
            VcsFileUtil.$$$reportNull$$$0(18);
        }
        ArrayList<String> rc = new ArrayList<String>(files2.size());
        for (VirtualFile virtualFile2 : files2) {
            rc.add(VcsFileUtil.relativePath(root2, virtualFile2));
        }
        return rc;
    }

    public static void markFilesDirty(@NotNull Project project, @NotNull Collection<? extends VirtualFile> affectedFiles2) {
        if (project == null) {
            VcsFileUtil.$$$reportNull$$$0(19);
        }
        if (affectedFiles2 == null) {
            VcsFileUtil.$$$reportNull$$$0(20);
        }
        VcsDirtyScopeManager dirty = VcsDirtyScopeManager.getInstance((Project)project);
        for (VirtualFile virtualFile2 : affectedFiles2) {
            if (virtualFile2.isDirectory()) {
                dirty.dirDirtyRecursively(virtualFile2);
                continue;
            }
            dirty.fileDirty(virtualFile2);
        }
    }

    public static void markFilesDirty(@NotNull Project project, @NotNull List<? extends FilePath> affectedFiles2) {
        if (project == null) {
            VcsFileUtil.$$$reportNull$$$0(21);
        }
        if (affectedFiles2 == null) {
            VcsFileUtil.$$$reportNull$$$0(22);
        }
        VcsDirtyScopeManager dirty = VcsDirtyScopeManager.getInstance((Project)project);
        for (FilePath filePath : affectedFiles2) {
            if (filePath.isDirectory()) {
                dirty.dirDirtyRecursively(filePath);
                continue;
            }
            dirty.fileDirty(filePath);
        }
    }

    public static void addFilesToVcsWithConfirmation(@NotNull Project project, VirtualFile ... virtualFiles) {
        if (project == null) {
            VcsFileUtil.$$$reportNull$$$0(23);
        }
        VcsFileUtil.addFilesToVcsWithConfirmation(project, Arrays.asList(virtualFiles));
    }

    public static void addFilesToVcsWithConfirmation(@NotNull Project project, @NotNull Collection<? extends VirtualFile> virtualFiles) {
        if (project == null) {
            VcsFileUtil.$$$reportNull$$$0(24);
        }
        if (virtualFiles == null) {
            VcsFileUtil.$$$reportNull$$$0(25);
        }
        if (virtualFiles.isEmpty()) {
            return;
        }
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)project);
        ArrayListMultimap vcsMap = ArrayListMultimap.create();
        for (VirtualFile virtualFile2 : virtualFiles) {
            AbstractVcs vcs = vcsManager2.getVcsFor(virtualFile2);
            if (vcs == null) continue;
            VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)virtualFile2, arg_0 -> VcsFileUtil.lambda$addFilesToVcsWithConfirmation$1((Multimap)vcsMap, vcs, arg_0));
        }
        for (AbstractVcs abstractVcs : vcsMap.keySet()) {
            VcsShowConfirmationOption addOption = vcsManager2.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, abstractVcs);
            if (addOption.getValue() == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
                return;
            }
            ArrayList<VirtualFile> filesList = new ArrayList<VirtualFile>(vcsMap.get((Object)abstractVcs));
            if (addOption.getValue() == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
                VcsFileUtil.performAdditions(abstractVcs, filesList);
                continue;
            }
            AbstractVcsHelper helper2 = AbstractVcsHelper.getInstance((Project)project);
            Ref filesToAdd = Ref.create();
            ApplicationManager.getApplication().invokeAndWait(() -> filesToAdd.set((Object)helper2.selectFilesToProcess(new ArrayList(filesList), VcsBundle.message((String)"confirmation.title.add.files.to", (Object[])new Object[]{vcs.getDisplayName()}), null, VcsBundle.message((String)"confirmation.title.add.file.to", (Object[])new Object[]{vcs.getDisplayName()}), null, addOption)));
            if (filesToAdd.isNull()) continue;
            VcsFileUtil.performAdditions(abstractVcs, new ArrayList<VirtualFile>((Collection)filesToAdd.get()));
        }
    }

    private static void performAdditions(@NotNull AbstractVcs vcs, @NotNull List<VirtualFile> value2) {
        CheckinEnvironment checkinEnvironment;
        if (vcs == null) {
            VcsFileUtil.$$$reportNull$$$0(26);
        }
        if (value2 == null) {
            VcsFileUtil.$$$reportNull$$$0(27);
        }
        if ((checkinEnvironment = vcs.getCheckinEnvironment()) != null) {
            checkinEnvironment.scheduleUnversionedFilesForAddition(value2);
        }
    }

    public static boolean isAncestor(@NotNull @SystemIndependent String ancestor, @NotNull @SystemIndependent String path2, boolean strict) {
        if (ancestor == null) {
            VcsFileUtil.$$$reportNull$$$0(28);
        }
        if (path2 == null) {
            VcsFileUtil.$$$reportNull$$$0(29);
        }
        return FileUtil.startsWith((String)path2, (String)ancestor, (boolean)SystemInfo.isFileSystemCaseSensitive, (boolean)strict);
    }

    public static boolean isAncestor(@NotNull FilePath ancestor, @NotNull FilePath path2, boolean strict) {
        if (ancestor == null) {
            VcsFileUtil.$$$reportNull$$$0(30);
        }
        if (path2 == null) {
            VcsFileUtil.$$$reportNull$$$0(31);
        }
        return VcsFileUtil.isAncestor(ancestor.getPath(), path2.getPath(), strict);
    }

    public static boolean isAncestor(@NotNull VirtualFile root2, @NotNull FilePath path2) {
        if (root2 == null) {
            VcsFileUtil.$$$reportNull$$$0(32);
        }
        if (path2 == null) {
            VcsFileUtil.$$$reportNull$$$0(33);
        }
        return VcsFileUtil.isAncestor(root2.getPath(), path2.getPath(), false);
    }

    @NotNull
    public static String unescapeGitPath(@NotNull String path2) throws IllegalArgumentException {
        if (path2 == null) {
            VcsFileUtil.$$$reportNull$$$0(34);
        }
        String QUOTE = "\"";
        if (path2.startsWith("\"") && path2.endsWith("\"")) {
            path2 = path2.substring(1, path2.length() - 1);
        }
        if (path2.indexOf(92) == -1) {
            String string = path2;
            if (string == null) {
                VcsFileUtil.$$$reportNull$$$0(35);
            }
            return string;
        }
        Charset encoding = Charset.defaultCharset();
        int l = path2.length();
        StringBuilder rc = new StringBuilder(l);
        for (int i2 = 0; i2 < path2.length(); ++i2) {
            char c = path2.charAt(i2);
            if (c == '\\') {
                if (++i2 >= l) {
                    throw new IllegalArgumentException("Unterminated escape sequence in the path: " + path2);
                }
                char e = path2.charAt(i2);
                switch (e) {
                    case '\\': {
                        rc.append('\\');
                        break;
                    }
                    case 't': {
                        rc.append('\t');
                        break;
                    }
                    case 'n': {
                        rc.append('\n');
                        break;
                    }
                    case 'r': {
                        rc.append('\r');
                        break;
                    }
                    case 'a': {
                        rc.append('\u0007');
                        break;
                    }
                    case 'b': {
                        rc.append('\b');
                        break;
                    }
                    case 'f': {
                        rc.append('\f');
                        break;
                    }
                    case '\"': {
                        rc.append('\"');
                        break;
                    }
                    default: {
                        if (VcsFileUtil.isOctal(e)) {
                            int n = 0;
                            for (int j = i2; j < l; ++j) {
                                if (VcsFileUtil.isOctal(path2.charAt(j))) {
                                    ++n;
                                    for (int k = 0; k < 3 && j < l && VcsFileUtil.isOctal(path2.charAt(j)); ++j, ++k) {
                                    }
                                }
                                if (j + 1 >= l || path2.charAt(j) != '\\' || !VcsFileUtil.isOctal(path2.charAt(j + 1))) break;
                            }
                            byte[] b = new byte[n];
                            n = 0;
                            while (i2 < l) {
                                if (VcsFileUtil.isOctal(path2.charAt(i2))) {
                                    int code = 0;
                                    for (int k = 0; k < 3 && i2 < l && VcsFileUtil.isOctal(path2.charAt(i2)); ++i2, ++k) {
                                        code = code * 8 + (path2.charAt(i2) - 48);
                                    }
                                    b[n++] = (byte)code;
                                }
                                if (i2 + 1 >= l || path2.charAt(i2) != '\\' || !VcsFileUtil.isOctal(path2.charAt(i2 + 1))) break;
                                ++i2;
                            }
                            --i2;
                            assert (n == b.length);
                            rc.append(new String(b, encoding));
                            break;
                        }
                        throw new IllegalArgumentException("Unknown escape sequence '\\" + path2.charAt(i2) + "' in the path: " + path2);
                    }
                }
                continue;
            }
            rc.append(c);
        }
        String string = rc.toString();
        if (string == null) {
            VcsFileUtil.$$$reportNull$$$0(36);
        }
        return string;
    }

    private static /* synthetic */ boolean lambda$addFilesToVcsWithConfirmation$1(Multimap vcsMap, AbstractVcs vcs, VirtualFile virtualFile2) {
        return vcsMap.put((Object)vcs, (Object)virtualFile2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 14: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 14: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 7: 
            case 14: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcsUtil/VcsFileUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 8: 
            case 12: 
            case 15: 
            case 17: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 19: 
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedFiles";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 29: 
            case 31: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcsUtil/VcsFileUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "foreachChunk";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "chunkArguments";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "relativePath";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeGitPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "foreachChunk";
                break;
            }
            case 2: 
            case 7: 
            case 14: 
            case 35: 
            case 36: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "chunkArguments";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "chunkFiles";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeFilePath";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "relativePath";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "toRelativePaths";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "toRelativeFiles";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "markFilesDirty";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addFilesToVcsWithConfirmation";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "performAdditions";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "unescapeGitPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 14: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FilePathCaseSensitiveStrategy
    implements HashingStrategy<FilePath> {
        private FilePathCaseSensitiveStrategy() {
        }

        public boolean equals(FilePath path1, FilePath path2) {
            if (path1 == path2) {
                return true;
            }
            if (path1 == null || path2 == null) {
                return false;
            }
            if (path1.isDirectory() != path2.isDirectory()) {
                return false;
            }
            String canonical1 = FileUtil.toCanonicalPath((String)path1.getPath());
            String canonical2 = FileUtil.toCanonicalPath((String)path2.getPath());
            return canonical1.equals(canonical2);
        }

        public int hashCode(FilePath path2) {
            if (path2 == null) {
                return 0;
            }
            int result2 = path2.getPath().isEmpty() ? 0 : FileUtil.toCanonicalPath((String)path2.getPath()).hashCode();
            result2 = 31 * result2 + (path2.isDirectory() ? 1 : 0);
            return result2;
        }
    }
}

