/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.vcsUtil.VcsSelection;
import com.intellij.vcsUtil.VcsSelectionProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsSelectionUtil {
    private VcsSelectionUtil() {
    }

    @Nullable
    public static VcsSelection getSelection(@NotNull AnActionEvent e) {
        Editor editor2;
        if (e == null) {
            VcsSelectionUtil.$$$reportNull$$$0(0);
        }
        if ((editor2 = (Editor)e.getData(CommonDataKeys.EDITOR)) == null) {
            return null;
        }
        SelectionModel selectionModel = editor2.getSelectionModel();
        if (selectionModel.hasSelection() && !EditorUtil.contextMenuInvokedOutsideOfSelection(e)) {
            return new VcsSelection(editor2.getDocument(), new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()), VcsBundle.message((String)"action.name.show.history.for.selection", (Object[])new Object[0]));
        }
        for (VcsSelectionProvider provider2 : VcsSelectionProvider.EP_NAME.getExtensionList()) {
            try {
                VcsSelection vcsSelection = provider2.getSelection(e.getDataContext());
                if (vcsSelection == null) continue;
                return vcsSelection;
            }
            catch (IndexNotReadyException indexNotReadyException) {
            }
        }
        Caret caret = editor2.getCaretModel().getPrimaryCaret();
        return new VcsSelection(editor2.getDocument(), new TextRange(caret.getOffset(), caret.getOffset()), VcsBundle.message((String)"action.name.show.history.for.selection", (Object[])new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcsUtil/VcsSelectionUtil", "getSelection"));
    }
}

