/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.workspaceModel.ide.WorkspaceModelChangeListener;
import com.intellij.workspaceModel.ide.WorkspaceModelTopics;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.PersistentEntityId;
import com.intellij.workspaceModel.storage.VersionedStorageChange;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityWithPersistentId;
import com.intellij.workspaceModel.storage.bridgeEntities.FacetEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.FacetId;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleId;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rR\u0014\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/workspaceModel/ide/impl/EntityTracingLogger;", "", "()V", "entityToTrace", "Lcom/intellij/workspaceModel/storage/PersistentEntityId;", "printInfoAboutTracedEntity", "", "storage", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "storageDescription", "", "subscribe", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "EntityTracingListener", "intellij.platform.projectModel.impl"})
public final class EntityTracingLogger {
    private final PersistentEntityId<?> entityToTrace;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public final void subscribe(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (this.entityToTrace != null) {
            WorkspaceModelTopics workspaceModelTopics = WorkspaceModelTopics.Companion.getInstance(project);
            MessageBusConnection messageBusConnection2 = project.getMessageBus().connect();
            Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection2, (String)"project.messageBus.connect()");
            workspaceModelTopics.subscribeImmediately(messageBusConnection2, new EntityTracingListener(this.entityToTrace));
        }
    }

    public final void printInfoAboutTracedEntity(@NotNull WorkspaceEntityStorage storage2, @NotNull String storageDescription) {
        Intrinsics.checkNotNullParameter((Object)storage2, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)storageDescription, (String)"storageDescription");
        if (this.entityToTrace != null) {
            Object obj2 = storage2.resolve(this.entityToTrace);
            LOG.info("Traced entity from " + storageDescription + ": " + (obj2 != null ? EntityTracingLogger.Companion.toDebugString((WorkspaceEntity)obj2) : null));
        }
    }

    /*
     * WARNING - void declaration
     */
    public EntityTracingLogger() {
        PersistentEntityId persistentEntityId;
        EntityTracingLogger entityTracingLogger = this;
        String string = System.getProperty("idea.workspace.model.track.entity.id");
        if (string != null) {
            PersistentEntityId persistentEntityId2;
            void it;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String string3 = string2;
            EntityTracingLogger entityTracingLogger2 = entityTracingLogger;
            boolean bl3 = false;
            List tokens = StringsKt.split$default((CharSequence)((CharSequence)it), (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6, null);
            switch (tokens.size()) {
                case 3: {
                    void moduleName;
                    void facetTypeId;
                    List list2;
                    List list3 = list2 = tokens;
                    boolean bl4 = false;
                    String string4 = (String)list3.get(0);
                    list3 = list2;
                    bl4 = false;
                    String string5 = (String)list3.get(1);
                    list3 = list2;
                    bl4 = false;
                    String facetName = (String)list3.get(2);
                    persistentEntityId2 = new FacetId(facetName, (String)facetTypeId, new ModuleId((String)moduleName));
                    break;
                }
                case 1: {
                    persistentEntityId2 = new ModuleId((String)CollectionsKt.first((List)tokens));
                    break;
                }
                default: {
                    persistentEntityId2 = null;
                }
            }
            PersistentEntityId persistentEntityId3 = persistentEntityId2;
            entityTracingLogger = entityTracingLogger2;
            persistentEntityId = persistentEntityId3;
        } else {
            persistentEntityId = null;
        }
        entityTracingLogger.entityToTrace = persistentEntityId;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EntityTracingListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/workspaceModel/ide/impl/EntityTracingLogger$EntityTracingListener;", "Lcom/intellij/workspaceModel/ide/WorkspaceModelChangeListener;", "entityId", "Lcom/intellij/workspaceModel/storage/PersistentEntityId;", "(Lcom/intellij/workspaceModel/storage/PersistentEntityId;)V", "changed", "", "event", "Lcom/intellij/workspaceModel/storage/VersionedStorageChange;", "printInfo", "action", "", "entity", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "intellij.platform.projectModel.impl"})
    private static final class EntityTracingListener
    implements WorkspaceModelChangeListener {
        private final PersistentEntityId<?> entityId;

        @Override
        public void changed(@NotNull VersionedStorageChange event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Sequence<EntityChange<?>> $this$forEach$iv = event.getAllChanges();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EntityChange it = (EntityChange)element$iv;
                boolean bl = false;
                EntityChange entityChange = it;
                if (entityChange instanceof EntityChange.Added) {
                    this.printInfo("added", (WorkspaceEntity)((EntityChange.Added)it).getEntity());
                    continue;
                }
                if (entityChange instanceof EntityChange.Removed) {
                    this.printInfo("removed", (WorkspaceEntity)((EntityChange.Removed)it).getEntity());
                    continue;
                }
                if (!(entityChange instanceof EntityChange.Replaced)) continue;
                this.printInfo("replaced from", (WorkspaceEntity)((EntityChange.Replaced)it).getOldEntity());
                this.printInfo("replaced to", (WorkspaceEntity)((EntityChange.Replaced)it).getNewEntity());
            }
        }

        private final void printInfo(String action2, WorkspaceEntity entity) {
            WorkspaceEntity workspaceEntity = entity;
            if (!(workspaceEntity instanceof WorkspaceEntityWithPersistentId)) {
                workspaceEntity = null;
            }
            WorkspaceEntityWithPersistentId workspaceEntityWithPersistentId = (WorkspaceEntityWithPersistentId)workspaceEntity;
            if (Intrinsics.areEqual(workspaceEntityWithPersistentId != null ? workspaceEntityWithPersistentId.persistentId() : null, this.entityId)) {
                LOG.info(action2 + ": " + Companion.toDebugString(entity), new Throwable());
            }
        }

        public EntityTracingListener(@NotNull PersistentEntityId<?> entityId) {
            Intrinsics.checkNotNullParameter(entityId, (String)"entityId");
            this.entityId = entityId;
        }

        @Override
        public void beforeChanged(@NotNull VersionedStorageChange event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            WorkspaceModelChangeListener.DefaultImpls.beforeChanged(this, event);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\bH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/workspaceModel/ide/impl/EntityTracingLogger$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "toDebugString", "", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "intellij.platform.projectModel.impl"})
    public static final class Companion {
        private final String toDebugString(WorkspaceEntity $this$toDebugString) {
            WorkspaceEntity workspaceEntity = $this$toDebugString;
            return workspaceEntity instanceof FacetEntity ? "Facet: " + ((FacetEntity)$this$toDebugString).getConfigurationXmlTag() : (workspaceEntity instanceof ModuleEntity ? "Module " + ((ModuleEntity)$this$toDebugString).getName() : $this$toDebugString.getClass().getSimpleName());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

