/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.jps.serialization;

import com.intellij.openapi.module.impl.ModulePath;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.intellij.workspaceModel.ide.JpsFileEntitySource;
import com.intellij.workspaceModel.ide.JpsImportedEntitySource;
import com.intellij.workspaceModel.ide.impl.jps.serialization.ExternalModuleImlFileEntitiesSerializer;
import com.intellij.workspaceModel.ide.impl.jps.serialization.ExternalModuleListSerializer;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsFileContentWriter;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsFileEntitiesSerializer;
import com.intellij.workspaceModel.ide.impl.jps.serialization.ModuleListSerializerImpl;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0015H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0015H\u0014J\b\u0010#\u001a\u00020\bH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/workspaceModel/ide/impl/jps/serialization/ExternalModuleListSerializer;", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/ModuleListSerializerImpl;", "externalStorageRoot", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "virtualFileManager", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "(Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;)V", "componentName", "", "getComponentName", "()Ljava/lang/String;", "entitySourceFilter", "Lkotlin/Function1;", "Lcom/intellij/workspaceModel/storage/EntitySource;", "", "getEntitySourceFilter", "()Lkotlin/jvm/functions/Function1;", "isExternalStorage", "()Z", "createSerializer", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsFileEntitiesSerializer;", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleEntity;", "internalSource", "Lcom/intellij/workspaceModel/ide/JpsFileEntitySource;", "fileUrl", "moduleGroup", "deleteObsoleteFile", "", "writer", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsFileContentWriter;", "getFileName", "entity", "getSourceToSave", "Lcom/intellij/workspaceModel/ide/JpsFileEntitySource$FileInDirectory;", "module", "toString", "intellij.platform.workspaceModel.jps"})
public final class ExternalModuleListSerializer
extends ModuleListSerializerImpl {
    private final VirtualFileUrl externalStorageRoot;
    private final VirtualFileUrlManager virtualFileManager;

    @Override
    public boolean isExternalStorage() {
        return true;
    }

    @Override
    @NotNull
    public String getComponentName() {
        return "ExternalProjectModuleManager";
    }

    @Override
    @NotNull
    public Function1<EntitySource, Boolean> getEntitySourceFilter() {
        return entitySourceFilter.1.INSTANCE;
    }

    @Override
    @Nullable
    protected JpsFileEntitySource.FileInDirectory getSourceToSave(@NotNull ModuleEntity module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        EntitySource entitySource = module.getEntitySource();
        if (!(entitySource instanceof JpsImportedEntitySource)) {
            entitySource = null;
        }
        JpsImportedEntitySource jpsImportedEntitySource = (JpsImportedEntitySource)entitySource;
        JpsFileEntitySource jpsFileEntitySource = jpsImportedEntitySource != null ? jpsImportedEntitySource.getInternalFile() : null;
        if (!(jpsFileEntitySource instanceof JpsFileEntitySource.FileInDirectory)) {
            jpsFileEntitySource = null;
        }
        return (JpsFileEntitySource.FileInDirectory)jpsFileEntitySource;
    }

    @Override
    @NotNull
    public String getFileName(@NotNull ModuleEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return entity.getName() + ".xml";
    }

    @Override
    @NotNull
    public JpsFileEntitiesSerializer<ModuleEntity> createSerializer(@NotNull JpsFileEntitySource internalSource, @NotNull VirtualFileUrl fileUrl, @Nullable String moduleGroup) {
        String filePath;
        Intrinsics.checkNotNullParameter((Object)internalSource, (String)"internalSource");
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        String string = PathUtil.getFileName((String)fileUrl.getUrl());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PathUtil.getFileName(fileUrl.url)");
        String fileName = string;
        VirtualFileUrl actualFileUrl = Intrinsics.areEqual((Object)PathUtil.getFileExtension((String)fileName), (Object)"iml") ? this.externalStorageRoot.append("modules/" + StringsKt.substringBeforeLast$default((String)fileName, (char)'.', null, (int)2, null) + ".xml") : fileUrl;
        String string2 = filePath = JpsPathUtil.urlToPath((String)fileUrl.getUrl());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"filePath");
        ModulePath modulePath = new ModulePath(string2, moduleGroup);
        VirtualFileUrl virtualFileUrl = actualFileUrl;
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileUrl, (String)"actualFileUrl");
        return new ExternalModuleImlFileEntitiesSerializer(modulePath, virtualFileUrl, this.virtualFileManager, internalSource, this);
    }

    @Override
    public void deleteObsoleteFile(@NotNull String fileUrl, @NotNull JpsFileContentWriter writer) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        super.deleteObsoleteFile(fileUrl, writer);
        if (FileUtil.extensionEquals((String)fileUrl, (String)"xml")) {
            writer.saveComponent(fileUrl, "ExternalSystem", null);
            writer.saveComponent(fileUrl, "ExternalFacetManager", null);
            writer.saveComponent(fileUrl, "DeprecatedModuleOptionManager", null);
        }
    }

    @Override
    @NotNull
    public String toString() {
        return "ExternalModuleListSerializer(" + this.getFileUrl() + ')';
    }

    public ExternalModuleListSerializer(@NotNull VirtualFileUrl externalStorageRoot, @NotNull VirtualFileUrlManager virtualFileManager) {
        Intrinsics.checkNotNullParameter((Object)externalStorageRoot, (String)"externalStorageRoot");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        VirtualFileUrl virtualFileUrl = externalStorageRoot.append("project/modules.xml");
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileUrl, (String)"externalStorageRoot.append(\"project/modules.xml\")");
        String string = virtualFileUrl.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"externalStorageRoot.appe\u2026project/modules.xml\").url");
        super(string, virtualFileManager, null, null, 12, null);
        this.externalStorageRoot = externalStorageRoot;
        this.virtualFileManager = virtualFileManager;
    }
}

