/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.jps.serialization;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ConfigurationErrorDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.workspaceModel.ide.impl.jps.serialization.ErrorReporter;
import com.intellij.workspaceModel.ide.impl.jps.serialization.ModuleLoadingErrorDescriptionBridge;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/workspaceModel/ide/impl/jps/serialization/IdeErrorReporter;", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/ErrorReporter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "errors", "Ljava/util/ArrayList;", "Lcom/intellij/openapi/module/ConfigurationErrorDescription;", "Lkotlin/collections/ArrayList;", "getErrors", "()Ljava/util/ArrayList;", "reportError", "", "message", "", "file", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "Companion", "intellij.platform.ide.impl"})
public final class IdeErrorReporter
implements ErrorReporter {
    @NotNull
    private final ArrayList<ConfigurationErrorDescription> errors;
    private final Project project;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final ArrayList<ConfigurationErrorDescription> getErrors() {
        return this.errors;
    }

    @Override
    public void reportError(@NotNull String message2, @NotNull VirtualFileUrl file2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (FileUtil.extensionEquals((String)file2.getFileName(), (String)"iml")) {
            this.errors.add(new ModuleLoadingErrorDescriptionBridge(message2, file2, this.project));
        } else {
            LOG.error("Failed to load " + file2.getPresentableUrl() + ": " + message2);
        }
    }

    public IdeErrorReporter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.errors = new ArrayList();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(IdeErrorReporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/workspaceModel/ide/impl/jps/serialization/IdeErrorReporter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

