/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.jps.serialization;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.workspaceModel.ide.JpsFileEntitySource;
import com.intellij.workspaceModel.ide.JpsImportedEntitySource;
import com.intellij.workspaceModel.ide.impl.jps.serialization.FileInDirectorySourceNames;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsFileContentWriter;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsFileEntityTypeSerializer;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsLibrariesExternalFileSerializer;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsLibraryEntitiesSerializer;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsProjectSerializersImplKt;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryTableId;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001d\u001a\u00020\u0003H\u0014R \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsLibrariesExternalFileSerializer;", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsLibraryEntitiesSerializer;", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsFileEntityTypeSerializer;", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryEntity;", "externalFile", "Lcom/intellij/workspaceModel/ide/JpsFileEntitySource$ExactFile;", "internalLibrariesDirUrl", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "fileInDirectorySourceNames", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/FileInDirectorySourceNames;", "(Lcom/intellij/workspaceModel/ide/JpsFileEntitySource$ExactFile;Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;Lcom/intellij/workspaceModel/ide/impl/jps/serialization/FileInDirectorySourceNames;)V", "entityFilter", "Lkotlin/Function1;", "", "getEntityFilter", "()Lkotlin/jvm/functions/Function1;", "isExternalStorage", "()Z", "createEntitySource", "Lcom/intellij/workspaceModel/storage/EntitySource;", "libraryTag", "Lorg/jdom/Element;", "deleteObsoleteFile", "", "fileUrl", "", "writer", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsFileContentWriter;", "getExternalSystemId", "libraryEntity", "intellij.platform.workspaceModel.jps"})
public final class JpsLibrariesExternalFileSerializer
extends JpsLibraryEntitiesSerializer
implements JpsFileEntityTypeSerializer<LibraryEntity> {
    private final JpsFileEntitySource.ExactFile externalFile;
    private final VirtualFileUrl internalLibrariesDirUrl;
    private final FileInDirectorySourceNames fileInDirectorySourceNames;

    @Override
    public boolean isExternalStorage() {
        return true;
    }

    @Override
    @NotNull
    public Function1<LibraryEntity, Boolean> getEntityFilter() {
        return entityFilter.1.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected EntitySource createEntitySource(@NotNull Element libraryTag) {
        JpsFileEntitySource.FileInDirectory fileInDirectory;
        Intrinsics.checkNotNullParameter((Object)libraryTag, (String)"libraryTag");
        String string = libraryTag.getAttributeValue("__external-system-id");
        if (string == null) {
            return null;
        }
        String externalSystemId2 = string;
        String libraryName = JpsProjectSerializersImplKt.getAttributeValueStrict(libraryTag, "name");
        JpsFileEntitySource.FileInDirectory existingInternalSource = this.fileInDirectorySourceNames.findSource(this.getMainEntityClass(), libraryName);
        if (existingInternalSource != null && Intrinsics.areEqual((Object)existingInternalSource.getDirectory(), (Object)this.internalLibrariesDirUrl)) {
            void $this$debug$iv;
            boolean $i$f$logger22 = false;
            Logger logger = Logger.getInstance(JpsLibrariesExternalFileSerializer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            Logger $i$f$logger22 = logger;
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                void var11_9 = $this$debug$iv;
                boolean bl = false;
                String string2 = "Reuse existing source for library: " + existingInternalSource.getFileNameId() + '=' + libraryName;
                var11_9.debug(string2, (Throwable)e$iv);
            }
            fileInDirectory = existingInternalSource;
        } else {
            fileInDirectory = new JpsFileEntitySource.FileInDirectory(this.internalLibrariesDirUrl, this.externalFile.getProjectLocation());
        }
        JpsFileEntitySource.FileInDirectory internalEntitySource = fileInDirectory;
        return new JpsImportedEntitySource(internalEntitySource, externalSystemId2, true);
    }

    @Override
    @Nullable
    protected String getExternalSystemId(@NotNull LibraryEntity libraryEntity) {
        Intrinsics.checkNotNullParameter((Object)libraryEntity, (String)"libraryEntity");
        EntitySource source = libraryEntity.getEntitySource();
        EntitySource entitySource = source;
        if (!(entitySource instanceof JpsImportedEntitySource)) {
            entitySource = null;
        }
        JpsImportedEntitySource jpsImportedEntitySource = (JpsImportedEntitySource)entitySource;
        return jpsImportedEntitySource != null ? jpsImportedEntitySource.getExternalSystemId() : null;
    }

    @Override
    public void deleteObsoleteFile(@NotNull String fileUrl, @NotNull JpsFileContentWriter writer) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.saveComponent(fileUrl, "libraryTable", null);
    }

    public JpsLibrariesExternalFileSerializer(@NotNull JpsFileEntitySource.ExactFile externalFile, @NotNull VirtualFileUrl internalLibrariesDirUrl, @NotNull FileInDirectorySourceNames fileInDirectorySourceNames) {
        Intrinsics.checkNotNullParameter((Object)externalFile, (String)"externalFile");
        Intrinsics.checkNotNullParameter((Object)internalLibrariesDirUrl, (String)"internalLibrariesDirUrl");
        Intrinsics.checkNotNullParameter((Object)fileInDirectorySourceNames, (String)"fileInDirectorySourceNames");
        super(externalFile.getFile(), externalFile, LibraryTableId.ProjectLibraryTableId.INSTANCE);
        this.externalFile = externalFile;
        this.internalLibrariesDirUrl = internalLibrariesDirUrl;
        this.fileInDirectorySourceNames = fileInDirectorySourceNames;
    }
}

