/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.jps.serialization;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.workspaceModel.ide.JpsFileEntitySource;
import com.intellij.workspaceModel.ide.impl.jps.serialization.ErrorReporter;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsFileContentReader;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsFileContentWriter;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsFileEntitiesSerializer;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsLibraryEntitiesSerializerKt;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsProjectSerializersImplKt;
import com.intellij.workspaceModel.ide.impl.jps.serialization.LibraryExternalSystemIdEntity;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryId;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryTableId;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0002H\u0014J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016JH\u0010(\u001a\u00020\u001f2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020*2 \u0010+\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020-0\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0.0,2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020\u001cH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00064"}, d2={"Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsLibraryEntitiesSerializer;", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsFileEntitiesSerializer;", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryEntity;", "fileUrl", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "internalEntitySource", "Lcom/intellij/workspaceModel/ide/JpsFileEntitySource;", "libraryTableId", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryTableId;", "(Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;Lcom/intellij/workspaceModel/ide/JpsFileEntitySource;Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryTableId;)V", "getFileUrl", "()Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "getInternalEntitySource", "()Lcom/intellij/workspaceModel/ide/JpsFileEntitySource;", "isExternalStorage", "", "()Z", "getLibraryTableId", "()Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryTableId;", "mainEntityClass", "Ljava/lang/Class;", "getMainEntityClass", "()Ljava/lang/Class;", "createEntitySource", "Lcom/intellij/workspaceModel/storage/EntitySource;", "libraryTag", "Lorg/jdom/Element;", "getExternalSystemId", "", "libraryEntity", "loadEntities", "", "builder", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;", "reader", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsFileContentReader;", "errorReporter", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/ErrorReporter;", "virtualFileManager", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "saveEntities", "mainEntities", "", "entities", "", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "", "storage", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "writer", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsFileContentWriter;", "toString", "intellij.platform.workspaceModel.jps"})
public class JpsLibraryEntitiesSerializer
implements JpsFileEntitiesSerializer<LibraryEntity> {
    @NotNull
    private final VirtualFileUrl fileUrl;
    @NotNull
    private final JpsFileEntitySource internalEntitySource;
    @NotNull
    private final LibraryTableId libraryTableId;

    public boolean isExternalStorage() {
        return false;
    }

    @Override
    @NotNull
    public Class<LibraryEntity> getMainEntityClass() {
        return LibraryEntity.class;
    }

    @Override
    public void loadEntities(@NotNull WorkspaceEntityStorageBuilder builder2, @NotNull JpsFileContentReader reader, @NotNull ErrorReporter errorReporter, @NotNull VirtualFileUrlManager virtualFileManager) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        String string = this.getFileUrl().getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileUrl.url");
        Element element2 = JpsFileContentReader.DefaultImpls.loadComponent$default(reader, string, "libraryTable", null, 4, null);
        if (element2 == null) {
            return;
        }
        Element libraryTableTag = element2;
        Iterator iterator2 = libraryTableTag.getChildren("library").iterator();
        while (iterator2.hasNext()) {
            EntitySource source;
            Element libraryTag;
            Element element3 = libraryTag = (Element)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"libraryTag");
            if (this.createEntitySource(element3) == null) {
                continue;
            }
            String name2 = JpsProjectSerializersImplKt.getAttributeValueStrict(libraryTag, "name");
            LibraryId libraryId = new LibraryId(name2, this.libraryTableId);
            LibraryEntity existingLibraryEntity = (LibraryEntity)builder2.resolve(libraryId);
            if (existingLibraryEntity != null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(JpsLibraryEntitiesSerializer.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.error(StringsKt.trimMargin$default((String)("Error during entities loading\n          |Entity with this library id already exists.\n          |Library id: " + libraryId + "\n          |fileUrl: " + this.getFileUrl().getPresentableUrl() + "\n          |library table id: " + this.libraryTableId + "\n          |internal entity source: " + this.getInternalEntitySource() + "\n        "), null, (int)1, null));
            }
            JpsLibraryEntitiesSerializerKt.loadLibrary(name2, libraryTag, this.libraryTableId, builder2, source, virtualFileManager, this.isExternalStorage());
        }
    }

    @Nullable
    protected EntitySource createEntitySource(@NotNull Element libraryTag) {
        Intrinsics.checkNotNullParameter((Object)libraryTag, (String)"libraryTag");
        return this.getInternalEntitySource();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveEntities(@NotNull Collection<LibraryEntity> mainEntities, @NotNull Map<Class<? extends WorkspaceEntity>, ? extends List<? extends WorkspaceEntity>> entities2, @NotNull WorkspaceEntityStorage storage2, @NotNull JpsFileContentWriter writer) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter(mainEntities, (String)"mainEntities");
        Intrinsics.checkNotNullParameter(entities2, (String)"entities");
        Intrinsics.checkNotNullParameter((Object)storage2, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        if (mainEntities.isEmpty()) {
            return;
        }
        Element componentTag = JDomSerializationUtil.createComponentElement((String)"libraryTable");
        Iterable $this$sortedBy$iv = mainEntities;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                LibraryEntity it = (LibraryEntity)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (LibraryEntity)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LibraryEntity it = (LibraryEntity)element$iv;
            boolean bl2 = false;
            componentTag.addContent(JpsLibraryEntitiesSerializerKt.saveLibrary(it, this.getExternalSystemId(it), this.isExternalStorage()));
        }
        String string = this.getFileUrl().getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileUrl.url");
        writer.saveComponent(string, "libraryTable", componentTag);
    }

    @Nullable
    protected String getExternalSystemId(@NotNull LibraryEntity libraryEntity) {
        Intrinsics.checkNotNullParameter((Object)libraryEntity, (String)"libraryEntity");
        LibraryExternalSystemIdEntity libraryExternalSystemIdEntity = JpsLibraryEntitiesSerializerKt.access$getExternalSystemId$p(libraryEntity);
        return libraryExternalSystemIdEntity != null ? libraryExternalSystemIdEntity.getExternalSystemId() : null;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        return stringBuilder.append(StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null)).append('(').append(this.getFileUrl()).append(')').toString();
    }

    @Override
    @NotNull
    public VirtualFileUrl getFileUrl() {
        return this.fileUrl;
    }

    @Override
    @NotNull
    public JpsFileEntitySource getInternalEntitySource() {
        return this.internalEntitySource;
    }

    @NotNull
    protected final LibraryTableId getLibraryTableId() {
        return this.libraryTableId;
    }

    public JpsLibraryEntitiesSerializer(@NotNull VirtualFileUrl fileUrl, @NotNull JpsFileEntitySource internalEntitySource, @NotNull LibraryTableId libraryTableId) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)internalEntitySource, (String)"internalEntitySource");
        Intrinsics.checkNotNullParameter((Object)libraryTableId, (String)"libraryTableId");
        this.fileUrl = fileUrl;
        this.internalEntitySource = internalEntitySource;
        this.libraryTableId = libraryTableId;
    }

    @Override
    @NotNull
    public List<Class<? extends WorkspaceEntity>> getAdditionalEntityTypes() {
        return JpsFileEntitiesSerializer.DefaultImpls.getAdditionalEntityTypes(this);
    }
}

