/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.project;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeIndexingInfo;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.workspaceModel.ide.impl.legacyBridge.project.ProjectRootManagerBridge;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.VersionedStorageChange;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ContentRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.CustomSourceRootPropertiesEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.JavaModuleSettingsEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.JavaResourceRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.JavaSourceRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryPropertiesEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryTableId;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleCustomImlDataEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleGroupPathEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.SourceRootEntity;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/project/ProjectRootsChangeListener;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "beforeChanged", "", "event", "Lcom/intellij/workspaceModel/storage/VersionedStorageChange;", "changed", "shouldFireRootsChanged", "", "events", "Companion", "WorkspaceEventIndexingInfo", "intellij.platform.lang.impl"})
public final class ProjectRootsChangeListener {
    private final Project project;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void beforeChanged(@NotNull VersionedStorageChange event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.project.isDisposed()) {
            return;
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.project);
        if (!(projectRootManager instanceof ProjectRootManagerBridge)) {
            return;
        }
        boolean performUpdate = this.shouldFireRootsChanged(event, this.project);
        if (performUpdate && !((ProjectRootManagerBridge)projectRootManager).isFiringEvent()) {
            ((ProjectRootManagerBridge)projectRootManager).getRootsChanged().beforeRootsChanged();
        }
    }

    public final void changed(@NotNull VersionedStorageChange event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.project.isDisposed()) {
            return;
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.project);
        if (!(projectRootManager instanceof ProjectRootManagerBridge)) {
            return;
        }
        boolean performUpdate = this.shouldFireRootsChanged(event, this.project);
        if (performUpdate && !((ProjectRootManagerBridge)projectRootManager).isFiringEvent()) {
            WorkspaceEventIndexingInfo rootsChangeInfo = new WorkspaceEventIndexingInfo(SequencesKt.toList(event.getAllChanges()));
            ((ProjectRootManagerBridge)projectRootManager).getRootsChanged().rootsChanged(rootsChangeInfo);
        }
    }

    private final boolean shouldFireRootsChanged(VersionedStorageChange events, Project project) {
        boolean bl;
        block7: {
            Sequence<EntityChange<?>> $this$any$iv = events.getAllChanges();
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Object entity;
                Object t;
                EntityChange it = (EntityChange)element$iv;
                boolean bl2 = false;
                EntityChange entityChange = it;
                if (entityChange instanceof EntityChange.Added) {
                    t = ((EntityChange.Added)it).getEntity();
                } else if (entityChange instanceof EntityChange.Removed) {
                    t = ((EntityChange.Removed)it).getEntity();
                } else if (entityChange instanceof EntityChange.Replaced) {
                    t = ((EntityChange.Replaced)it).getNewEntity();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                if (!Companion.shouldFireRootsChanged$intellij_platform_lang_impl((WorkspaceEntity)(entity = t), project)) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        return bl;
    }

    public ProjectRootsChangeListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u001b\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/project/ProjectRootsChangeListener$WorkspaceEventIndexingInfo;", "Lcom/intellij/openapi/project/RootsChangeIndexingInfo;", "events", "", "Lcom/intellij/workspaceModel/storage/EntityChange;", "(Ljava/util/List;)V", "getEvents", "()Ljava/util/List;", "intellij.platform.lang.impl"})
    public static final class WorkspaceEventIndexingInfo
    extends RootsChangeIndexingInfo {
        @NotNull
        private final List<EntityChange<?>> events;

        @NotNull
        public final List<EntityChange<?>> getEvents() {
            return this.events;
        }

        public WorkspaceEventIndexingInfo(@NotNull List<? extends EntityChange<?>> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            this.events = events;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001d\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/project/ProjectRootsChangeListener$Companion;", "", "()V", "libraryHasOrderEntry", "", "library", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryEntity;", "project", "Lcom/intellij/openapi/project/Project;", "shouldFireRootsChanged", "entity", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "shouldFireRootsChanged$intellij_platform_lang_impl", "intellij.platform.lang.impl"})
    public static final class Companion {
        public final boolean shouldFireRootsChanged$intellij_platform_lang_impl(@NotNull WorkspaceEntity entity, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            WorkspaceEntity workspaceEntity = entity;
            return workspaceEntity instanceof LibraryEntity ? this.libraryHasOrderEntry((LibraryEntity)entity, project) : (workspaceEntity instanceof LibraryPropertiesEntity ? this.libraryHasOrderEntry(((LibraryPropertiesEntity)entity).getLibrary(), project) : workspaceEntity instanceof ModuleEntity || workspaceEntity instanceof JavaModuleSettingsEntity || workspaceEntity instanceof ModuleCustomImlDataEntity || workspaceEntity instanceof ModuleGroupPathEntity || workspaceEntity instanceof SourceRootEntity || workspaceEntity instanceof JavaSourceRootEntity || workspaceEntity instanceof JavaResourceRootEntity || workspaceEntity instanceof CustomSourceRootPropertiesEntity || workspaceEntity instanceof ContentRootEntity);
        }

        private final boolean libraryHasOrderEntry(LibraryEntity library2, Project project) {
            if (library2.getTableId() instanceof LibraryTableId.ModuleLibraryTableId) {
                return true;
            }
            String libraryName = library2.getName();
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
            Module[] moduleArray = moduleManager.getModules();
            Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
            Module[] $this$forEach$iv = moduleArray;
            boolean $i$f$forEach = false;
            Module[] moduleArray2 = $this$forEach$iv;
            int n = moduleArray2.length;
            for (int j = 0; j < n; ++j) {
                boolean exists;
                block3: {
                    boolean bl;
                    OrderEntry[] $this$any$iv;
                    Module element$iv;
                    Module module = element$iv = moduleArray2[j];
                    boolean bl2 = false;
                    ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                    Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
                    Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager.getOrderEntries(), (String)"ModuleRootManager.getInstance(module).orderEntries");
                    boolean $i$f$any = false;
                    OrderEntry[] orderEntryArray = $this$any$iv;
                    int n2 = orderEntryArray.length;
                    for (int k = 0; k < n2; ++k) {
                        OrderEntry element$iv2;
                        OrderEntry it = element$iv2 = orderEntryArray[k];
                        boolean bl3 = false;
                        if (!(it instanceof LibraryOrderEntry && Intrinsics.areEqual((Object)((LibraryOrderEntry)it).getLibraryName(), (Object)libraryName))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = exists = false;
                }
                if (!exists) continue;
                return true;
            }
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

