/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.BreakpointsUsageCollector;
import com.intellij.xdebugger.impl.breakpoints.CustomizedBreakpointPresentation;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointListener;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEditorLinePainter;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.frame.XWatchesViewImpl;
import com.intellij.xdebugger.impl.inline.DebuggerInlayListener;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.stepping.XSmartStepIntoVariant;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XDebugSessionImpl
implements XDebugSession {
    private static final Logger LOG = Logger.getInstance(XDebugSessionImpl.class);
    private static final Logger PERFORMANCE_LOG = Logger.getInstance((String)"#com.intellij.xdebugger.impl.XDebugSessionImpl.performance");
    private static final NotificationGroup BP_NOTIFICATION_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("Breakpoint hit");
    private XDebugProcess myDebugProcess;
    private final Map<XBreakpoint<?>, CustomizedBreakpointPresentation> myRegisteredBreakpoints;
    private final Set<XBreakpoint<?>> myInactiveSlaveBreakpoints;
    private boolean myBreakpointsDisabled;
    private final XDebuggerManagerImpl myDebuggerManager;
    private Disposable myBreakpointListenerDisposable;
    private XSuspendContext mySuspendContext;
    private XExecutionStack myCurrentExecutionStack;
    private XStackFrame myCurrentStackFrame;
    private boolean myIsTopFrame;
    private volatile XSourcePosition myTopFramePosition;
    private final AtomicBoolean myPaused;
    private XValueMarkers<?, ?> myValueMarkers;
    @Nls
    private final String mySessionName;
    @Nullable
    private XDebugSessionTab mySessionTab;
    @NotNull
    private final XDebugSessionData mySessionData;
    private final AtomicReference<Pair<XBreakpoint<?>, XSourcePosition>> myActiveNonLineBreakpoint;
    private final EventDispatcher<XDebugSessionListener> myDispatcher;
    private final Project myProject;
    @Nullable
    private final ExecutionEnvironment myEnvironment;
    private final AtomicBoolean myStopped;
    private boolean myPauseActionSupported;
    private boolean myReadOnly;
    private final AtomicBoolean myShowTabOnSuspend;
    private final List<AnAction> myRestartActions;
    private final List<AnAction> myExtraStopActions;
    private final List<AnAction> myExtraActions;
    private ConsoleView myConsoleView;
    private final Icon myIcon;
    private volatile boolean breakpointsInitialized;
    private long myUserRequestStart;

    public XDebugSessionImpl(@NotNull ExecutionEnvironment environment2, @NotNull XDebuggerManagerImpl debuggerManager) {
        if (environment2 == null) {
            XDebugSessionImpl.$$$reportNull$$$0(0);
        }
        if (debuggerManager == null) {
            XDebugSessionImpl.$$$reportNull$$$0(1);
        }
        this(environment2, debuggerManager, environment2.getRunProfile().getName(), environment2.getRunProfile().getIcon(), false, null);
    }

    public XDebugSessionImpl(@Nullable ExecutionEnvironment environment2, @NotNull XDebuggerManagerImpl debuggerManager, @NotNull @Nls String sessionName, @Nullable Icon icon2, boolean showTabOnSuspend, @Nullable RunContentDescriptor contentToReuse) {
        JComponent component2;
        if (debuggerManager == null) {
            XDebugSessionImpl.$$$reportNull$$$0(2);
        }
        if (sessionName == null) {
            XDebugSessionImpl.$$$reportNull$$$0(3);
        }
        this.myRegisteredBreakpoints = new HashMap();
        this.myInactiveSlaveBreakpoints = Collections.synchronizedSet(new HashSet());
        this.myPaused = new AtomicBoolean();
        this.myActiveNonLineBreakpoint = new AtomicReference();
        this.myDispatcher = EventDispatcher.create(XDebugSessionListener.class);
        this.myStopped = new AtomicBoolean();
        this.myReadOnly = false;
        this.myRestartActions = new SmartList();
        this.myExtraStopActions = new SmartList();
        this.myExtraActions = new SmartList();
        this.myEnvironment = environment2;
        this.mySessionName = sessionName;
        this.myDebuggerManager = debuggerManager;
        this.myShowTabOnSuspend = new AtomicBoolean(showTabOnSuspend);
        this.myProject = debuggerManager.getProject();
        ValueLookupManager.getInstance(this.myProject).startListening();
        DebuggerInlayListener.getInstance(this.myProject).startListening();
        this.myIcon = icon2;
        XDebugSessionData oldSessionData = null;
        if (contentToReuse == null) {
            RunContentDescriptor runContentDescriptor = contentToReuse = environment2 != null ? environment2.getContentToReuse() : null;
        }
        if (contentToReuse != null && (component2 = contentToReuse.getComponent()) != null) {
            oldSessionData = XDebugSessionData.DATA_KEY.getData(DataManager.getInstance().getDataContext((Component)component2));
        }
        String currentConfigurationName = this.getConfigurationName();
        if (oldSessionData == null || !oldSessionData.getConfigurationName().equals(currentConfigurationName)) {
            oldSessionData = new XDebugSessionData(this.getWatchExpressions(), currentConfigurationName);
        }
        this.mySessionData = oldSessionData;
    }

    @NotNull
    public String getSessionName() {
        String string = this.mySessionName;
        if (string == null) {
            XDebugSessionImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public RunContentDescriptor getRunContentDescriptor() {
        this.assertSessionTabInitialized();
        RunContentDescriptor runContentDescriptor = this.mySessionTab.getRunContentDescriptor();
        if (runContentDescriptor == null) {
            XDebugSessionImpl.$$$reportNull$$$0(5);
        }
        return runContentDescriptor;
    }

    private void assertSessionTabInitialized() {
        if (this.myShowTabOnSuspend.get()) {
            LOG.error("Debug tool window isn't shown yet because debug process isn't suspended");
        } else {
            LOG.assertTrue(this.mySessionTab != null, (Object)"Debug tool window not initialized yet!");
        }
    }

    public void setPauseActionSupported(boolean isSupported) {
        this.myPauseActionSupported = isSupported;
    }

    public boolean isReadOnly() {
        return this.myReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.myReadOnly = readOnly;
    }

    @NotNull
    public List<AnAction> getRestartActions() {
        List<AnAction> list2 = this.myRestartActions;
        if (list2 == null) {
            XDebugSessionImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    public void addRestartActions(AnAction ... restartActions) {
        if (restartActions != null) {
            Collections.addAll(this.myRestartActions, restartActions);
        }
    }

    @NotNull
    public List<AnAction> getExtraActions() {
        List<AnAction> list2 = this.myExtraActions;
        if (list2 == null) {
            XDebugSessionImpl.$$$reportNull$$$0(7);
        }
        return list2;
    }

    public void addExtraActions(AnAction ... extraActions) {
        if (extraActions != null) {
            Collections.addAll(this.myExtraActions, extraActions);
        }
    }

    public List<AnAction> getExtraStopActions() {
        return this.myExtraStopActions;
    }

    public void addExtraStopActions(AnAction ... extraStopActions) {
        if (extraStopActions != null) {
            Collections.addAll(this.myExtraStopActions, extraStopActions);
        }
    }

    public void rebuildViews() {
        ((XDebugSessionListener)this.myDispatcher.getMulticaster()).settingsChanged();
    }

    @Nullable
    public RunProfile getRunProfile() {
        return this.myEnvironment != null ? this.myEnvironment.getRunProfile() : null;
    }

    public boolean isPauseActionSupported() {
        return this.myPauseActionSupported;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myDebuggerManager.getProject();
        if (project == null) {
            XDebugSessionImpl.$$$reportNull$$$0(8);
        }
        return project;
    }

    @NotNull
    public XDebugProcess getDebugProcess() {
        XDebugProcess xDebugProcess = this.myDebugProcess;
        if (xDebugProcess == null) {
            XDebugSessionImpl.$$$reportNull$$$0(9);
        }
        return xDebugProcess;
    }

    public boolean isSuspended() {
        return this.myPaused.get() && this.mySuspendContext != null;
    }

    public boolean isPaused() {
        return this.myPaused.get();
    }

    @Nullable
    public XStackFrame getCurrentStackFrame() {
        return this.myCurrentStackFrame;
    }

    public XExecutionStack getCurrentExecutionStack() {
        return this.myCurrentExecutionStack;
    }

    public XSuspendContext getSuspendContext() {
        return this.mySuspendContext;
    }

    @Nullable
    public XSourcePosition getCurrentPosition() {
        return this.myCurrentStackFrame != null ? this.myCurrentStackFrame.getSourcePosition() : null;
    }

    @Nullable
    public XSourcePosition getTopFramePosition() {
        return this.myTopFramePosition;
    }

    void init(@NotNull XDebugProcess process2, @Nullable RunContentDescriptor contentToReuse) {
        if (process2 == null) {
            XDebugSessionImpl.$$$reportNull$$$0(10);
        }
        LOG.assertTrue(this.myDebugProcess == null);
        this.myDebugProcess = process2;
        if (this.myDebugProcess.checkCanInitBreakpoints()) {
            this.initBreakpoints();
        }
        this.myDebugProcess.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                XDebugSessionImpl.this.stopImpl();
                XDebugSessionImpl.this.myDebugProcess.getProcessHandler().removeProcessListener((ProcessListener)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/XDebugSessionImpl$1", "processTerminated"));
            }
        });
        this.myConsoleView = (ConsoleView)this.myDebugProcess.createConsole();
        if (!this.myShowTabOnSuspend.get()) {
            this.initSessionTab(contentToReuse);
        }
    }

    public void reset() {
        this.breakpointsInitialized = false;
        this.removeBreakpointListeners();
        this.unsetPaused();
        this.clearPausedData();
        this.rebuildViews();
    }

    public void initBreakpoints() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LOG.assertTrue(!this.breakpointsInitialized);
        this.breakpointsInitialized = true;
        this.disableSlaveBreakpoints();
        this.processAllBreakpoints(true, false);
        if (this.myBreakpointListenerDisposable == null) {
            this.myBreakpointListenerDisposable = Disposer.newDisposable();
            MessageBusConnection busConnection = this.myProject.getMessageBus().connect(this.myBreakpointListenerDisposable);
            busConnection.subscribe(XBreakpointListener.TOPIC, (Object)new MyBreakpointListener());
            busConnection.subscribe(XDependentBreakpointListener.TOPIC, (Object)new MyDependentBreakpointListener());
        }
    }

    public ConsoleView getConsoleView() {
        return this.myConsoleView;
    }

    @Nullable
    public XDebugSessionTab getSessionTab() {
        return this.mySessionTab;
    }

    public RunnerLayoutUi getUI() {
        this.assertSessionTabInitialized();
        assert (this.mySessionTab != null);
        return this.mySessionTab.getUi();
    }

    private void initSessionTab(@Nullable RunContentDescriptor contentToReuse) {
        this.mySessionTab = XDebugSessionTab.create(this, this.myIcon, this.myEnvironment, contentToReuse);
        this.myDebugProcess.sessionInitialized();
        this.addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                this.updateActions();
            }

            public void sessionResumed() {
                this.updateActions();
            }

            public void sessionStopped() {
                this.updateActions();
            }

            public void stackFrameChanged() {
                this.updateActions();
            }

            private void updateActions() {
                UIUtil.invokeLaterIfNeeded(() -> XDebugSessionImpl.this.mySessionTab.getUi().updateActionsNow());
            }
        });
    }

    @NotNull
    public XDebugSessionData getSessionData() {
        XDebugSessionData xDebugSessionData = this.mySessionData;
        if (xDebugSessionData == null) {
            XDebugSessionImpl.$$$reportNull$$$0(11);
        }
        return xDebugSessionData;
    }

    private void disableSlaveBreakpoints() {
        Set<XBreakpoint<?>> slaveBreakpoints = this.myDebuggerManager.getBreakpointManager().getDependentBreakpointManager().getAllSlaveBreakpoints();
        if (slaveBreakpoints.isEmpty()) {
            return;
        }
        HashSet<XBreakpointType> breakpointTypes = new HashSet<XBreakpointType>();
        for (XBreakpointHandler handler2 : this.myDebugProcess.getBreakpointHandlers()) {
            breakpointTypes.add(XDebugSessionImpl.getBreakpointTypeClass(handler2));
        }
        for (XBreakpoint xBreakpoint : slaveBreakpoints) {
            if (!breakpointTypes.contains(xBreakpoint.getType())) continue;
            this.myInactiveSlaveBreakpoints.add(xBreakpoint);
        }
    }

    public void showSessionTab() {
        RunContentDescriptor descriptor2 = this.getRunContentDescriptor();
        RunContentManager.getInstance((Project)this.getProject()).showRunContent(DefaultDebugExecutor.getDebugExecutorInstance(), descriptor2);
    }

    @Nullable
    public XValueMarkers<?, ?> getValueMarkers() {
        XValueMarkerProvider provider2;
        if (this.myValueMarkers == null && (provider2 = this.myDebugProcess.createValueMarkerProvider()) != null) {
            this.myValueMarkers = XValueMarkers.createValueMarkers(provider2);
        }
        return this.myValueMarkers;
    }

    private static XBreakpointType getBreakpointTypeClass(XBreakpointHandler handler2) {
        return XDebuggerUtil.getInstance().findBreakpointType(handler2.getBreakpointTypeClass());
    }

    private <B extends XBreakpoint<?>> void processBreakpoints(XBreakpointHandler<B> handler2, boolean register2, boolean temporary) {
        Collection breakpoints = this.myDebuggerManager.getBreakpointManager().getBreakpoints(handler2.getBreakpointTypeClass());
        for (XBreakpoint b : breakpoints) {
            this.handleBreakpoint(handler2, b, register2, temporary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <B extends XBreakpoint<?>> void handleBreakpoint(XBreakpointHandler<B> handler2, B b, boolean register2, boolean temporary) {
        if (register2) {
            boolean active2 = (Boolean)ReadAction.compute(() -> this.isBreakpointActive(b));
            if (active2) {
                Map<XBreakpoint<?>, CustomizedBreakpointPresentation> map2 = this.myRegisteredBreakpoints;
                synchronized (map2) {
                    this.myRegisteredBreakpoints.put(b, new CustomizedBreakpointPresentation());
                    if (b instanceof XLineBreakpoint) {
                        this.updateBreakpointPresentation((XLineBreakpoint)b, b.getType().getPendingIcon(), null);
                    }
                }
                handler2.registerBreakpoint(b);
            }
        } else {
            boolean removed;
            Map<XBreakpoint<?>, CustomizedBreakpointPresentation> map3 = this.myRegisteredBreakpoints;
            synchronized (map3) {
                removed = this.myRegisteredBreakpoints.remove(b) != null;
            }
            if (removed) {
                handler2.unregisterBreakpoint(b, temporary);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CustomizedBreakpointPresentation getBreakpointPresentation(@NotNull XBreakpoint<?> breakpoint) {
        if (breakpoint == null) {
            XDebugSessionImpl.$$$reportNull$$$0(12);
        }
        Map<XBreakpoint<?>, CustomizedBreakpointPresentation> map2 = this.myRegisteredBreakpoints;
        synchronized (map2) {
            return this.myRegisteredBreakpoints.get(breakpoint);
        }
    }

    private void processAllHandlers(XBreakpoint<?> breakpoint, boolean register2) {
        for (XBreakpointHandler handler2 : this.myDebugProcess.getBreakpointHandlers()) {
            this.processBreakpoint(breakpoint, handler2, register2);
        }
    }

    private <B extends XBreakpoint<?>> void processBreakpoint(XBreakpoint<?> breakpoint, XBreakpointHandler<B> handler2, boolean register2) {
        XBreakpointType type = breakpoint.getType();
        if (handler2.getBreakpointTypeClass().equals(type.getClass())) {
            XBreakpoint<?> b = breakpoint;
            this.handleBreakpoint(handler2, b, register2, false);
        }
    }

    public boolean isBreakpointActive(@NotNull XBreakpoint<?> b) {
        if (b == null) {
            XDebugSessionImpl.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return !this.areBreakpointsMuted() && b.isEnabled() && !this.isInactiveSlaveBreakpoint(b) && !((XBreakpointBase)b).isDisposed();
    }

    public boolean areBreakpointsMuted() {
        return this.mySessionData.isBreakpointsMuted();
    }

    public void addSessionListener(@NotNull XDebugSessionListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            XDebugSessionImpl.$$$reportNull$$$0(14);
        }
        if (parentDisposable == null) {
            XDebugSessionImpl.$$$reportNull$$$0(15);
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void addSessionListener(@NotNull XDebugSessionListener listener2) {
        if (listener2 == null) {
            XDebugSessionImpl.$$$reportNull$$$0(16);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void removeSessionListener(@NotNull XDebugSessionListener listener2) {
        if (listener2 == null) {
            XDebugSessionImpl.$$$reportNull$$$0(17);
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public void setBreakpointMuted(boolean muted) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.areBreakpointsMuted() == muted) {
            return;
        }
        this.mySessionData.setBreakpointsMuted(muted);
        if (!this.myBreakpointsDisabled) {
            this.processAllBreakpoints(!muted, muted);
        }
        this.myDebuggerManager.getBreakpointManager().getLineBreakpointManager().queueAllBreakpointsUpdate();
        ((XDebugSessionListener)this.myDispatcher.getMulticaster()).breakpointsMuted(muted);
    }

    public void stepOver(boolean ignoreBreakpoints) {
        this.rememberUserActionStart("Step Over");
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        if (ignoreBreakpoints) {
            this.setBreakpointsDisabledTemporarily(true);
        }
        this.myDebugProcess.startStepOver(this.doResume());
    }

    public void stepInto() {
        this.rememberUserActionStart("Step Into");
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        this.myDebugProcess.startStepInto(this.doResume());
    }

    public void stepOut() {
        this.rememberUserActionStart("Step Out");
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        this.myDebugProcess.startStepOut(this.doResume());
    }

    public <V extends XSmartStepIntoVariant> void smartStepInto(XSmartStepIntoHandler<V> handler2, V variant) {
        this.rememberUserActionStart("Smart Step Into");
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        XSuspendContext context2 = this.doResume();
        handler2.startStepInto(variant, context2);
    }

    public void forceStepInto() {
        this.rememberUserActionStart("Force Step Into");
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        this.myDebugProcess.startForceStepInto(this.doResume());
    }

    public void runToPosition(@NotNull XSourcePosition position, boolean ignoreBreakpoints) {
        if (position == null) {
            XDebugSessionImpl.$$$reportNull$$$0(18);
        }
        this.rememberUserActionStart("Run To Cursor");
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        if (ignoreBreakpoints) {
            this.setBreakpointsDisabledTemporarily(true);
        }
        this.myDebugProcess.runToPosition(position, this.doResume());
    }

    public void pause() {
        this.rememberUserActionStart("Pause");
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        this.myDebugProcess.startPausing();
    }

    private void processAllBreakpoints(boolean register2, boolean temporary) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        for (XBreakpointHandler handler2 : this.myDebugProcess.getBreakpointHandlers()) {
            this.processBreakpoints(handler2, register2, temporary);
        }
    }

    private void setBreakpointsDisabledTemporarily(boolean disabled) {
        ApplicationManager.getApplication().runReadAction(() -> {
            if (this.myBreakpointsDisabled == disabled) {
                return;
            }
            this.myBreakpointsDisabled = disabled;
            if (!this.areBreakpointsMuted()) {
                this.processAllBreakpoints(!disabled, disabled);
            }
        });
    }

    public void resume() {
        this.rememberUserActionStart("Resume");
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        this.myDebugProcess.resume(this.doResume());
    }

    @Nullable
    private XSuspendContext doResume() {
        if (!this.myPaused.getAndSet(false)) {
            return null;
        }
        ((XDebugSessionListener)this.myDispatcher.getMulticaster()).beforeSessionResume();
        XSuspendContext context2 = this.mySuspendContext;
        this.clearPausedData();
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.mySessionTab != null) {
                this.mySessionTab.getUi().clearAttractionBy("breakpoint");
            }
        });
        ((XDebugSessionListener)this.myDispatcher.getMulticaster()).sessionResumed();
        return context2;
    }

    private void clearPausedData() {
        this.mySuspendContext = null;
        this.myCurrentExecutionStack = null;
        this.myCurrentStackFrame = null;
        this.myTopFramePosition = null;
        this.clearActiveNonLineBreakpoint(false);
        this.updateExecutionPosition();
    }

    public void updateExecutionPosition() {
        if (this.myDebuggerManager.getCurrentSession() == this) {
            boolean isTopFrame = this.isTopFrameSelected();
            this.myDebuggerManager.updateExecutionPoint(this.getCurrentPosition(), !isTopFrame, this.getPositionIconRenderer(isTopFrame));
        }
    }

    public boolean isTopFrameSelected() {
        return this.myCurrentExecutionStack != null && this.myIsTopFrame;
    }

    public void showExecutionPoint() {
        XStackFrame topFrame;
        XExecutionStack executionStack;
        if (this.mySuspendContext != null && (executionStack = this.mySuspendContext.getActiveExecutionStack()) != null && (topFrame = executionStack.getTopFrame()) != null) {
            this.setCurrentStackFrame(executionStack, topFrame, true);
            this.myDebuggerManager.showExecutionPosition();
        }
    }

    public void setCurrentStackFrame(@NotNull XExecutionStack executionStack, @NotNull XStackFrame frame, boolean isTopFrame) {
        if (executionStack == null) {
            XDebugSessionImpl.$$$reportNull$$$0(19);
        }
        if (frame == null) {
            XDebugSessionImpl.$$$reportNull$$$0(20);
        }
        if (this.mySuspendContext == null) {
            return;
        }
        boolean frameChanged = this.myCurrentStackFrame != frame;
        this.myCurrentExecutionStack = executionStack;
        this.myCurrentStackFrame = frame;
        this.myIsTopFrame = isTopFrame;
        if (frameChanged) {
            ((XDebugSessionListener)this.myDispatcher.getMulticaster()).stackFrameChanged();
        }
        this.activateSession();
    }

    void activateSession() {
        this.myDebuggerManager.setCurrentSession(this);
        this.updateExecutionPosition();
    }

    public XBreakpoint<?> getActiveNonLineBreakpoint() {
        Pair<XBreakpoint<?>, XSourcePosition> pair = this.myActiveNonLineBreakpoint.get();
        if (pair != null) {
            XSourcePosition breakpointPosition = (XSourcePosition)pair.getSecond();
            XSourcePosition position = this.getTopFramePosition();
            if (breakpointPosition == null || position != null && (!breakpointPosition.getFile().equals(position.getFile()) || breakpointPosition.getLine() != position.getLine())) {
                return (XBreakpoint)pair.getFirst();
            }
        }
        return null;
    }

    @Nullable
    private GutterIconRenderer getPositionIconRenderer(boolean isTopFrame) {
        if (!isTopFrame) {
            return null;
        }
        XBreakpoint<?> activeNonLineBreakpoint = this.getActiveNonLineBreakpoint();
        if (activeNonLineBreakpoint != null) {
            return ((XBreakpointBase)activeNonLineBreakpoint).createGutterIconRenderer();
        }
        if (this.myCurrentExecutionStack != null) {
            return this.myCurrentExecutionStack.getExecutionLineIconRenderer();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBreakpointPresentation(@NotNull XLineBreakpoint<?> breakpoint, @Nullable Icon icon2, @Nullable String errorMessage) {
        if (breakpoint == null) {
            XDebugSessionImpl.$$$reportNull$$$0(21);
        }
        Map<XBreakpoint<?>, CustomizedBreakpointPresentation> map2 = this.myRegisteredBreakpoints;
        synchronized (map2) {
            CustomizedBreakpointPresentation presentation2 = this.myRegisteredBreakpoints.get(breakpoint);
            if (presentation2 == null || Comparing.equal((Object)presentation2.getIcon(), (Object)icon2) && Comparing.strEqual((String)presentation2.getErrorMessage(), (String)errorMessage)) {
                return;
            }
            presentation2.setErrorMessage(errorMessage);
            presentation2.setIcon(icon2);
            long timestamp = presentation2.getTimestamp();
            if (timestamp != 0L && XDebuggerUtilImpl.getVerifiedIcon(breakpoint).equals(icon2)) {
                long delay = System.currentTimeMillis() - timestamp;
                presentation2.setTimestamp(0L);
                BreakpointsUsageCollector.reportBreakpointVerified(breakpoint, delay);
            }
        }
        XBreakpointManagerImpl debuggerManager = this.myDebuggerManager.getBreakpointManager();
        debuggerManager.getLineBreakpointManager().queueBreakpointUpdate((XLineBreakpointImpl)breakpoint);
        debuggerManager.fireBreakpointPresentationUpdated((XBreakpoint<?>)breakpoint, this);
    }

    public void setBreakpointVerified(@NotNull XLineBreakpoint<?> breakpoint) {
        if (breakpoint == null) {
            XDebugSessionImpl.$$$reportNull$$$0(22);
        }
        this.updateBreakpointPresentation(breakpoint, XDebuggerUtilImpl.getVerifiedIcon(breakpoint), null);
    }

    public void setBreakpointInvalid(@NotNull XLineBreakpoint<?> breakpoint, @Nullable String errorMessage) {
        if (breakpoint == null) {
            XDebugSessionImpl.$$$reportNull$$$0(23);
        }
        this.updateBreakpointPresentation(breakpoint, AllIcons.Debugger.Db_invalid_breakpoint, errorMessage);
    }

    public boolean breakpointReached(@NotNull XBreakpoint<?> breakpoint, @NotNull XSuspendContext suspendContext) {
        if (breakpoint == null) {
            XDebugSessionImpl.$$$reportNull$$$0(24);
        }
        if (suspendContext == null) {
            XDebugSessionImpl.$$$reportNull$$$0(25);
        }
        return this.breakpointReached(breakpoint, null, suspendContext);
    }

    public boolean breakpointReached(@NotNull XBreakpoint<?> breakpoint, @Nullable String evaluatedLogExpression, @NotNull XSuspendContext suspendContext) {
        if (breakpoint == null) {
            XDebugSessionImpl.$$$reportNull$$$0(26);
        }
        if (suspendContext == null) {
            XDebugSessionImpl.$$$reportNull$$$0(27);
        }
        return this.breakpointReached(breakpoint, evaluatedLogExpression, suspendContext, true);
    }

    public void breakpointReachedNoProcessing(@NotNull XBreakpoint<?> breakpoint, @NotNull XSuspendContext suspendContext) {
        if (breakpoint == null) {
            XDebugSessionImpl.$$$reportNull$$$0(28);
        }
        if (suspendContext == null) {
            XDebugSessionImpl.$$$reportNull$$$0(29);
        }
        this.breakpointReached(breakpoint, null, suspendContext, false);
    }

    private boolean breakpointReached(@NotNull XBreakpoint<?> breakpoint, @Nullable String evaluatedLogExpression, @NotNull XSuspendContext suspendContext, boolean doProcessing) {
        if (breakpoint == null) {
            XDebugSessionImpl.$$$reportNull$$$0(30);
        }
        if (suspendContext == null) {
            XDebugSessionImpl.$$$reportNull$$$0(31);
        }
        if (doProcessing) {
            if (breakpoint.isLogMessage()) {
                XSourcePosition position = breakpoint.getSourcePosition();
                OpenFileHyperlinkInfo hyperlinkInfo = position != null ? new OpenFileHyperlinkInfo(this.myProject, position.getFile(), position.getLine()) : null;
                this.printMessage(XDebuggerBundle.message((String)"xbreakpoint.reached.text", (Object[])new Object[0]) + " ", XBreakpointUtil.getShortText(breakpoint), (HyperlinkInfo)hyperlinkInfo);
            }
            if (breakpoint.isLogStack()) {
                this.myDebugProcess.logStack(suspendContext, (XDebugSession)this);
            }
            if (evaluatedLogExpression != null) {
                this.printMessage(evaluatedLogExpression, null, null);
            }
            this.processDependencies(breakpoint);
            if (breakpoint.getSuspendPolicy() == SuspendPolicy.NONE) {
                return false;
            }
        }
        BP_NOTIFICATION_GROUP.createNotification(XDebuggerBundle.message((String)"xdebugger.breakpoint.reached", (Object[])new Object[0]), MessageType.INFO).notify(this.getProject());
        if (!(breakpoint instanceof XLineBreakpoint) || ((XLineBreakpoint)breakpoint).getType().canBeHitInOtherPlaces()) {
            this.myActiveNonLineBreakpoint.set(Pair.create(breakpoint, (Object)breakpoint.getSourcePosition()));
        } else {
            this.myActiveNonLineBreakpoint.set(null);
        }
        this.myDebuggerManager.setCurrentSession(this);
        this.positionReachedInternal(suspendContext, true);
        if (doProcessing && breakpoint instanceof XLineBreakpoint && ((XLineBreakpoint)breakpoint).isTemporary()) {
            this.handleTemporaryBreakpointHit(breakpoint);
        }
        return true;
    }

    private void handleTemporaryBreakpointHit(final XBreakpoint<?> breakpoint) {
        this.addSessionListener(new XDebugSessionListener(){

            private void removeBreakpoint() {
                XDebuggerUtil.getInstance().removeBreakpoint(XDebugSessionImpl.this.myProject, breakpoint);
                XDebugSessionImpl.this.removeSessionListener(this);
            }

            public void sessionResumed() {
                this.removeBreakpoint();
            }

            public void sessionStopped() {
                this.removeBreakpoint();
            }
        });
    }

    public void processDependencies(XBreakpoint<?> breakpoint) {
        boolean added2;
        XDependentBreakpointManager dependentBreakpointManager = this.myDebuggerManager.getBreakpointManager().getDependentBreakpointManager();
        if (!dependentBreakpointManager.isMasterOrSlave(breakpoint)) {
            return;
        }
        List<XBreakpoint<?>> breakpoints = dependentBreakpointManager.getSlaveBreakpoints(breakpoint);
        this.myInactiveSlaveBreakpoints.removeAll(breakpoints);
        for (XBreakpoint<?> slaveBreakpoint : breakpoints) {
            this.processAllHandlers(slaveBreakpoint, true);
        }
        if (dependentBreakpointManager.getMasterBreakpoint(breakpoint) != null && !dependentBreakpointManager.isLeaveEnabled(breakpoint) && (added2 = this.myInactiveSlaveBreakpoints.add(breakpoint))) {
            this.processAllHandlers(breakpoint, false);
            this.myDebuggerManager.getBreakpointManager().getLineBreakpointManager().queueBreakpointUpdate(breakpoint);
        }
    }

    private void printMessage(String message2, String hyperLinkText, @Nullable HyperlinkInfo info2) {
        AppUIUtil.invokeOnEdt(() -> {
            this.myConsoleView.print(message2, ConsoleViewContentType.SYSTEM_OUTPUT);
            if (info2 != null) {
                this.myConsoleView.printHyperlink(hyperLinkText, info2);
            } else if (hyperLinkText != null) {
                this.myConsoleView.print(hyperLinkText, ConsoleViewContentType.SYSTEM_OUTPUT);
            }
            this.myConsoleView.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        });
    }

    public void unsetPaused() {
        this.myPaused.set(false);
    }

    private void positionReachedInternal(@NotNull XSuspendContext suspendContext, boolean attract) {
        if (suspendContext == null) {
            XDebugSessionImpl.$$$reportNull$$$0(32);
        }
        this.setBreakpointsDisabledTemporarily(false);
        this.mySuspendContext = suspendContext;
        this.myCurrentExecutionStack = suspendContext.getActiveExecutionStack();
        this.myCurrentStackFrame = this.myCurrentExecutionStack != null ? this.myCurrentExecutionStack.getTopFrame() : null;
        this.myIsTopFrame = true;
        this.myTopFramePosition = this.myCurrentStackFrame != null ? this.myCurrentStackFrame.getSourcePosition() : null;
        this.myPaused.set(true);
        this.updateExecutionPosition();
        this.logPerformanceEvent("Position reached");
        boolean showOnSuspend = this.myShowTabOnSuspend.compareAndSet(true, false);
        if (showOnSuspend || attract) {
            AppUIUtil.invokeLaterIfProjectAlive(this.myProject, () -> {
                if (showOnSuspend) {
                    this.initSessionTab(null);
                    this.showSessionTab();
                }
                if (attract) {
                    if (this.mySessionTab == null) {
                        LOG.debug("Cannot request focus because Session Tab is not initialized yet");
                        return;
                    }
                    if (XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().isShowDebuggerOnBreakpoint()) {
                        this.mySessionTab.toFront(true, this::updateExecutionPosition);
                    }
                    if (this.myTopFramePosition == null) {
                        XDebugSessionTab.showFramesView(this);
                    }
                    this.mySessionTab.getUi().attractBy("breakpoint");
                }
            });
        }
        ((XDebugSessionListener)this.myDispatcher.getMulticaster()).sessionPaused();
    }

    public void positionReached(@NotNull XSuspendContext suspendContext) {
        if (suspendContext == null) {
            XDebugSessionImpl.$$$reportNull$$$0(33);
        }
        this.positionReached(suspendContext, false);
    }

    public void positionReached(@NotNull XSuspendContext suspendContext, boolean attract) {
        if (suspendContext == null) {
            XDebugSessionImpl.$$$reportNull$$$0(34);
        }
        this.clearActiveNonLineBreakpoint(false);
        this.positionReachedInternal(suspendContext, attract);
    }

    public void sessionResumed() {
        this.doResume();
    }

    public boolean isStopped() {
        return this.myStopped.get();
    }

    private void stopImpl() {
        if (!this.myStopped.compareAndSet(false, true)) {
            return;
        }
        try {
            this.removeBreakpointListeners();
        }
        finally {
            this.myDebugProcess.stopAsync().onSuccess(aVoid -> {
                if (!this.myProject.isDisposed()) {
                    ((XDebuggerManagerListener)this.myProject.getMessageBus().syncPublisher(XDebuggerManager.TOPIC)).processStopped(this.myDebugProcess);
                }
                if (this.mySessionTab != null) {
                    AppUIUtil.invokeOnEdt(() -> {
                        ((XWatchesViewImpl)this.mySessionTab.getWatchesView()).updateSessionData();
                        this.mySessionTab.detachFromSession();
                    });
                } else if (this.myConsoleView != null) {
                    AppUIUtil.invokeOnEdt(() -> Disposer.dispose((Disposable)this.myConsoleView));
                }
                this.clearPausedData();
                if (this.myValueMarkers != null) {
                    this.myValueMarkers.clear();
                }
                if (XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().isUnmuteOnStop()) {
                    this.mySessionData.setBreakpointsMuted(false);
                }
                this.myDebuggerManager.removeSession(this);
                ((XDebugSessionListener)this.myDispatcher.getMulticaster()).sessionStopped();
                this.myDispatcher.getListeners().clear();
                this.myProject.putUserData(XDebuggerEditorLinePainter.CACHE, null);
                Map<XBreakpoint<?>, CustomizedBreakpointPresentation> map2 = this.myRegisteredBreakpoints;
                synchronized (map2) {
                    this.myRegisteredBreakpoints.clear();
                }
            });
        }
    }

    private void removeBreakpointListeners() {
        Disposable breakpointListenerDisposable = this.myBreakpointListenerDisposable;
        if (breakpointListenerDisposable != null) {
            this.myBreakpointListenerDisposable = null;
            Disposer.dispose((Disposable)breakpointListenerDisposable);
        }
    }

    public boolean isInactiveSlaveBreakpoint(XBreakpoint<?> breakpoint) {
        return this.myInactiveSlaveBreakpoints.contains(breakpoint);
    }

    public void stop() {
        ProcessHandler processHandler2;
        ProcessHandler processHandler3 = processHandler2 = this.myDebugProcess == null ? null : this.myDebugProcess.getProcessHandler();
        if (processHandler2 == null || processHandler2.isProcessTerminated() || processHandler2.isProcessTerminating()) {
            return;
        }
        if (processHandler2.detachIsDefault()) {
            processHandler2.detachProcess();
        } else {
            processHandler2.destroyProcess();
        }
    }

    public void reportError(@NotNull String message2) {
        if (message2 == null) {
            XDebugSessionImpl.$$$reportNull$$$0(35);
        }
        this.reportMessage(message2, MessageType.ERROR);
    }

    public void reportMessage(@NotNull String message2, @NotNull MessageType type) {
        if (message2 == null) {
            XDebugSessionImpl.$$$reportNull$$$0(36);
        }
        if (type == null) {
            XDebugSessionImpl.$$$reportNull$$$0(37);
        }
        this.reportMessage(message2, type, null);
    }

    public void reportMessage(@NotNull String message2, @NotNull MessageType type, @Nullable HyperlinkListener listener2) {
        if (message2 == null) {
            XDebugSessionImpl.$$$reportNull$$$0(38);
        }
        if (type == null) {
            XDebugSessionImpl.$$$reportNull$$$0(39);
        }
        Notification notification = XDebuggerManagerImpl.getNotificationGroup().createNotification(message2, type.toNotificationType());
        if (listener2 != null) {
            notification.setListener((__, event) -> {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    listener2.hyperlinkUpdate(event);
                }
            });
        }
        notification.notify(this.myProject);
    }

    public void clearActiveNonLineBreakpoint(boolean updateExecutionPointIcon) {
        this.myActiveNonLineBreakpoint.set(null);
        if (updateExecutionPointIcon) {
            this.myDebuggerManager.updateExecutionPoint(this.getPositionIconRenderer(this.isTopFrameSelected()));
        }
    }

    @NotNull
    private String getConfigurationName() {
        RunProfile profile;
        if (this.myEnvironment != null && (profile = this.myEnvironment.getRunProfile()) instanceof RunConfiguration) {
            String string = ((RunConfiguration)profile).getType().getId();
            if (string == null) {
                XDebugSessionImpl.$$$reportNull$$$0(40);
            }
            return string;
        }
        String string = this.getSessionName();
        if (string == null) {
            XDebugSessionImpl.$$$reportNull$$$0(41);
        }
        return string;
    }

    public void setWatchExpressions(@NotNull List<XExpression> watchExpressions) {
        if (watchExpressions == null) {
            XDebugSessionImpl.$$$reportNull$$$0(42);
        }
        this.mySessionData.setWatchExpressions(watchExpressions);
        this.myDebuggerManager.getWatchesManager().setWatches(this.getConfigurationName(), watchExpressions);
    }

    List<XExpression> getWatchExpressions() {
        return this.myDebuggerManager.getWatchesManager().getWatches(this.getConfigurationName());
    }

    @Nullable
    public ExecutionEnvironment getExecutionEnvironment() {
        return this.myEnvironment;
    }

    private void rememberUserActionStart(String action2) {
        if (PERFORMANCE_LOG.isDebugEnabled()) {
            this.myUserRequestStart = System.currentTimeMillis();
        }
    }

    private void logPerformanceEvent(String event) {
        if (this.myUserRequestStart > 0L && PERFORMANCE_LOG.isDebugEnabled()) {
            PERFORMANCE_LOG.debug(event + " in " + (System.currentTimeMillis() - this.myUserRequestStart) + "ms");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 40: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 40: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/XDebugSessionImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 12: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionStack";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
            case 35: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/XDebugSessionImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunContentDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestartActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugProcess";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionData";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 40: 
            case 41: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getBreakpointPresentation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isBreakpointActive";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addSessionListener";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeSessionListener";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "runToPosition";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentStackFrame";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateBreakpointPresentation";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setBreakpointVerified";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setBreakpointInvalid";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "breakpointReached";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "breakpointReachedNoProcessing";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "positionReachedInternal";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "positionReached";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "reportMessage";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setWatchExpressions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 40: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDependentBreakpointListener
    implements XDependentBreakpointListener {
        private MyDependentBreakpointListener() {
        }

        @Override
        public void dependencySet(@NotNull XBreakpoint<?> slave, @NotNull XBreakpoint<?> master) {
            boolean added2;
            if (slave == null) {
                MyDependentBreakpointListener.$$$reportNull$$$0(0);
            }
            if (master == null) {
                MyDependentBreakpointListener.$$$reportNull$$$0(1);
            }
            if (added2 = XDebugSessionImpl.this.myInactiveSlaveBreakpoints.add(slave)) {
                XDebugSessionImpl.this.processAllHandlers(slave, false);
            }
        }

        @Override
        public void dependencyCleared(XBreakpoint<?> breakpoint) {
            boolean removed = XDebugSessionImpl.this.myInactiveSlaveBreakpoints.remove(breakpoint);
            if (removed) {
                XDebugSessionImpl.this.processAllHandlers(breakpoint, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "slave";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "master";
                    break;
                }
            }
            objectArray[1] = "com/intellij/xdebugger/impl/XDebugSessionImpl$MyDependentBreakpointListener";
            objectArray[2] = "dependencySet";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyBreakpointListener
    implements XBreakpointListener<XBreakpoint<?>> {
        private MyBreakpointListener() {
        }

        public void breakpointAdded(@NotNull XBreakpoint<?> breakpoint) {
            CustomizedBreakpointPresentation presentation2;
            if (breakpoint == null) {
                MyBreakpointListener.$$$reportNull$$$0(0);
            }
            if (this.processAdd(breakpoint) && (presentation2 = XDebugSessionImpl.this.getBreakpointPresentation(breakpoint)) != null) {
                if (XDebuggerUtilImpl.getVerifiedIcon(breakpoint).equals(presentation2.getIcon())) {
                    BreakpointsUsageCollector.reportBreakpointVerified(breakpoint, 0L);
                } else {
                    presentation2.setTimestamp(System.currentTimeMillis());
                }
            }
        }

        public void breakpointRemoved(@NotNull XBreakpoint<?> breakpoint) {
            if (breakpoint == null) {
                MyBreakpointListener.$$$reportNull$$$0(1);
            }
            if (XDebugSessionImpl.this.getActiveNonLineBreakpoint() == breakpoint) {
                XDebugSessionImpl.this.clearActiveNonLineBreakpoint(true);
            }
            this.processRemove(breakpoint);
        }

        void processRemove(@NotNull XBreakpoint<?> breakpoint) {
            if (breakpoint == null) {
                MyBreakpointListener.$$$reportNull$$$0(2);
            }
            XDebugSessionImpl.this.processAllHandlers(breakpoint, false);
        }

        boolean processAdd(@NotNull XBreakpoint<?> breakpoint) {
            if (breakpoint == null) {
                MyBreakpointListener.$$$reportNull$$$0(3);
            }
            if (!XDebugSessionImpl.this.myBreakpointsDisabled) {
                XDebugSessionImpl.this.processAllHandlers(breakpoint, true);
                return true;
            }
            return false;
        }

        public void breakpointChanged(@NotNull XBreakpoint<?> breakpoint) {
            if (breakpoint == null) {
                MyBreakpointListener.$$$reportNull$$$0(4);
            }
            this.processRemove(breakpoint);
            this.processAdd(breakpoint);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "breakpoint";
            objectArray2[1] = "com/intellij/xdebugger/impl/XDebugSessionImpl$MyBreakpointListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "breakpointAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "breakpointRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processRemove";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processAdd";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "breakpointChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

