/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.popup.util.ItemWrapper;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;

public abstract class BreakpointItem
extends ItemWrapper
implements Comparable<BreakpointItem>,
Navigatable {
    public static final Key<Object> EDITOR_ONLY = Key.create((String)"EditorOnly");

    public abstract void saveState();

    public abstract Object getBreakpoint();

    public abstract boolean isEnabled();

    public abstract void setEnabled(boolean var1);

    public abstract boolean isDefaultBreakpoint();

    public void updateAccessoryView(JComponent component2) {
        JCheckBox checkBox2 = (JCheckBox)component2;
        checkBox2.setSelected(this.isEnabled());
    }

    public void setupRenderer(ColoredListCellRenderer renderer2, Project project, boolean selected2) {
        this.setupGenericRenderer((SimpleColoredComponent)renderer2, true);
    }

    public void setupRenderer(ColoredTreeCellRenderer renderer2, Project project, boolean selected2) {
        boolean plainView = renderer2.getTree().getClientProperty("plainView") != null;
        this.setupGenericRenderer((SimpleColoredComponent)renderer2, plainView);
    }

    public abstract void setupGenericRenderer(SimpleColoredComponent var1, boolean var2);

    public abstract Icon getIcon();

    @Nls
    public abstract String getDisplayText();

    protected void dispose() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BreakpointItem item = (BreakpointItem)o;
        return !(this.getBreakpoint() != null ? !this.getBreakpoint().equals(item.getBreakpoint()) : item.getBreakpoint() != null);
    }

    public int hashCode() {
        return this.getBreakpoint() != null ? this.getBreakpoint().hashCode() : 0;
    }
}

