/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.openapi.project.Project;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.XDebuggerWatchesManager;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.inline.InlineWatch;
import com.intellij.xdebugger.impl.inline.InlineWatchNodeImpl;
import com.intellij.xdebugger.impl.inline.XInlineWatchesView;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeInplaceEditor;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchesRootNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import java.awt.Rectangle;
import java.util.Collections;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WatchInplaceEditor
extends XDebuggerTreeInplaceEditor {
    private final WatchesRootNode myRootNode;
    private final XWatchesView myWatchesView;
    private final WatchNode myOldNode;

    public WatchInplaceEditor(@NotNull WatchesRootNode rootNode, XWatchesView watchesView, WatchNode node2, @Nullable WatchNode oldNode) {
        if (rootNode == null) {
            WatchInplaceEditor.$$$reportNull$$$0(0);
        }
        super((XDebuggerTreeNode)((Object)node2), "watch");
        this.myRootNode = rootNode;
        this.myWatchesView = watchesView;
        this.myOldNode = oldNode;
        this.myExpressionEditor.setExpression(oldNode != null ? oldNode.getExpression() : null);
    }

    @Override
    public void cancelEditing() {
        if (!this.isShown()) {
            return;
        }
        super.cancelEditing();
        int index2 = this.myRootNode.getIndex(this.myNode);
        if (this.myOldNode == null && index2 != -1) {
            this.myRootNode.removeChildNode(this.myNode);
        }
        TreeUtil.selectNode((JTree)((Object)this.myTree), (TreeNode)this.myNode);
    }

    @Override
    public void doOKAction() {
        XExpression expression = this.getExpression();
        super.doOKAction();
        int index2 = this.myRootNode.removeChildNode(this.myNode);
        XDebuggerWatchesManager watchesManager = null;
        if (this.myNode instanceof InlineWatchNodeImpl) {
            InlineWatch inlineWatch = ((InlineWatchNodeImpl)this.myNode).getWatch();
            watchesManager = ((XDebuggerManagerImpl)XDebuggerManager.getInstance((Project)this.getProject())).getWatchesManager();
            watchesManager.inlineWatchesRemoved(Collections.singletonList(inlineWatch), (XInlineWatchesView)((Object)this.myWatchesView));
        }
        if (!XDebuggerUtilImpl.isEmptyExpression(expression) && index2 != -1) {
            if (this.myNode instanceof InlineWatchNodeImpl) {
                watchesManager.addInlineWatchExpression(expression, index2, ((InlineWatchNodeImpl)this.myNode).getPosition(), false);
            } else {
                this.myWatchesView.addWatchExpression(expression, index2, false);
            }
        }
        TreeUtil.selectNode((JTree)((Object)this.myTree), (TreeNode)this.myNode);
    }

    @Override
    @Nullable
    protected Rectangle getEditorBounds() {
        Rectangle bounds2 = super.getEditorBounds();
        if (bounds2 == null) {
            return null;
        }
        int afterIconX = this.getAfterIconX();
        bounds2.x += afterIconX;
        bounds2.width -= afterIconX;
        return bounds2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootNode", "com/intellij/xdebugger/impl/frame/WatchInplaceEditor", "<init>"));
    }
}

