/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.frame.DebuggerFramesList;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.FontUIResource;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerFramesList
extends DebuggerFramesList
implements DataProvider {
    private final Project myProject;
    private final Map<VirtualFile, Color> myFileColors;
    private static final DataKey<XDebuggerFramesList> FRAMES_LIST = DataKey.create("FRAMES_LIST");

    private void copyStack() {
        List items = this.getModel().getItems();
        if (!items.isEmpty()) {
            StringBuilder plainBuf = new StringBuilder();
            TextTransferable.ColoredStringBuilder coloredTextContainer = new TextTransferable.ColoredStringBuilder();
            for (Object value2 : items) {
                ItemWithSeparatorAbove item;
                if (value2 instanceof ItemWithSeparatorAbove && (item = (ItemWithSeparatorAbove)value2).hasSeparatorAbove()) {
                    String caption = " - " + StringUtil.notNullize((String)item.getCaptionAboveOf());
                    plainBuf.append(caption).append('\n');
                }
                if (value2 != null) {
                    if (value2 instanceof XStackFrame) {
                        ((XStackFrame)value2).customizePresentation((ColoredTextContainer)coloredTextContainer);
                        coloredTextContainer.appendTo(plainBuf);
                    } else {
                        String text2 = value2.toString();
                        plainBuf.append(text2);
                    }
                }
                plainBuf.append('\n');
            }
            plainBuf.setLength(plainBuf.length() - 1);
            String plainText = plainBuf.toString();
            CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable("<html><body><pre>\n" + XmlStringUtil.escapeString((String)plainText) + "\n</pre></body></html>", plainText));
        }
    }

    public XDebuggerFramesList(@NotNull Project project) {
        if (project == null) {
            XDebuggerFramesList.$$$reportNull$$$0(0);
        }
        this.myFileColors = new HashMap<VirtualFile, Color>();
        this.myProject = project;
        this.doInit();
        Font font = this.getFont();
        if (font != null) {
            this.setFont(new FontUIResource(font.getName(), font.getStyle(), font.getSize()));
        }
    }

    @Override
    @Nullable
    public Object getData(@NonNls @NotNull String dataId) {
        XStackFrame frame;
        if (dataId == null) {
            XDebuggerFramesList.$$$reportNull$$$0(1);
        }
        if (FRAMES_LIST.is(dataId)) {
            return this;
        }
        if (PlatformDataKeys.CONTEXT_MENU_POINT.is(dataId)) {
            Rectangle cellBounds;
            int index2 = this.getSelectedIndex();
            if (index2 != -1 && (cellBounds = this.getCellBounds(index2, index2)) != null) {
                Rectangle visibleRect = this.getVisibleRect();
                return new Point(visibleRect.x + visibleRect.width / 4, cellBounds.y + cellBounds.height - 1);
            }
            return null;
        }
        if (PlatformCoreDataKeys.SLOW_DATA_PROVIDERS.is(dataId) && (frame = this.getSelectedFrame()) != null) {
            return List.of(realDataId -> this.getSlowData(frame, realDataId));
        }
        return null;
    }

    @Nullable
    private Object getSlowData(@NotNull XStackFrame frame, @NonNls String dataId) {
        VirtualFile file2;
        if (frame == null) {
            XDebuggerFramesList.$$$reportNull$$$0(2);
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return this.getFrameNavigatable(frame);
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return XDebuggerFramesList.getFile(frame);
        }
        if (CommonDataKeys.PSI_FILE.is(dataId) && (file2 = XDebuggerFramesList.getFile(frame)) != null && file2.isValid()) {
            return PsiManager.getInstance((Project)this.myProject).findFile(file2);
        }
        return null;
    }

    @Override
    public void clear() {
        super.clear();
        this.myFileColors.clear();
    }

    public boolean selectFrame(@NotNull XStackFrame toSelect2) {
        if (toSelect2 == null) {
            XDebuggerFramesList.$$$reportNull$$$0(3);
        }
        if (!Objects.equals(this.getSelectedValue(), toSelect2) && this.getModel().contains((Object)toSelect2)) {
            this.setSelectedValue(toSelect2, true);
            return true;
        }
        return false;
    }

    public boolean selectFrame(int indexToSelect) {
        if (this.getSelectedIndex() != indexToSelect && this.getElementCount() > indexToSelect && this.getModel().getElementAt(indexToSelect) != null) {
            this.setSelectedIndex(indexToSelect);
            return true;
        }
        return false;
    }

    @Nullable
    public XStackFrame getSelectedFrame() {
        Object value2 = this.getSelectedValue();
        return value2 instanceof XStackFrame ? (XStackFrame)value2 : null;
    }

    @Override
    @Nullable
    protected Navigatable getSelectedFrameNavigatable() {
        Navigatable navigatable2;
        XStackFrame frame = this.getSelectedFrame();
        Navigatable navigatable3 = navigatable2 = frame != null ? this.getFrameNavigatable(frame) : null;
        if (navigatable2 instanceof OpenFileDescriptor) {
            ((OpenFileDescriptor)navigatable2).setUsePreviewTab(true);
        }
        return navigatable2 != null ? this.keepFocus(navigatable2) : null;
    }

    @NotNull
    private Navigatable keepFocus(final @NotNull Navigatable navigatable2) {
        FileEditorManagerEx fileEditorManager;
        boolean isEditorAreaFocused;
        if (navigatable2 == null) {
            XDebuggerFramesList.$$$reportNull$$$0(4);
        }
        return (isEditorAreaFocused = IJSwingUtilities.hasFocus((fileEditorManager = FileEditorManagerEx.getInstanceEx(this.myProject)).getComponent())) ? navigatable2 : new Navigatable(){

            public void navigate(boolean requestFocus) {
                navigatable2.navigate(false);
            }

            public boolean canNavigate() {
                return navigatable2.canNavigate();
            }

            public boolean canNavigateToSource() {
                return navigatable2.canNavigateToSource();
            }
        };
    }

    @Nullable
    private Navigatable getFrameNavigatable(@NotNull XStackFrame frame) {
        XSourcePosition position;
        if (frame == null) {
            XDebuggerFramesList.$$$reportNull$$$0(5);
        }
        return (position = frame.getSourcePosition()) != null ? position.createNavigatable(this.myProject) : null;
    }

    @Nullable
    private static VirtualFile getFile(XStackFrame frame) {
        XSourcePosition position = frame.getSourcePosition();
        return position != null ? position.getFile() : null;
    }

    @Override
    protected ListCellRenderer createListRenderer() {
        return new XDebuggerGroupedFrameListRenderer();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSelect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/frame/XDebuggerFramesList";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSlowData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "selectFrame";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "keepFocus";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getFrameNavigatable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class CopyStackAction
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyStackAction.$$$reportNull$$$0(0);
            }
            XDebuggerFramesList framesList = (XDebuggerFramesList)e.getData(FRAMES_LIST);
            e.getPresentation().setEnabledAndVisible(framesList != null && ContainerUtil.getLastItem((List)framesList.getModel().getItems()) != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            XDebuggerFramesList framesList;
            if (e == null) {
                CopyStackAction.$$$reportNull$$$0(1);
            }
            if ((framesList = (XDebuggerFramesList)e.getData(FRAMES_LIST)) != null) {
                framesList.copyStack();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/xdebugger/impl/frame/XDebuggerFramesList$CopyStackAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ItemWithCustomBackgroundColor {
        @Nullable
        public Color getBackgroundColor();
    }

    public static interface ItemWithSeparatorAbove {
        public boolean hasSeparatorAbove();

        @NlsContexts.Separator
        public String getCaptionAboveOf();
    }

    private class XDebuggerFrameListRenderer
    extends ColoredListCellRenderer {
        private final FileColorManager myColorsManager;

        XDebuggerFrameListRenderer(Project project) {
            if (project == null) {
                XDebuggerFrameListRenderer.$$$reportNull$$$0(0);
            }
            this.myColorsManager = FileColorManager.getInstance((Project)project);
        }

        protected void customizeCellRenderer(@NotNull JList list2, Object value2, int index2, boolean selected2, boolean hasFocus) {
            if (list2 == null) {
                XDebuggerFrameListRenderer.$$$reportNull$$$0(1);
            }
            if (value2 == null) {
                this.append(XDebuggerBundle.message((String)"stack.frame.loading.text", (Object[])new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
                return;
            }
            if (value2 instanceof String) {
                this.append((String)value2, SimpleTextAttributes.ERROR_ATTRIBUTES);
                return;
            }
            XStackFrame stackFrame = (XStackFrame)value2;
            if (!selected2) {
                Color c = this.getFrameBgColor(stackFrame);
                if (c != null) {
                    this.setBackground(c);
                }
            } else {
                this.setBackground(UIUtil.getListSelectionBackground((boolean)hasFocus));
                this.setForeground(UIUtil.getListSelectionForeground((boolean)hasFocus));
                this.mySelectionForeground = this.getForeground();
            }
            stackFrame.customizePresentation((ColoredTextContainer)((Object)this));
        }

        Color getFrameBgColor(XStackFrame stackFrame) {
            if (stackFrame instanceof ItemWithCustomBackgroundColor) {
                return ((ItemWithCustomBackgroundColor)stackFrame).getBackgroundColor();
            }
            VirtualFile virtualFile2 = XDebuggerFramesList.getFile(stackFrame);
            if (virtualFile2 != null) {
                if (XDebuggerFramesList.this.myFileColors.containsKey(virtualFile2)) {
                    return XDebuggerFramesList.this.myFileColors.get(virtualFile2);
                }
                if (virtualFile2.isValid()) {
                    Color color = this.myColorsManager.getFileColor(virtualFile2);
                    XDebuggerFramesList.this.myFileColors.put(virtualFile2, color);
                    return color;
                }
            } else {
                return this.myColorsManager.getScopeColor("Non-Project Files");
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/frame/XDebuggerFramesList$XDebuggerFrameListRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class XDebuggerGroupedFrameListRenderer
    extends GroupedItemsListRenderer {
        private final XDebuggerFrameListRenderer myOriginalRenderer;

        XDebuggerGroupedFrameListRenderer() {
            super((ListItemDescriptor)new ListItemDescriptorAdapter(){

                @Override
                @Nullable
                public String getTextFor(Object value2) {
                    return null;
                }

                @Override
                @Nullable
                public String getCaptionAboveOf(Object value2) {
                    return value2 instanceof ItemWithSeparatorAbove ? ((ItemWithSeparatorAbove)value2).getCaptionAboveOf() : null;
                }

                @Override
                public boolean hasSeparatorAboveOf(Object value2) {
                    return value2 instanceof ItemWithSeparatorAbove && ((ItemWithSeparatorAbove)value2).hasSeparatorAbove();
                }
            });
            this.myOriginalRenderer = new XDebuggerFrameListRenderer(XDebuggerFramesList.this.myProject);
            this.mySeparatorComponent.setCaptionCentered(false);
        }

        public Component getListCellRendererComponent(JList list2, Object value2, int index2, boolean isSelected, boolean cellHasFocus) {
            if (this.myDescriptor.hasSeparatorAboveOf(value2)) {
                Component component2 = super.getListCellRendererComponent(list2, value2, index2, isSelected, cellHasFocus);
                ((XDebuggerFrameListRenderer)((Object)this.myComponent)).getListCellRendererComponent(list2, value2, index2, isSelected, cellHasFocus);
                return component2;
            }
            return this.myOriginalRenderer.getListCellRendererComponent(list2, value2, index2, isSelected, cellHasFocus);
        }

        protected JComponent createItemComponent() {
            this.createLabel();
            return new XDebuggerFrameListRenderer(XDebuggerFramesList.this.myProject);
        }
    }
}

