/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.inline;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.impl.frame.WatchInplaceEditor;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.inline.InlineWatch;
import com.intellij.xdebugger.impl.inline.InlineWatchNode;
import com.intellij.xdebugger.impl.inline.InlineWatchNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchesRootNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueGroupNodeImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineWatchesRootNode
extends WatchesRootNode {
    @NotNull
    private final XWatchesView myWatchesView;
    private final XValueGroupNodeImpl myInlinesRootNode;
    private final InlinesGroup myInlinesGroup;

    public InlineWatchesRootNode(@NotNull XDebuggerTree tree, @NotNull XWatchesView watchesView, @NotNull List<XExpression> regularWatchesExpressions, @NotNull List<InlineWatch> inlineWatchesExpressions, @Nullable XStackFrame stackFrame, boolean watchesInVariables) {
        if (tree == null) {
            InlineWatchesRootNode.$$$reportNull$$$0(0);
        }
        if (watchesView == null) {
            InlineWatchesRootNode.$$$reportNull$$$0(1);
        }
        if (regularWatchesExpressions == null) {
            InlineWatchesRootNode.$$$reportNull$$$0(2);
        }
        if (inlineWatchesExpressions == null) {
            InlineWatchesRootNode.$$$reportNull$$$0(3);
        }
        super(tree, watchesView, regularWatchesExpressions, stackFrame, watchesInVariables);
        this.myWatchesView = watchesView;
        this.myInlinesGroup = new InlinesGroup(XDebuggerBundle.message((String)"debugger.inline.watches.group.name", (Object[])new Object[0]), true);
        this.myInlinesRootNode = new XValueGroupNodeImpl(tree, this, this.myInlinesGroup){

            @Override
            @NotNull
            public List<? extends TreeNode> getChildren() {
                List<InlineWatchNodeImpl> list2 = InlineWatchesRootNode.this.myInlinesGroup.getChildren();
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/inline/InlineWatchesRootNode$1", "getChildren"));
            }
        };
        for (InlineWatch watchExpression : inlineWatchesExpressions) {
            this.myInlinesGroup.getChildren().add(new InlineWatchNodeImpl(this.myTree, (XDebuggerTreeNode)this.myInlinesRootNode, watchExpression, stackFrame));
        }
    }

    public void addInlineWatchExpression(XStackFrame frame, InlineWatch watch, int index2, boolean navigateToWatchNode) {
        InlineWatchNodeImpl message2 = new InlineWatchNodeImpl(this.myTree, (XDebuggerTreeNode)this.myInlinesRootNode, watch, frame);
        if (index2 == -1) {
            this.myInlinesGroup.getChildren().add(message2);
            index2 = this.myInlinesGroup.getChildren().size() - 1;
        } else {
            this.myInlinesGroup.getChildren().add(index2, message2);
        }
        if (this.myInlinesGroup.getChildren().size() == 1) {
            this.myTree.getTreeModel().reload();
        }
        this.fireInlineNodeInserted(index2);
        message2.computePresentationIfNeeded();
        TreeUtil.selectNode((JTree)((Object)this.myTree), (TreeNode)message2);
        if (navigateToWatchNode) {
            this.myTree.scrollPathToVisible(message2.getPath());
        }
    }

    public void fireInlineNodeInserted(int index2) {
        this.myTree.getTreeModel().nodesWereInserted(this.myInlinesRootNode, new int[]{index2});
    }

    public void removeInlineChildren(List<InlineWatchNode> inlines) {
        List<? extends InlineWatchNode> children2 = this.getInlineWatchChildren();
        int[] indices = inlines.stream().mapToInt(node2 -> children2.indexOf(node2)).filter(ind -> ind >= 0).toArray();
        TreeNode[] removed = (TreeNode[])Arrays.stream(indices).mapToObj(ind -> (TreeNode)children2.get(ind)).toArray(TreeNode[]::new);
        children2.removeAll(inlines);
        if (indices.length > 0) {
            this.inlineNodeRemoved(indices, removed);
        }
        if (children2.size() == 0) {
            this.myTree.getTreeModel().nodesWereRemoved(this, new int[]{0}, new XValueGroupNodeImpl[]{this.myInlinesRootNode});
        }
    }

    private void inlineNodeRemoved(int[] indices, TreeNode[] removed) {
        this.myTree.getTreeModel().nodesWereRemoved(this.myInlinesRootNode, indices, removed);
        for (TreeNode node2 : removed) {
            ((InlineWatchNodeImpl)node2).nodeRemoved();
        }
    }

    @Override
    @NotNull
    public List<? extends XValueContainerNode<?>> getLoadedChildren() {
        List<? extends XValueContainerNode<?>> children2 = super.getLoadedChildren();
        if (this.inlinesRootNodeIsShown()) {
            List list2 = ContainerUtil.prepend(children2, (Object[])new XValueContainerNode[]{this.myInlinesRootNode});
            if (list2 == null) {
                InlineWatchesRootNode.$$$reportNull$$$0(4);
            }
            return list2;
        }
        List<? extends XValueContainerNode<?>> list3 = children2;
        if (list3 == null) {
            InlineWatchesRootNode.$$$reportNull$$$0(5);
        }
        return list3;
    }

    @Override
    @NotNull
    public List<? extends TreeNode> getChildren() {
        List<? extends TreeNode> children2 = super.getChildren();
        if (this.myInlinesRootNode != null && this.inlinesRootNodeIsShown()) {
            List list2 = ContainerUtil.prepend(children2, (Object[])new TreeNode[]{this.myInlinesRootNode});
            if (list2 == null) {
                InlineWatchesRootNode.$$$reportNull$$$0(6);
            }
            return list2;
        }
        List<? extends TreeNode> list3 = children2;
        if (list3 == null) {
            InlineWatchesRootNode.$$$reportNull$$$0(7);
        }
        return list3;
    }

    public boolean inlinesRootNodeIsShown() {
        return !this.getInlineWatchChildren().isEmpty();
    }

    @NotNull
    public List<? extends InlineWatchNode> getInlineWatchChildren() {
        List<InlineWatchNodeImpl> list2 = this.myInlinesGroup.myChildren;
        if (list2 == null) {
            InlineWatchesRootNode.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @Override
    public void clearChildren() {
        super.clearChildren();
        this.getInlineWatchChildren().clear();
    }

    @Override
    public void computeWatches() {
        super.computeWatches();
        this.getInlineWatchChildren().forEach(WatchNodeImpl::computePresentationIfNeeded);
    }

    @Override
    public int removeChildNode(XDebuggerTreeNode node2) {
        if (node2 instanceof InlineWatchNodeImpl) {
            List<? extends InlineWatchNode> children2 = this.getInlineWatchChildren();
            int index2 = children2.indexOf(node2);
            if (index2 != -1) {
                children2.remove(node2);
                this.inlineNodeRemoved(new int[]{index2}, new TreeNode[]{node2});
            }
            return index2;
        }
        return super.removeChildNode(node2);
    }

    @Override
    public void removeAllChildren() {
        this.getInlineWatchChildren().clear();
        this.fireNodeStructureChanged(this.myInlinesRootNode);
        super.removeAllChildren();
    }

    @Override
    public void editWatch(@Nullable WatchNodeImpl node2) {
        if (node2 instanceof InlineWatchNodeImpl) {
            new WatchInplaceEditor(this, this.myWatchesView, node2, node2).show();
        } else {
            super.editWatch(node2);
        }
    }

    @Override
    public int headerNodesCount() {
        return this.inlinesRootNodeIsShown() ? 1 : 0;
    }

    @Override
    public void moveUp(WatchNode node2) {
        int index2 = this.getIndex(node2);
        if (this.inlinesRootNodeIsShown()) {
            --index2;
        }
        if (index2 > 0) {
            ContainerUtil.swapElements(this.getWatchChildren(), (int)index2, (int)(index2 - 1));
        }
        this.fireNodeStructureChanged();
        int selectionRow = this.inlinesRootNodeIsShown() ? index2 : index2 - 1;
        this.getTree().setSelectionRow(selectionRow);
    }

    @Override
    public void moveDown(WatchNode node2) {
        int index2 = this.getIndex(node2);
        if (this.inlinesRootNodeIsShown()) {
            --index2;
        }
        if (index2 < this.getWatchChildren().size() - 1) {
            ContainerUtil.swapElements(this.getWatchChildren(), (int)index2, (int)(index2 + 1));
        }
        this.fireNodeStructureChanged();
        int selectionRow = this.inlinesRootNodeIsShown() ? index2 + 2 : index2 + 1;
        this.getTree().setSelectionRow(selectionRow);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchesView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regularWatchesExpressions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlineWatchesExpressions";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/inline/InlineWatchesRootNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/inline/InlineWatchesRootNode";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedChildren";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineWatchChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class InlinesGroup
    extends XValueGroup {
        private final boolean myInlinesInWatches;
        private final List<InlineWatchNodeImpl> myChildren;

        protected InlinesGroup(@NotNull String name2, boolean inlinesInWatches) {
            if (name2 == null) {
                InlinesGroup.$$$reportNull$$$0(0);
            }
            super(name2);
            this.myInlinesInWatches = inlinesInWatches;
            this.myChildren = new ArrayList<InlineWatchNodeImpl>();
        }

        public void computeChildren(@NotNull XCompositeNode node2) {
            if (node2 == null) {
                InlinesGroup.$$$reportNull$$$0(1);
            }
            if (this.myInlinesInWatches) {
                XValueChildrenList list2 = new XValueChildrenList();
                for (InlineWatchNodeImpl child2 : this.myChildren) {
                    list2.add((XNamedValue)child2.getValueContainer());
                }
                node2.addChildren(list2, true);
            } else {
                node2.addChildren(XValueChildrenList.EMPTY, true);
            }
        }

        List<InlineWatchNodeImpl> getChildren() {
            return this.myChildren;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/inline/InlineWatchesRootNode$InlinesGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeChildren";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

