/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Consumer;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeValueNodeInplaceEditor;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public final class SetValueInplaceEditor
extends XDebuggerTreeValueNodeInplaceEditor {
    private final XValueModifier myModifier;

    private SetValueInplaceEditor(XValueNodeImpl node2, @NotNull @NlsSafe String nodeName) {
        if (nodeName == null) {
            SetValueInplaceEditor.$$$reportNull$$$0(0);
        }
        super("setValue", node2, nodeName);
        this.myModifier = ((XValue)this.myValueNode.getValueContainer()).getModifier();
    }

    public static void show(XValueNodeImpl node2, @NotNull String nodeName) {
        if (nodeName == null) {
            SetValueInplaceEditor.$$$reportNull$$$0(1);
        }
        SetValueInplaceEditor editor2 = new SetValueInplaceEditor(node2, nodeName);
        if (editor2.myModifier != null) {
            editor2.myModifier.calculateInitialValueEditorText(initialValue -> AppUIUtil.invokeOnEdt(() -> {
                if (editor2.getTree().isShowing()) {
                    editor2.show(initialValue);
                }
            }));
        } else {
            editor2.show(null);
        }
    }

    private void show(String initialValue) {
        this.myExpressionEditor.setExpression(XExpressionImpl.fromText(initialValue));
        this.myExpressionEditor.selectAll();
        this.show();
    }

    @Override
    public void doOKAction() {
        if (this.myModifier == null) {
            return;
        }
        DebuggerUIUtil.setTreeNodeValue(this.myValueNode, this.getExpression(), (Consumer<? super String>)((Consumer)errorMessage -> {
            Editor editor2 = this.getEditor();
            if (editor2 != null) {
                HintManager.getInstance().showErrorHint(editor2, errorMessage);
            } else {
                Messages.showErrorDialog((Component)((Object)this.myTree), (String)errorMessage);
            }
        }));
        super.doOKAction();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "nodeName";
        objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/SetValueInplaceEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

