/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeInplaceEditor;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValuePresentationUtil;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XDebuggerTreeValueNodeInplaceEditor
extends XDebuggerTreeInplaceEditor {
    protected final XValueNodeImpl myValueNode;
    private final JPanel myEditorPanel;
    private final int myNameOffset;

    protected XDebuggerTreeValueNodeInplaceEditor(@NonNls String historyId, XValueNodeImpl node2, @NotNull @NlsSafe String nodeName) {
        if (nodeName == null) {
            XDebuggerTreeValueNodeInplaceEditor.$$$reportNull$$$0(0);
        }
        super(node2, historyId);
        this.myValueNode = node2;
        SimpleColoredComponent nameLabel = new SimpleColoredComponent();
        nameLabel.getIpad().right = 0;
        nameLabel.getIpad().left = 0;
        nameLabel.setIcon(this.myNode.getIcon());
        nameLabel.append(nodeName, XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
        XValuePresentation presentation2 = node2.getValuePresentation();
        if (presentation2 != null) {
            XValuePresentationUtil.appendSeparator((ColoredTextContainer)nameLabel, presentation2.getSeparator());
        }
        Border border = nameLabel.getMyBorder();
        this.myNameOffset = nameLabel.getPreferredSize().width - (border != null ? border.getBorderInsets((Component)nameLabel).right : 0);
        this.myEditorPanel = JBUI.Panels.simplePanel((Component)this.myExpressionEditor.getComponent());
    }

    @Override
    @Nullable
    protected Rectangle getEditorBounds() {
        Rectangle bounds2 = super.getEditorBounds();
        if (bounds2 == null) {
            return null;
        }
        bounds2.x += this.myNameOffset;
        bounds2.width -= this.myNameOffset;
        return bounds2;
    }

    @Override
    protected JComponent createInplaceEditorComponent() {
        return this.myEditorPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeName", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeValueNodeInplaceEditor", "<init>"));
    }
}

