/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HtmlCompatibleFile;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.util.LayeredTextAttributes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.source.html.dtd.HtmlElementDescriptorImpl;
import com.intellij.psi.impl.source.html.dtd.HtmlNSDescriptorImpl;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlCustomElementDescriptor;
import com.intellij.xml.XmlCustomTagHighlightingPassKt;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001b\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002\u00a2\u0006\u0002\u0010\u001dJ%\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002\u00a2\u0006\u0002\u0010!J\u0018\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020\u0019H\u0002J\u0018\u0010(\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J!\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002\u00a2\u0006\u0002\u0010+R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/xml/XmlCustomTagHighlightingPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "myHighlighter", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighter;", "kotlin.jvm.PlatformType", "myHolder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "applyHighlighting", "", "node", "Lcom/intellij/lang/ASTNode;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "doApplyInformationToEditor", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "hasKey", "", "keys", "", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "([Lcom/intellij/openapi/editor/colors/TextAttributesKey;)Z", "highlight", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "key", "(Lcom/intellij/lang/ASTNode;[Lcom/intellij/openapi/editor/colors/TextAttributesKey;)Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "isCustomTag", "descriptor", "Lcom/intellij/xml/XmlElementDescriptor;", "tag", "Lcom/intellij/psi/xml/XmlTag;", "isHtmlLikeFile", "isHtmlTagName", "replaceTextAttributeKeys", "newAttributesKeys", "([Lcom/intellij/openapi/editor/colors/TextAttributesKey;)[Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "intellij.xml.analysis.impl"})
public final class XmlCustomTagHighlightingPass
extends TextEditorHighlightingPass {
    private final HighlightInfoHolder myHolder;
    private final SyntaxHighlighter myHighlighter;
    @NotNull
    private final PsiFile file;

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress2) {
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        this.file.acceptChildren((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(this){
            final /* synthetic */ XmlCustomTagHighlightingPass this$0;

            public void visitXmlTag(@NotNull XmlTag tag2) {
                Intrinsics.checkNotNullParameter((Object)tag2, (String)"tag");
                super.visitXmlTag(tag2);
                XmlElementDescriptor xmlElementDescriptor = tag2.getDescriptor();
                if (xmlElementDescriptor == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)xmlElementDescriptor, (String)"tag.descriptor ?: return");
                XmlElementDescriptor descriptor2 = xmlElementDescriptor;
                if (descriptor2 instanceof AnyXmlElementDescriptor) {
                    return;
                }
                if (XmlCustomTagHighlightingPass.access$isCustomTag(this.this$0, descriptor2, tag2)) {
                    ASTNode aSTNode = tag2.getNode();
                    if (aSTNode != null) {
                        ASTNode aSTNode2 = aSTNode;
                        boolean bl = false;
                        boolean bl2 = false;
                        ASTNode it = aSTNode2;
                        boolean bl3 = false;
                        ASTNode[] aSTNodeArray = it.getChildren(null);
                        int n = aSTNodeArray.length;
                        for (int j = 0; j < n; ++j) {
                            ASTNode child2;
                            ASTNode aSTNode3 = child2 = aSTNodeArray[j];
                            Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"child");
                            IElementType iElementType = child2.getElementType();
                            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"child.elementType");
                            XmlCustomTagHighlightingPass.access$applyHighlighting(this.this$0, aSTNode3, iElementType);
                        }
                    }
                }
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    private final boolean isCustomTag(XmlElementDescriptor descriptor2, XmlTag tag2) {
        if (descriptor2 instanceof XmlCustomElementDescriptor) {
            return ((XmlCustomElementDescriptor)descriptor2).isCustomElement();
        }
        return this.isHtmlLikeFile() && !this.isHtmlTagName(descriptor2, tag2);
    }

    private final boolean isHtmlLikeFile() {
        boolean bl;
        block3: {
            FileViewProvider fileViewProvider = this.file.getViewProvider();
            Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"file.viewProvider");
            List list2 = fileViewProvider.getAllFiles();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"file.viewProvider.allFiles");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiFile it = (PsiFile)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof HtmlCompatibleFile)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl || HtmlUtil.supportsXmlTypedHandlers(this.file);
    }

    private final boolean isHtmlTagName(XmlElementDescriptor descriptor2, XmlTag tag2) {
        XmlElementDescriptor htmlDescriptor;
        if (descriptor2 instanceof HtmlElementDescriptorImpl) {
            return true;
        }
        XmlNSDescriptor nsDescriptor = tag2.getNSDescriptor(tag2.getNamespace(), true);
        return nsDescriptor instanceof HtmlNSDescriptorImpl && (htmlDescriptor = ((HtmlNSDescriptorImpl)nsDescriptor).getElementDescriptorByName(tag2.getName())) != null;
    }

    private final void applyHighlighting(ASTNode node2, IElementType elementType) {
        Object[] newAttributesKeys;
        if (!(node2 instanceof LeafElement)) {
            return;
        }
        IElementType effectiveElementType = Intrinsics.areEqual((Object)elementType, (Object)XmlElementType.XML_NAME) ? XmlElementType.XML_TAG_NAME : elementType;
        Object[] attributesKeys = this.myHighlighter.getTokenHighlights(effectiveElementType);
        Intrinsics.checkNotNullExpressionValue((Object)attributesKeys, (String)"attributesKeys");
        Object[] objectArray = newAttributesKeys = this.replaceTextAttributeKeys((TextAttributesKey[])attributesKeys);
        boolean bl = false;
        if (!Arrays.equals(objectArray, attributesKeys)) {
            this.myHolder.add(this.highlight(node2, (TextAttributesKey[])newAttributesKeys));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final TextAttributesKey[] replaceTextAttributeKeys(TextAttributesKey[] newAttributesKeys) {
        if (this.hasKey(newAttributesKeys)) {
            void $this$mapTo$iv$iv;
            TextAttributesKey[] $this$map$iv = newAttributesKeys;
            boolean $i$f$map = false;
            TextAttributesKey[] textAttributesKeyArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var7_7 = $this$mapTo$iv$iv;
            int n = ((void)var7_7).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var11_11 = item$iv$iv = var7_7[j];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                TextAttributesKey textAttributesKey = XmlCustomTagHighlightingPassKt.getAttributeKeyMapping().get(it);
                if (textAttributesKey == null) {
                    textAttributesKey = it;
                }
                TextAttributesKey textAttributesKey2 = textAttributesKey;
                collection.add(textAttributesKey2);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            TextAttributesKey[] textAttributesKeyArray2 = thisCollection$iv.toArray(new TextAttributesKey[0]);
            if (textAttributesKeyArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return textAttributesKeyArray2;
        }
        return newAttributesKeys;
    }

    private final boolean hasKey(TextAttributesKey[] keys2) {
        TextAttributesKey textAttributesKey;
        block1: {
            TextAttributesKey[] $this$firstOrNull$iv = keys2;
            boolean $i$f$firstOrNull = false;
            TextAttributesKey[] textAttributesKeyArray = $this$firstOrNull$iv;
            int n = textAttributesKeyArray.length;
            for (int j = 0; j < n; ++j) {
                TextAttributesKey element$iv;
                TextAttributesKey it = element$iv = textAttributesKeyArray[j];
                boolean bl = false;
                if (!XmlCustomTagHighlightingPassKt.getAttributeKeyMapping().containsKey(it)) continue;
                textAttributesKey = element$iv;
                break block1;
            }
            textAttributesKey = null;
        }
        return textAttributesKey != null;
    }

    private final HighlightInfo highlight(ASTNode node2, TextAttributesKey[] key) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        String description = application.isUnitTestMode() ? "Custom tag name" : null;
        HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo(HighlightInfoType.INFORMATION).severity(HighlightInfoType.SYMBOL_TYPE_SEVERITY).range(node2);
        EditorColorsScheme editorColorsScheme = this.getColorsScheme();
        if (editorColorsScheme == null) {
            editorColorsScheme = EditorColorsUtil.getGlobalOrDefaultColorScheme();
        }
        HighlightInfo.Builder builder3 = builder2.textAttributes(LayeredTextAttributes.create(editorColorsScheme, key));
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"HighlightInfo.newHighlig\u2026faultColorScheme(), key))");
        HighlightInfo.Builder textAttributes = builder3;
        if (description != null) {
            HighlightInfo.Builder builder4 = textAttributes.description(description);
            Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"textAttributes.description(description)");
            textAttributes = builder4;
        }
        return textAttributes.create();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doApplyInformationToEditor() {
        int n = 0;
        List highlights = new ArrayList();
        n = 0;
        int n2 = this.myHolder.size();
        while (n < n2) {
            void i2;
            HighlightInfo highlightInfo = this.myHolder.get((int)i2);
            Intrinsics.checkNotNullExpressionValue((Object)highlightInfo, (String)"myHolder[i]");
            highlights.add(highlightInfo);
            ++i2;
        }
        UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, 0, this.file.getTextLength(), highlights, this.getColorsScheme(), this.getId());
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    public XmlCustomTagHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        super(file2.getProject(), editor2.getDocument(), true);
        this.file = file2;
        this.myHolder = new HighlightInfoHolder(this.file, new HighlightInfoFilter[0]);
        this.myHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)this.file.getLanguage(), (Project)this.file.getProject(), (VirtualFile)this.file.getVirtualFile());
    }

    public static final /* synthetic */ boolean access$isCustomTag(XmlCustomTagHighlightingPass $this, XmlElementDescriptor descriptor2, XmlTag tag2) {
        return $this.isCustomTag(descriptor2, tag2);
    }

    public static final /* synthetic */ void access$applyHighlighting(XmlCustomTagHighlightingPass $this, ASTNode node2, IElementType elementType) {
        $this.applyHighlighting(node2, elementType);
    }
}

