/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.ide.ui.UISettings;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.xml.breadcrumbs.BreadcrumbsForceShownSettings;
import com.intellij.xml.breadcrumbs.BreadcrumbsUtilEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ToggleBreadcrumbsAction
extends ToggleAction
implements DumbAware {
    ToggleBreadcrumbsAction() {
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            ToggleBreadcrumbsAction.$$$reportNull$$$0(0);
        }
        super.update(event);
        boolean enabled = this.isEnabled(event);
        event.getPresentation().setEnabledAndVisible(enabled);
    }

    boolean isEnabled(AnActionEvent event) {
        PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return true;
        }
        FileViewProvider provider2 = psiFile.getViewProvider();
        return BreadcrumbsUtilEx.findProvider(false, provider2) != null;
    }

    public boolean isSelected(@NotNull AnActionEvent event) {
        if (event == null) {
            ToggleBreadcrumbsAction.$$$reportNull$$$0(1);
        }
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        boolean shown = settings.isBreadcrumbsShown();
        Editor editor2 = ToggleBreadcrumbsAction.findEditor(event);
        if (editor2 == null) {
            return shown;
        }
        Boolean forcedShown = BreadcrumbsForceShownSettings.getForcedShown(editor2);
        if (forcedShown != null) {
            return forcedShown;
        }
        if (!shown) {
            return false;
        }
        String languageID = ToggleBreadcrumbsAction.findLanguageID(event);
        return languageID == null || settings.isBreadcrumbsShownFor(languageID);
    }

    @Contract(value="null -> null")
    @Nullable
    static Editor findEditor(@Nullable AnActionEvent event) {
        return event == null ? null : (Editor)event.getData(CommonDataKeys.EDITOR_EVEN_IF_INACTIVE);
    }

    @Contract(value="null -> null")
    @Nullable
    static String findLanguageID(@Nullable AnActionEvent event) {
        if (event == null) {
            return null;
        }
        PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return null;
        }
        Language baseLanguage = psiFile.getViewProvider().getBaseLanguage();
        return BreadcrumbsUtilEx.findLanguageWithBreadcrumbSettings(baseLanguage);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "com/intellij/xml/breadcrumbs/ToggleBreadcrumbsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class ShowHide
    extends ToggleBreadcrumbsAction {
        ShowHide() {
        }

        @Override
        boolean isEnabled(AnActionEvent event) {
            return ShowHide.findEditor(event) != null && super.isEnabled(event);
        }

        public void setSelected(@NotNull AnActionEvent event, boolean selected2) {
            Editor editor2;
            if (event == null) {
                ShowHide.$$$reportNull$$$0(0);
            }
            if ((editor2 = ShowHide.findEditor(event)) != null && BreadcrumbsForceShownSettings.setForcedShown(selected2, editor2)) {
                UISettings.getInstance().fireUISettingsChanged();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xml/breadcrumbs/ToggleBreadcrumbsAction$ShowHide", "setSelected"));
        }
    }
}

