/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.refactoring;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.TitledHandler;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.refactoring.XmlTagInplaceRenamer;
import com.intellij.xml.refactoring.XmlTagRenameDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagRenameHandler
implements RenameHandler,
TitledHandler {
    private static final Logger LOG = Logger.getInstance(XmlTagRenameHandler.class);

    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        PsiElement element2;
        if (dataContext == null) {
            XmlTagRenameHandler.$$$reportNull$$$0(0);
        }
        if ((element2 = XmlTagRenameHandler.getElement(dataContext)) == null || PsiElementRenameHandler.isVetoed(element2)) {
            return false;
        }
        PsiElement parent = element2.getParent();
        if (!(parent instanceof XmlTag)) {
            return false;
        }
        XmlTag tag2 = (XmlTag)parent;
        String prefix = tag2.getNamespacePrefix();
        if (StringUtil.isNotEmpty((String)prefix)) {
            Editor editor2 = XmlTagRenameHandler.getEditor(dataContext);
            assert (editor2 != null);
            int offset = editor2.getCaretModel().getOffset();
            if (offset <= element2.getTextRange().getStartOffset() + prefix.length()) {
                return false;
            }
        }
        return XmlTagRenameHandler.isDeclarationOutOfProjectOrAbsent(element2.getProject(), dataContext);
    }

    public String getActionTitle() {
        return XmlBundle.message((String)"rename.xml.tag", (Object[])new Object[0]);
    }

    private static boolean isInplaceRenameAvailable(Editor editor2) {
        return editor2.getSettings().isVariableInplaceRenameEnabled();
    }

    private static boolean isDeclarationOutOfProjectOrAbsent(@NotNull Project project, DataContext context2) {
        PsiElement[] elements;
        if (project == null) {
            XmlTagRenameHandler.$$$reportNull$$$0(1);
        }
        return (elements = BaseRefactoringAction.getPsiElementArray(context2)).length == 0 || elements.length == 1 && XmlTagRenameHandler.shouldBeRenamedInplace(project, elements);
    }

    private static boolean shouldBeRenamedInplace(Project project, PsiElement[] elements) {
        boolean inProject = PsiManager.getInstance((Project)project).isInProject(elements[0]);
        if (inProject && elements[0] instanceof XmlTag) {
            XmlElementDescriptor descriptor2 = ((XmlTag)elements[0]).getDescriptor();
            return descriptor2 instanceof AnyXmlElementDescriptor;
        }
        return !inProject;
    }

    @Nullable
    private static Editor getEditor(@Nullable DataContext context2) {
        return (Editor)CommonDataKeys.EDITOR.getData(context2);
    }

    @Nullable
    private static PsiElement getElement(@Nullable DataContext context2) {
        Editor editor2;
        if (context2 != null && (editor2 = XmlTagRenameHandler.getEditor(context2)) != null) {
            PsiFile psiAtOffset;
            Language language2;
            int offset = editor2.getCaretModel().getOffset();
            PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(context2);
            if (file2 instanceof XmlFile) {
                return file2.getViewProvider().findElementAt(offset);
            }
            if (file2 != null && (language2 = PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)offset)) != file2.getLanguage() && (psiAtOffset = file2.getViewProvider().getPsi(language2)) instanceof XmlFile) {
                return psiAtOffset.findElementAt(offset);
            }
        }
        return null;
    }

    private void invoke(@Nullable Editor editor2, @NotNull PsiElement element2, @Nullable DataContext context2) {
        if (element2 == null) {
            XmlTagRenameHandler.$$$reportNull$$$0(2);
        }
        if (!this.isRenaming(context2)) {
            return;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.rename");
        if (XmlTagRenameHandler.isInplaceRenameAvailable(editor2)) {
            XmlTagInplaceRenamer.rename(editor2, (XmlTag)element2.getParent());
        } else {
            XmlTagRenameDialog.renameXmlTag(editor2, element2, (XmlTag)element2.getParent());
        }
    }

    public void invoke(@NotNull Project project, Editor editor2, PsiFile file2, @Nullable DataContext dataContext) {
        if (project == null) {
            XmlTagRenameHandler.$$$reportNull$$$0(3);
        }
        if (!this.isRenaming(dataContext)) {
            return;
        }
        PsiElement element2 = XmlTagRenameHandler.getElement(dataContext);
        assert (element2 != null);
        this.invoke(editor2, element2, dataContext);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, @Nullable DataContext dataContext) {
        PsiElement element2;
        if (project == null) {
            XmlTagRenameHandler.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            XmlTagRenameHandler.$$$reportNull$$$0(5);
        }
        PsiElement psiElement = element2 = elements.length == 1 ? elements[0] : null;
        if (element2 == null) {
            element2 = XmlTagRenameHandler.getElement(dataContext);
        }
        LOG.assertTrue(element2 != null);
        this.invoke(XmlTagRenameHandler.getEditor(dataContext), element2, dataContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xml/refactoring/XmlTagRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isDeclarationOutOfProjectOrAbsent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

