/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlToken;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.ColorPickerListener;
import com.intellij.ui.ColorPickerListenerFactory;
import com.intellij.ui.ColorUtil;
import com.intellij.util.Function;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.ColorMap;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserColorLookup
extends LookupElementDecorator<LookupElement> {
    private static final Function<Color, String> COLOR_TO_STRING_CONVERTER = color -> "#" + ColorUtil.toHex((Color)color);

    public UserColorLookup() {
        this(COLOR_TO_STRING_CONVERTER);
    }

    public UserColorLookup(Function<? super Color, String> colorToStringConverter) {
        this(colorToStringConverter, 2);
    }

    public UserColorLookup(final Function<? super Color, String> colorToStringConverter, int priority) {
        super(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)UserColorLookup.getColorString()).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
                if (context2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    1.$$$reportNull$$$0(1);
                }
                UserColorLookup.handleUserSelection(context2, (Function<? super Color, String>)colorToStringConverter);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/xml/util/UserColorLookup$1";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }), (double)priority));
    }

    private static void handleUserSelection(InsertionContext context2, @NotNull Function<? super Color, String> colorToStringConverter) {
        if (colorToStringConverter == null) {
            UserColorLookup.$$$reportNull$$$0(0);
        }
        Project project = context2.getProject();
        Editor editor2 = context2.getEditor();
        int startOffset = context2.getStartOffset();
        context2.getDocument().deleteString(startOffset, context2.getTailOffset());
        PsiElement element2 = context2.getFile().findElementAt(editor2.getCaretModel().getOffset());
        Color myColorAtCaret = element2 instanceof XmlToken ? UserColorLookup.getColorFromElement(element2) : null;
        context2.setLaterRunnable(() -> {
            if (editor2.isDisposed() || project.isDisposed()) {
                return;
            }
            List<ColorPickerListener> listeners2 = ColorPickerListenerFactory.createListenersFor(element2);
            Color color = ColorChooser.chooseColor((Project)project, (Component)WindowManager.getInstance().suggestParentWindow(project), (String)IdeBundle.message((String)"dialog.title.choose.color", (Object[])new Object[0]), (Color)myColorAtCaret, (boolean)true, listeners2, (boolean)true);
            if (color != null) {
                WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                    editor2.getCaretModel().moveToOffset(startOffset);
                    EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)((String)colorToStringConverter.fun((Object)color)));
                });
            }
        });
    }

    @Nullable
    public static Color getColorFromElement(PsiElement element2) {
        if (!(element2 instanceof XmlToken)) {
            return null;
        }
        return ColorMap.getColor(element2.getText());
    }

    private static String getColorString() {
        return XmlBundle.message((String)"xml.lookup.choose.color", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorToStringConverter", "com/intellij/xml/util/UserColorLookup", "handleUserSelection"));
    }
}

